<?php

//
// Author: Guy Thomas
// Date:2007 - 02 - 20
// Extends class.resultdata.php
// Purpose: Outputs data generated by parent class resultdata
//

require_once("class.resultdata.php");
require_once("class.resultcriteria.php");
require_once("lib_file.php"); // necessary to create safe file names for excel
require_once("lib_url.php");
require_once("excel/Writer.php"); // script for exporting to excel

class resultreport extends resultdata{

	var $outputType='htmltext'; // types can be htmltable, htmltext, excel
	var $outputAsSection=true; // is the output a continuation of previous html, excel sheet, etc - or is it a totally new page?	
	var $cpArrays=array(); // array of criteria value & points arrays (key is assessment id)
	var $resultCritObj; // result criteria object for processing criteria
	var $title='Eportal extender - report';
	var $altRow=0;
	var $r=0;
	var $c=0;
	var $wb; // excel workbook
	var $ws; // excel worksheet
	
	
	//
	// Class Constructor
	//
	function resultreport($columns, $params){
	
		parent::resultdata($columns, $params);
		
		$this->outputType=strtolower($this->outputType);
		
	}
	
	//
	// Override resultdata Run Query Method - outputs html or excel
	//
	function RunQuery(){
	
		$this->resultCritObj=new resultcriteria();	
		$this->openReport(); // writes html or excel opening data	
		$fdata=$this->fdata;
		$sql=$this->GenSQL();
		$result=$fdata->db->execute($sql);

		$bindData="";
		$prevBindData="";
		$bind=false;
		$lineNum=-1;
		$critData="";
		$prevStuId="";
		$prevRow=array();
					
		
		while ($row = $result->fetchrow()) {
			$rowClass=$rowClass==0 ? 1 : 0;
										
					
			// Get criteria bind data (for binding more than 1 row of criteria data)	 - sql ordering always by studentid, examid, subject, groupId, linenum
			$stuId=$row['studentid'];
			$examId=$row['examid'];
			$groupId=$row['groupid'];
			$bindData=$stuId.$examId.$groupId;
			
			// only bind criteria data if linenumber is greater than previous line number (sql ordering must always be done by line number)				
			if ($row['LineNum']>$lineNum){
				// only bind if bind data is the same
				if ($bindData==$prevBindData){
					$bind=true;
				} else {
					$bind=false;
				}
			} else {
				$bind=false;
			}
	
	
			if ($bind){				
				//GROUPED STUDENT RESULT DATA
				$critData.=$row['criteriadata']; // bind criteria data
												
				// reset bind variables
				$bind=false;
				$lineNum=-1;
				$prevBindData="";
			} else {

				$prevBindData=$bindData;
	
				// Output previous row
				if (!empty($prevRow)){
					$this->outputRow($prevRow, $critData);
				}
				
				// Reset criteria data to current row criteria
				$critData=$row['criteriadata'];
				
			}
			
			
			// Get line num (criteria data can span more than 1 row)
			$lineNum=$row['linenum'];
			$prevRow=$row;
						
		}
		
		// row output needs outputting for last record (no need to check binding)
		$this->outputRow($prevRow, $critData);

		$this->closeReport(); // writes html or excel opening data
		
	}
	
	function outputRow($row, $critData){
	
		$this->altRow=$this->altRow==0 ? 1 : 0; // set alternating row class
		
		if ($critData!="" && $row['examid']){
			$assId=$this->examCodesAssIds[$row['examid']];
			if (!isset($cpArrays[$assId])){
				// create cp array for this assessment id
				$cpArrays[$assId]=$this->resultCritObj->AssessmentCriteriaPoints($assId);
			}
			$critArray=$this->resultCritObj->flatCriteriaToArray($critData);
			$critArray=$this->resultCritObj->createNiceDataArray($assId, $critArray, $cpArrays[$assId]);
		}	
	
		switch ($this->outputType){
			case 'htmltable' : $this->rowHTMLTable($row, $critArray); break;
			case 'htmltext' : $this->rowHTMLText($row, $critArray); break;
			case 'excel' : $this->rowExcel($row, $critArray); break;
		}
		
		$this->r++; // increment row
	}
	
	function openReport(){
		switch ($this->outputType){
			case 'htmltable' : $this->openReportHTMLTable(); break;
			case 'htmltext' : $this->openReportHTMLText(); break;
			case 'excel' : $this->openReportExcel(); break;
		}
	}
	
	function closeReport(){
		switch ($this->outputType){
			case 'htmltable' : $this->closeReportHTMLTable(); break;
			case 'htmltext' : $this->closeReportHTMLText(); break;
			case 'excel' : $this->closeReportExcel(); break;
		}	
	}

	//
	// Opens report for outputting html table
	//
	function openReportHTMLTable(){
		$this->openHTMLDocument();
		// open table
		echo ("
		<table>
			<thead>
			<caption style='text-align:left'>$this->title</caption>
			<tr>
		");
		// now write column titles
		foreach ($this->_columns as $col){
			$title=$col['title'];
			$this->writeHCell($title);
		}
		// close table header
		echo ("
			</tr>
			</thead>
		");
		
	}
	
	//
	// Closes report for outputting html table
	//
	function closeReportHTMLTable(){
		echo ("</table>");
		$this->closeHTMLDocument();		
	}
	
	//
	// Write report row for html table
	//
	function rowHTMLTable($row, $critArray){
		echo ("\n\t\t<tr class='rowAlt{$this->altRow}'>");
		foreach ($this->_columns as $col){
			$cellVal=$this->getCellVal($col, $row, $critArray);
			$this->writeCell($cellVal);
		}
		echo ("\n\t\t</tr>");
	}
	
	//
	// Write row to Excel
	//
	function rowExcel($row, $critArray){
		$this->c=0; // reset column
		foreach ($this->_columns as $col){
			$cellVal=$this->getCellVal($col, $row, $critArray);
			$this->writeCell($cellVal);
		}	
	}
	
	// Plain HTML in a block (not table)
	function rowHTMLText($row, $critArray){
		foreach ($this->_columns as $col){
		
			$fldExp=$col['field'];
			$colTitle=$col['title'];
			
			if ($this->aliasMap->isExamField($fldExp)==false){			
				// do student field
				$fldRef=$this->aliasMap->getFieldTableConcat($fldExp);			
				$rowVal=$row[$fldRef];										
			} else {
				// do exam field
				$rowVal="";
				$fld=$this->aliasMap->getField($fldExp);
				if (isset($critArray[$fld])){
					$rowVal=$critArray[$fld]->val;
				}
			}
			
			echo ("<p>$colTitle = $rowVal </p>");
		}
		echo ("<hr />");
	}	
	
	function openReportHTMLText(){
		$this->openHTMLDocument();
	}
	
	function closeReportHTMLText(){
		$this->closeHTMLDocument();
	}
	

	
	//
	// Opens an excel report
	//
	function openReportExcel(){
		
		// Check workbook exists and if not make sure outputAsSection is false
		if (!isset($this->wb) && $this->outputAsSection){
			echo ("<p>Error. Can not create Excel workbook as section of document unless workbook already exists</p>");
			return; // cant create excel spread sheet
		}
		
		if (!isset($this->wb)){
			$this->wb=new Spreadsheet_Excel_Writer();
			// Get class group name and convert to file name		
			$fileName=strToFileName($this->title)."_export.xls";		
			// sending HTTP headers
			$this->wb->send($fileName);			
		}
		
		if (!isset($this->wb)){
			// if still not set then exit
			echo ("<p>Error - failed to create Excel worbook</p>");
			return;
		}
		
		// Creating a worksheet
		$this->ws=& $this->wb->addWorksheet(substr(strToFileName($this->title),0,10));

		// now write column titles
		foreach ($this->_columns as $col){
			$title=$col['title'];
			$this->writeHCell($title);
		}
		
		$this->r++;
		
	}
	
	//
	// Closes an excel report
	//
	function closeReportExcel(){
		if (!isset($this->wb)){
			echo ("<p>Error. Excel workbook not available to close</p>");
			return;
		}		
	
		// Let's send the file
		$this->wb->close();
	}
	
	
	//
	// Write a table cell
	//
	function writeCell($str, $bgColor=null, $border=null){
	
		if ($bgColor==null && $border==null){
			if ($this->outputType!='excel'){			
				echo ("<td>$str</td>");
			} else {
				$this->ws->write($this->r, $this->c, $str);
				$this->c++;
			}
		} else {		
			$styleStr="style = \"";
			$styleStr.=$bgColor!=null ? "background-color:$bgColor;" : "";
			$styleStr.=$border!=null ? "border: 2px solid $border !important;" : "";
			$styleStr.="\"";
			
			if ($this->outputType!='excel'){
				echo ("<td $styleStr>$str</td>");
			} else {
				$this->ws->write($this->r, $this->c, $str);
				$this->c++;				
			}		
		}
	}
	
	//
	// Writes a header cell
	//
	function writeHCell($str){
		if ($this->outputType!='excel'){
			echo ("<th>$str</th>");
		} else {
			$this->ws->write($this->r, $this->c, $str);
			$this->c++;
		}
	}
	
	//
	// Opens HTML document
	//
	function openHTMLDocument(){
		if ($this->outputAsSection){return;}
		echo ("<html>");			
		echo ("<head>");
		echo ("<title>$this->title</title>");
		echo ("</head>");
		echo ("<body>");
	}
	
	//
	// Closes HTML document
	//
	function closeHTMLDocument(){
		/** FUTURE IDEA - make each report automatically create an export to Excel link
		/** would need to send this report object to export file as session variable
		/** Put the links at the bottom of document
		**/
		/*
		$exportExcelLink=dirname(fileURL(__FILE__))."/exportToExcel?expId=1";
		echo ("<a href='$exportExcelLink'><span class='excelFile'></span>Export to Excel (".strToFileName($this->title)."_export.xls)</a><p></p>");
		*/
		if ($this->outputAsSection){return;}
		echo ("</body>");
	}
	
	//
	// Gets a cell value for a column specified in report class $_columns
	//
	function getCellVal($col, $row, $critArray){
		$fldExp=$col['field'];
		$colTitle=$col['title'];
		
		if ($this->aliasMap->isExamField($fldExp)==false){			
			// do student field
			$fldRef=$this->aliasMap->getFieldTableConcat($fldExp);			
			$cellVal=$row[$fldRef];										
		} else {
			// do exam field
			$cellVal="";
			$fld=$this->aliasMap->getField($fldExp);
			if (isset($critArray[$fld])){
				$cellVal=$critArray[$fld]->val;
			}
		}
		return ($cellVal);
	}
}
?>