<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * GovBR-DS Language file.
 *
 * @package    theme_govbrds
 * @copyright  2018 Fábio Santos <fabio.santos@ifrr.edu.br>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined("MOODLE_INTERNAL") || die();

$string["about"] = "About";
$string["accessibility"] = "Accessibility";
$string["address"] = "Address";
$string["address_desc"] =
    "JSON of the address you want to display in the footer.";
$string["addressm"] = "Manual Footer";
$string["addressm_desc"] = "Type something you want to display in the footer.";
$string["advancedsettings"] = "Advanced Settings";
$string["all_rights_reserved"] = "All rights reserved";
$string["backgroundimage"] = "Background Image";
$string["backgroundimage_desc"] =
    "The image to be displayed as the site background. The image you upload here will replace the default background image in the theme files.";
$string["boostset"] = "Theme Configuration";
$string["brandcolor"] = "Brand Color";
$string["brandcolor_desc"] = "Select a color to apply to links and titles.";
$string["choosereadme"] =
    "The GovBR-DS theme is a child theme of Boost. It is based on the digital identity of the Brazilian government.";
$string["configtitle"] = "GovBR-DS Settings";
$string["contact"] = "Contact";
$string["course_deadline"] = "Course Deadline";
$string["course_details"] = "Course Details";
$string["courses"] = "Courses";
$string["currentinparentheses"] = "(current)";
$string["development_team"] = "Development Team";
$string["donthaveanaccount"] = "Don't have an account yet?";
$string["email"] = "Email";
$string["enddate"] = "End Date";
$string["facebook"] = "Facebook";
$string["facebookdesc"] = "Link to your Facebook profile.";

$string["feature_content"] = 'Feature {$a} Content';
$string["feature_content_desc"] =
    'Choose an icon for feature {$a}. See the list of icons at https://fontawesome.com/icons?d=gallery&m=free.';
$string["feature_heading"] = 'Feature {$a} Heading';
$string["feature_icon"] = 'Feature {$a} Icon';
$string["feature_btntext"] = 'Feature {$a} Button Text';
$string["feature_btntext_desc"] = 'Text for the button of feature {$a}.';
$string["feature_btnurl"] = 'Feature {$a} Button URL';
$string["feature_btnurl_desc"] = 'URL for the button of feature {$a}.';

$string["features"] = "Display Features Boxes";
$string["features_content"] = "Features Section Content";
$string["features_desc"] =
    "Choose whether to display the features boxes section on the homepage.";
$string["features_heading"] = "Features Section Heading";

$string["generalsettings"] = "General Settings";
$string["greeting"] = "Hello";
$string["herocta"] = "Hero Call to Action (CTA)";
$string["herocta_desc"] =
    "Text for the call to action button in the hero section.";
$string["heroctalink"] = "Hero Call to Action (CTA) Link";
$string["heroctalink_desc"] =
    "URL for the call to action button in the hero section.";
$string["herohtml"] = "Hero section";
$string["herohtml_desc"] = "Content of the hero section on the homepage.";
$string["heroimage"] = "Hero Image";
$string["heroimage_desc"] =
    "Image to be displayed in the hero section. The recommended is .png (PNG-24) without background and size is 450x600 (3x4 proportinal) pixels.";
$string["heroimagealt"] = "Hero Image Alt Text";
$string["heroimagealt_desc"] =
    "Alternative text for the hero image, used for accessibility purposes.";
$string["homepage"] = "Homepage";
$string["homepage_settings"] = "Homepage Settings";
$string["search"] = "Search";
$string["how_to"] = "How it works?";
$string["instagram"] = "Instagram";
$string["instagramdesc"] = "Link to your Instagram profile.";
$string["layout"] = "Layout";
$string["layout_desc"] = "Choose the layout for the site.";
$string["linkedin"] = "LinkedIn";
$string["linkedindesc"] = "Link to your LinkedIn profile.";
$string["listcoursestitle"] = "List Courses Title";
$string["listcoursestitle_desc"] =
    "Title for the courses section on the homepage.";
$string["loginsettings"] = "Login Settings";
$string["logo"] = "Your Logo";
$string["logo_desc"] =
    "Upload the logo image that will be displayed in the website header. The recommended size is 280x80 pixels.";
$string["message_content"] = "Highlighted Message Content";
$string["message_content_desc"] =
    "Content of the highlighted message on the homepage.";
$string["message_title"] = "Highlighted Message Title";
$string["message_title_desc"] =
    "Title of the highlighted message on the homepage.";
$string["next_activity"] = "Next activity";
$string["no_related_course"] = "No related courses";
$string["no_teacher"] = "No teacher";
$string["organization"] = "Organization";
$string["organization_desc"] = "Description of the institution.";
$string["organization_url"] = "Organization URL";
$string["organization_url_desc"] = 'Link to the institution\'s homepage.';
$string["partners"] = "Partners Logo";
$string["partners_desc"] =
    "Upload the logo image that will be displayed in the website footer. The recommended size is 280x80 pixels.";
$string["phone"] = "Phone";
$string["pluginname"] = "GovBR-DS";
$string["preset"] = "Theme Preset";
$string["preset_desc"] = "Choose a preset to change the theme appearance.";
$string["presetfiles"] = "Additional Theme Preset Files";
$string["presetfiles_desc"] =
    "Preset files can be used to drastically change the theme appearance. See <a href=https://docs.moodle.org/dev/Boost_Presets>Boost presets</a> for info on creating and sharing your own presets, and check the <a href=http://moodle.net/boost>Presets repository</a> for presets shared by others.";
$string["prev_activity"] = "Previous activity";
$string["privacy:metadata:govbrds_user_setting"] =
    "Stores user-specific theme configuration preferences.";
$string["privacy_policy"] = "Privacy Policy";
$string["rawscss"] = "Raw SCSS";
$string["rawscss_desc"] =
    "Use this field to provide SCSS or CSS code that will be injected at the end of the stylesheet.";
$string["rawscsspre"] = "Initial Raw SCSS";
$string["rawscsspre_desc"] =
    "Use this field to provide initialization SCSS code. It will be injected before everything else. Most of the time, you’ll use this setting to define variables.";
$string["region-footer-left"] = "Footer (Left)";
$string["region-footer-middle"] = "Footer (Middle)";
$string["region-footer-right"] = "Footer (Right)";
$string["region-hidden-dock"] = "Hidden from users";
$string["region-home-left"] = "Home (Left)";
$string["region-home-middle"] = "Home (Middle)";
$string["region-home-right"] = "Home (Right)";
$string["region-side-post"] = "Right";
$string["region-side-pre"] = "Left";
$string["related_courses"] = "Related Courses";
$string["search"] = "Search";
$string["search_close"] = "Close Search";
$string["searchtext"] = "Search text";
$string["signinwith"] = "Sign in with";
$string["sitemap"] = "Sitemap";
$string["socialnetworks"] = "Social Networks";
$string["socialsettings"] = "Social Settings";
$string["startdate"] = "Start Date";
$string["subordination"] = "Subordination";
$string["subordination_desc"] = "Ministry to which it belongs.";
$string["tab"] = "Tab";
$string["tabdesc"] =
    "A custom menu may be configured here. Enter each menu item on a new line with format: menu text, a link URL and a tooltip title, separated by pipe characters. <pre><br/>eLearn|https://example.com/|Online Study Platform <br/> Mooc|https://example.com/mooc|MOOC Platform <br />Workspace|https://example.com/workspace|Corporative Training Environment</pre>";
$string["terms_of_use"] = "Terms of Use";
$string["tiktok"] = "Tik Tok";
$string["tiktokdesc"] = "Link to your Tik Tok profile.";
$string["to"] = "to";
$string["twitter"] = "Twitter";
$string["twitterdesc"] = "Link to your Twitter profile.";
$string["useful_links"] = "Useful Links";
$string["visit_linkedin"] = "Linkdin";
$string["visit_facebook"] = "Facebook";
$string["visit_instagram"] = "Instagram";
$string["visit_youtube"] = "Youtube";
$string["visit_tiktok"] = "Tiktok";
$string["youtube"] = "YouTube";
$string["youtubedesc"] = "Link to your YouTube profile.";
