<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Event observer definitions for MoodleConnect plugin.
 *
 * @package    local_mc_plugin
 * @copyright  2025 Kerem Can Akdag
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

// Register the observer for common Moodle events.
// We also register for \core\event\base to attempt catching everything,
// allowing the observer to filter based on settings.
$observers = [
    // Wildcard observer - catches ALL Moodle events (Moodle 3.1+).
    // The observer filters based on user-selected events in settings.
    [
        'eventname' => '*',
        'callback'  => '\local_mc_plugin\observer::handle_event',
    ],
    // Course sync observers - always active when connected.
    // These sync the course list to MoodleConnect automatically.
    [
        'eventname' => '\core\event\course_created',
        'callback'  => '\local_mc_plugin\course_observer::course_created',
        'priority'  => 100,
    ],
    [
        'eventname' => '\core\event\course_updated',
        'callback'  => '\local_mc_plugin\course_observer::course_updated',
        'priority'  => 100,
    ],
    [
        'eventname' => '\core\event\course_deleted',
        'callback'  => '\local_mc_plugin\course_observer::course_deleted',
        'priority'  => 100,
    ],
];
