/**
 * Event selector module for the admin settings page.
 *
 * Handles event search, filtering, and bulk selection.
 * Uses data-* attributes from event_selector.mustache template.
 *
 * @module     local_mc_plugin/local/admin/event_selector
 * @copyright  2025 Kerem Can Akdag
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("local_mc_plugin/local/admin/event_selector",["local_mc_plugin/local/admin/selectors","core/str"],(function(Selectors,Str){let syncedEvents=[],strings={},container=null,hiddenInput=null,counterEl=null;const updateValue=()=>{if(!hiddenInput||!counterEl)return;const selected=[];if((container?container.querySelectorAll("".concat(Selectors.events.checkbox,":checked")):document.querySelectorAll("".concat(Selectors.events.checkbox,":checked, ").concat(Selectors.events.legacyCheckbox,":checked"))).forEach((cb=>{const eventItem=cb.closest(Selectors.events.eventItem);eventItem&&eventItem.dataset.class&&selected.push(eventItem.dataset.class)})),hiddenInput.value=selected.join(","),syncedEvents.length>0){const toAdd=selected.filter((evt=>!syncedEvents.includes(evt))).length,toRemove=syncedEvents.filter((evt=>!selected.includes(evt))).length;if(0===toAdd&&0===toRemove)counterEl.innerHTML=strings.selectedCount.replace("{$a}",selected.length)+' <span class="text-success">• '.concat(strings.allSynced,"</span>");else{const changes=[];toAdd>0&&changes.push("".concat(toAdd," ").concat(strings.newEvents)),toRemove>0&&changes.push("".concat(toRemove," ").concat(strings.removed)),counterEl.innerHTML=strings.selectedCount.replace("{$a}",selected.length)+' <span class="text-warning">• '.concat(changes.join(", "),"</span>")}}else counterEl.textContent=strings.selectedCount.replace("{$a}",selected.length)},filterEvents=term=>{const lowerTerm=term.toLowerCase();(container?container.querySelectorAll(Selectors.events.eventItem):document.querySelectorAll(Selectors.events.eventItem)).forEach((item=>{item.textContent.toLowerCase().includes(lowerTerm)?item.classList.remove(Selectors.events.hiddenClass):item.classList.add(Selectors.events.hiddenClass)}));(container?container.querySelectorAll(Selectors.events.category):document.querySelectorAll(Selectors.events.category)).forEach((cat=>{0===cat.querySelectorAll("".concat(Selectors.events.eventItem,":not(.").concat(Selectors.events.hiddenClass,")")).length?cat.classList.add(Selectors.events.hiddenClass):cat.classList.remove(Selectors.events.hiddenClass)}))},selectVisible=()=>{const selector="".concat(Selectors.events.eventItem,":not(.").concat(Selectors.events.hiddenClass,") ").concat(Selectors.events.checkbox);(container?container.querySelectorAll(selector):document.querySelectorAll(selector)).forEach((cb=>{cb.checked=!0})),updateValue()},deselectVisible=()=>{const selector="".concat(Selectors.events.eventItem,":not(.").concat(Selectors.events.hiddenClass,") ").concat(Selectors.events.checkbox);(container?container.querySelectorAll(selector):document.querySelectorAll(selector)).forEach((cb=>{cb.checked=!1})),updateValue()};return{setSyncedEvents:function(events){syncedEvents=events||[]},refreshCounter:function(inputId){updateValue()},init:async function(inputId){if(inputId=inputId||null,await(async()=>{const results=await Str.get_strings([{key:"event_selected_count",component:"local_mc_plugin"},{key:"event_all_synced",component:"local_mc_plugin"},{key:"event_new",component:"local_mc_plugin"},{key:"event_removed",component:"local_mc_plugin"}]);strings={selectedCount:results[0],allSynced:results[1],newEvents:results[2],removed:results[3]}})(),container=document.querySelector(Selectors.events.container),container){hiddenInput=container.querySelector(Selectors.events.hiddenInput),counterEl=container.querySelector(Selectors.events.counter);const searchInput=container.querySelector(Selectors.events.searchInput);searchInput&&searchInput.addEventListener("keyup",(e=>{filterEvents(e.target.value)}));const selectBtn=container.querySelector(Selectors.events.selectVisibleBtn);selectBtn&&selectBtn.addEventListener("click",selectVisible);const deselectBtn=container.querySelector(Selectors.events.deselectVisibleBtn);deselectBtn&&deselectBtn.addEventListener("click",deselectVisible),container.querySelectorAll(Selectors.events.categoryTitle).forEach((title=>{title.style.cursor="pointer",title.addEventListener("click",(()=>{const events=title.nextElementSibling;events&&(events.style.display="none"===events.style.display?"block":"none")}))}))}else if(inputId){hiddenInput=document.getElementById(inputId),counterEl=document.querySelector(Selectors.events.legacyCounter(inputId));const searchInput=document.querySelector(Selectors.events.legacySearchInput(inputId));searchInput&&searchInput.addEventListener("keyup",(e=>{filterEvents(e.target.value)}));const selectBtn=document.querySelector(Selectors.events.legacySelectVisibleBtn(inputId));selectBtn&&selectBtn.addEventListener("click",selectVisible);const deselectBtn=document.querySelector(Selectors.events.legacyDeselectVisibleBtn(inputId));deselectBtn&&deselectBtn.addEventListener("click",deselectVisible),document.querySelectorAll(Selectors.events.categoryTitle).forEach((title=>{title.style.cursor="pointer",title.addEventListener("click",(()=>{const events=title.nextElementSibling;events&&(events.style.display="none"===events.style.display?"block":"none")}))}))}updateValue(),document.addEventListener("change",(e=>{(e.target.matches(Selectors.events.checkbox)||e.target.matches(Selectors.events.legacyCheckbox))&&updateValue()}))}}}));

//# sourceMappingURL=event_selector.min.js.map