define("ivplugin_contentbank/main",["exports","jquery","ivplugin_contentbank/util","core_form/modalform","mod_interactivevideo/type/base","core_filters/events","core/notification","core/str"],(function(_exports,_jquery,_util,_modalform,_base,_events,_notification,_str){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Main class for content bank
   *
   * @module     ivplugin_contentbank/main
   * @copyright  2024 Sokunthearith Makara <sokunthearithmakara@gmail.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_jquery=_interopRequireDefault(_jquery),_util=_interopRequireDefault(_util),_modalform=_interopRequireDefault(_modalform),_base=_interopRequireDefault(_base),_notification=_interopRequireDefault(_notification);class ContentBank extends _base.default{onEditFormLoaded(form,event){let self=this,body=form.modal.modal.find(".modal-body");return _util.default.init(M.cfg.courseContextId),body.off("click","#refreshcontentbank").on("click","#refreshcontentbank",(function(e){e.preventDefault(),(0,_jquery.default)(this).find("i").addClass("fa-spin");const currentid=(0,_jquery.default)("[name=contentid]").val();(0,_jquery.default)(".contentbank-container").html('<div class="d-flex justify-content-center align-items-center"\n            style="height: 150px;"><div class="spinner-grow text-secondary" role="status">\n            <span class="sr-only">Loading...</span></div></div>'),_util.default.refreshContentBank(currentid,M.cfg.courseContextId,(0,_jquery.default)(this).data("editable"),(function(){(0,_jquery.default)("#refreshcontentbank i").removeClass("fa-spin")}))})),body.off("click","#uploadcontentbank").on("click","#uploadcontentbank",(async function(e){e.preventDefault();const uploadForm=new _modalform.default({formClass:"core_contentbank\\form\\upload_files",args:{contextid:M.cfg.courseContextId},modalConfig:{title:await(0,_str.get_string)("uploadcontent","ivplugin_contentbank")}});uploadForm.addEventListener(uploadForm.events.FORM_SUBMITTED,(async e=>{self.addNotification(await(0,_str.get_string)("contentuploaded","ivplugin_contentbank"),"success");const contentid=e.detail.returnurl.match(/id=(\d+)/)[1];(0,_jquery.default)("[name=contentid]").val(contentid),setTimeout((function(){(0,_jquery.default)("#refreshcontentbank").trigger("click")}),1e3)})),uploadForm.addEventListener(uploadForm.events.ERROR,(async()=>{self.addNotification(await(0,_str.get_string)("contentuploaderror","ivplugin_contentbank"))})),uploadForm.show()})),self.timepicker({modal:!0,disablelist:!0,required:!0}),{form:form,event:event}}async postContentRender(annotation,callback){let self=this;const $message=(0,_jquery.default)("#message[data-id='".concat(annotation.id,"']"));if($message.addClass("hascontentbank"),$message.find(".modal-dialog").addClass("modal-xl"),"view"!==annotation.completiontracking){const tooltipAttr=self.isBS5?"data-bs":"data";if($message.find("#title .info").remove(),$message.find("#completiontoggle").before('<i class="bi bi-info-circle-fill iv-mr-2 info"\n                    '.concat(tooltipAttr,'-toggle="tooltip"\n                    ').concat(tooltipAttr,'-placement="auto"\n                    ').concat(tooltipAttr,'-container="#message"\n                    ').concat(tooltipAttr,'-trigger="hover"\n                    title="').concat(await(0,_str.get_string)("completionon"+annotation.completiontracking,"mod_interactivevideo"),'">\n                </i>')),!annotation.completed){const tooltip=$message.find("#title .info[".concat(tooltipAttr,'-toggle="tooltip"]'));setTimeout((()=>tooltip.tooltip("show")),1e3),setTimeout((()=>tooltip.tooltip("hide")),3e3)}}return!(1==annotation.hascompletion&&"manual"!=annotation.completiontracking&&!annotation.completed)||callback}renderContainer(annotation){super.renderContainer(annotation),(0,_jquery.default)("#message[data-id='".concat(annotation.id,"']")).find(".modal-body").addClass("p-0")}resizeIframe(annotation){const modalbody=document.querySelector("#message[data-id='".concat(annotation.id,"'] .modal-body"));if(!modalbody)return;let resizeTimeout;new ResizeObserver((()=>{clearTimeout(resizeTimeout),resizeTimeout=setTimeout((()=>{const iframe=modalbody.querySelector("iframe.h5p-player");if(iframe){const height=iframe.scrollHeight;modalbody.style.height="".concat(height+2e3,"px")}}),100)})).observe(modalbody)}async applyContent(annotation,existingstate){let self=this,$message=(0,_jquery.default)("#message[data-id='".concat(annotation.id,"']"));$message.removeClass("modal-dialog-centered");let annoid=annotation.id;const onPassFail=async(passed,time)=>{let label=passed?"continue":"rewatch";$message.find("#content").append('<button class="btn btn-'.concat(passed?"success":"danger",' mt-2 btn-rounded"\n                    id="passfail" data-timestamp="').concat(time,'"><i class="fa fa-').concat(passed?"play":"redo",' iv-mr-2"></i>\n                ').concat(await(0,_str.get_string)(label,"ivplugin_contentbank"),"\n                </button>")),$message.find("iframe").addClass("no-pointer-events")};(0,_jquery.default)(document).off("click","#passfail").on("click","#passfail",(function(e){e.preventDefault();let time=(0,_jquery.default)(this).data("timestamp");$message.find(".interaction-dismiss").trigger("click"),self.player.seek(time),self.player.play(),(0,_jquery.default)(this).remove()}));let saveState=0,condition=null;""!=annotation.text1&&null!==annotation.text1&&(condition=JSON.parse(annotation.text1)),1==JSON.parse(annotation.advanced).savecurrentstate&&(saveState=1);const afterLog=async log=>{let firstview=!1;self.cache[annotation.id]&&!self.isEditMode()||(self.cache[annotation.id]=await self.render(annotation),firstview=!0);const data=self.cache[annotation.id];if($message.find(".modal-body").html(data).attr("id","content").fadeIn(300),self.postContentRender(annotation,(annotation=>{const detectH5P=async()=>{let H5P;try{H5P=document.querySelector("#message[data-id='".concat(annoid,"'] iframe")).contentWindow.H5P}catch(e){H5P=null}if(null!=H5P){if(void 0===H5P.externalDispatcher)return void requestAnimationFrame(detectH5P);if(void 0===document.querySelector("#message[data-id='".concat(annoid,"'] iframe")).contentWindow.H5PIntegration)return void requestAnimationFrame(detectH5P);self.isEditMode()&&($message.find("#title .btns .xapi").remove(),$message.find("#title .btns").prepend('<div class="xapi alert-secondary px-2\n                         iv-rounded-pill">'.concat(await(0,_str.get_string)("xapicheck","ivplugin_contentbank"),"</div>"))),window.H5PIntegration=document.querySelector("#message[data-id='".concat(annoid,"'] iframe")).contentWindow.H5PIntegration||{},window.H5PIntegration.saveFreq=1;let content=window.H5PIntegration.contents,id=Object.keys(content)[0];if(null!=existingstate&&(log=existingstate),window.H5PIntegration.contents[id].contentUserData[0].state=log,window.H5P=H5P,annotation.completed)return;try{H5P.externalDispatcher.on("xAPI",(async function(event){let statement=event.data.statement;if(("http://adlnet.gov/expapi/verbs/completed"==statement.verb.id||"http://adlnet.gov/expapi/verbs/answered"==statement.verb.id)&&statement.object.id.indexOf("subContentId")<0&&!statement.context.contextActivities.parent){if(self.isEditMode()){(0,_jquery.default)("#message[data-id='".concat(annotation.id,"'] #title .btns .xapi")).remove(),(0,_jquery.default)("#message[data-id='".concat(annotation.id,"'] #title .btns")).prepend('<div class="xapi alert-success d-inline px-2 iv-rounded-pill">\n                                                    <i class="fa fa-check iv-mr-2"></i>\n                                                    '.concat(await(0,_str.get_string)("xapieventdetected","ivplugin_contentbank"),"\n                                                    </div>"));return void new Audio(M.cfg.wwwroot+"/mod/interactivevideo/sounds/pop.mp3").play()}let complete=!1,textclass="",result=statement.result;if(("completepass"==annotation.completiontracking&&result&&result.score.scaled>=.5||"completefull"==annotation.completiontracking&&result&&1==result.score.scaled||"complete"==annotation.completiontracking)&&(complete=!0),textclass=result.score.scaled<.5?"fa fa-check text-danger":result.score.scaled<1?"fa fa-check text-success":"bi bi-check2-all text-success",complete&&!annotation.completed){let details={};const completeTime=new Date;let windowAnno=window.ANNOS.find((x=>x.id==annotation.id));details.xp=annotation.xp,"1"==annotation.char1&&(details.xp=(result.score.scaled*annotation.xp).toFixed(2)),details.percent=details.xp/annotation.xp,details.duration=windowAnno.duration+(completeTime.getTime()-windowAnno.newstarttime),details.timecompleted=completeTime.getTime();const completiontime=completeTime.toLocaleString();let duration=self.formatTime(details.duration/1e3);details.reportView='<span data-toggle="tooltip" data-html="true"\n                     data-title=\'<span class="d-flex flex-column align-items-start"><span><i class="bi bi-calendar iv-mr-2"></i>\n                     '.concat(completiontime,'</span><span><i class="bi bi-stopwatch iv-mr-2"></i>').concat(duration,'</span>\n                     <span><i class="bi bi-list-check iv-mr-2"></i>\n                     ').concat(result.score.raw,"/").concat(result.score.max,"</span></span>'>\n                     <i class=\"").concat(textclass,'"></i><br><span>').concat(Number(details.xp),"</span></span>"),details.details=1==saveState?window.H5PIntegration.contents[id].contentUserData[0].state:"",setTimeout((function(){self.toggleCompletion(annoid,"mark-done","automatic",details)}),1500)}if(null!==condition)if(result.score.scaled<.5){if(1==condition.gotoonfailed&&1!=condition.forceonfailed?onPassFail(!1,condition.timeonfailed):1==condition.gotoonfailed&&1==condition.forceonfailed&&setTimeout((function(){$message.find(".interaction-dismiss").trigger("click"),self.player.seek(condition.timeonfailed),self.player.play()}),1e3),1==condition.showtextonfailed&&""!=condition.textonfailed.text){let textonfailed=await self.formatContent(condition.textonfailed.text);$message.find(".passfail-message").remove(),$message.find("#content").prepend('<div class="alert bg-light mt-2 mx-3 passfail-message">\n                                            '.concat(textonfailed,"</div>")),(0,_events.notifyFilterContentUpdated)((0,_jquery.default)(".passfail-message"))}}else if(1==condition.gotoonpassing&&1!=condition.forceonpassing?onPassFail(!0,condition.timeonpassing):1==condition.gotoonpassing&&1==condition.forceonpassing&&setTimeout((function(){$message.find(".interaction-dismiss").trigger("click"),self.player.seek(condition.timeonpassing),self.player.play()}),1e3),1==condition.showtextonpassing&&""!=condition.textonpassing.text){let textonpassing=await self.formatContent(condition.textonpassing.text);$message.find(".passfail-message").remove(),$message.find("#content").prepend('<div class="alert bg-light mt-2 mx-3 passfail-message">\n                                            '.concat(textonpassing,"</div>")),(0,_events.notifyFilterContentUpdated)((0,_jquery.default)(".passfail-message"))}}}))}catch(e){requestAnimationFrame(detectH5P)}}else requestAnimationFrame(detectH5P)};requestAnimationFrame(detectH5P)})(annotation)),null==existingstate&&!self.isEditMode()){if(!annotation.completed&&firstview&&1==saveState){let namespace=annotation.id,eventName="interactionclose.".concat(namespace," interactionrefresh.").concat(namespace);(0,_jquery.default)(document).off(eventName).on(eventName,(async function(e){if(e.detail.annotation.id==annotation.id)try{let content=window.H5PIntegration.contents,id=Object.keys(content)[0],state=window.H5PIntegration.contents[id].contentUserData[0].state;await self.saveLog(annotation,{text1:JSON.stringify(state),char1:annotation.type},self.userid,!0)}catch(e){}}))}1==annotation.hascompletion&&(annotation.completed||"view"!=annotation.completiontracking||self.completiononview(annotation))}};if(null!=existingstate)return void afterLog(existingstate);if(self.isEditMode())return void afterLog("");if(1!==saveState)return void afterLog("");let logs=await self.getLogs(annotation,[self.userid]),log="";logs.length<=0?afterLog(""):logs.length>0&&(log=JSON.parse(logs[0].text1),""!==log&&null!==log?_notification.default.saveCancel(await(0,_str.get_string)("resume","ivplugin_contentbank"),await(0,_str.get_string)("resumeconfirm","ivplugin_contentbank"),await(0,_str.get_string)("resume","ivplugin_contentbank"),(function(){afterLog(log)}),(function(){afterLog("")})):afterLog(log))}async getCompletionData(annotation,userid){let logs=await this.getLogs(annotation,[userid]),log="";return logs.length>0&&(log=JSON.parse(logs[0].text1)),annotation.displayoptions="popup",annotation.hascompletion=0,annotation.completed=!0,await this.renderViewer(annotation),this.renderContainer(annotation),this.applyContent(annotation,log),log}}return _exports.default=ContentBank,_exports.default}));

//# sourceMappingURL=main.min.js.map