<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Plugin strings are defined here.
 *
 * @package     mod_interactivevideo
 * @category    string
 * @copyright   2024 Sokunthearith Makara <sokunthearithmakara@gmail.com>
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitycard'] = "កាតសកម្មភាព";
$string['add'] = 'បន្ថែម';
$string['addinteractiontitle'] = 'បន្ថែម {$a->name} នៅ {$a->time}';
$string['additionalsettings'] = 'ការកំណត់បន្ថែម';
$string['advanced'] = 'ការកំណត់ដទៃ';
$string['aftercompletion'] = 'បន្ទាប់ពីបញ្ចប់';
$string['allowcustomtheme'] = 'អនុញ្ញាត​ឱ្យ​កំណត់ស្បែកផ្ទាល់ខ្លួន';
$string['allowcustomtheme_desc'] = 'ធីកដើម្បីអនុញ្ញាតឱ្យអ្នកប្រើប្រាស់ជ្រើសរើសស្បែកផ្ទាល់ខ្លួនសម្រាប់វីដេអូអន្តរកម្ម។';
$string['annotationscopied'] = 'អន្តរកម្មត្រូវបានចម្លងទៅក្ដារតម្បៀតខ្ទាស់';
$string['annotationsimported'] = 'អន្តរកម្មត្រូវបាននាំចូលដោយជោគជ័យ';
$string['annotationssavedasdefaults'] = 'លំនាំដើមត្រូវបានធ្វើបច្ចុប្បន្នភាពដោយជោគជ័យ។';
$string['appearanceandbehaviorsettings'] = 'ការកំណត់ពីរូបរាង និងអាកប្បកិរិយា';
$string['appearancesettings'] = 'ការកំណត់សម្រាប់រូបរាង';
$string['areyousureyouwanttoresetthecompletiondata'] = 'តើអ្នកពិតជាចង់លុបវឌ្ឍនភាពរបស់សិស្សនេះមែនទេ? រាល់ការល្បងទាំងអស់ និងឯកសារទាក់ទងទាំងឡាយនឹងត្រូវលុបចោល ។';
$string['atleastonecompletionrule'] = 'ត្រូវតែកំណត់លក្ខខណ្ឌបញ្ចប់យ៉ាងហោចណាស់មួយ។';
$string['audio'] = 'សម្លេង';
$string['autoplay'] = 'លេងដោយស្វ័យប្រវត្តិ';
$string['autoplay_help'] = 'វានឹងមិនមានប្រសិទ្ធភាពទេ ប្រសិនបើកម្មវិធីរុករកហាមមិនឲ្យមេឌាលេងដោយស្វ័យប្រវត្តិ។';
$string['autoplayblocked'] = 'កម្មវិធីរុករករបស់អ្នកបានបិទការចាក់មេឌាដោយស្វ័យប្រវត្តិ។ អ្នកនៅតែអាចប្រើសកម្មភាពនេះ​ តែអាចនឹងជួបប្រទះបញ្ហាមួយចំនួន។ ដើម្បីធានាថាអ្វីៗនឹងដំណើរការដោយរលូន សូមអនុញ្ញាតឲ្យមេឌាដំណើរការដោយស្វ័យប្រវត្តិក្នុងគេហទំព័រនេះ។';
$string['avg'] = 'មធ្យមភាគ';
$string['awardpartialpoints'] = 'ឲ្យពិន្ទុតាមសមាមាត្រ';
$string['backtocourse'] = 'ត្រឡប់ទៅកាន់វគ្គសិក្សា';
$string['beforecompletion'] = 'មុនបញ្ចប់';
$string['behaviorsettings'] = 'ការកំណត់សម្រាប់មុខងារ';
$string['braveautoplay'] = 'សកម្មភាពនេះមិនអាចដំណើរការលើកម្មវិធី Brave ដែលមិនអនុញ្ញាតឲ្យមេឌាដំណើរការដោយស្វ័យប្រវត្តិទេ។ សូមបើកឲ្យមេឌាលេងដោយស្វ័យប្រវត្តិក្នុងគេហទំព័រនេះ ឬប្តូរកម្មវិធីរុករក។';
$string['bulkedit'] = 'កែសម្រួលជាដុំ';
$string['byauthor'] = 'ដោយ {$a}';
$string['cachedef_interactivevideo_settings'] = 'និយមន័យឃ្លាំងសម្ងាត់សម្រាប់វីដេអូអន្តរកម្ម';
$string['cachedef_iv_items_by_cmid'] = 'និយមន័យឃ្លាំងសម្ងាត់សម្រាប់รายการវីដេអូអន្តរកម្មតាមលេខសម្គាល់ម៉ូឌុលវគ្គសិក្សា';
$string['cancel'] = 'បោះបង់';
$string['cardsize'] = 'ទំហំកាត';
$string['cardsize_desc'] = 'ជ្រើសទំហំលំនាំដើមសម្រាប់កាតសកម្មភាពនៅលើទំព័រវគ្គសិក្សា';
$string['changeplaybackspeed'] = 'ល្បឿន';
$string['checkall'] = 'ធីកទាំងអស់';
$string['clickability'] = 'អាចចុចដំណើរការ';
$string['clickability_desc'] = 'ប្រសិនបើបានធីក អន្តរកម្មអាចត្រូវបានចុចដើម្បីមើលមាតិកាអន្តរកម្ម។';
$string['clickaddtoaddinteraction'] = 'ចុច "បន្ថែម" ដើម្បីបន្ថែមអន្តរកម្ម';
$string['clone'] = 'ចម្លង';
$string['close'] = 'បិទ';
$string['completed'] = 'បាន​បញ្ចប់';
$string['completedeletedforthisitem'] = 'ទិន្នន័យ​ការ​បញ្ចប់​ត្រូវ​បាន​លុប​សម្រាប់ <b>{$a->item}</b> សម្រាប់ <b>{$a->user}</b>';
$string['completionandgrade'] = 'ការ​បញ្ចប់ និង​ពិន្ទុ';
$string['completioncompleted'] = 'បានបញ្ចប់';
$string['completiondetail:nonexistent'] = 'លក្ខខណ្ឌដទៃ៖ {$a}';
$string['completiondetail:percentage'] = 'បញ្ចប់យ៉ាងហោចណាស់ {$a}% ';
$string['completiondisablewarning'] = 'យ៉ាងហោចណាស់មានសិស្សម្នាក់បានបញ្ចប់មេរៀននេះ ។ ដើម្បីកែប្រែវីដេអូ អ្នកត្រូវបើកការកំណត់សម្រាប់ការបញ្ចប់សកម្មភាពជាមុនសិន។ ការធ្វើបែបនេះនឹងធ្វើការគណនាទិន្នន័យបញ្ចប់ជាថ្មី ។';
$string['completionincomplete'] = 'មិនបានបញ្ចប់';
$string['completionmanual'] = 'ចុចប៊ូតុងដើម្បីសម្គាល់ថាបញ្ចប់';
$string['completionmarkcomplete'] = 'សម្គាល់ថាបានបញ្ចប់';
$string['completionmarkincomplete'] = 'បានបញ្ចប់';
$string['completionnone'] = 'មិនតាមដាន';
$string['completionnotrecordedinpreviewmode'] = 'ការបញ្ចប់មិនត្រូវបានរក្សាទុកក្នុងពេលមើលសាកល្បង';
$string['completiononcomplete'] = 'នៅពេលដែលសកម្មភាពបានបញ្ចប់';
$string['completiononcompletefull'] = 'ទទួលបានពិន្ទុពេញ';
$string['completiononcompletepass'] = 'ទទួលបានពិន្ទុជាប់ (> 50%)';
$string['completiononpass'] = 'ទទួលបានពិន្ទុជាប់ (> 50%)';
$string['completiononview'] = 'មើល';
$string['completionpercentage'] = 'ភាគរយបញ្ចប់';
$string['completionpercentageerror'] = 'ភាគរយបញ្ចប់ត្រូវតែធំជាង 0 និងតិចជាង 100';
$string['completionreseterror'] = 'មានបញ្ហាក្នុងការលុបទិន្នន័យបញ្ចប់';
$string['completionresetsuccess'] = 'ទិន្នន័យបញ្ចប់លុបបានជោគជ័យ';
$string['completiontracking'] = 'តាមដានការបញ្ចប់';
$string['content'] = 'មាតិកា';
$string['contenttype'] = 'ប្រភេទមាតិកា';
$string['contentuploaded'] = 'មាតិកាបានផ្ទុកឡើងដោយជោគជ័យ';
$string['contentuploaderror'] = 'មានបញ្ហាក្នុងការអាប់ឡូតមាតិកា';
$string['copied'] = 'បានចម្លង!';
$string['copiedtoclipboard'] = 'តំណ​ត្រូវ​បាន​ចម្លង​ទៅ​ក្ដារ​តម្បៀត​ខ្ទាស់!';
$string['copy'] = 'ចម្លង';
$string['copynoun'] = 'ច្បាប់ចម្លង';
$string['createinteractivevideofromlist'] = 'បង្កើតវីដេអូអន្តរកម្មពីបញ្ជី';
$string['customdescription'] = 'ការពណ៌នាជំនួស';
$string['dailymotion'] = 'Dailymotion';
$string['darkmode'] = 'ប្រើម៉ូតងងឹត';
$string['datatableinfo'] = 'បង្ហាញ _START_ - _END_ ចំណោម _TOTAL_ ជួរ';
$string['datatableinfoempty'] = 'បង្ហាញ 0 - 0 - 0 ជួរ';
$string['datatableinfofiltered'] = '(ចម្រាញ់ពីជួរសរុប _MAX_)';
$string['default'] = 'ចម្លើយលំនាំដើម';
$string['defaultappearance'] = 'រូបរាងលំនាំដើម';
$string['defaultappearance_desc'] = 'ជ្រើសរើសការកំណត់លំនាំដើមសម្រាប់រូបរាង';
$string['defaultbehavior'] = 'មុខងារលំនាំដើម';
$string['defaultbehavior_desc'] = 'ជ្រើសរើសការកំណត់លំនាំដើមសម្រាប់​មុខងារ';
$string['defaulttheme'] = 'ស្បែកលំនាំដើម';
$string['defaulttheme_desc'] = 'ជ្រើសរើសស្បែកលំនាំដើមសម្រាប់វីដេអូអន្តរកម្ម';
$string['defaulttitle'] = 'គ្មានចំណងជើង';
$string['defaultvideosource'] = 'ប្រភពវីដេអូលំនាំដើម';
$string['defaultvideosource_desc'] = 'ជ្រើសរើសប្រភពលំនាំដើមសម្រាប់វីដេអូ';
$string['delete'] = 'លុប';
$string['deletecompletion'] = 'លុបទិន្នន័យបំពេញ​សកម្មភាព';
$string['deletedbyinstructor'] = 'បាន​លុប​ដោយ​គ្រូ';
$string['deleteinteraction'] = 'លុបអន្តរកម្ម';
$string['deleteinteractionconfirm'] = 'តើអ្នកប្រាកដថាអ្នកចង់លុបអន្តរកម្មនេះឬ?';
$string['deleterecordforitemforuserconfirm'] = 'តើអ្នកពិតជាចង់លុបទិន្នន័យ <b>{$a->item}</b> សម្រាប់ <b>{$a->user}</b> មែនទេ? <br><br><b>ចំណាំ</b>៖ សកម្មភាពនេះមិនធ្វើបច្ចុប្បន្នភាពស្ថានភាពការបញ្ចប់ ពិន្ទុ ឬពិន្ទុ XP ទេ។ ការគណនាឡើងវិញកើតឡើងតែនៅពេលដែលអ្នកប្រើប្រាស់ព្យាយាមធ្វើសកម្មភាពឡើងវិញប៉ុណ្ណោះ។';
$string['deleterecordforselectedusers'] = 'តើអ្នកពិតជាចង់លុបទិន្នន័យដែលបានជ្រើសរើស ({$a}) មែនទេ?';
$string['deletevideo'] = 'លុបវីដេអូ';
$string['deletevideobutton'] = '<i class="fa fa-trash fa-fw iv-mr-2"></i>លុបវីដេអូ';
$string['deletevideoconfirm'] = 'តើអ្នកពិតជាចង់លុបវីដេអូនេះមែនទេ?';
$string['disablechapternavigation'] = 'បិទផ្ទាំងបញ្ជីមាតិកា';
$string['disablecustomtime'] = 'បិទការកំណត់ពេលវេលា';
$string['disablecustomtime_desc'] = 'ប្រសិនបើធីក គេនឹងមិនអាចកំណត់ពេលចាប់ផ្តើមនិងពេលបញ្ចប់សម្រាប់វីដេអូនៅលើទម្រង់សម្រាប់កែសកម្មភាពទេ។';
$string['disableinteractionclick'] = 'បិទការចុចលើអន្តរកម្ម';
$string['disableinteractionclickuntilcompleted'] = 'បិទការចុចលើអន្តរកម្មរហូតដល់បានបញ្ចប់';
$string['dismissible'] = 'អាចមិនអើពើបាន';
$string['dismissibleandskippable'] = 'ប្រសិនបើអាចមិនអើពើបាន អន្តរកម្មដែលមិនទាន់បានបញ្ចប់អាចត្រូវបានបិទដោយប្រើប៊ូតុងបិទ។ <br>ប្រសិនបើអាចរំលងបាន អន្តរកម្មដែលមិនទាន់បានបញ្ចប់អាចត្រូវបានរំលង។ បើមិនដូច្នោះទេ អ្នកប្រើប្រាស់ត្រូវតែបំពេញអន្តរកម្មមុននឹងបន្តទៅផ្នែកបន្ទាប់។';
$string['dismissnotallowedbeforecompletion'] = 'អ្នកមិនអាចមិនអើពើអន្តរកម្មនេះបានទេ មុនពេលបញ្ចប់វា។';
$string['displayasstartscreen'] = 'បង្ហាញសេចក្តីណែនាំជាផ្ទាំងចាប់ផ្តើម';
$string['displaydescriptiononactivityheader'] = 'បង្ហាញសេចក្តីពណ៌នាលើក្បាលទំព័រសកម្មភាព';
$string['displayinline'] = 'បង្ហាញជាកាតលើទំព័រវគ្គសិក្សា';
$string['displayoptions'] = 'ជម្រើសសម្រាប់បង្ហាញ';
$string['displayoptionsbottom'] = 'ក្រោមវីដេអូ';
$string['displayoptionsinline'] = 'លើវីដេអូ';
$string['displayoptionspopup'] = 'ផ្ទាំងផុស';
$string['displayoptionsside'] = 'Drawer';
$string['distractionfreemode'] = 'ប្រើម៉ូតសាមញ្ញ';
$string['download'] = 'ទាញយក';
$string['draftsaved'] = 'បានរក្សាទុក';
$string['duration'] = 'រយៈពេល';
$string['edit'] = 'កែប្រែ';
$string['editinteractiontitle'] = 'កែប្រែ {$a->name} នៅ {$a->time}';
$string['editinteractiontitlenotime'] = 'កែប្រែ {$a}';
$string['editwithctrlclick'] = 'កែសម្រួល (ctrl/cmd + ចុច សម្រាប់ការកែសម្រួលរហ័ស)';
$string['email'] = 'អ៊ីមែល';
$string['enablecontenttypes'] = 'ប្រភេទមាតិកាដែលអាចប្រើបាន';
$string['enablecontenttypes_desc'] = 'ដាក់ធីកដើម្បីបើកប្រភេទមាតិកាដែលអ្នកចង់ប្រើនៅទីនេះ';
$string['enablecoursesettings'] = 'បើកការកំណត់កម្រិតវគ្គសិក្សា';
$string['enablecoursesettings_desc'] = 'ធីកដើម្បីបើកការកំណត់កម្រិតវគ្គសិក្សាសម្រាប់វីដេអូអន្តរកម្ម។';
$string['enablevideosources'] = 'ប្រភពវីដេអូដែលបានអនុញ្ញាត';
$string['enablevideosources_desc'] = 'ដាក់ធីកលើប្រភពវីដេអូដែលគេអាចប្រើបាន';
$string['end'] = 'ពេលបញ្ចប់';
$string['endscreentext'] = 'អត្ថបទសម្រាប់ផ្ទាំងបញ្ចប់';
$string['endtime'] = 'ពេលបញ្ចប់';
$string['endtimegreaterstarttime'] = 'ពេលបញ្ចប់ត្រូវតែធំជាងពេលចាប់ផ្តើម';
$string['endtimelesstotaltime'] = 'ពេលត្រូវតែតិចជាងពេលសរុបនៃវីដេអូ';
$string['endtip'] = '<b>គន្លឹះ</b> ចុចម៉ៅស៍ស្តាំដើម្បីបញ្ចូលពេលបច្ចុប្បន្ន។ ចុច Ctrl/Cmd + ម៉ៅស៍ឆ្វេងដើម្បីបញ្ចូលពេលបញ្ចប់លំនាំដើម។';
$string['errorplaynotallowed'] = 'កម្មវិធីរុករករបស់អ្នកមិនអនុញ្ញាតឲ្យចាក់វីដេអូដោយស្វ័យប្រវត្តិទេ។ សូមចុចប៊ូតុងលេង ដើម្បីយកព័ត៌មានពីវីដេអូនេះ។';
$string['external'] = 'ខាងក្រៅ';
$string['fastforward200'] = 'ទៅមុខ 0.2វិនាទី (ចុច Ctrl/Cmd សម្រាប់ 1 វិនាទី)';
$string['file'] = 'ផ្ទុកវីដេអូ';
$string['first'] = 'ដំបូង';
$string['firstname'] = 'នាមខ្លួន';
$string['fontfamilies'] = 'ពុម្ពអក្សរ';
$string['fontfamilies_desc'] = 'កំណត់ពុម្ពអក្សរដែលអាចជ្រើសរើសបាន ។ ឧទា: Arial=Arial, sans-serif';
$string['formvaluesarereset'] = 'តម្លៃទម្រង់ត្រូវបានកំណត់ឡើងវិញ។ សូមរក្សាទុកទម្រង់ម្តងទៀត។';
$string['fullavailablewidth'] = 'រូបភាពក្របពេញទទឹង';
$string['fullscreenisnotsupported'] = 'មិនអាចបង្ហាញពេញអេក្រង់ក្នុងឧបករណ៍នេះបានទេ';
$string['generalsettings'] = 'ការកំណត់ទូទៅ';
$string['generalsettings_desc'] = 'នេះគឺជាកំណែបេក្ខជនចេញផ្សាយរបស់កម្មវិធីជំនួយវីដេអូអន្តរកម្ម។ វាត្រូវបានណែនាំឱ្យសាកល្បងកម្មវិធីជំនួយនេះនៅក្នុងបរិយាកាសអភិវឌ្ឍន៍មុនពេលដាក់ឱ្យប្រើប្រាស់នៅលើគេហទំព័រផលិតកម្ម។ សូមរាយការណ៍បញ្ហាណាមួយទៅកាន់អ្នកថែទាំកម្មវិធីជំនួយ៖ <a href="{$a}">{$a}</a>។';
$string['goto'] = 'ទៅ';
$string['gradenonzero'] = 'ពិន្ទុត្រូវតែធំជាងឬស្មើ 0';
$string['hideinteractions'] = 'លាក់អន្តរកម្ម';
$string['hidemainvideocontrols'] = 'លាក់ឧបករណ៍លេងវីដេអូចំបង';
$string['html5video'] = 'ផ្ទុកឯកសារវីដេអូ/សម្លេង';
$string['id'] = 'លេខសម្គាល់';
$string['idlealert'] = 'អ្នកបានអសកម្មយ៉ាងយូរ។ យើងបានបញ្ឈប់ដំណើរការទាំងអស់ដើម្បីសន្សំអង្គចងចាំរបស់កម្មវិធីរុករករបស់អ្នក។ សូមដំណើរការទំព័រនេះឡើងវិញ ដើម្បីបន្ត។';
$string['import'] = 'នាំចូល';
$string['importcontent'] = 'នាំចូលមាតិកា';
$string['incomplete'] = 'មិន​ទាន់​ចប់';
$string['inprogress'] = 'កំពុងដំណើរការ';
$string['instance'] = 'ករណី';
$string['interactionadded'] = 'បានបន្ថែមអន្តរកម្មដោយជោគជ័យ';
$string['interactionalreadyexists'] = 'អន្តរកម្មនេះមានរួចហើយនៅវិនាទីនេះ';
$string['interactioncanonlybeaddedbetweenstartandendtime'] = 'អន្តរកម្មអាចបន្ថែមបានតែក្នុងពេលវេលាចាប់ផ្តើម ({$a->start}) និងពេលបញ្ចប់ ({$a->end}) នៃវីដេអូដែលបានកំណត់ក្នុងការកំណត់សកម្មភាព។';
$string['interactioncount'] = 'អន្តរកម្ម';
$string['interactiondeleted'] = 'បានលុបអន្តរកម្មដោយជោគជ័យ';
$string['interactionimported'] = 'បាននាំចូលមាតិកាដោយជោគជ័យ';
$string['interactionisbetweentheskipsegment'] = 'អ្នកមិនអាចបញ្ចូលមាតិកានៅចន្លោះដែលត្រូវរំលងទេ';
$string['interactions'] = 'អន្តរកម្ម';
$string['interactionscannotbeedited'] = '<i class="fa fa-warning iv-mr-2 fa-xl"></i>យ៉ាងហោចណាស់មានសិស្សម្នាក់បានសាកល្បងមេរៀននេះ ។ អ្នកនៅតែអាចបន្ថែម ឬកែប្រែអន្តរកម្ម តែទិន្នន័យពិន្ទុ និងការបញ្ចប់នឹងមិនត្រូវបានអាប់ដែតទេ ទាល់តែសិស្សល្បងមេរៀននេះជាថ្មី ។';
$string['interactionsdeleted'] = 'អន្តរកម្មចំនួន {$a} ត្រូវបានលុបដោយជោគជ័យ។';
$string['interactionsin'] = 'អន្តរកម្មក្នុង {$a}';
$string['interactionsnotsupportedonlivevideo'] = 'មិនគាំទ្រអន្តរកម្មនៅលើវីដេអូផ្សាយផ្ទាល់ទេ។';
$string['interactionupdated'] = 'បានកែប្រែអន្តរកម្មដោយជោគជ័យ';
$string['interactivevideo:addinstance'] = 'បញ្ចូលម៉ូឌុលមាតិកាអន្តរកម្ម';
$string['interactivevideo:edit'] = 'កែម៉ូឌុលមាតិកាអន្តរកម្ម';
$string['interactivevideo:editreport'] = 'កែសម្រួលរបាយការណ៍វីដេអូអន្តរកម្ម';
$string['interactivevideo:manage'] = 'គ្រប់គ្រងសកម្មភាពវីដេអូអន្តរកម្ម';
$string['interactivevideo:view'] = 'មើលម៉ូឌុលមាតិកាអន្តរកម្ម';
$string['interactivevideo:viewreport'] = 'មើលរបាយការណ៍ម៉ូឌុលមាតិកាអន្តរកម្ម';
$string['interactivevideoname'] = 'ឈ្មោះសកម្មភាព';
$string['invalidtimeformat'] = 'សូមបញ្ចូលពេលវេលាក្នុងទម្រង់ត្រឹមត្រូវ';
$string['invalidtimestamp'] = 'ពេលវេលាមិនត្រឹមត្រូវ';
$string['invalidtimestampformat'] = 'ទម្រង់ពេលវេលាមិនត្រឹមត្រូវ';
$string['invalidtoken'] = 'ថូខិនមិនត្រឹមត្រូវ';
$string['invalidurlformat'] = 'តំណមិនត្រឹមត្រូវ';
$string['invalidvideourl'] = 'តំណ URL វីដេអូមិនត្រឹមត្រូវ';
$string['keepcurrent'] = 'រក្សាទុកបច្ចុប្បន្ន';
$string['keyboardshortcuts'] = '<h5>ផ្លូវកាត់ក្តារចុច៖</h5><br><ul class="iv-pl-3"><li><b>Space</b> - លេង/ផ្អាក</li><li><b>Arrow Right</b> - ទៅមុខ 1 វិនាទី</li><li><b>Arrow Left</b> - ថយក្រោយ 1 វិនាទី</li><li><b>Plus (+)</b> - ពង្រីកលើបន្ទាត់ពេលវេលា</li><li><b>Minus (-)</b> - បង្រួមលើបន្ទាត់ពេលវេលា</li><li><b>Ctrl/Cmd + S</b> - រក្សាទុកអន្តរកម្ម</li><li><b>A</b> - បើកបញ្ជីប្រភេទអន្តរកម្ម</li><li><b>E</b> - ដំណើរការការកែសម្រួលជាដុំ</li><li><b>Ctrl/Cmd + A</b> - ជ្រើសរើស/មិនជ្រើសរើសអន្តរកម្ម</li><li><b>C</b> - ចម្លងអន្តរកម្មដែលបានជ្រើសរើស</li><li><b>D</b> - ទាញយកអន្តរកម្មដែលបានជ្រើសរើស</li><li><b>X</b> - លុបអន្តរកម្មដែលបានជ្រើសរើស</li><li><b>I</b> - បើកទម្រង់នាំចូលអន្តរកម្ម</li><li><b>P</b> - បិទភ្ជាប់អន្តរកម្មដែលបានចម្លង</li><li><b>U</b> - បើកទម្រង់ផ្ទុកឡើងអន្តរកម្ម</li></ul>';
$string['kinescope'] = 'Kinescope';
$string['last'] = 'ចុងក្រោយ';
$string['lastname'] = 'នាមត្រកូល';
$string['launchinpopup'] = 'ដំណើរការក្នុងផ្ទាំងផុស';
$string['layer-down'] = 'រុញទៅក្រោម';
$string['layer-up'] = 'រុញទៅលើ';
$string['list'] = 'បញ្ជី';
$string['live'] = 'ផ្សាយផ្ទាល់';
$string['lock'] = 'Unlocked: click to lock';
$string['manageivfor'] = 'គ្រប់គ្រងវីដេអូអន្តរកម្មសម្រាប់ {$a}';
$string['managevideos'] = 'គ្រប់គ្រងវីដេអូអន្តរកម្ម';
$string['max'] = 'អតិបរមា';
$string['maximum'] = 'យ៉ាងច្រើន {$a}';
$string['min'] = 'អប្បបរមា';
$string['minimum'] = 'យ៉ាងហោច {$a}';
$string['minimumcompletionpercentage'] = 'បញ្ចប់កិច្ចការយ៉ាងហោចណាស់ (%):';
$string['modulename'] = 'វីដេអូអន្តរកម្ម';
$string['modulename_help'] = 'វីដេអូអន្តរកម្មគឺជាម៉ូឌុលដែលអនុញ្ញាតឱ្យអ្នកបង្ហាញវីដេអូនិងបង្ហាញអន្តរកម្មនៅក្នុងវីដេអូនេះ។';
$string['modulenameplural'] = 'វីដេអូអន្តរកម្ម';
$string['moresettings'] = 'ការកំណត់​បន្ថែម';
$string['mute'] = 'បិទសម្លេង';
$string['mutetooltip'] = 'បិទសំឡេង (M)';
$string['nametip'] = '<b>គន្លឹះ</b> ចុចម៉ៅស៍ស្តាំដើម្បីប្តូរឈ្មោះទៅជាចំណងជើងដើមវិញ';
$string['new'] = 'ថ្មី';
$string['next'] = 'បន្ទាប់';
$string['nocontent'] = 'មិនមានមាតិកាទេ';
$string['nocontentfound'] = 'មិនមានមាតិកាទេ';
$string['nofound'] = 'រកមិនឃើញ';
$string['nonzero'] = 'ត្រូវតែធំជាង 0';
$string['nopermissiontoaddinteractions'] = "អ្នកមិនមានសិទ្ធបញ្ចូលមាតិកាអន្តរកម្មទេ";
$string['nopermissiontoview'] = 'អ្នកមិនមានសិទ្ធមើលវីដេអូអន្តរកម្មទេ';
$string['noposterimage'] = 'មិនមានរូបភាពក្រប';
$string['notaccessreport'] = 'អ្នកមិនអាចចូលមើលរបាយការណ៍បានទេ';
$string['notstarted'] = 'មិនបានចាប់ផ្តើម';
$string['novideofile'] = 'អ្នកត្រូវផ្ទុកឡើងឯកសារវីដេអូ។';
$string['novideourl'] = 'អ្នកត្រូវបន្ថែម URL វីដេអូនៅទីនេះ។';
$string['numeric'] = 'ត្រូវតែជាលេខ';
$string['off'] = 'បិទ';
$string['openinnewtab'] = 'បើកក្នុងផ្ទាំងថ្មី';
$string['options'] = 'ជម្រើស';
$string['panopto'] = 'Panopto';
$string['participant'] = 'អ្នកចូលរួម';
$string['passwordprotected'] = 'មានពាក្យសម្ងាត់';
$string['passwordprotected_help'] = 'ធីកប្រអប់់នេះប្រសិនបើវីដេអូនេះត្រូវការពាក្យសម្ងាត់។ ការធ្វើបែបនេះនឹងធានាថាប្រអប់បញ្ចូលពាក្យសម្ងាត់នឹងមិនត្រូវបានបាំងដោយធាតុផ្សេងៗ។';
$string['passwordrequired'] = 'ទាមទារពាក្យសម្ងាត់';
$string['pause'] = 'ផ្អាក';
$string['pauseonblur'] = 'ផ្អាកវីដេអូពេលប្តូរផ្ទាំង';
$string['pausetooltip'] = 'ផ្អាក (Space)';
$string['peertube'] = 'PeerTube';
$string['play'] = 'លេង';
$string['player'] = 'ឧបករណ៍លេង';
$string['playhere'] = 'បង្ហាញទីនេះ';
$string['playpause'] = 'លេង/ផ្អាក';
$string['playtooltip'] = 'លេង (Space)';
$string['pluginadministration'] = 'ការគ្រប់គ្រងវីដេអូអន្តរកម្ម';
$string['pluginname'] = 'វីដេអូអន្តរកម្ម';
$string['posterimage'] = 'រូបភាពក្រប';
$string['preventseeking'] = 'ហាមផ្លាស់ទី';
$string['preventskipping'] = 'ហាមរំលង';
$string['preventskipping_help'] = 'ការកំណត់នេះមិនមានប្រសិទ្ធភាពសម្រាប់អ្នកដែលមានសិទ្ធកែសកម្មភាពទេ (ឧទា. គ្រូ)';
$string['preview'] = 'មើលជាមុន';
$string['previous'] = 'មុន';
$string['privacy:metadata:attachments'] = 'itemid របស់​ attachment.';
$string['privacy:metadata:char1'] = 'ទិន្នន័យដែលបានរក្សាទុកជា Char1.';
$string['privacy:metadata:char2'] = 'ទិន្នន័យដែលបានរក្សាទុកជា Char2.';
$string['privacy:metadata:char3'] = 'ទិន្នន័យដែលបានរក្សាទុកជា Char3.';
$string['privacy:metadata:completeditems'] = 'បញ្ជីធាតុដែលបានបញ្ចប់​';
$string['privacy:metadata:completiondetails'] = 'សេចក្តីលម្អិតពីការបញ្ចប់';
$string['privacy:metadata:completionid'] = 'លេខសម្គាល់ការបញ្ចប់';
$string['privacy:metadata:completionpercentage'] = 'ភាគរយការបញ្ចប់';
$string['privacy:metadata:interactivevideo_completion'] = 'ស្ថានភាពបញ្ចប់សកម្មភាព';
$string['privacy:metadata:interactivevideo_log'] = 'កំណត់ហេតុនៃការបញ្ចប់កិច្ចការក្នុងសកម្មភាព';
$string['privacy:metadata:intg1'] = 'ទិន្នន័យដែលបានរក្សាទុកជា Intg1.';
$string['privacy:metadata:intg2'] = 'ទិន្នន័យដែលបានរក្សាទុកជា Intg2.';
$string['privacy:metadata:intg3'] = 'ទិន្នន័យដែលបានរក្សាទុកជា Intg3.';
$string['privacy:metadata:text1'] = 'ទិន្នន័យដែលបានរក្សាទុកជា Text1.';
$string['privacy:metadata:text2'] = 'ទិន្នន័យដែលបានរក្សាទុកជា Text2.';
$string['privacy:metadata:text3'] = 'ទិន្នន័យដែលបានរក្សាទុកជា Text3.';
$string['privacy:metadata:timecompleted'] = 'ពេលបញ្ចប់';
$string['privacy:metadata:timecreated'] = 'ពេលបង្កើត';
$string['privacy:metadata:timeended'] = 'ពេលវេលាដែលវីដេអូបានទៅដល់ទីបញ្ចប់។';
$string['privacy:metadata:timemodified'] = 'ពេលកែប្រែ';
$string['privacy:metadata:userid'] = 'លេខសម្គាល់អ្នកប្រើប្រាស់​';
$string['privacy:metadata:xp'] = 'ពិន្ទុដែលគេទទួលបាន';
$string['quicksettings'] = 'ការកំណត់រហ័ស';
$string['redo'] = "ធ្វើឡើងវិញ";
$string['replayaftercompletion'] = 'បង្ហាញម្តងទៀតបន្ទាប់ពេលបញ្ចប់';
$string['replaybehavior'] = 'ការបង្ហាញម្តងទៀត';
$string['replycount'] = 'ចំនួនការឆ្លើយ';
$string['report'] = 'របាយការណ៍';
$string['reportfields'] = 'ផ្នែករបាយការណ៍';
$string['reportfields_desc'] = 'ជ្រើសរើសផ្នែកអ្នកប្រើប្រាស់ដើម្បីបង្ហាញក្នុងរបាយការណ៍។';
$string['reportfor'] = 'របាយការណ៍សម្រាប់​ {$a}';
$string['reportsettings'] = 'ការកំណត់របាយការណ៍';
$string['reportwithctrlclick'] = 'របាយការណ៍ (ctrl/cmd + ចុច សម្រាប់របាយការណ៍រហ័ស)';
$string['required'] = 'ទាមទារ';
$string['requiremintime'] = 'ទាមទារចំណាយពេល (នាទី)';
$string['requiremintime_help'] = 'ពេលវេលាអប្បបរមាជានាទីដែលអ្នកប្រើត្រូវចំណាយលើសកម្មភាព (បន្ទាប់ពីបានចាប់ផ្តើមសកម្មភាព) មុនពេលវាត្រូវបានសម្គាល់ថាបានបញ្ចប់។';
$string['rerun_desc'] = 'ប្រសិនបើបានធីក អន្តរកម្មដែលបានបញ្ចប់នឹងត្រូវបានបង្ខំឱ្យដំណើរការឡើងវិញនៅពេលអ្នកប្រើប្រាស់ចូលមើលផ្នែកនោះម្តងទៀត។';
$string['reset'] = 'កំណត់ឡើងវិញ';
$string['resetappearancesettings'] = 'កំណត់ការកំណត់រូបរាងឡើងវិញ';
$string['resetbehaviorsettings'] = 'កំណត់ការកំណត់មុខងារឡើងវិញ';
$string['resetcompletion'] = 'កំណត់ការបញ្ចប់ឡើងវិញ';
$string['resetgrades'] = 'កំណត់ពិន្ទុឡើងវិញ';
$string['resetintro'] = 'លុបការពិពណ៌នា';
$string['resetpasswordprotected'] = 'កំណត់ការការពារដោយពាក្យសម្ងាត់ឡើងវិញ';
$string['resetsettings'] = 'កំណត់ការកំណត់ឡើងវិញ';
$string['resettodefaults'] = 'កំណត់ទៅលំនាំដើមវិញ';
$string['resettositedefaults'] = 'កំណត់ទៅលំនាំដើមរបស់គេហទំព័រវិញ';
$string['resize'] = 'ប្ដូរទំហំ';
$string['resync'] = 'សមកាលកម្មមាតិកាពីឃ្លាំងមាតិកា';
$string['rewind200'] = 'ទៅក្រោយ 0.2វិនាទី (ចុច Ctrl/Cmd សម្រាប់ 1 វិនាទី)';
$string['rightclicktodelete'] = 'ចុចកណ្ដុរខាងស្ដាំដើម្បីលុប';
$string['rightclicktosetcurrenttime'] = 'ចុចម៉ៅស៍ស្តាំដើម្បីបញ្ចូលពេលបច្ចុប្បន្ន។ ចុច Enter ដើម្បីរក្សាទុក។';
$string['rowsselected'] = 'បានជ្រើសរើស %d ជួរ';
$string['rumble'] = 'Rumble';
$string['rutube'] = 'RuTube';
$string['save'] = 'រក្សាទុក';
$string['search'] = 'ស្វែងរក';
$string['section'] = 'ផ្នែក';
$string['sectionname'] = 'ឈ្មោះផ្នែក';
$string['sectionnum'] = 'ផ្នែក';
$string['seekingdisabled'] = 'មិនអាចប្តូរទីតាំងបាន';
$string['segmentendmustbegreaterthantimestamp'] = 'ពេលចុងត្រូវតែធំជាងពេលផ្តើម';
$string['select'] = 'ជ្រើសរើស...';
$string['selectacontenttypetoadd'] = 'ជ្រើសរើសប្រភេទមាតិកាដើម្បីបន្ថែម';
$string['selectactivity'] = 'ជ្រើសរើសសកម្មភាព';
$string['selectcourse'] = 'ជ្រើសរើសវគ្គសិក្សា';
$string['selectinteraction'] = 'សូមពិនិត្យជម្រើសរបស់អ្នកឡើងវិញ';
$string['selectoruploadcontent'] = 'ជ្រើសរើសមាតិកាពីបញ្ជីឬបង្កើតមួយថ្មី';
$string['separatesearchtermsbyslash'] = 'គន្លឹះ៖ ប្រើ "|" ដើម្បីបំបែកពាក្យស្វែងរកច្រើន។';
$string['setasdefault'] = 'កំណត់ជាលំនាំដើមសម្រាប់វគ្គសិក្សានេះ';
$string['settings'] = 'ការកំណត់';
$string['settingssaved'] = 'បានរក្សាទុកការកំណត់';
$string['settingstooltip'] = 'ការកំណត់ (Ctrl/Cmd + ចុច សម្រាប់ការកំណត់រហ័ស)';
$string['sharethismoment'] = 'ចែករំលែកខណៈនេះ';
$string['showcompletionrequirements'] = 'បង្ហាញលក្ខខណ្ឌបញ្ចប់';
$string['showless'] = 'បង្ហាញតិច';
$string['showmore'] = 'បង្ហាញច្រើន';
$string['showname'] = 'បង្ហាញឈ្មោះ';
$string['showplaybuttononcoursepage'] = 'បង្ហាញប៊ូតុងលេងនៅទំព័រវគ្គសិក្សា';
$string['showposterimage'] = 'បង្ហាញរូបភាពក្រប';
$string['showposterimageright'] = 'បង្ហាញរូបភាពក្របនៅខាងស្ដាំ';
$string['showprogressbar'] = 'បង្ហាញរបារវឌ្ឍនភាព';
$string['skip'] = 'រំលង';
$string['skippable'] = 'អាចរំលងបាន';
$string['skipped'] = 'រំលង';
$string['soundcloud'] = 'SoundCloud';
$string['source'] = 'ប្រភពវីដេអូ';
$string['source_help'] = 'ជ្រើសរើសប្រភពវីដេអូ';
$string['spendatleast'] = 'ចំណាយពេលយ៉ាងតិច {$a} នាទី';
$string['spotify'] = 'Spotify';
$string['sproutvideo'] = 'SproutVideo';
$string['squareposterimage'] = 'រូបក្របរាងការ៉េ';
$string['start'] = 'ពេលចាប់ផ្តើម';
$string['startchapter'] = 'ចាប់ផ្តើម';
$string['started'] = 'បានចាប់ផ្តើម';
$string['starttimelessthanendtime'] = 'ពេលចាប់ផ្តើមត្រូវតែតិចជាងពេលបញ្ចប់';
$string['starttimelesstotaltime'] = 'ពេលចាប់ផ្តើមត្រូវតែតិចជាងពេលសរុបនៃវីដេអូ';
$string['starttip'] = '<b>គន្លឹះ</b> ចុចម៉ៅស៍ស្តាំដើម្បីបញ្ចូលពេលបច្ចុប្បន្ន។ Ctrl/Cmd + ម៉ៅស៍ ដើម្បីបញ្ចូល 00:00:00.';
$string['subplugintype_ivplugin'] = 'ប្រភេទមាតិកាសម្រាប់វីដេអូអន្តរកម្ម';
$string['subplugintype_ivplugin_plural'] = 'ប្រភេទមាតិកាសម្រាប់វីដេអូអន្តរកម្ម';
$string['subtitle'] = 'ចំណងជើងរត់';
$string['supportedlinks'] = '<b>ប្រភពដែលគាំទ្រ:</b> {$a}';
$string['taskscompleted'] = 'កិច្ចការបានបញ្ចប់';
$string['thereisanissueloadingvideo'] = 'វីដេអូនេះមានបញ្ហា';
$string['thisinteractionalreadyexists'] = 'អ្នកមិនអាចបញ្ចូល <b>{$a}</b> លើសពីមួយទេ។';
$string['timecompleted'] = 'ពេលបញ្ចប់';
$string['timecompletedrange'] = 'ចន្លោះពេលបញ្ចប់';
$string['timecreatedrange'] = 'ចន្លោះពេលចាប់ផ្តើម';
$string['timemodified'] = 'ពេលកែប្រែ';
$string['timemustbebetweenstartandendtime'] = 'វីនាទីត្រូវនៅចន្លោះពេលចាប់​ផ្តើម ({$a->start}) និងពេលបញ្ចប់ ({$a->end})';
$string['timestamp'] = 'ពេលវេលា';
$string['timestarted'] = 'ពេលចាប់ផ្តើម';
$string['timesubmitted'] = 'ពេលប្រគល់';
$string['tip'] = 'គន្លឹះ';
$string['title'] = 'ចំណងជើង';
$string['todo'] = 'ត្រូវធ្វើ';
$string['togglechapter'] = 'បិទ/បើកបញ្ជីមាតិកា';
$string['togglecontrols'] = 'បិទ/បើកឧបករណ៍';
$string['togglefullscreen'] = 'បិទ/បើកអេក្រង់ពេញ';
$string['toggleview'] = 'បិទ/បើក ទិដ្ឋភាព';
$string['tutorial'] = 'ការបង្ហាញ';
$string['type'] = 'ប្រភេទ';
$string['undo'] = "មិនធ្វើឡើងវិញ";
$string['unknowncontenttype'] = 'មិនស្គាល់ប្រភេទមាតិកា';
$string['unlock'] = 'ចាក់សោ៖ ចុចដើម្បីបើក';
$string['unmute'] = 'បើកសម្លេង';
$string['unmutetooltip'] = 'បើកសំឡេង (M)';
$string['unsavedchanges'] = 'មានការផ្លាស់ប្ដូរដែលមិនបានរក្សាទុក។ តើអ្នកចង់បន្តឬទេ?';
$string['updateavailable'] = 'មានបច្ចុប្បន្នភាព';
$string['upload'] = 'ផ្ទុកឡើង';
$string['uploadanimagebelow'] = 'ផ្ទុករូបភាពនៅខាងក្រោម';
$string['uploadannotations'] = 'ផ្ទុកឡើងអន្តរកម្ម';
$string['uploadcontent'] = 'ផ្ទុកឡើងមាតិកា';
$string['uploadvideo'] = 'ផ្ទុកឡើងវីដេអូ';
$string['uploadvideobutton'] = '<i class="fa fa-upload fa-fw iv-mr-2"></i>ផ្ទុកឡើងវីដេអូ';
$string['url'] = 'តំណ';
$string['usecardonlydesign'] = 'ប្រើកាតសាមញ្ញ';
$string['usecolumnlayout'] = 'ប្រើទម្រង់ដេក';
$string['usecustomdescription'] = 'ប្រើការពិពណ៌នាជំនួស';
$string['usecustomposterimage'] = 'ប្រើរូបភាពក្របជំនួស';
$string['usefixedratio'] = 'បង្ខំសមមាត្រ 16:9';
$string['useoriginalvideocontrols'] = 'ប្រើឧបករណ៍លេងវីដេអូដើម';
$string['video'] = 'វីដេអូ';
$string['videodisplayoptions'] = 'រូបរាង';
$string['videolink'] = 'វីដេអូ/សម្លេងខាងក្រៅ';
$string['videonavhelp'] = '<h5>គន្លឹះ</h5><ul class="iv-pl-3"><li>ចុចលើរបារវីដេអូដើម្បីផ្លាស់ទីទៅកាន់ពេលណាមួយក្នុងវីដេអូ</li><li>ចុចម៉ៅស៍ស្តាំលើរបារវីដេអូ ដើម្បីបញ្ចូលអន្តរកម្មនៅទីនោះ។</li><li>ចុចលើរូបតំណាងអន្តរកម្មដើម្បីដំណើរការអន្តរកម្ម។</li><li>ចុចម៉ៅស៍ស្តាំលើរូបតំណាងអន្តរកម្មដើម្បីកែប្រែវា។</li><li>ចុច Shift និងអូសលើម៉ៅស៍ ដើម្បីអូសថែមឡាញឆ្វេងស្តាំ </li><li>ចុច Ctrl/Cmd និងអូសលើម៉ៅស៍ នៅលើថែមឡាញដើម្បីពង្រីក/បង្រួម</li><li>អូសរូបតំណាងអន្តរកម្មដើម្បីប្តូរទីតាំង</li></ul>';
$string['videoquality'] = 'គុណភាពវីដេអូ';
$string['videosharinginstructions'] = 'សេចក្តីណែនាំពីការប្រើប្រាស់មេឌា';
$string['videosharinginstructions_desc'] = 'បញ្ចូលសេចក្តីណែនាំសម្រាប់ការចែករំលែកមេឌា។ ឧទាហរណ៍៖ ប្រសិនបើស្ថាប័នរបស់អ្នកមានគោលការណ៍ផ្សេងៗដែលត្រូវអនុវត្តពេលប្រើប្រាស់មេឌាពីខាងក្រៅ អ្នកអាចបញ្ចូលគោលការណ៍ទាំងនោះនៅទីនេះបាន។ សេចក្តីណែនាំទាំងនេះនឹងត្រូវបង្ហាញនៅលើទម្រង់ពេលកែប្រែ ឬបញ្ចូលសកម្មភាពវីដេអូអន្តរកម្ម។';
$string['videourl'] = 'តំណវីដេអូ';
$string['videourlplaceholder'] = 'ផ្តិត (Paste) តំណវីដេអូទៅទីនេះ';
$string['views'] = 'ការ​ចូល​មើល';
$string['vimeo'] = 'Vimeo';
$string['visibilityonvideonav'] = 'បង្ហាញលើរបារបញ្ជាវីដេអូ';
$string['watch'] = 'មើល';
$string['watched'] = 'បានមើល %';
$string['wistia'] = 'Wistia';
$string['xp'] = 'ពិន្ទុ XP';
$string['xpcompleted'] = 'XP ដែលបានទទួល';
$string['xpearned'] = 'អ្នកទទួលបានពិន្ទុ {$a} XP!';
$string['xplost'] = 'អ្នកបាត់បង់ពិន្ទុ {$a} XP!';
$string['xppoint'] = 'ពិន្ទុ XP';
$string['yes'] = 'បាទ/ចាស';
$string['youcannotviewthisannotationyet'] = 'អ្នកមិនអាចមើលសម្លេងនេះនៅឡើយទេ។';
$string['youmustcompletethepreviousactivity'] = 'អ្នកត្រូវបញ្ចប់សកម្មភាពមុននឹងអ្នកអាចមើលវីដេអូបន្ទាប់ពីនេះបាន។';
$string['youmustcompletethistaskfirst'] = 'អ្នកត្រូវបញ្ចប់កិច្ចការនេះសិន។';
$string['youmustspendatleastminutesbeforemarkingcomplete'] = 'អ្នកត្រូវចំណាយពេលយ៉ាងហោចណាស់ <b>{$a->timerequire} នាទី</b> មុននឹងអាចចុចបញ្ចប់បាន<br><br><b>ពេលដែលអ្នកបានចំណាយ: {$a->timespent} នាទី</b>';
$string['youtube'] = 'YouTube';
$string['yt'] = 'YouTube';
