define("mod_interactivevideo/type/base",["exports","jquery","mod_interactivevideo/displaycontent","mod_interactivevideo/viewannotation","core/event_dispatcher","core/toast","core_form/modalform","mod_interactivevideo/libraries/jquery-ui","core/str"],(function(_exports,_jquery,_displaycontent,_viewannotation,_event_dispatcher,_toast,_modalform,_jqueryUi,_str){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Base class to be extended by other content types
   *
   * @module     mod_interactivevideo/type/base
   * @copyright  2024 Sokunthearith Makara <sokunthearithmakara@gmail.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_jquery=_interopRequireDefault(_jquery),_modalform=_interopRequireDefault(_modalform);var _default=class{constructor(player,annotations,interaction,course,userid,completionpercentage,gradeiteminstance,grademax,vtype,preventskip,totaltime,start,end,properties,cm,token,displayoptions,completionid,extracompletion){let options=arguments.length>19&&void 0!==arguments[19]?arguments[19]:{};this.token=token,this.cm=cm,this.player=player,this.annotations=annotations,this.interaction=interaction,this.course=course,this.userid=userid,this.completionpercentage=completionpercentage,this.gradeiteminstance=gradeiteminstance,this.grademax=grademax,this.vtype=vtype,this.preventskip=preventskip,this.totaltime=totaltime,this.start=start,this.end=end,this.prop=properties,this.displayoptions=displayoptions,this.completionid=Number(completionid),this.extracompletion=extracompletion?JSON.parse(extracompletion):{},this.options=options,this.cache={},this.isBS5=(0,_jquery.default)("body").hasClass("bs-5"),this.rtl=(0,_jquery.default)("body").hasClass("dir-rtl"),this.main=!0}setPlayer(player,start,end,vtype){this.start=start,this.end=end,this.totaltime=end-start,this.vtype=vtype,this.player=player,this.main=!player.subvideo}dispatchEvent(name,detail){(0,_event_dispatcher.dispatchEvent)(name,detail)}enableColorPicker(){(0,_jquery.default)(document).on("input",'input[type="color"]',(function(){const color=(0,_jquery.default)(this).val();(0,_jquery.default)(this).closest(".color-picker").css("background-color",color),(0,_jquery.default)(this).closest(".fitem").find('input[type="text"]').val(color)})),(0,_jquery.default)(document).on("change",'input[type="color"]',(function(){(0,_jquery.default)(".modal-backdrop").removeClass("opacity-0")})),(0,_jquery.default)(document).off("click",'.modal input[type="color"]').on("click",'.modal input[type="color"]',(function(){(0,_jquery.default)(".modal-backdrop").addClass("opacity-0")}))}formatContent(text){let shorttext=arguments.length>1&&void 0!==arguments[1]&&arguments[1];return(0,_displaycontent.formatText)(text,shorttext)}async render(annotation){let format=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"html";return(0,_displaycontent.renderContent)(annotation,format)}addNotification(msg){let type=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"danger";(0,_toast.add)(msg,{type:type})}init(){}isSkipped(timestamp){return this.isInSkipSegment(timestamp)||!this.isBetweenStartAndEnd(timestamp)}convertSecondsToHMS(s){let dynamic=arguments.length>1&&void 0!==arguments[1]&&arguments[1],rounded=arguments.length>2&&void 0!==arguments[2]&&arguments[2];rounded&&(s=Math.round(s));const hours=Math.floor(s/3600).toString().padStart(2,"0"),minutes=Math.floor(s%3600/60).toString().padStart(2,"0");let seconds=(s%60).toFixed(2);return seconds<10&&(seconds="0"+seconds),rounded&&(seconds=Math.floor(s%60).toString().padStart(2,"0")),dynamic&&s/3600<1?"".concat(minutes,":").concat(seconds):"".concat(hours,":").concat(minutes,":").concat(seconds)}convertHMSToSeconds(hms){return hms.split(":").reduce(((acc,time)=>60*acc+ +time))}renderEditItem(annotations,listItem,item){return this.annotations=annotations,listItem.removeAttr("id").removeClass("d-none"),listItem.attr("data-type",item.type),this.prop.allowmultiple&&listItem.addClass(item.type+(this.isSkipped(item.timestamp)?" skipped":"")),listItem.attr("data-timestamp",item.timestamp).attr("data-id",item.id),listItem.find(".timestamp").text(this.convertSecondsToHMS(item.timestamp,this.totaltime<3600,!0)).attr("data-timestamp",item.timestamp),listItem.find(".title").html(item.formattedtitle),1==item.hascompletion?(listItem.find(".btn.xp span").text(item.xp),listItem.attr("data-xp",item.xp)):listItem.find(".btn.xp").remove(),listItem.find(".type-icon i").addClass(this.prop.icon),listItem.find(".type-icon").attr("title",this.prop.title),this.prop.allowmultiple&&(Number(item.timestamp)>this.end||Number(item.timestamp)<this.start||this.isSkipped(item.timestamp))&&(listItem.find(".title").addClass("text-secondary"),listItem.attr("data-xp",0),listItem.find(".title").append('<span class="badge iv-badge-warning iv-ml-2">\n                            '.concat(M.util.get_string("skipped","mod_interactivevideo"),"</span>"))),listItem.find("[data-field]").attr("data-id",item.id),listItem.find('[data-field="xp"]').val(item.xp),listItem.find('[data-field="title"]').val(item.title),listItem.find('[data-field="timestamp"]').val(this.convertSecondsToHMS(item.timestamp)),this.prop.allowmultiple||(listItem.find(".btn.copy").remove(),listItem.find(".title").addClass("text-dark no-pointer").removeClass("text-primary text-secondary cursor-pointer"),listItem.removeAttr("data-timestamp"),listItem.find(".timestamp").remove()),listItem.appendTo("#annotation-list"),listItem}isBetweenStartAndEnd(timestamp){return timestamp<=this.end&&timestamp>=this.start}isAlreadyAdded(timestamp){return this.annotations.some((x=>x.timestamp==timestamp))}isInSkipSegment(timestamp){return this.annotations.some((x=>"skipsegment"==x.type&&Number(x.timestamp)<Number(timestamp)&&Number(x.title)>Number(timestamp)))}validateTimestampFormat(timestamp){return/^([0-9]{2}):([0-5][0-9]):([0-5][0-9])(\.\d{2})?$/.test(timestamp)}validateTimestampFieldValue(fld,hiddenfield){const self=this;(0,_jquery.default)(document).on("change","form [name=".concat(fld,"]"),(async function(e){if(e.preventDefault(),!self.validateTimestampFormat((0,_jquery.default)(this).val()))return self.addNotification(M.util.get_string("invalidtimestampformat","mod_interactivevideo")),void(0,_jquery.default)(this).val((0,_jquery.default)(this).attr("data-initial-value"));const parts=(0,_jquery.default)(this).val().split(":"),timestamp=3600*Number(parts[0])+60*Number(parts[1])+Number(parts[2]);if(!self.isBetweenStartAndEnd(timestamp)){const message=M.util.get_string("timemustbebetweenstartandendtime","mod_interactivevideo",{start:self.convertSecondsToHMS(self.start),end:self.convertSecondsToHMS(self.end)});return self.addNotification(message),void(0,_jquery.default)(this).val((0,_jquery.default)(this).attr("data-initial-value"))}return self.isAlreadyAdded(timestamp)?(self.addNotification(M.util.get_string("interactionalreadyexists","mod_interactivevideo")),void(0,_jquery.default)(this).val((0,_jquery.default)(this).attr("data-initial-value"))):self.isInSkipSegment(timestamp)?(self.addNotification(M.util.get_string("interactionisbetweentheskipsegment","mod_interactivevideo")),void(0,_jquery.default)(this).val((0,_jquery.default)(this).attr("data-initial-value"))):((0,_jquery.default)("form [name=".concat(hiddenfield,"]")).val(timestamp),await self.player.seek(timestamp,!0),void await self.player.pause())}))}addAnnotation(annotations,timestamp,coursemodule){let self=this;if(this.annotations=annotations,timestamp>=0){if(!this.isBetweenStartAndEnd(timestamp)){const message=M.util.get_string("interactioncanonlybeaddedbetweenstartandendtime","mod_interactivevideo",{start:self.convertSecondsToHMS(self.start),end:self.convertSecondsToHMS(self.end)});return void self.addNotification(message)}if(self.isAlreadyAdded(timestamp))return void self.addNotification(M.util.get_string("interactionalreadyexists","mod_interactivevideo"));if(self.isInSkipSegment(timestamp))return void self.addNotification(M.util.get_string("interactionisbetweentheskipsegment","mod_interactivevideo"))}const startHMS=self.convertSecondsToHMS(self.start),endHMS=self.convertSecondsToHMS(self.end),timestampHMS=timestamp>0?self.convertSecondsToHMS(timestamp):startHMS,data={id:0,timestamp:timestamp>0?timestamp:self.start,timestampassist:timestampHMS,title:self.prop.title,start:startHMS,end:endHMS,contextid:M.cfg.contextid,type:self.prop.name,courseid:self.course,cmid:coursemodule,annotationid:self.interaction,hascompletion:self.prop.hascompletion?1:0},form=new _modalform.default({formClass:self.prop.form,args:data,modalConfig:{title:M.util.get_string("addinteractiontitle","mod_interactivevideo",{name:self.prop.title.toLowerCase(),time:timestampHMS})}});form.show();const onEditFormLoaded=e=>{try{!function waitForForm(){form.modal.modal.find("form").length?self.onEditFormLoaded(form,e):requestAnimationFrame(waitForForm)}()}catch(error){}self.validateTimestampFieldValue("timestampassist","timestamp")};form.addEventListener(form.events.LOADED,(e=>{setTimeout((()=>{(0,_jquery.default)("body").addClass("modal-open")}),500),onEditFormLoaded(e),form.modal.modal.draggable({handle:".modal-header"})})),form.addEventListener(form.events.SERVER_VALIDATION_ERROR,(e=>{onEditFormLoaded(e)})),form.addEventListener(form.events.CLIENT_VALIDATION_ERROR,(e=>{onEditFormLoaded(e)})),form.addEventListener(form.events.FORM_SUBMITTED,(e=>{e.stopImmediatePropagation(),_jquery.default.ajax({url:M.cfg.wwwroot+"/mod/interactivevideo/ajax.php",method:"POST",dataType:"text",data:{action:"get_item",id:e.detail.id,sesskey:M.cfg.sesskey,contextid:M.cfg.courseContextId,token:self.token,cmid:self.cm},success:function(data){const newAnnotation=JSON.parse(data);(0,_event_dispatcher.dispatchEvent)("annotationupdated",{annotation:newAnnotation,action:"add"})}})}))}cloneAnnotation(id,timestamp){_jquery.default.ajax({url:M.cfg.wwwroot+"/mod/interactivevideo/ajax.php",method:"POST",dataType:"text",data:{action:"copy_item",id:id,sesskey:M.cfg.sesskey,contextid:M.cfg.contextid,token:this.token,cmid:this.cm,timestamp:timestamp},success:function(data){const newAnnotation=JSON.parse(data);(0,_event_dispatcher.dispatchEvent)("annotationupdated",{annotation:newAnnotation,action:"clone"})}})}editAnnotation(annotations,id){this.annotations=annotations;let self=this;const annotation=annotations.find((x=>x.id==id)),timestamp=annotation.timestamp,timestampassist=this.convertSecondsToHMS(timestamp);annotation.timestampassist=timestampassist,annotation.start=this.convertSecondsToHMS(this.start),annotation.end=this.convertSecondsToHMS(this.end),annotation.contextid=M.cfg.contextid;const title="skipsegment"===annotation.type?M.util.get_string("skipsegmentcontent","ivplugin_skipsegment").toLowerCase():annotation.formattedtitle;let modalTitle=M.util.get_string("editinteractiontitlenotime","mod_interactivevideo",title);timestamp>0&&(modalTitle=M.util.get_string("editinteractiontitle","mod_interactivevideo",{name:title,time:timestampassist}));const form=new _modalform.default({formClass:this.prop.form,args:annotation,modalConfig:{title:modalTitle}});form.show();const onEditFormLoaded=e=>{try{!function waitForForm(){form.modal.modal.find("form").length?self.onEditFormLoaded(form,e):requestAnimationFrame(waitForForm)}()}catch(error){}self.validateTimestampFieldValue("timestampassist","timestamp")};form.addEventListener(form.events.LOADED,(e=>{onEditFormLoaded(e),form.modal.modal.draggable({handle:".modal-header"})})),form.addEventListener(form.events.SERVER_VALIDATION_ERROR,(e=>{onEditFormLoaded(e)})),form.addEventListener(form.events.CLIENT_VALIDATION_ERROR,(e=>{onEditFormLoaded(e)})),form.addEventListener(form.events.FORM_SUBMITTED,(e=>{e.stopImmediatePropagation(),this.annotations=this.annotations.filter((x=>x.id!=id)),_jquery.default.ajax({url:M.cfg.wwwroot+"/mod/interactivevideo/ajax.php",method:"POST",dataType:"text",data:{action:"get_item",id:e.detail.id,sesskey:M.cfg.sesskey,contextid:M.cfg.courseContextId,token:self.token,cmid:self.cm}}).done((function(data){const updated=JSON.parse(data);(0,_event_dispatcher.dispatchEvent)("annotationupdated",{annotation:updated,action:"edit"})}))}))}deleteAnnotation(annotations,id){let bulk=arguments.length>2&&void 0!==arguments[2]&&arguments[2];this.annotations=annotations;const annotation=this.annotations.find((x=>x.id==id));_jquery.default.ajax({url:M.cfg.wwwroot+"/mod/interactivevideo/ajax.php",method:"POST",dataType:"text",data:{action:"delete_item",sesskey:M.cfg.sesskey,id:id,contextid:M.cfg.contextid,token:this.token,cmid:this.interaction},success:function(){bulk||(0,_event_dispatcher.dispatchEvent)("annotationdeleted",{annotation:annotation})}})}async deleteAnnotations(annotations,ids){this.annotations=annotations;const promises=ids.map((id=>new Promise((resolve=>{this.deleteAnnotation(this.annotations,id,!0),resolve()}))));await Promise.all(promises),(0,_event_dispatcher.dispatchEvent)("annotationsdeleted",{annotations:this.annotations,ids:ids})}onEditFormLoaded(form){return form.modal.modal.find(".modal-body")}postEditCallback(annotation){return this.runInteraction(annotation)}isEditMode(){return this.options.isEditMode}isPreviewMode(){return this.options.isPreviewMode}isClickable(annotation){if(this.isEditMode())return!0;const advanced=JSON.parse(annotation.advanced);return"1"==advanced.clickablebeforecompleted&&!annotation.completed||"1"==advanced.clickableaftercompleted&&annotation.completed}isVisible(annotation){if(this.isEditMode())return!0;const advanced=JSON.parse(annotation.advanced);return"1"==advanced.visiblebeforecompleted&&!annotation.completed||"1"==advanced.visibleaftercompleted&&annotation.completed}renderItemOnVideoNavigation(annotation){let self=this;if(annotation.timestamp<this.start||annotation.timestamp>this.end)return;this.totaltime||(this.totaltime=this.end-this.start);const percentage=(Number(annotation.timestamp)-this.start)/this.totaltime*100;if(this.isVisible(annotation)){let classes=annotation.type+" annotation li-draggable ";annotation.completed&&(classes+="completed "),this.isClickable(annotation)||(classes+="no-pointer-events "),this.isSkipped(annotation.timestamp)&&(classes+="skipped "),0==annotation.hascompletion&&(classes+="no-completion ");let title=annotation.formattedtitle;title=title.replace(/'/g,"&apos;").replace(/"/g,"&quot;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/&/g,"&amp;"),this.isEditMode()?(0,_jquery.default)("#video-nav ul").append('<li class="'.concat(classes,'" data-timestamp="').concat(annotation.timestamp,'"\n        data-id="').concat(annotation.id,'" style="left: calc(').concat(percentage,'% - 5px)">\n        <div class="item" data').concat(self.isBS5?"-bs":"",'-toggle="tooltip"\n         data').concat(self.isBS5?"-bs":"",'-html="true"\n         title=\'<div class="d-flex align-items-center"><i class="').concat(this.prop.icon,' iv-mr-2"></i>\n        <span>').concat(title,"</span></div>'></div></li>")):(0,_jquery.default)("#interactions-nav ul").append('<li class="'.concat(classes,'" data-timestamp="').concat(annotation.timestamp,'"\n                    data-id="').concat(annotation.id,'" style="left: calc(').concat(percentage,'% - 5px)">\n                    <a href="javascript:void()" class="item" tabindex="0" data').concat(self.isBS5?"-bs":"",'-toggle="tooltip"\n                     data').concat(self.isBS5?"-bs":"",'-container="#wrapper"\n                      data').concat(self.isBS5?"-bs":"",'-trigger="hover" data').concat(self.isBS5?"-bs":"",'-placement="top"\n                       data').concat(self.isBS5?"-bs":"",'-html="true"\n                      title=\'<div class="d-flex align-items-center">\n                        <i class="').concat(this.prop.icon,' iv-mr-2"></i>\n                        <span>').concat(title,"</span></div>'></a></li>"))}}async renderViewer(annotation){return(0,_displaycontent.defaultDisplayContent)(annotation,this.player,this.start,this.end)}async renderContainer(annotation){if(0==annotation.hascompletion)return;let $message=(0,_jquery.default)("#message[data-id='".concat(annotation.id,"']"));if("manual"!=annotation.completiontracking){let $completiontoggle=$message.find("#completiontoggle");$completiontoggle.prop("disabled",!0);let string=annotation.completed?await(0,_str.get_string)("completioncompleted","mod_interactivevideo"):await(0,_str.get_string)("completionincomplete","mod_interactivevideo");$completiontoggle.find("span").text(string)}if(!annotation.completed&&("view"==annotation.completiontracking||"manual"==annotation.completiontracking)&&annotation.requiremintime>0){const infoIcon='<i class="bi bi-info-circle-fill iv-mr-2 info"\n                data'.concat(self.isBS5?"-bs":"",'-toggle="tooltip"\n                data').concat(self.isBS5?"-bs":"",'-html="true"\n                data').concat(self.isBS5?"-bs":"",'-placement="auto"\n                data').concat(self.isBS5?"-bs":"",'-container="#message"\n                title="').concat(await(0,_str.get_string)("spendatleast","mod_interactivevideo",annotation.requiremintime),'"></i>');let $completiontoggle=$message.find("#completiontoggle");$message.find("#title .info").remove(),$completiontoggle.before(infoIcon);const $tooltip=$message.find("#title .info");setTimeout((()=>$tooltip.tooltip("show")),1e3),setTimeout((()=>$tooltip.tooltip("hide")),3e3)}}postContentRender(){}setModalDraggable(elem){(0,_jquery.default)(elem).draggable({handle:".modal-header"})}formatTime(seconds){seconds=parseInt(seconds);const hours=Math.floor(seconds/3600),minutes=Math.floor(seconds%3600/60),remainingSeconds=seconds%60;let string="";return hours>0&&(string+=hours+"h "),minutes>0&&(string+=minutes+"m "),remainingSeconds>0&&(string+=remainingSeconds+"s"),string}async completionCallback(annotations,thisItem,action,type){const $toggleButton=(0,_jquery.default)("#message[data-id='".concat(thisItem.id,"']")).find("#completiontoggle");var _window$IVAudio;if("manual"==type?($toggleButton.prop("disabled",!1),$toggleButton.find("i").removeClass("fa-spin bi-arrow-repeat").addClass("mark-done"==action?"bi-check2":"bi-circle"),$toggleButton.find("span").show()):"automatic"==type&&$toggleButton.find("i").removeClass("bi-check2 bi-circle").addClass("mark-done"==action?"bi-check2":"bi-circle"),"mark-done"==action)$toggleButton.removeClass("btn-secondary mark-done").addClass("btn-success mark-undone"),null===(_window$IVAudio=window.IVAudio)||void 0===_window$IVAudio||_window$IVAudio.point.play(),(0,_jquery.default)("#message[data-id='".concat(thisItem.id,"'] #title .badge")).removeClass("iv-badge-secondary").addClass("alert-success"),thisItem.xp>0?(0,_jquery.default)("#message[data-id='".concat(thisItem.id,"'] #title .badge")).text(thisItem.earned==thisItem.xp?Number(thisItem.earned)+" XP":"".concat(Number(thisItem.earned),"/").concat(thisItem.xp," XP")):(0,_jquery.default)("#message[data-id='".concat(thisItem.id,"'] #title .badge")).hide();else if("mark-undone"==action){var _window$IVAudio2;$toggleButton.removeClass("btn-success mark-undone").addClass("btn-secondary mark-done"),null===(_window$IVAudio2=window.IVAudio)||void 0===_window$IVAudio2||_window$IVAudio2.pop.play(),(0,_jquery.default)("#message[data-id='".concat(thisItem.id,"'] #title .badge")).removeClass("alert-success").addClass("iv-badge-secondary")}if($toggleButton.find("span").text(""),thisItem.earned>0&&("mark-undone"==action?this.addNotification(await(0,_str.get_string)("xplost","mod_interactivevideo",Number(thisItem.earned)),"info"):"mark-done"==action&&this.addNotification(await(0,_str.get_string)("xpearned","mod_interactivevideo",Number(thisItem.earned)),"success")),"manual"==type){let string="mark-done"==action?await(0,_str.get_string)("completionmarkincomplete","mod_interactivevideo"):await(0,_str.get_string)("completionmarkcomplete","mod_interactivevideo");$toggleButton.find("span").text(string)}else if("automatic"==type){let string="mark-done"==action?await(0,_str.get_string)("completioncompleted","mod_interactivevideo"):await(0,_str.get_string)("completionincomplete","mod_interactivevideo");$toggleButton.find("span").text(string)}return"done"}async toggleCompletion(id,action){let type=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"manual",details=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{};if(this.isEditMode())return Promise.resolve();if(this.isPreviewMode())return this.addNotification(await(0,_str.get_string)("completionnotrecordedinpreviewmode","mod_interactivevideo")),Promise.resolve();const gradableitems=this.annotations.filter((x=>"1"==x.hascompletion)),totalXp=gradableitems.map((_ref=>{let{xp:xp}=_ref;return Number(xp)})).reduce(((a,b)=>a+b),0);let completedItems=gradableitems.filter((_ref2=>{let{completed:completed}=_ref2;return completed})),earnedXp=completedItems.map((_ref3=>{let{earned:earned}=_ref3;return Number(earned)})).reduce(((a,b)=>a+b),0);completedItems=completedItems.map((_ref4=>{let{id:id}=_ref4;return id}));let completed,thisItem=gradableitems.find((_ref5=>{let{id:itemId}=_ref5;return itemId==id})),completionDetails={id:id};if("mark-done"==action){const completeTime=new Date;completionDetails.hasDetails=!!details.details,details.hasDetails&&(completionDetails.hasDetails=!0),completionDetails.xp=void 0!==details.xp&&null!==details.xp?details.xp:thisItem.xp,completionDetails.percent=void 0!==details.percent&&null!==details.percent?details.percent:1;let windowAnno=window.ANNOS.find((x=>x.id==id));completionDetails.duration=void 0!==details.duration&&null!==details.duration?details.duration:windowAnno.duration+(completeTime.getTime()-windowAnno.newstarttime),completionDetails.timecompleted=void 0!==details.timecompleted&&null!==details.timecompleted?details.timecompleted:completeTime.getTime();const completiontime=completeTime.toLocaleString();let duration=this.formatTime(completionDetails.duration/1e3);completionDetails.reportView=details.reportView||"<span data".concat(self.isBS5?"-bs":"",'-toggle="tooltip" data').concat(self.isBS5?"-bs":"",'-html="true"\n                 title=\'<span class="d-flex flex-column align-items-start"><span><i class="bi bi-calendar iv-mr-2"></i>\n                 ').concat(completiontime,'</span><span><i class="bi bi-stopwatch iv-mr-2"></i>').concat(duration,'</span></span>\'>\n                 <i class="fa fa-check text-success"></i><br><span>').concat(Number(completionDetails.xp),"</span></span>")}return"mark-done"==action?(completedItems.push(id.toString()),thisItem.earned>0&&(earnedXp-=Number(thisItem.earned)),earnedXp+=Number(completionDetails.xp)):"mark-undone"==action&&(completedItems=completedItems.filter((itemId=>itemId!=id)),earnedXp-=Number(thisItem.earned)),completedItems=[...new Set(completedItems)],completed=Number(this.completionpercentage)>0?completedItems.length/gradableitems.length*100>=Number(this.completionpercentage)?1:0:gradableitems.length==completedItems.length?1:0,new Promise((resolve=>{_jquery.default.ajax({url:"".concat(M.cfg.wwwroot,"/mod/interactivevideo/ajax.php"),method:"POST",dataType:"text",data:{action:"save_progress",markdone:"mark-done"==action,sesskey:M.cfg.sesskey,id:this.interaction,uid:this.userid,percentage:completedItems.length/gradableitems.length*100,g:parseFloat(earnedXp/totalXp*this.grademax).toFixed(2),gradeiteminstance:this.gradeiteminstance,c:completed,xp:earnedXp,completeditems:JSON.stringify(completedItems),completiondetails:JSON.stringify(completionDetails),details:JSON.stringify(details.details||{}),annotationtype:thisItem.type,token:this.token,cmid:this.cm,completionid:this.completionid,contextid:thisItem.contextid,updatestate:this.completionpercentage>0||0!=Object.keys(this.extracompletion).length?1:0,courseid:this.course},success:res=>{const annotations=this.annotations.map((x=>(x.id==id&&(x.completed="mark-done"==action,x.earned=completionDetails.xp||0),x)));(0,_viewannotation.renderAnnotationItems)(annotations,this.start,this.totaltime),thisItem.earned=completionDetails.xp||0,this.completionCallback(annotations,thisItem,action,type),(0,_event_dispatcher.dispatchEvent)("completionupdated",{annotations:annotations,completionpercentage:completedItems.length/gradableitems.length*100,grade:parseFloat(earnedXp/totalXp*this.grademax).toFixed(2),completed:completed,xp:earnedXp,completeditems:completedItems,target:thisItem,action:action,type:type,response:res}),resolve()}})}))}enableManualCompletion(annotation){let self=this;(0,_jquery.default)("#message[data-id='".concat(annotation.id,"']")).off("click","button#completiontoggle").on("click","button#completiontoggle",(async function(e){if(e.preventDefault(),e.stopImmediatePropagation(),(0,_jquery.default)(this).hasClass("mark-done")&&annotation.requiremintime>0){const windowAnno=window.ANNOS.find((x=>x.id==annotation.id)),duration=(windowAnno.duration+((new Date).getTime()-windowAnno.newstarttime))/1e3/60;if(duration<annotation.requiremintime)return void self.addNotification(await(0,_str.get_string)("youmustspendatleastminutesbeforemarkingcomplete","mod_interactivevideo",{timerequire:annotation.requiremintime,timespent:duration.toFixed(2)}),"danger")}(0,_jquery.default)(this).attr("disabled",!0),(0,_jquery.default)(this).find("i").removeClass("bi-check2 bi-circle").addClass("fa-spin bi-arrow-repeat"),(0,_jquery.default)(this).find("span").hide();const annoid=(0,_jquery.default)(this).data("id");self.toggleCompletion(annoid,(0,_jquery.default)(this).hasClass("mark-done")?"mark-done":"mark-undone","manual")}))}async applyContent(annotation){const self=this;self.cache[annotation.id]&&!self.isEditMode()||(self.cache[annotation.id]=await self.render(annotation));const data=self.cache[annotation.id];let $message=(0,_jquery.default)("#message[data-id='".concat(annotation.id,"']"));$message.find(".modal-body").html(data),$message.find(".modal-body").attr("id","content"),self.postContentRender(annotation),annotation.completed||self.isEditMode()||this.completiononview(annotation)}completiononview(annotation){let self=this;if(1==annotation.hascompletion&&"view"==annotation.completiontracking){let duration=0,windowAnno=window.ANNOS.find((x=>x.id==annotation.id));if(windowAnno&&(duration=windowAnno.duration+((new Date).getTime()-windowAnno.newstarttime)),duration>60*annotation.requiremintime*1e3)return void self.toggleCompletion(annotation.id,"mark-done","automatic");const intervalFunction=async function(){let runInterval=setInterval((async function(){let windowAnno=window.ANNOS.find((x=>x.id==annotation.id));windowAnno&&!windowAnno.completed?(duration+=1e4,duration>60*annotation.requiremintime*1e3&&(clearInterval(runInterval),self.toggleCompletion(annotation.id,"mark-done","automatic"))):clearInterval(runInterval)}),1e4);(0,_jquery.default)(document).on("interactionclose",(function(e){e.detail.annotation.id==annotation.id&&clearInterval(runInterval)}))};intervalFunction(),(0,_jquery.default)(document).on("interactionrun",(function(e){if(e.detail.annotation.id==annotation.id){let windowAnno=window.ANNOS.find((x=>x.id==annotation.id));windowAnno&&!windowAnno.completed&&intervalFunction()}}))}}async runInteraction(annotation){let self=this;if(!await self.player.isPaused())return await self.player.pause(),void this.runInteraction(annotation);await this.renderViewer(annotation),this.renderContainer(annotation),self.applyContent(annotation),document.querySelector("#message[data-id='".concat(annotation.id,"']")).focus(),1==annotation.hascompletion&&"manual"==annotation.completiontracking&&this.enableManualCompletion(annotation),"popup"==annotation.displayoptions&&self.setModalDraggable("#annotation-modal .modal-dialog")}getCompletionData(annotation,userid){return Promise.resolve({annotation:annotation,userid:userid})}async displayReportView(annotation){const data=await this.render(annotation,"html");let $message=(0,_jquery.default)("#message[data-id='".concat(annotation.id,"']"));$message.find(".modal-body").html(data),$message.find(".modal-body").attr("id","content"),this.postContentRender(annotation)}getLogs(annotation,userids){let self=this;return userids=userids.join(","),new Promise((resolve=>{_jquery.default.ajax({url:M.cfg.wwwroot+"/mod/interactivevideo/ajax.php",method:"POST",dataType:"text",data:{action:"get_logs_by_userids",annotationid:annotation.id,contextid:annotation.contextid,userids:userids,sesskey:M.cfg.sesskey,token:self.token,cmid:self.interaction},success:data=>{try{resolve(JSON.parse(data))}catch(error){resolve([])}}})}))}async deleteCompletionData(recordid,itemid,userid){let self=this;return await new Promise((resolve=>{_jquery.default.ajax({url:M.cfg.wwwroot+"/mod/interactivevideo/ajax.php",method:"POST",dataType:"text",data:{action:"delete_completion_data",id:recordid,itemid:itemid,userid:userid,sesskey:M.cfg.sesskey,cmid:self.cm,contextid:M.cfg.contextid},success:data=>{data.id&&resolve(!0),resolve(!1)}})}))}timepicker(options){(options=options||{}).modal=options.modal||!0,options.disablelist=options.disablelist||!1,options.required=options.required||!1;let self=this;(0,_jquery.default)(document).off("click",".pickatime button").on("click",".pickatime button",(async function(e){e.preventDefault();const $this=(0,_jquery.default)(this),currenttime=await self.player.getCurrentTime(),field=(0,_jquery.default)(this).data("field"),fieldval=(0,_jquery.default)("[name=".concat(field,"]")).val();if(fieldval){const parts=fieldval.split(":"),time=3600*Number(parts[0])+60*Number(parts[1])+Number(parts[2]);await self.player.seek(time)}options.modal&&($this.closest(".modal").addClass("d-none"),(0,_jquery.default)(".modal-backdrop").addClass("d-none")),options.disablelist&&(0,_jquery.default)("#annotationwrapper").addClass("no-pointer-events"),(0,_jquery.default)("#timeline-btns .col:first-child").hide().before('<div class="col confirmtime-wrapper\n                d-flex justify-content-start align-items-center\n                     "><button class="btn btn-circle pulse btn-primary" id="confirmtime"\n                     title="'.concat(M.util.get_string("confirmtime","ivplugin_contentbank"),'">\n                     <i class="fa fa-check"></i></button></div>')),(0,_jquery.default)(document).off("click","#confirmtime").on("click","#confirmtime",(async function(e){e.preventDefault(),options.modal&&($this.closest(".modal").removeClass("d-none"),(0,_jquery.default)(".modal-backdrop").removeClass("d-none")),options.disablelist&&(0,_jquery.default)("#annotationwrapper").removeClass("no-pointer-events");const time=await self.player.getCurrentTime(),formattedTime=self.convertSecondsToHMS(time,!1,!0);(0,_jquery.default)("[name=".concat(field,"]")).val(formattedTime),(0,_jquery.default)(this).closest("div").remove(),(0,_jquery.default)("#timeline-btns .col:first-child").show(),self.player.seek(currenttime)}))})),(0,_jquery.default)(document).off("click",".resettime button").on("click",".resettime button",(function(e){e.preventDefault();const field=(0,_jquery.default)(this).data("field");(0,_jquery.default)("[name=".concat(field,"]")).val(""),options.required&&(0,_jquery.default)("[name=".concat(field,"]")).val(self.convertSecondsToHMS(self.start,!1,!0))}))}saveLog(annotation,data,userid){let replaceexisting=arguments.length>3&&void 0!==arguments[3]?arguments[3]:1,self=this;return new Promise((resolve=>{_jquery.default.ajax({url:M.cfg.wwwroot+"/mod/interactivevideo/ajax.php",method:"POST",dataType:"text",data:{action:"save_log",annotationid:annotation.id,contextid:annotation.contextid,data:JSON.stringify({text1:data.text1||"",text2:data.text2||"",text3:data.text3||"",char1:data.char1||"",char2:data.char2||"",char3:data.char3||"",intg1:data.intg1||0,intg2:data.intg2||0,intg3:data.intg3||0,completionid:self.completionid||0}),userid:userid,sesskey:M.cfg.sesskey,token:self.token,cmid:self.interaction,replaceexisting:replaceexisting?1:0},success:function(res){try{res=JSON.parse(res)}catch(e){res={}}resolve(res)}})}))}renderReportView(annotation,details,data){let res="";return res='<span class="completion-detail '.concat(details.hasDetails?"cursor-pointer":"",'"')+' data-id="'.concat(data.itemid,'" data-userid="').concat(data.row.id,'" data-type="').concat(data.ctype,'">').concat(details.reportView,"</span>"),1==data.access.canedit&&(res+='<i class="bi bi-trash3 fs-unset text-danger cursor-pointer position-absolute delete-cell" '+'title="'.concat(M.util.get_string("delete","mod_interactivevideo"),'"></i>')),res}};return _exports.default=_default,_exports.default}));

//# sourceMappingURL=base.min.js.map