define("mod_interactivevideo/player/yt",["exports","core/event_dispatcher","jquery","mod_interactivevideo/player/checkautoplay"],(function(_exports,_event_dispatcher,_jquery,_checkautoplay){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Youtube Player class
   * Documented at https://developers.google.com/youtube/iframe_api_reference
   *
   * @module     mod_interactivevideo/player/yt
   * @copyright  2024 Sokunthearith Makara <sokunthearithmakara@gmail.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_jquery=_interopRequireDefault(_jquery),_checkautoplay=_interopRequireDefault(_checkautoplay);let player={};var _default=class{constructor(){this.useAnimationFrame=!0,this.type="yt",this.frequency=.25,this.support={playbackrate:!0,quality:!1,password:!0},this.live=!1}async getInfo(url,node){return this.node=node,new Promise((resolve=>{var YT;var videoId=new RegExp("(?:https?:\\/\\/)?(?:www\\.)?(?:youtube\\.com|youtu\\.be|youtube-nocookie\\.com)(?:\\/embed\\/|\\/watch\\?v=|\\/)([^\\/]+)","g").exec(url)[1],options={videoId:videoId=videoId.split("&")[0],width:1080,height:720,playerVars:{autoplay:0,hl:M.cfg.language,controls:1,showinfo:0,fs:0,iv_load_policy:3,cc_load_policy:0,autohide:1,rel:0,playsinline:1,disablekb:0},events:{onReady:function(e){resolve({title:e.target.videoTitle,duration:e.target.getDuration(),posterImage:"https://img.youtube.com/vi/".concat(videoId,"/maxresdefault.jpg")})}}};if(window.YT)YT=window.YT||{},player[node]=new YT.Player(node,options);else{var tag=document.createElement("script");tag.src="https://www.youtube.com/iframe_api",tag.async=!0,tag.as="script",tag.rel="preload";var firstScriptTag=document.getElementsByTagName("script")[0];firstScriptTag.parentNode.insertBefore(tag,firstScriptTag),window.onYouTubeIframeAPIReady=function(){YT=window.YT||{},player[node]=new YT.Player(node,options)}}}))}async load(url,start,end){let opts=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{},reloaded=arguments.length>4&&void 0!==arguments[4]&&arguments[4];const showControls=opts.showControls||!1,customStart=opts.customStart||!1,preload=opts.preload||!1,node=opts.node||"player";var YT;this.node=node,this.allowAutoplay=await(0,_checkautoplay.default)(document.getElementById(node)),this.allowAutoplay||(0,_event_dispatcher.dispatchEvent)("iv:autoplayBlocked",{requireVideoBlock:!0}),this.start=start,this.end=end;var videoId=new RegExp("(?:https?:\\/\\/)?(?:www\\.)?(?:youtube\\.com|youtu\\.be|youtube-nocookie\\.com)(?:\\/embed\\/|\\/watch\\?v=|\\/)([^\\/]+)","g").exec(url)[1];videoId=videoId.split("&")[0],this.videoId=videoId,this.posterImage="https://img.youtube.com/vi/".concat(videoId,"/maxresdefault.jpg");const img=new Image;img.src=this.posterImage,img.onload=()=>{120==img.width&&90==img.height&&(this.posterImage="https://img.youtube.com/vi/".concat(videoId,"/hqdefault.jpg"))};let loadedcaption=!1;var ready=!1,self=this;let hasError=!1;var options={videoId:videoId,width:1080,height:720,playerVars:{autoplay:opts.autoplay||0,hl:M.cfg.language,start:start,end:end,controls:showControls?1:0,showinfo:0,fs:0,iv_load_policy:3,cc_load_policy:0,autohide:1,rel:0,playsinline:1,disablekb:opts.keyboard?0:1,mute:1},events:{onError:function(e){hasError=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerError",{error:e.data})},onReady:function(e){if(self.title=e.target.videoTitle,e.target.getDuration()<=0&&""==e.target.videoTitle)return void(0,_event_dispatcher.dispatchEvent)("iv:playerError",{error:"Video not found"});let totaltime=Number(e.target.getDuration().toFixed(2))-self.frequency;if(0==e.target.getDuration()&&(totaltime=.1,self.live=!0),.1!=end||self.live||(end=totaltime),end=end?Math.min(end,totaltime):totaltime,end=Number(end.toFixed(2)),self.end=end,self.totaltime=totaltime,self.duration=self.end-self.start,self.aspectratio=self.ratio(),1==preload&&0==customStart)ready=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerReady",null,document.getElementById(node)),(0,_jquery.default)("#video-wrapper").removeClass("invisible");else{e.target.mute(),e.target.playVideo();let count=0,interval=setInterval((()=>{if(count++,!0===ready)return clearInterval(interval),e.target.pauseVideo(),void e.target.unMute();let currentTime=e.target.getCurrentTime();if(currentTime>0||count>6){if(clearInterval(interval),hasError)return;self.live&&(self.start=currentTime,self.end=currentTime+1),Math.abs(currentTime-self.start)>self.frequency&&e.target.seekTo(self.start),e.target.getPlayerState()===YT.PlayerState.BUFFERING?(e.target.playVideo(),setTimeout((()=>{e.target.unMute(),ready=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerReady",null,document.getElementById(node))}),1e3)):(e.target.unMute(),ready=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerReady",null,document.getElementById(node))),(0,_jquery.default)("#video-wrapper").removeClass("invisible")}}),1e3)}},onAutoplayBlocked:function(e){(0,_jquery.default)(".video-block, #video-block").remove(),!1===ready&&(e.target.unMute(),ready=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerReady",null,document.getElementById(node)),(0,_jquery.default)("#video-wrapper").removeClass("invisible"))},onStateChange:function(e){if(!1===ready)return;let currentTime=player[self.node].getCurrentTime();switch(self.live||(currentTime<self.start&&(player[self.node].seekTo(self.start),player[self.node].playVideo()),currentTime>=self.end+self.frequency&&(player[self.node].seekTo(self.end-self.frequency),player[self.node].playVideo())),e.data){case YT.PlayerState.ENDED:self.ended=!0,self.paused=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerEnded");break;case YT.PlayerState.PLAYING:self.paused=!1,self.ended&&(self.ended=!1,(currentTime<self.start||currentTime>=self.end)&&player[self.node].seekTo(self.start)),(0,_event_dispatcher.dispatchEvent)("iv:playerPlay"),(0,_event_dispatcher.dispatchEvent)("iv:playerPlaying"),!self.live&&currentTime>=self.end&&(self.ended=!0,self.paused=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerEnded"));break;case YT.PlayerState.PAUSED:self.paused=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerPaused");break;case YT.PlayerState.CUED:!self.live&&currentTime>=self.end&&player[self.node].seekTo(self.start)}},onPlaybackRateChange:function(e){(0,_event_dispatcher.dispatchEvent)("iv:playerRateChange",{rate:e.data})},onApiChange:function(){let tracks;loadedcaption||(player[self.node].loadModule("captions"),loadedcaption=!0),player[self.node].setOption("captions","track",{});try{tracks=player[self.node].getOption("captions","tracklist")}catch(e){tracks=[]}tracks&&tracks.length>0&&(tracks=tracks.map((track=>({label:track.displayName,code:track.languageCode}))),self.captions=tracks),loadedcaption=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerLoaded",{tracks:tracks,reloaded:reloaded})}}};if(url.includes("youtube-nocookie")&&(options.host="https://www.youtube-nocookie.com"),window.YT)YT=window.YT||{},player[node]=new YT.Player(node,options);else{var tag=document.createElement("script");tag.src="https://www.youtube.com/iframe_api",tag.async=!0,tag.as="script",tag.rel="preload";var firstScriptTag=document.getElementsByTagName("script")[0];firstScriptTag.parentNode.insertBefore(tag,firstScriptTag),window.onYouTubeIframeAPIReady=function(){YT=window.YT||{},player[node]=new YT.Player(node,options)}}return new Promise((resolve=>{resolve(!0)}))}play(){player[this.node]&&(player[this.node].playVideo(),this.paused=!1)}pause(){player[this.node]&&(this.paused||(player[this.node].pauseVideo(),this.paused=!0))}stop(starttime){player[this.node]&&(player[this.node].seekTo(starttime),player[this.node].pauseVideo())}async seek(time){if(!player[this.node])return!1;let currentTime=this.getCurrentTime();return currentTime===time||((0,_event_dispatcher.dispatchEvent)("iv:playerSeekStart",{time:currentTime}),this.ended=!1,new Promise((resolve=>{player[this.node].seekTo(time,!0),(0,_event_dispatcher.dispatchEvent)("iv:playerSeek",{time:time}),resolve(!0)})))}getCurrentTime(){return player[this.node]?player[this.node].getCurrentTime():0}getDuration(){return player[this.node]?player[this.node].getDuration():0}isPaused(){return!player[this.node]||(!!this.paused||player[this.node].getPlayerState()==window.YT.PlayerState.PAUSED)}isPlaying(){if(!player[this.node])return!1;if(this.paused)return!1;try{return player[this.node].getPlayerState()==window.YT.PlayerState.PLAYING}catch(e){return!1}}isEnded(){return!!player[this.node]&&(!!this.ended||(player[this.node].getPlayerState()==window.YT.PlayerState.ENDED||player[this.node].getCurrentTime()>=this.end))}ratio(){return 16/9}destroy(){player[this.node]&&(player[this.node].destroy(),(0,_event_dispatcher.dispatchEvent)("iv:playerDestroyed"))}getState(){return player[this.node]?player[this.node].getPlayerState():0}setRate(rate){return player[this.node]?(player[this.node].setPlaybackRate(rate),rate):1}mute(){player[this.node]&&(player[this.node].mute(),(0,_event_dispatcher.dispatchEvent)("iv:playerVolumeChange",{volume:0}))}unMute(){player[this.node]&&(player[this.node].unMute(),player[this.node].setVolume(100),(0,_event_dispatcher.dispatchEvent)("iv:playerVolumeChange",{volume:1}))}isMuted(){return!!player[this.node]&&player[this.node].isMuted()}originalPlayer(){return player[this.node]}setCaption(track){player[this.node]&&player[this.node].setOption("captions","track",track?{languageCode:track}:{})}};return _exports.default=_default,_exports.default}));

//# sourceMappingURL=yt.min.js.map