define("mod_interactivevideo/player/vidyard",["exports","core/event_dispatcher","jquery","mod_interactivevideo/player/checkautoplay"],(function(_exports,_event_dispatcher,_jquery,_checkautoplay){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Vidyard Player class
   * Doc: https://knowledge.vidyard.com/hc/en-us/articles/360019034753-Using-the-Vidyard-Player-API
   * @module     mod_interactivevideo/player/vidyard
   * @copyright  2024 Sokunthearith Makara <sokunthearithmakara@gmail.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_jquery=_interopRequireDefault(_jquery),_checkautoplay=_interopRequireDefault(_checkautoplay);var player={};var _default=class{constructor(){this.useAnimationFrame=!1,this.type="vidyard",this.frequency=.25,this.support={playbackrate:!0,quality:!1}}async getInfo(url,node){this.node=node;let self=this;var match=/(?:https?:\/\/)?(?:share\.vidyard\.com)\/watch\/([a-zA-Z0-9]+)/i.exec(url),videoId=match?match[1]:null;this.videoId=videoId;var tag=document.createElement("script");tag.src="https://play.vidyard.com/embed/v4.js",tag.async=!0,tag.as="script",tag.rel="preload";var firstScriptTag=document.getElementsByTagName("script")[0];return firstScriptTag.parentNode.insertBefore(tag,firstScriptTag),(0,_jquery.default)("#".concat(node)).attr({"data-uuid":videoId,"data-v":"4","data-type":"inline","data-autoplay":"0","data-viral_sharing":"0","data-embed_button":"0","data-hide_playlist":"1","data-name_overlay":"0"}).addClass("vidyard-player-embed"),new Promise((resolve=>{window.onVidyardAPI=vidyardEmbed=>{vidyardEmbed.api.addReadyListener(((_,pl)=>{player[node]=pl,(0,_jquery.default)(pl.container).attr("id",node),(0,_jquery.default)(pl.container).parent().removeClass("audio");let targetvideo=pl.metadata.chapters_attributes[0].video_attributes;self.targetvideo=targetvideo,self.title=targetvideo.name,self.posterImage=targetvideo.thumbnail_urls.normal,resolve({duration:targetvideo.length_in_seconds,title:self.title,posterImage:self.posterImage})}))}}))}async load(url,start,end){let opts=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{},reloaded=arguments.length>4&&void 0!==arguments[4]&&arguments[4],showControls=opts.showControls||!1;const node=opts.node||"player";this.node=node,this.allowAutoplay=await(0,_checkautoplay.default)(document.getElementById(node)),this.allowAutoplay||(0,_event_dispatcher.dispatchEvent)("iv:autoplayBlocked",{requireVideoBlock:!0});let self=this,ready=!1;var match=/(?:https?:\/\/)?(?:share\.vidyard\.com)\/watch\/([a-zA-Z0-9]+)/i.exec(url),videoId=match?match[1]:null;this.videoId=videoId;var tag=document.createElement("script");tag.src="https://play.vidyard.com/embed/v4.js",tag.async=!0,tag.as="script",tag.rel="preload";var firstScriptTag=document.getElementsByTagName("script")[0];firstScriptTag.parentNode.insertBefore(tag,firstScriptTag),(0,_jquery.default)("#".concat(node)).attr({"data-uuid":videoId,"data-v":"4","data-type":"inline","data-autoplay":"0","data-second":start||0,"data-hidden_controls":showControls?"0":"1","data-viral_sharing":"0","data-embed_button":"0","data-hide_playlist":"1","data-name_overlay":"0"}).addClass("vidyard-player-embed"),window.onVidyardAPI=vidyardEmbed=>{vidyardEmbed.api.addReadyListener(((_,pl)=>{player[node]=pl,(0,_jquery.default)(pl.container).attr("id",node),(0,_jquery.default)(pl.container).parent().removeClass("audio");let targetvideo=pl.metadata.chapters_attributes[0].video_attributes;self.targetvideo=targetvideo,self.title=targetvideo.name,self.start=start||0;let totaltime=Number(targetvideo.length_in_seconds.toFixed(2))-self.frequency;end=end?Math.min(end,totaltime):totaltime,end=Number(end.toFixed(2)),self.end=end,self.totaltime=Number(totaltime.toFixed(2)),self.duration=self.end-self.start,self.posterImage=targetvideo.thumbnail_urls.normal,player[node].disableCaption();let tracks=[];targetvideo.captions.length>0&&(targetvideo.captions.forEach((track=>{tracks.push({label:track.name,code:track.language})})),(0,_event_dispatcher.dispatchEvent)("iv:playerLoaded",{tracks:tracks,reloaded:reloaded})),player[node].on("ready",(function(){let $div=(0,_jquery.default)(pl.container).find(".vidyard-div-"+videoId+'[role="region"]');self.aspectratio=$div[0].style["padding-bottom"].replace("%","")/100,self.aspectratio=1/self.aspectratio,ready=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerReady",null,document.getElementById(node)),setTimeout((()=>{(0,_jquery.default)(".video-block, #video-block").addClass("no-pointer bg-transparent")}),1e3)})),player[node].on("play",(function(){self.paused=!1,(0,_event_dispatcher.dispatchEvent)("iv:playerPlay")})),player[node].on("pause",(function(){self.paused=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerPaused")})),player[node].on("videoComplete",(async function(){self.ended=!0,pl.metadata.chapters_attributes.length>1&&(player[node].playVideoAtIndex(0),player[node].pause()),player[node].seek(self.start),(0,_event_dispatcher.dispatchEvent)("iv:playerEnded")})),player[node].on("timeupdate",(function(e){if(ready){if(e>self.end)return self.ended=!0,self.paused=!0,player[node].seek(self.start),player[node].pause(),void(0,_event_dispatcher.dispatchEvent)("iv:playerEnded");e<self.start&&player[node].seek(self.start),self.paused=!1,self.ended=!1,(0,_event_dispatcher.dispatchEvent)("iv:playerPlaying")}})),player[node].on("volumechange",(function(e){(0,_event_dispatcher.dispatchEvent)("iv:playerVolumeChange",{volume:e.volume})}))}),videoId)}}play(){player[this.node]&&(player[this.node].play(),this.paused=!1)}pause(){player[this.node]&&(player[this.node].pause(),this.paused=!0)}stop(starttime){player[this.node]&&(player[this.node].seek(starttime),player[this.node].pause())}async seek(time){if(!player[this.node])return time;let currentTime=player[this.node].currentTime();return(0,_event_dispatcher.dispatchEvent)("iv:playerSeekStart",{time:currentTime}),this.ended=!1,new Promise((resolve=>{player[this.node].seek(time,!0),(0,_event_dispatcher.dispatchEvent)("iv:playerSeek",{time:time}),resolve(!0)}))}getCurrentTime(){return player[this.node]?player[this.node].currentTime():0}getDuration(){return player[this.node]?this.targetvideo.length_in_seconds:0}isPaused(){return!player[this.node]||this.paused}isPlaying(){return!!player[this.node]&&!this.paused}isEnded(){return!!player[this.node]&&this.ended}ratio(){return player[this.node]?this.aspectratio:16/9}destroy(){(0,_jquery.default)("#".concat(this.node)).remove(),player[this.node]=null,(0,_event_dispatcher.dispatchEvent)("iv:playerDestroyed")}getState(){return player[this.node]?this.paused?"paused":"playing":"paused"}setRate(rate){return player[this.node]?(player[this.node].setPlaybackSpeed(rate),rate):rate}mute(){player[this.node]&&(player[this.node].setVolume(0),this.muted=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerVolumeChange",{volume:0}))}unMute(){player[this.node]&&(player[this.node].setVolume(1),this.muted=!1,(0,_event_dispatcher.dispatchEvent)("iv:playerVolumeChange",{volume:1}))}isMuted(){return!!player[this.node]&&this.muted}originalPlayer(){return player[this.node]}setCaption(track){player[this.node]&&(track&&""!==track?player[this.node].enableCaption(track):player[this.node].disableCaption())}};return _exports.default=_default,_exports.default}));

//# sourceMappingURL=vidyard.min.js.map