define("mod_interactivevideo/player/vdocipher",["exports","jquery","core/event_dispatcher","mod_interactivevideo/player/checkautoplay"],(function(_exports,_jquery,_event_dispatcher,_checkautoplay){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * VdoCipher Player class
   * Doc: https://www.vdocipher.com/docs/player/v2/
   * @module     mod_interactivevideo/player/vdocipher
   * @copyright  2025 Sokunthearith Makara <sokunthearithmakara@gmail.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_jquery=_interopRequireDefault(_jquery),_checkautoplay=_interopRequireDefault(_checkautoplay);let player={};var _default=class{constructor(){this.type="vdocipher",this.frequency=.25,this.useAnimationFrame=!1,this.support={playbackrate:!0,quality:!0,password:!1},this.live=!1}async getInfo(url,node){this.node=node;let self=this;url=url.split("|")[0];var match=/(?:https?:\/\/)?(?:www\.)?vdocipher\.com\/dashboard\/video\/(?:embed\/|)([a-zA-Z0-9_-]+)/i.exec(url),videoId=match?match[1]:null;this.videoId=videoId;let data=await(async()=>await _jquery.default.ajax({url:M.cfg.wwwroot+"/mod/interactivevideo/ajax.php",type:"POST",dataType:"text",data:{action:"get_vdocipher",sesskey:M.cfg.sesskey,videoid:videoId,contextid:M.cfg.contextid,info:"otp"}}))();try{data=JSON.parse(data)}catch{data={error:!0}}if(data.error)return void(0,_event_dispatcher.dispatchEvent)("iv:playerError",{error:data});self.otp=data.otp,self.playbackInfo=data.playbackInfo;let info=await(async()=>await _jquery.default.ajax({url:M.cfg.wwwroot+"/mod/interactivevideo/ajax.php",type:"POST",dataType:"text",data:{action:"get_vdocipher",sesskey:M.cfg.sesskey,videoid:videoId,contextid:M.cfg.contextid,info:"info"}}))();try{info=JSON.parse(info)}catch{info={error:!0}}if(info.error)return void(0,_event_dispatcher.dispatchEvent)("iv:playerError",{error:info});self.title=info.title,self.posterImage=info.posters[0]?info.posters[0].posterUrl:info.poster,self.aspectratio=info.posters[0].width/info.posters[0].height,self.duration=info.length,self.iframesrc="https://player.vdocipher.com/v2/?otp=".concat(self.otp,"&playbackInfo=").concat(self.playbackInfo);var tag=document.createElement("script");tag.src="https://player.vdocipher.com/v2/api.js",tag.async=!0,tag.as="script",tag.rel="preload";var firstScriptTag=document.getElementsByTagName("script")[0];firstScriptTag.parentNode.insertBefore(tag,firstScriptTag),(0,_jquery.default)("#".concat(node)).replaceWith('\n            <iframe id="'.concat(node,'"\n            src="').concat(self.iframesrc)+'&controls=on"\n             frameborder=0 allowFullScreen="true" allow="encrypted-media"></iframe>');let iframe=document.getElementById(node);return await new Promise((function waitForVdoPlayer(resolve){window.VdoPlayer?(player[node]=window.VdoPlayer.getInstance(iframe),resolve()):window.requestAnimationFrame((()=>waitForVdoPlayer(resolve)))})),new Promise((resolve=>{player[node].video.addEventListener("loadedmetadata",(async function(){resolve({duration:self.duration,title:self.title,posterImage:self.posterImage})}))}))}async load(url,start,end){let opts=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{},reloaded=arguments.length>4&&void 0!==arguments[4]&&arguments[4];const showControls=opts.showControls||!1,node=opts.node||"player";this.node=node,this.url=url,this.allowAutoplay=await(0,_checkautoplay.default)(document.getElementById(node)),this.allowAutoplay||(0,_event_dispatcher.dispatchEvent)("iv:autoplayBlocked",{requireVideoBlock:!0});var self=this;if(this.start=start,this.end=end,opts.editform){url=url.split("|")[0];var match=/(?:https?:\/\/)?(?:www\.)?vdocipher\.com\/dashboard\/video\/(?:embed\/|)([a-zA-Z0-9_-]+)/i.exec(url),videoId=match?match[1]:null;this.videoId=videoId;const getData=async()=>await _jquery.default.ajax({url:M.cfg.wwwroot+"/mod/interactivevideo/ajax.php",type:"POST",dataType:"text",data:{action:"get_vdocipher",sesskey:M.cfg.sesskey,videoid:videoId,contextid:M.cfg.contextid,info:"otp"}});let data=await getData();try{data=JSON.parse(data)}catch{data={error:!0}}if(data.error)return void(0,_event_dispatcher.dispatchEvent)("iv:playerError",{error:data});self.otp=data.otp,self.playbackInfo=data.playbackInfo;const getVideoInfo=async()=>await _jquery.default.ajax({url:M.cfg.wwwroot+"/mod/interactivevideo/ajax.php",type:"POST",dataType:"text",data:{action:"get_vdocipher",sesskey:M.cfg.sesskey,videoid:videoId,contextid:M.cfg.contextid,info:"info"}});let info=await getVideoInfo();try{info=JSON.parse(info)}catch{info={error:!0}}if(info.error)return void(0,_event_dispatcher.dispatchEvent)("iv:playerError",{error:info});self.title=info.title,self.posterImage=info.posters[0]?info.posters[0].posterUrl:info.poster,self.aspectratio=info.posters[0].width/info.posters[0].height,self.duration=info.length,self.iframesrc="https://player.vdocipher.com/v2/?otp=".concat(self.otp,"&playbackInfo=").concat(self.playbackInfo)}else{self.iframesrc=url.split("|")[1];let params=new URLSearchParams(self.iframesrc);self.otp=params.get("otp"),self.playbackInfo=params.get("playbackInfo")}var tag=document.createElement("script");tag.src="https://player.vdocipher.com/v2/api.js",tag.async=!0,tag.as="script",tag.rel="preload";var firstScriptTag=document.getElementsByTagName("script")[0];firstScriptTag.parentNode.insertBefore(tag,firstScriptTag),(0,_jquery.default)("#".concat(node)).replaceWith('\n            <iframe id="'.concat(node,'"\n            src="').concat(self.iframesrc)+"&controls=".concat(showControls?"on":"off",'"\n             frameborder=0 allowFullScreen="true" allow="encrypted-media"></iframe>'));let iframe=document.getElementById(node);await new Promise((function waitForVdoPlayer(resolve){window.VdoPlayer?(player[node]=window.VdoPlayer.getInstance(iframe),resolve()):window.requestAnimationFrame((()=>waitForVdoPlayer(resolve)))})),player[node].video.setAttribute("disablePictureInPicture",""),player[node].video.addEventListener("loadedmetadata",(async function(){self.aspectratio=self.ratio(),isNaN(self.aspectratio)&&(self.aspectratio=16/9);let totaltime=Number(player[node].video.duration.toFixed(2))-self.frequency;end=end?Math.min(end,totaltime):totaltime,end=Number(end.toFixed(2)),self.end=end,self.totaltime=totaltime,self.duration=self.end-self.start,player[node].video.currentTime=self.start;let captions=await player[node].api.getCaptionLanguages();captions=captions.languages||[];let tracks=[];captions&&captions.length&&captions.forEach((track=>{tracks.push({label:track.label,code:track.lang})})),player[node].api.hideCaptions(),(0,_event_dispatcher.dispatchEvent)("iv:playerLoaded",{tracks:tracks,reloaded:reloaded}),(0,_event_dispatcher.dispatchEvent)("iv:playerReady",null,document.getElementById(node)),opts.editform&&!self.url.includes("|")&&(0,_jquery.default)("#id_videourl").val(self.url+"|"+self.iframesrc),navigator.userAgent.toLowerCase().indexOf("chrome")>-1&&(setTimeout((()=>{(0,_jquery.default)(".video-block, #video-block").addClass("no-pointer")}),2e3),(0,_jquery.default)("#start-screen").remove())})),player[node].video.addEventListener("pause",(function(){self.paused=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerPaused")})),player[node].video.addEventListener("play",(function(){self.paused=!1,(0,_event_dispatcher.dispatchEvent)("iv:playerPlay"),(0,_jquery.default)(".video-block, #video-block").removeClass("no-pointer")})),player[node].video.addEventListener("timeupdate",(function(){self.paused||(player[node].video.currentTime<self.start&&(player[node].video.currentTime=self.start),player[node].video.currentTime>=self.end+self.frequency&&!self.live&&(player[node].video.currentTime=self.end-self.frequency),(0,_event_dispatcher.dispatchEvent)("iv:playerPlaying"),self.live||(self.ended?self.ended=!1:!self.ended&&player[node].video.currentTime>=self.end&&(self.ended=!0,self.paused=!0,player[node].video.pause(),(0,_event_dispatcher.dispatchEvent)("iv:playerEnded"))))})),player[node].video.addEventListener("error",(function(e){(0,_event_dispatcher.dispatchEvent)("iv:playerError",{error:e})})),player[node].video.addEventListener("ratechange",(function(){(0,_event_dispatcher.dispatchEvent)("iv:playerRateChange",{rate:player[node].video.playbackRate})})),player[node].video.addEventListener("waiting",(function(){(0,_event_dispatcher.dispatchEvent)("iv:playerBuffering")})),player[node].video.addEventListener("volumechange",(function(){(0,_event_dispatcher.dispatchEvent)("iv:playerVolumeChange",{volume:player[node].video.volume})})),player[node].api.addEventListener("videoQualityChange",(function(quality){(0,_event_dispatcher.dispatchEvent)("iv:playerQualityChange",{quality:quality})}))}play(){if(player[this.node]){try{player[this.node].video.play()}catch(e){player[this.node].api.loadVideo(this.otp,this.playbackInfo),player[this.node].video.play()}this.paused=!1}}pause(){player[this.node]&&(player[this.node].video.pause(),this.paused=!0)}stop(starttime){player[this.node]&&(player[this.node].video.currentTime=starttime||this.start,player[this.node].video.pause())}seek(time){if(!player[this.node])return time;let currentTime=this.getCurrentTime();return(0,_event_dispatcher.dispatchEvent)("iv:playerSeekStart",{time:currentTime}),this.ended=!1,player[this.node].video.currentTime=time,(0,_event_dispatcher.dispatchEvent)("iv:playerSeek",{time:time}),!0}getCurrentTime(){return player[this.node]?player[this.node].video.currentTime:0}getDuration(){return player[this.node]?player[this.node].video.duration:0}isPaused(){return!player[this.node]||(!!this.paused||player[this.node].video.paused)}isPlaying(){return!!player[this.node]&&(!this.paused&&!player[this.node].video.paused)}isEnded(){return!!player[this.node]&&(player[this.node].video.ended||player[this.node].video.currentTime>=this.end)}ratio(){return player[this.node]?player[this.node].video.videoWidth/player[this.node].video.videoHeight:16/9}destroy(){player[this.node]&&(player[this.node]=null,(0,_jquery.default)("#".concat(this.node)).remove(),(0,_event_dispatcher.dispatchEvent)("iv:playerDestroyed"))}getState(){return player[this.node]?player[this.node].video.paused?"paused":"playing":0}setRate(rate){return player[this.node]?(player[this.node].video.playbackRate=rate,rate):1}mute(){player[this.node]&&(player[this.node].video.muted=!0,player[this.node].video.volume=0,(0,_event_dispatcher.dispatchEvent)("iv:playerVolumeChange",{volume:0}))}unMute(){player[this.node]&&(player[this.node].video.muted=!1,player[this.node].video.volume=1,(0,_event_dispatcher.dispatchEvent)("iv:playerVolumeChange",{volume:1}))}isMuted(){return!!player[this.node]&&player[this.node].video.muted}originalPlayer(){return player[this.node]}setQuality(quality){return player[this.node]?(player[this.node].api.setVideoQuality(quality),quality):quality}async getQualities(){if(!player[this.node])return null;let qualities=await player[this.node].api.getVideoQualities();return{qualities:qualities.qualities.map((x=>x.id)),qualitiesLabel:qualities.qualities.map((x=>x.label)),currentQuality:qualities.qualities.find((x=>x.active))?qualities.qualities.find((x=>x.active)).id:null}}setCaption(track){return player[this.node]?""===track?(player[this.node].api.hideCaptions(),track):(player[this.node].api.setCaptionLanguage(track),track):track}};return _exports.default=_default,_exports.default}));

//# sourceMappingURL=vdocipher.min.js.map