define("mod_interactivevideo/player/rumble",["exports","jquery","core/event_dispatcher","mod_interactivevideo/player/checkautoplay"],(function(_exports,_jquery,_event_dispatcher,_checkautoplay){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Rumble Player class
   * Doc: https://www.rumbleplayer.com/developers/Player-Methods.html
   *
   * @module     mod_interactivevideo/player/rumble
   * @copyright  2024 Sokunthearith Makara <sokunthearithmakara@gmail.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_jquery=_interopRequireDefault(_jquery),_checkautoplay=_interopRequireDefault(_checkautoplay);var player={};var _default=class{constructor(){this.type="rumble",this.useAnimationFrame=!0,this.frequency=.1,this.support={playbackrate:!1,quality:!1,password:!1}}async getInfo(url,node){this.node=node;let self=this;return new Promise((resolve=>{let oEmbed="https://rumble.com/api/Media/oembed.json?url="+encodeURIComponent(url);_jquery.default.ajax({url:M.cfg.wwwroot+"/mod/interactivevideo/ajax.php",type:"POST",data:{action:"get_from_url",contextid:M.cfg.contextid,url:oEmbed,sesskey:M.cfg.sesskey}}).done((function(data){let firstAPIrun=!1;self.title=data.title,self.posterImage=data.thumbnail_url,self.duration=Number(data.duration).toFixed(2);let videoId=(0,_jquery.default)(data.html).attr("src").match(/embed\/([a-zA-Z0-9]+)/)[1];videoId=videoId.split("/")[0],self.videoId=videoId;var tag=document.createElement("script");tag.src="https://rumble.com/embedJS/"+videoId;var firstScriptTag=document.getElementsByTagName("script")[0];firstScriptTag.parentNode.insertBefore(tag,firstScriptTag),tag.onload=async()=>{let id=videoId.split(".")[1]?videoId.split(".")[1]:videoId;window.Rumble("play",{video:id,div:node,rel:0,autoplay:2,ui:{logo:{hidden:!0},fullscreen:{hidden:!0},autoplay:{hidden:!0}},api:function(api){player[node]=api,firstAPIrun||(firstAPIrun=!0,resolve({duration:self.duration,title:self.title,posterImage:self.posterImage}))}})}}))}))}async load(url,start,end){let opts=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{};const showControls=opts.showControls||!1,node=opts.node||"player";this.node=node,this.start=start,this.allowAutoplay=await(0,_checkautoplay.default)(document.getElementById(node)),this.allowAutoplay||(0,_event_dispatcher.dispatchEvent)("iv:autoplayBlocked"),(0,_jquery.default)("#start-screen, .video-block").addClass("no-pointer");let ready=!1,firstAPIrun=!1,self=this;self.ended="unknown",self.paused="unknown";let oEmbed="https://rumble.com/api/Media/oembed.json?url="+encodeURIComponent(url);_jquery.default.ajax({url:M.cfg.wwwroot+"/mod/interactivevideo/ajax.php",type:"POST",data:{action:"get_from_url",contextid:M.cfg.contextid,url:oEmbed,sesskey:M.cfg.sesskey}}).done((function(data){firstAPIrun=!1,self.title=data.title,self.aspectratio=data.width/data.height,self.posterImage=data.thumbnail_url;let totaltime=Number(data.duration).toFixed(2)-self.frequency;end=end&&0!=end?Math.min(end,totaltime):totaltime,end=Number(end).toFixed(2),self.end=end,self.totaltime=totaltime,self.duration=self.end-self.start;let videoId=(0,_jquery.default)(data.html).attr("src").match(/embed\/([a-zA-Z0-9]+)/)[1];videoId=videoId.split("/")[0],self.videoId=videoId;var tag=document.createElement("script");tag.src="https://rumble.com/embedJS/"+videoId;var firstScriptTag=document.getElementsByTagName("script")[0];firstScriptTag.parentNode.insertBefore(tag,firstScriptTag),tag.onload=async()=>{let id=videoId.split(".")[1]?videoId.split(".")[1]:videoId;window.Rumble("play",{video:id,div:node,rel:0,autoplay:2,ui:{logo:{hidden:!0},fullscreen:{hidden:!0},autoplay:{hidden:!0}},api:function(api){player[node]=api,player[node].mute(),showControls||(0,_jquery.default)("body").addClass("no-original-controls"),firstAPIrun||(player[node].setCurrentTime(start),ready=!0,firstAPIrun=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerReady",null,document.getElementById(node))),(0,_jquery.default)(document).off("timeupdate.Rumble").on("timeupdate.Rumble",(function(){ready&&(player[node].getCurrentTime()<start&&player[node].setCurrentTime(start),player[node].getCurrentTime()>=end+self.frequency&&player[node].setCurrentTime(end-self.frequency))})),api.on("play",(function(){ready&&(self.paused=!1,player[node]&&(player[node].getCurrentTime()<start&&player[node].setCurrentTime(start),self.ended&&player[node].getCurrentTime()>=end&&(player[node].setCurrentTime(start),player[node].play(),self.ended=!1),self.ended=!1,(0,_event_dispatcher.dispatchEvent)("iv:playerPlay"),(0,_event_dispatcher.dispatchEvent)("iv:playerPlaying"),showControls||(0,_jquery.default)("body").hasClass("no-original-controls")||(0,_jquery.default)("body").addClass("no-original-controls")))})),api.on("pause",(()=>{if(ready&&!self.ended){if(self.paused=!0,player[node].getCurrentTime()>=end)return self.ended=!0,void(0,_event_dispatcher.dispatchEvent)("iv:playerEnded");(0,_event_dispatcher.dispatchEvent)("iv:playerPaused")}})),api.on("videoEnd",(()=>{ready&&(self.ended=!0,self.paused=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerEnded"))}))}})}}))}play(){player[this.node]&&(player[this.node].play(),this.paused=!1)}pause(){return!!player[this.node]&&(player[this.node].pause(),this.paused=!0,!0)}stop(starttime){player[this.node]&&(player[this.node].pause(),player[this.node].setCurrentTime(starttime))}seek(time){if(!player[this.node])return time;let currentTime=this.getCurrentTime();return(0,_event_dispatcher.dispatchEvent)("iv:playerSeekStart",{time:currentTime}),time=parseFloat(time),new Promise((resolve=>{time<0&&(time=0),this.ended=!1,player[this.node].setCurrentTime(time),(0,_event_dispatcher.dispatchEvent)("iv:playerSeek",{time:time}),resolve(time)}))}getCurrentTime(){return player[this.node]?player[this.node].getCurrentTime():0}getDuration(){return player[this.node]?player[this.node].getDuration():0}isPaused(){return!player[this.node]||this.paused&&player[this.node].getPaused()}isPlaying(){return!!player[this.node]&&!this.paused}isEnded(){return"unknown"!==this.ended&&(this.ended||player[this.node].getCurrentTime()>=this.end)}async ratio(){return player[this.node]?this.aspectratio:16/9}destroy(){try{(0,_jquery.default)("#".concat(this.node)).remove()}catch(e){window.console.error(e)}(0,_jquery.default)(document).off("timeupdate.Rumble"),player[this.node]=null,(0,_event_dispatcher.dispatchEvent)("iv:playerDestroyed")}async getState(){return this.paused?"paused":"playing"}setRate(){}mute(){player[this.node].mute(),this.muted=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerVolumeChange",{volume:0})}unMute(){player[this.node].unmute(),player[this.node].setVolume(1),this.muted=!1,(0,_event_dispatcher.dispatchEvent)("iv:playerVolumeChange",{volume:1})}isMuted(){return this.muted}originalPlayer(){return player[this.node]}setQuality(){}getQualities(){return null}setCaption(track){return track}};return _exports.default=_default,_exports.default}));

//# sourceMappingURL=rumble.min.js.map