define("mod_interactivevideo/player/dyntube",["exports","jquery","core/event_dispatcher","mod_interactivevideo/player/checkautoplay"],(function(_exports,_jquery,_event_dispatcher,_checkautoplay){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Dyntube Player class
   * Doc: https://www.dyntube.com/dev/javascript-events-methods/plain-javascript-events-and-methods
   * @module     mod_interactivevideo/player/dyntube
   * @copyright  2025 Sokunthearith Makara <sokunthearithmakara@gmail.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_jquery=_interopRequireDefault(_jquery),_checkautoplay=_interopRequireDefault(_checkautoplay);let player={};var _default=class{constructor(){this.type="dyntube",this.frequency=.25,this.useAnimationFrame=!1,this.support={playbackrate:!1,quality:!1,password:!1},this.live=!1}async getInfo(url,node){this.node=node;let self=this;var match=/(?:https?:\/\/)?(?:videos\.dyntube\.com|dyntube\.com)\/(?:videos|iframes)\/([^/]+)/.exec(url),videoId=match?match[1]:null;this.videoId=videoId,url="https://videos.dyntube.com/videos/".concat(videoId);let oembedUrl="https://videos.dyntube.com/oembed/oembed.json?url=".concat(encodeURIComponent(url));let data=await(async()=>{try{return await _jquery.default.ajax({url:oembedUrl,type:"GET",dataType:"json"})}catch{return{error:!0}}})();if(data.error)return void(0,_event_dispatcher.dispatchEvent)("iv:playerError",{error:data});self.title=data.title,self.posterImage=data.thumbnail_url,self.aspectratio=data.width/data.height,self.duration=data.duration;let $iframe=(0,_jquery.default)(data.html);self.iframesrc=$iframe.attr("src");var tag=document.createElement("script");tag.src="https://embed.dyntube.com/player/v1/player-1.0.3.js",tag.async=!0,tag.as="script",tag.rel="preload";var firstScriptTag=document.getElementsByTagName("script")[0];return firstScriptTag.parentNode.insertBefore(tag,firstScriptTag),(0,_jquery.default)("#".concat(node)).length>0&&(0,_jquery.default)("#".concat(node)).replaceWith('\n            <iframe id="'.concat(node,'" allow="autoplay; fullscreen" frameborder="0"\n             webkitallowfullscreen mozallowfullscreen allowfullscreen\n              src="').concat(self.iframesrc,'"></iframe>')),await new Promise((function waitForDyntube(resolve){window.dyntube&&window.dyntube.Player?(player[node]=new window.dyntube.Player(document.querySelector("#".concat(node))),resolve()):window.requestAnimationFrame((()=>waitForDyntube(resolve)))})),new Promise((resolve=>{player[node].on("ready",(function(){resolve({title:self.title,duration:self.duration,posterImage:self.posterImage})}))}))}async load(url,start,end){let opts=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{};const showControls=opts.showControls||!1,node=opts.node||"player";this.node=node,this.allowAutoplay=await(0,_checkautoplay.default)(document.getElementById(node)),this.allowAutoplay||(0,_event_dispatcher.dispatchEvent)("iv:autoplayBlocked",{requireVideoBlock:!showControls});var self=this;this.start=start,this.end=end;var match=/(?:https?:\/\/)?(?:videos\.dyntube\.com|dyntube\.com)\/(?:videos|iframes)\/([^/]+)/.exec(url),videoId=match?match[1]:null;this.videoId=videoId,url="https://videos.dyntube.com/videos/".concat(videoId);let oembedUrl="https://videos.dyntube.com/oembed/oembed.json?url=".concat(encodeURIComponent(url));let data=await(async()=>{try{return await _jquery.default.ajax({url:oembedUrl,type:"GET",dataType:"json"})}catch{return{error:!0}}})();if(data.error)return void(0,_event_dispatcher.dispatchEvent)("iv:playerError",{error:data});self.title=data.title,self.posterImage=data.thumbnail_url,self.aspectratio=data.width/data.height,self.duration=data.duration;let $iframe=(0,_jquery.default)(data.html);self.iframesrc=$iframe.attr("src");var tag=document.createElement("script");tag.src="https://embed.dyntube.com/player/v1/player-1.0.3.js",tag.async=!0,tag.as="script",tag.rel="preload";var firstScriptTag=document.getElementsByTagName("script")[0];firstScriptTag.parentNode.insertBefore(tag,firstScriptTag),(0,_jquery.default)("#".concat(node)).replaceWith('\n            <iframe id="'.concat(node,'" allow="autoplay; fullscreen" frameborder="0"\n             webkitallowfullscreen mozallowfullscreen allowfullscreen\n              src="').concat(self.iframesrc,"?").concat(showControls?"":"controls=hidden","&start=").concat(start,"&end=").concat(end,'"></iframe>')),await new Promise((function waitForDyntube(resolve){window.dyntube&&window.dyntube.Player?(player[node]=new window.dyntube.Player(document.querySelector("#".concat(node))),resolve()):window.requestAnimationFrame((()=>waitForDyntube(resolve)))})),player[node].on("ready",(function(){player[node].play(),self.currentTime=start||0,self.paused=!0,self.ended=!1,self.volume=1,end=end||self.duration,end=Number(end.toFixed(2)),self.end=end,self.totaltime=self.duration,self.duration=self.end-self.start,(0,_event_dispatcher.dispatchEvent)("iv:playerReady",null,document.getElementById(node)),player[node].on("play",(function(){self.paused=!1,(0,_event_dispatcher.dispatchEvent)("iv:playerPlay")})),player[node].on("pause",(function(){self.paused=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerPaused")})),player[node].on("volumechange",(function(volumeLevel){(0,_event_dispatcher.dispatchEvent)("iv:playerVolumeChange",{volume:volumeLevel})})),player[node].on("timeupdate",(function(currentTime){if(currentTime>=self.end)return self.ended=!0,self.paused=!0,player[self.node].pause(),void(0,_event_dispatcher.dispatchEvent)("iv:playerEnded");currentTime<self.start&&(currentTime=Math.ceil(self.start),self.seek(currentTime)),(0,_event_dispatcher.dispatchEvent)("iv:playerPlaying"),self.currentTime=currentTime})),player[node].on("ended",(function(){self.ended=!0,self.paused=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerEnded")}))}))}play(){player[this.node]&&(player[this.node].play(),this.paused=!1)}pause(){player[this.node]&&(player[this.node].pause(),this.paused=!0)}stop(starttime){player[this.node]&&(this.currentTime=starttime||this.start,player[this.node].pause())}async seek(time){return!!player[this.node]&&(time<this.start&&(time=this.start),time>this.end&&(time=this.end),(0,_event_dispatcher.dispatchEvent)("iv:playerSeekStart",{time:this.currentTime}),this.ended=!1,player[this.node].seek(Number(time)),this.currentTime=time,(0,_event_dispatcher.dispatchEvent)("iv:playerSeek",{time:time}),!0)}getCurrentTime(){return player[this.node]?this.currentTime||this.start:0}getDuration(){return player[this.node]?this.duration:0}isPaused(){return!player[this.node]||this.paused}isPlaying(){return!!player[this.node]&&!this.paused}isEnded(){return!!player[this.node]&&this.ended}ratio(){return this.aspectratio}destroy(){player[this.node]&&(player[this.node]=null,(0,_jquery.default)("#".concat(this.node)).remove(),(0,_event_dispatcher.dispatchEvent)("iv:playerDestroyed"))}getState(){return player[this.node]?this.paused?"paused":"playing":0}setRate(rate){return player[this.node]?rate:1}mute(){player[this.node]&&(player[this.node].mute(),this.volume=0,(0,_event_dispatcher.dispatchEvent)("iv:playerVolumeChange",{volume:0}))}unMute(){player[this.node]&&(player[this.node].unmute(),player[this.node].setVolume(1),this.volume=1,(0,_event_dispatcher.dispatchEvent)("iv:playerVolumeChange",{volume:1}))}isMuted(){return!!player[this.node]&&0===this.volume}originalPlayer(){return player[this.node]}setCaption(track){return track}};return _exports.default=_default,_exports.default}));

//# sourceMappingURL=dyntube.min.js.map