<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Theme Boost Union - Hook callbacks.
 *
 * @package    theme_boost_union
 * @copyright  2024 Alexander Bias <bias@alexanderbias.de>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$callbacks = [
    [
        'hook' => \core\hook\output\before_standard_head_html_generation::class,
        'callback' => 'theme_boost_union\local\hook\output\before_standard_head_html_generation::callback',
        'priority' => 0,
    ],
    [
        'hook' => \core\hook\output\before_standard_top_of_body_html_generation::class,
        'callback' => 'theme_boost_union\local\hook\output\before_standard_top_of_body_html_generation::callback',
        'priority' => 0,
    ],
    [
        'hook' => \core_course\hook\after_form_definition::class,
        'callback' => 'theme_boost_union\local\hook\course\after_form_definition::callback',
        'priority' => 0,
    ],
    [
        'hook' => \core_course\hook\after_form_definition_after_data::class,
        'callback' => 'theme_boost_union\local\hook\course\after_form_definition_after_data::callback',
        'priority' => 0,
    ],
    [
        'hook' => \core_course\hook\after_form_submission::class,
        'callback' => 'theme_boost_union\local\hook\course\after_form_submission::callback',
        'priority' => 0,
    ],
    [
        'hook' => \core_backup\hook\after_restore_root_define_settings::class,
        'callback' => 'theme_boost_union\local\hook\backup\after_restore_root_define_settings::callback',
        'priority' => 0,
    ],
];
