<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * English plugin strings are defined here.
 *
 * @package     local_wunderbyte_table
 * @category    string
 * @copyright   2023 Wunderbyte GmbH <info@wunderbyte.at>
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action_executed'] = 'Action executed';
$string['action_executed_desc'] = 'The user executed an action "{$a->methodname}" on the table "{$a->tablename}"';
$string['addcheckboxes'] = 'Add a checkbox to each row';
$string['adddatabody'] = 'You are about to add a row';
$string['addwbtablefilter'] = 'Add Wunderbyte Table Filter';
$string['after'] = 'after';
$string['alertentriessanitized'] = 'Warning: Only the digits 0-9 will be taken into account from your entry.';
$string['allowedittable'] = 'Edit table settings (only for testing, do not use on productive sites!) <span class="badge bg-danger text-light"><i class="fa fa-flask" aria-hidden="true"></i> Experimental</span>';
$string['allowsearchincolumns'] = 'Allow search in columns via ":" <span class="badge bg-danger text-light"><i class="fa fa-flask" aria-hidden="true"></i> Experimental</span>';
$string['apply_filter'] = 'Apply Filter';
$string['applyfilterondownload'] = 'Apply filter on download';
$string['april'] = 'April';
$string['august'] = 'August';
$string['before'] = 'before';
$string['cachedef_cachedfilters'] = 'Wunderbyte Table: Cache for filters';
$string['cachedef_cachedfulltable'] = 'Wunderbyte Table: Cached full table';
$string['cachedef_cachedrawdata'] = "Wunderbyte Table: Default cache";
$string['cachedef_encodedtables'] = 'Wunderbyte Table: Cache for encoded tables';
$string['callback'] = 'Callback filter';
$string['change'] = 'Change';
$string['changesortorder'] = "Change sort order";
$string['checkallcheckbox'] = "Check all";
$string['checkbox'] = 'Checkbox';
$string['columnemptyerror'] = 'Column is empty';
$string['couldnotloaddata'] = "Could not load data";
$string['countlabel'] = '{$a->filteredrecords} of {$a->totalrecords} records found ';
$string['customizewbtable'] = 'Customize Wunderbyte Table';
$string['datepicker'] = 'Date filter with date span';
$string['datepickererrormandatory'] = 'Fill out all mandatory values. ';
$string['datepickererroroperations'] = 'At least one operator must be selected. ';
$string['datepickerheadingcheckboxlabel'] = 'Checkbox Label:';
$string['datepickerheadingdefaultvalue'] = 'Default Value: ';
$string['datepickerheadingdefaultvalueend'] = 'Default Value end: ';
$string['datepickerheadingdefaultvaluestart'] = 'Default Value start: ';
$string['datepickerheadingname'] = 'Name: ';
$string['datepickerheadingoperation'] = 'Operations: ';
$string['datepickerheadingpossibleoperations'] = 'Possible operations: ';
$string['datepickermoodleexception'] = 'Every column can have only one filter applied';
$string['datepickerplaceholdercheckboxlabel'] = 'Insert a checkbox label';
$string['datepickerplaceholdername'] = 'Insert a filter name';
$string['datepickertype'] = 'Choose datepicker type';
$string['december'] = 'December';
$string['deletedatabody'] = 'You are about to submit this data: <br> "{$a->data}"';
$string['deletedatasubmit'] = 'Delete';
$string['deletedatatitle'] = 'Do you really want to delete this data?';
$string['displayrecords'] = 'Display records';
$string['downloadas'] = "Download table data as";
$string['editfiltername'] = 'Edit filtername';
$string['edittable'] = "Edit table";
$string['enablefilter'] = 'Enable filter';
$string['enablefilterdesc'] = 'Select checkobx if this filter should be enabled.';
$string['endvalue'] = 'End';
$string['february'] = 'February';
$string['filter'] = 'Filter table';
$string['filter_heading'] = 'Filters';
$string['filteraddnewkeyvaluepair'] = 'Add new key value pair';
$string['filtercountmessage'] = '{$a->filtersum} filter(s) on: {$a->filtercolumns}';
$string['filteremptynameerror'] = 'Name is empty';
$string['filterenabledheader'] = 'General filter settings';
$string['filterexistingkeyvaluepairs'] = 'Existing key value pairs';
$string['filterinactive'] = 'Hide the entire filter';
$string['filternopairsexist'] = 'No pairs exist';
$string['filteronloadinactive'] = 'Collapse filters when table is loaded';
$string['flexoverlap'] = 'overlapping';
$string['friday'] = 'Fri';
$string['from'] = "From";
$string['from0to1'] = "00:00 - 01:00";
$string['from10to11'] = "10:00 - 11:00";
$string['from11to12'] = "11:00 - 12:00";
$string['from12to13'] = "12:00 - 13:00";
$string['from13to14'] = "13:00 - 14:00";
$string['from14to15'] = "14:00 - 15:00";
$string['from15to16'] = "15:00 - 16:00";
$string['from16to17'] = "16:00 - 17:00";
$string['from17to18'] = "17:00 - 18:00";
$string['from18to19'] = "18:00 - 19:00";
$string['from19to20'] = "19:00 - 20:00";
$string['from1to2'] = "01:00 - 02:00";
$string['from20to21'] = "20:00 - 21:00";
$string['from21to22'] = "21:00 - 22:00";
$string['from22to23'] = "22:00 - 23:00";
$string['from23to24'] = "23:00 - 24:00";
$string['from2to3'] = "02:00 - 03:00";
$string['from3to4'] = "03:00 - 04:00";
$string['from4to5'] = "04:00 - 05:00";
$string['from5to6'] = "05:00 - 06:00";
$string['from6to7'] = "06:00 - 07:00";
$string['from7to8'] = "07:00 - 08:00";
$string['from8to9'] = "08:00 - 09:00";
$string['from9to10'] = "09:00 - 10:00";
$string['functiondoesntexist'] = "Function of action button doesn\'t exist.";
$string['genericbody'] = 'You are about to treat this rows: <br> "{$a->data}"';
$string['genericsubmit'] = 'Confirm';
$string['generictitle'] = 'Do you really want to treat this data?';
$string['gotopage'] = 'Go to page:';
$string['hideallfiltershavingbypasscache'] = 'Hide all filters that cause the cache to be bypassed.';
$string['hierarchicalfilter'] = 'Hierachy filter';
$string['hourlastmodified'] = 'Hour, last time updated';
$string['hourlist'] = 'Hourlist filter';
$string['id'] = 'ID';
$string['idnumber'] = 'IdNumber';
$string['infinitescroll'] = 'Infinite scrolling';
$string['intrange'] = 'Integer range filter';
$string['january'] = 'January';
$string['july'] = 'July';
$string['june'] = 'June';
$string['loading'] = 'Loading...';
$string['logfiltercaches'] = 'Debug feature: Save queries to DB. Has negative impact on performance. <span class="badge bg-danger text-light"><i class="fa fa-flask" aria-hidden="true"></i> Experimental</span>';
$string['march'] = 'March';
$string['may'] = 'May';
$string['missingsubqueryandfieldid'] = 'Customfieldfilter: No SQL subquery or no fieldid provided.
    You must call set_sql() or set_sql_for_fieldid before applying the filter,
    otherwise the filter cannot be applied.';
$string['module'] = 'Module';
$string['monday'] = 'Mon';
$string['newwbtablefiltername'] = 'New filter name';
$string['nmmcns'] = 'NoModal, MultipleCall, NoSelection';
$string['nmmcys'] = 'NoModal, MultipleCall, Selection';
$string['nmscns'] = 'NoModal, SingleCall, NoSelection';
$string['nmscys'] = 'NoModal, SingleCall, Selection';
$string['nocheckboxchecked'] = "You didn't select anything.";
$string['noentriesfound'] = "No entries found";
$string['norecords'] = "No records found.";
$string['noselectionbody'] = 'You are about to make an action';
$string['november'] = 'November';
$string['october'] = 'October';
$string['orderdown'] = "Sorted from Z to A";
$string['orderup'] = "Sorted from A to Z";
$string['other'] = 'Other';
$string['overlapboth'] = 'overlapping both dates';
$string['overlapend'] = 'overlapping ending';
$string['overlapstart'] = 'overlapping beginning';
$string['pagelabel'] = 'Show {$a} rows';
$string['pagesize'] = 'Number of records per page';
$string['placebuttonandpageelementsontop'] = 'Show buttons and page elements on top (instead of bottom)';
$string['pluginname'] = 'Wunderbyte Table';
$string['print'] = "Download table";
$string['privacy:metadata:local_wunderbyte_table'] = 'Wunderbyte Table';
$string['privacy:metadata:local_wunderbyte_table:count'] = 'Count';
$string['privacy:metadata:local_wunderbyte_table:hash'] = 'Hash';
$string['privacy:metadata:local_wunderbyte_table:id'] = 'ID';
$string['privacy:metadata:local_wunderbyte_table:idstring'] = 'ID string';
$string['privacy:metadata:local_wunderbyte_table:jsonstring'] = 'JSON string';
$string['privacy:metadata:local_wunderbyte_table:page'] = 'Page';
$string['privacy:metadata:local_wunderbyte_table:sql'] = 'SQL';
$string['privacy:metadata:local_wunderbyte_table:tablehash'] = 'Table hash';
$string['privacy:metadata:local_wunderbyte_table:timecreated'] = 'Time created';
$string['privacy:metadata:local_wunderbyte_table:timemodified'] = 'Time updated';
$string['privacy:metadata:local_wunderbyte_table:userid'] = 'User ID';
$string['privacy:metadata:local_wunderbyte_table:usermodified'] = 'Modified by';
$string['reload'] = "Reload table";
$string['saturday'] = 'Sat';
$string['search'] = 'Search';
$string['searchcountmessage'] = 'Search for "{$a}"';
$string['searchtitleprefix'] = 'Search titleprefix';
$string['selectedtimespan'] = 'selected timespan';
$string['september'] = 'September';
$string['setwbtablefiltercolumn'] = 'Choose filter column';
$string['setwbtablefiltercolumnoption'] = 'Please select a filter column';
$string['setwbtablefiltertype'] = 'Choose filter type';
$string['setwbtablefiltertypeoption'] = 'Please select a type';
$string['showaddfilterbutton'] = 'Show button to add custom filters';
$string['showallrecords'] = 'Show all records';
$string['showcountlabel'] = 'Show numer of records found';
$string['showdownloadbutton'] = 'Show download button';
$string['showdownloadbuttonatbottom'] = 'Show download button at bottom of the table (instead of top)';
$string['showfilter'] = 'Show this filter';
$string['showfilterontop'] = 'Show filters on top of table';
$string['showgotopage'] = 'Show Go to page dropdown';
$string['showreloadbutton'] = 'Show reload button';
$string['showrowcountselect'] = 'Show dropdown for number of rows';
$string['somethingwentwrong'] = 'Something went wrong. Please contact your admin.';
$string['sortby'] = 'Sort by...';
$string['specialbody'] = 'Action will be applied!';
$string['standardfilter'] = 'Standard filter';
$string['standardfiltergrouplabel'] = 'Key value pair (optional)';
$string['standardfilterkeylabel'] = 'Key ';
$string['standardfiltervaluekeyerror'] = 'Either both or none have to be submitted';
$string['standardfiltervaluelabel'] = 'Value ';
$string['startvalue'] = 'Start';
$string['stickyheader'] = 'Make header sticky';
$string['successaddedfilternotification'] = 'Filter was successfully edited.';
$string['sunday'] = 'Sun';
$string['table1name'] = 'Demo table 1';
$string['table2name'] = 'Demo table 2';
$string['table3name'] = 'Demo table 3';
$string['table4name'] = 'Demo table 4';
$string['table_viewed'] = 'Table viewed';
$string['table_viewed_desc'] = 'The user viewed the table "{$a}"';
$string['tableheadercheckbox'] = '<input type="checkbox" class="tableheadercheckbox">';
$string['tableheadersortableitem'] = '<i class="fa fa-arrows" aria-label="Sorting"></i>';
$string['tableheight'] = 'Table height';
$string['tableheight_help'] = 'Tableheight is set in pixels. Useful values start at about 300. 0 means the height is calculated automatically.';
$string['template_switched'] = 'Template switched';
$string['template_switched_desc'] = 'The user has switched the view (template) on the table "{$a->tablename}" to "{$a->template}" with viewparam "{$a->viewparam}"';
$string['templateswitcherlabel'] = 'View';
$string['themennachkategorie'] = 'Topics by Category';
$string['thursday'] = 'Thu';
$string['timespan'] = 'Timespan';
$string['to'] = 'To';
$string['tuesday'] = 'Tue';
$string['turnoffcaching'] = 'Turn off caching <span class="badge bg-danger text-light"><i class="fa fa-flask" aria-hidden="true"></i> Experimental</span>';
$string['valuehastobeint'] = "Value has to be a number";
$string['veranstaltungen'] = "Events";
$string['viewcards'] = 'Cards view';
$string['viewlist'] = 'List view';
$string['wbfilterclassemptyerror'] = 'Please select a filter type';
$string['wbtablefiltersettingsheader'] = 'Edit filters';
$string['wbtabletablesettingsdemo'] = 'Demo Text';
$string['wbtabletablesettingsheader'] = 'More settings';
$string['wednesday'] = 'Wed';
$string['weekdays'] = 'Weekdays filter';
$string['within'] = 'within';
$string['wunderbyte_table:canaccess'] = 'Can access Wunderbyte Table';
$string['wunderbyte_table:canedittable'] = 'Can edit Wunderbyte table';
$string['ymmcns'] = '+Modal, MultipleCall, NoSelection';
$string['ymmcys'] = '+Modal, MultipleCall, Selection';
$string['ymscns'] = '+Modal, SingleCall, NoSelection';
$string['ymscys'] = '+Modal, SingleCall, Selection';
