<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * This class contains a webservice function related to the Booking Module by Wunderbyte.
 *
 * @package    mod_booking
 * @copyright  2022 Georg Maißer <info@wunderbyte.at>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

declare(strict_types=1);

namespace mod_booking\external;

use external_api;
use external_function_parameters;
use external_single_structure;
use external_value;
use mod_booking\local\performance\performance_renderer;

defined('MOODLE_INTERNAL') || die();

require_once($CFG->libdir . '/externallib.php');

/**
 * External web service to get performance chart data.
 *
 * @package   mod_booking
 * @copyright 2025 Wunderbyte GmbH {@link http://www.wunderbyte.at}
 * @author    Jacob Viertel
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class get_performance_chart extends external_api {
    /**
     * Describes the parameters.
     *
     * @return external_function_parameters
     */
    public static function execute_parameters(): external_function_parameters {
        return new external_function_parameters([
            'value' => new external_value(PARAM_TEXT, 'Selected value'),
        ]);
    }

    /**
     * Execute service.
     * @param string $value
     * @return array
     */
    public static function execute(string $value): array {
        $performancerenderer = new performance_renderer();
        return $performancerenderer->get_chart($value);
    }

    /**
     * Returns description of method result value.
     *
     * @return external_single_structure
     */
    public static function execute_returns(): external_single_structure {
        return new external_single_structure([
            'labelsjson' => new external_value(PARAM_TEXT, 'Status: true if success'),
            'datasetsjson' => new external_value(PARAM_TEXT, 'The updated note'),
            'notesjson' => new external_value(PARAM_TEXT, 'The updated note'),
        ]);
    }
}
