/**
 * AJAX helper for the inline editing a value.
 *
 * This script is automatically included from template core/inplace_editable
 * It registers a click-listener on [data-inplaceeditablelink] link (the "inplace edit" icon),
 * then replaces the displayed value with an input field. On "Enter" it sends a request
 * to web service core_update_inplace_editable, which invokes the specified callback.
 * Any exception thrown by the web service (or callback) is displayed as an error popup.
 *
 * @module     mod_booking/performance_submit
 * @copyright  2018 David Bogner
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since      3.3
 */
define("mod_booking/performance_submit",["core/ajax","core/notification","mod_booking/performance_chart"],(function(Ajax,Notification,ChartModule){return{init:()=>{const button=document.getElementById("performance-submit"),input=document.getElementById("performance-input"),noteinput=document.getElementById("performance-note");button&&input&&button.addEventListener("click",(()=>{const value=input.value.trim(),note=noteinput.value.trim();if(!value)return void Notification.alert("Missing value","Please select an item first.","OK");const actions={};document.querySelectorAll('[name^="actions["]').forEach((el=>{const match=el.name.match(/^actions\[([^\]]+)\]\[([^\]]+)\]$/);if(!match)return;const actionId=match[1],field=match[2];actions[actionId]||(actions[actionId]={}),"checkbox"===el.type?actions[actionId][field]=el.checked?1:0:actions[actionId][field]=el.value})),Ajax.call([{methodname:"mod_booking_submit_performance",args:{value:value,note:note,actions:JSON.stringify(actions)}}])[0].then((response=>{response.status?(Notification.addNotification({message:"Request successful",type:"success"}),Ajax.call([{methodname:"mod_booking_get_performance_chart",args:{value:response.hashedreceived},done:function(chartdata){ChartModule.updateChart(chartdata)},fail:function(error){console.error("Failed to reload chart:",error)}}])):Notification.addNotification({message:response.received+" Shortcode is not valid",type:"error"})})).catch(Notification.exception)}))}}}));

//# sourceMappingURL=performance_submit.min.js.map