define(["jquery"], function ($) {
    var blocks = {
        create: function (cmid, thumb) {
            let $module = $(`body.format-weeks:not(.editing) #module-${cmid}, body.format-topics:not(.editing) #module-${cmid}`);
            $module.addClass("theme-block");
            $module.find(".activity-item")
                .css({"background-image": `url('${thumb}')`})
                .click(function () {
                    if (event.target === this) {
                        location.href = $module.find("a.aalink").attr("href");
                    }
                });
            $module.append($module.find(".activity-completion"));
        },

        icons: function (cmid, thumb) {
            $(`#course-index-cm-${cmid}`).addClass("personal-icon");
            let rule = `
                #module-${cmid} .courseicon {
                    background       : #fff;
                    background-color : #fff;
                }
                #course-index-cm-${cmid} .activity-icon img,
                #module-${cmid} .courseicon img,
                .cmid-${cmid} #page-header .activityiconcontainer img {
                    content : url('${thumb}');
                    filter  : none;
                }
                .cmid-${cmid} #page-header .activityiconcontainer img {
                        width     : 45px !important;
                        height    : 45px !important;
                        max-width : 45px !important;
                        max-height: 45px !important;
                }`;
            blocks.add_style_tag(rule);
        },

        color: function (cmid, color) {
            if (!color || color.length < 4) {
                return;
            }
            let rule = `
                #module-${cmid} .courseicon {
                    background       : ${color} !important;
                    background-color : ${color} !important;
                }`;
            blocks.add_style_tag(rule);
        },

        add_style_tag:function (rule){
            let styleTag = $("#eadtraining-custom-style");
            if (styleTag.length) {
                styleTag.append(rule);
                return;
            }
            styleTag = $("<style>", { id: "eadtraining-custom-style", type: "text/css" })
                .appendTo("head");
            styleTag.append(rule);
        }
    };

    return blocks;
});
