define("block_eledia_coursesearch/view",["exports","jquery","block_eledia_coursesearch/repository","core/paged_content_factory","core/pubsub","core/custom_interaction_events","core/notification","core/templates","core_course/events","block_eledia_coursesearch/selectors","core/paged_content_events","core/aria","core/utils","core_user/repository"],(function(_exports,_jquery,Repository,PagedContentFactory,PubSub,CustomEvents,Notification,Templates,CourseEvents,_selectors,PagedContentEvents,Aria,_utils,_repository2){function _getRequireWildcardCache(nodeInterop){if("function"!=typeof WeakMap)return null;var cacheBabelInterop=new WeakMap,cacheNodeInterop=new WeakMap;return(_getRequireWildcardCache=function(nodeInterop){return nodeInterop?cacheNodeInterop:cacheBabelInterop})(nodeInterop)}function _interopRequireWildcard(obj,nodeInterop){if(!nodeInterop&&obj&&obj.__esModule)return obj;if(null===obj||"object"!=typeof obj&&"function"!=typeof obj)return{default:obj};var cache=_getRequireWildcardCache(nodeInterop);if(cache&&cache.has(obj))return cache.get(obj);var newObj={},hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj)if("default"!==key&&Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;desc&&(desc.get||desc.set)?Object.defineProperty(newObj,key,desc):newObj[key]=obj[key]}return newObj.default=obj,cache&&cache.set(obj,newObj),newObj}function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Manage the courses view for the overview block.
   *
   * @package
   * @copyright 2025 eLeDia GmbH
   * @author Immanuel Pasanec <support@eledia.de>
   * @license https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.reset=_exports.init=_exports.clearSearch=_exports.clearCustomfieldSingleIconSearch=_exports.clearCustomfieldSearch=_exports.clearCatSearch=_exports.activeCustomfieldSearch=void 0,_jquery=_interopRequireDefault(_jquery),Repository=_interopRequireWildcard(Repository),PagedContentFactory=_interopRequireWildcard(PagedContentFactory),PubSub=_interopRequireWildcard(PubSub),CustomEvents=_interopRequireWildcard(CustomEvents),Notification=_interopRequireWildcard(Notification),Templates=_interopRequireWildcard(Templates),CourseEvents=_interopRequireWildcard(CourseEvents),_selectors=_interopRequireDefault(_selectors),PagedContentEvents=_interopRequireWildcard(PagedContentEvents),Aria=_interopRequireWildcard(Aria);const TEMPLATES_COURSES_CARDS="block_eledia_coursesearch/view-cards",TEMPLATES_COURSES_LIST="block_eledia_coursesearch/view-list",TEMPLATES_COURSES_SUMMARY="block_eledia_coursesearch/view-summary",TEMPLATES_NOCOURSES="core_course/no-courses",GROUPINGS_GROUPING_ALLINCLUDINGHIDDEN="allincludinghidden",NUMCOURSES_PERPAGE=[12,24,48,96,0];let loadedPages=[],courseOffset=0,lastPage=0,lastLimit=0,namespace=null,selectedCategories=[],selectableCategories=[],selectedTags=[],selectableTags=[],customfields=[],filteredCustomfields=[],selectedCustomfields=[],searchTerm="",catSearchTerm="",tagsSearchTerm="",courseInProgress="all",currentCustomField=0,summaryDisplayLoaded=!1;const getFilterValues=root=>{const courseRegion=root.find(_selectors.default.courseView.region);return{display:courseRegion.attr("data-display"),grouping:courseRegion.attr("data-grouping"),sort:courseRegion.attr("data-sort"),displaycategories:courseRegion.attr("data-displaycategories"),customfieldname:courseRegion.attr("data-customfieldname"),customfieldvalue:courseRegion.attr("data-customfieldvalue")}},DEFAULT_PAGED_CONTENT_CONFIG={ignoreControlWhileLoading:!0,controlPlacementBottom:!0,persistentLimitKey:"block_eledia_coursesearch_user_paging_preference"},getParams=function(){let limit=arguments.length>0&&void 0!==arguments[0]?arguments[0]:0;const params={criteria:[{key:"categoryName",value:catSearchTerm},{key:"tagsName",value:tagsSearchTerm},{key:"name",value:searchTerm},{key:"selectedCategories",categories:selectedCategories},{key:"limit",value:limit},{key:"offset",value:courseOffset},{key:"progress",value:courseInProgress},{key:"currentCustomField",value:currentCustomField},{key:"selectedCustomfields",customfields:getCustomFields()},{key:"selectedTags",tags:selectedTags}],addsubcategories:!0};return params},getCustomFields=()=>{if(!selectedCustomfields.length)return[];return selectedCustomfields.map(((values,key)=>{if(!values||void 0===values)return null;return{fieldid:key,fieldvalues:values.map((val=>val.value))}})).filter(Boolean)},getFavouriteIconContainer=(root,courseId)=>root.find(_selectors.default.FAVOURITE_ICON+'[data-course-id="'+courseId+'"]'),getPagedContentContainer=(root,index)=>root.find('[data-region="paged-content-page"][data-page="'+index+'"]'),getCourseId=root=>root.attr("data-course-id"),getAddFavouriteMenuItem=(root,courseId)=>root.find('[data-action="add-favourite"][data-course-id="'+courseId+'"]'),getRemoveFavouriteMenuItem=(root,courseId)=>root.find('[data-action="remove-favourite"][data-course-id="'+courseId+'"]'),addToFavourites=(root,courseId)=>{const removeAction=getRemoveFavouriteMenuItem(root,courseId),addAction=getAddFavouriteMenuItem(root,courseId);setCourseFavouriteState(courseId,!0).then((success=>{success?(PubSub.publish(CourseEvents.favourited,courseId),removeAction.removeClass("hidden"),addAction.addClass("hidden"),((root,courseId)=>{const iconContainer=getFavouriteIconContainer(root,courseId),isFavouriteIcon=iconContainer.find(_selectors.default.ICON_IS_FAVOURITE);isFavouriteIcon.removeClass("hidden"),Aria.unhide(isFavouriteIcon);const notFavourteIcon=iconContainer.find(_selectors.default.ICON_NOT_FAVOURITE);notFavourteIcon.addClass("hidden"),Aria.hide(notFavourteIcon)})(root,courseId)):Notification.alert("Starring course failed","Could not change favourite state")})).catch(Notification.exception)},removeFromFavourites=(root,courseId)=>{const removeAction=getRemoveFavouriteMenuItem(root,courseId),addAction=getAddFavouriteMenuItem(root,courseId);setCourseFavouriteState(courseId,!1).then((success=>{success?(PubSub.publish(CourseEvents.unfavorited,courseId),removeAction.addClass("hidden"),addAction.removeClass("hidden"),((root,courseId)=>{const iconContainer=getFavouriteIconContainer(root,courseId),isFavouriteIcon=iconContainer.find(_selectors.default.ICON_IS_FAVOURITE);isFavouriteIcon.addClass("hidden"),Aria.hide(isFavouriteIcon);const notFavourteIcon=iconContainer.find(_selectors.default.ICON_NOT_FAVOURITE);notFavourteIcon.removeClass("hidden"),Aria.unhide(notFavourteIcon)})(root,courseId)):Notification.alert("Starring course failed","Could not change favourite state")})).catch(Notification.exception)},getHideCourseMenuItem=(root,courseId)=>root.find('[data-action="hide-course"][data-course-id="'+courseId+'"]'),getShowCourseMenuItem=(root,courseId)=>root.find('[data-action="show-course"][data-course-id="'+courseId+'"]'),setCourseHiddenState=(courseId,status)=>(!1===status&&(status=null),(0,_repository2.setUserPreference)("block_eledia_coursesearch_hidden_course_".concat(courseId),status).catch(Notification.exception)),hideElement=(root,id)=>{const pagingBar=root.find('[data-region="paging-bar"]'),jumpto=parseInt(pagingBar.attr("data-active-page-number"));let reducedCourse=loadedPages[jumpto].courses.reduce(((accumulator,current)=>(+id!=+current.id&&accumulator.push(current),accumulator)),[]);if(void 0!==loadedPages[jumpto+1]){const newElement=loadedPages[jumpto+1].courses.slice(0,1);loadedPages.forEach(((courseList,index)=>{if(index>jumpto){let popElement=[];void 0!==loadedPages[index+1]&&(popElement=loadedPages[index+1].courses.slice(0,1)),loadedPages[index].courses=[...loadedPages[index].courses.slice(1),...popElement]}})),reducedCourse=[...reducedCourse,...newElement]}if(lastPage===jumpto+1&&0===loadedPages[jumpto+1].courses.length){const pagedContentContainer=root.find('[data-region="paged-content-container"]');PagedContentFactory.resetLastPageNumber((0,_jquery.default)(pagedContentContainer).attr("id"),jumpto)}loadedPages[jumpto].courses=reducedCourse,courseOffset--;const pagedContentPage=getPagedContentContainer(root,jumpto);renderCourses(root,loadedPages[jumpto]).then(((html,js)=>Templates.replaceNodeContents(pagedContentPage,html,js))).catch(Notification.exception),loadedPages.forEach(((courseList,index)=>{if(index>jumpto){getPagedContentContainer(root,index).remove()}}))},setCourseFavouriteState=(courseId,status)=>Repository.setFavouriteCourses({courses:[{id:courseId,favourite:status}]}).then((result=>0===result.warnings.length&&(loadedPages.forEach((courseList=>{courseList.courses.forEach(((course,index)=>{course.id==courseId&&(courseList.courses[index].isfavourite=status)}))})),!0))).catch(Notification.exception),noCoursesRender=root=>{const nocoursesimg=root.find(_selectors.default.courseView.region).attr("data-nocoursesimg"),newcourseurl=root.find(_selectors.default.courseView.region).attr("data-newcourseurl");return Templates.render(TEMPLATES_NOCOURSES,{nocoursesimg:nocoursesimg,newcourseurl:newcourseurl})},renderCourses=(root,coursesData)=>{const filters=getFilterValues(root);let currentTemplate="";return currentTemplate="card"===filters.display?TEMPLATES_COURSES_CARDS:"list"===filters.display?TEMPLATES_COURSES_LIST:TEMPLATES_COURSES_SUMMARY,coursesData?(!1===Array.isArray(coursesData.courses)&&(coursesData.courses=Object.values(coursesData.courses)),coursesData.courses=coursesData.courses.map((course=>(course.showcoursecategory="on"===filters.displaycategories,course))),coursesData.courses.length?Templates.render(currentTemplate,{courses:coursesData.courses}):noCoursesRender(root)):noCoursesRender(root)},renderCustomfields=(dropdownContainer,dropdown,customfieldsData,selectionsData,page)=>Templates.renderForPromise("block_eledia_coursesearch/nav-customfield-dropdown",{customvalues:customfieldsData,customselections:selectionsData,customfieldid:currentCustomField,description:document.querySelector(dropdownContainer).dataset.description}).then((_ref3=>{let{html:html,js:js}=_ref3;const renderResult=Templates.replaceNodeContents(dropdownContainer,html,js);return page.querySelector(dropdown).style.display="block",renderResult})).catch((error=>(0,Notification.exception)(error))),registerPagedEventHandlers=(root,namespace)=>{const event=namespace+PagedContentEvents.SET_ITEMS_PER_PAGE_LIMIT;PubSub.subscribe(event,(root=>limit=>root.find(_selectors.default.courseView.region).attr("data-paging",limit))(root))},itemsPerPageFunc=(pagingLimit,root)=>{let itemsPerPage=NUMCOURSES_PERPAGE.map((value=>{let active=!1;return value===pagingLimit&&(active=!0),{value:value,active:active}}));const totalCourseCount=parseInt(root.find(_selectors.default.courseView.region).attr("data-totalcoursecount"),10);return itemsPerPage.filter((pagingOption=>!(0===pagingOption.value&&totalCourseCount>100)&&pagingOption.value<totalCourseCount))},pageBuilder=function(coursesData,currentPage,pageData,actions){let activeSearch=arguments.length>4&&void 0!==arguments[4]?arguments[4]:null,courses=coursesData.courses?coursesData.courses:coursesData,nextPageStart=0,pageCourses=[];if(void 0!==loadedPages[currentPage]){pageCourses=loadedPages[currentPage].courses;const currentPageLength=pageCourses.length;currentPageLength<pageData.limit&&(nextPageStart=pageData.limit-currentPageLength,pageCourses={...loadedPages[currentPage].courses,...courses.slice(0,nextPageStart)})}else nextPageStart=pageData.limit||!1,pageCourses=pageData.limit>0?courses.slice(0,pageData.limit):courses;loadedPages[currentPage]={courses:pageCourses};const remainingCourses=!1!==nextPageStart?courses.slice(nextPageStart,courses.length):[];remainingCourses.length&&(loadedPages[currentPage+1]={courses:remainingCourses}),loadedPages[currentPage].courses.length<pageData.limit||!remainingCourses.length?(lastPage=currentPage,null===activeSearch&&actions.allItemsLoaded(currentPage)):void 0!==loadedPages[currentPage+1]&&loadedPages[currentPage+1].courses.length<pageData.limit&&(lastPage=currentPage+1),courseOffset=coursesData.nextoffset},resetGlobals=()=>{courseOffset=0,loadedPages=[],lastPage=0,lastLimit=0},standardFunctionalityCurry=()=>(resetGlobals(),(filters,currentPage,pageData,actions,root,promises,limit,searchParams)=>{const pagePromise=((filters,limit,searchParams)=>{const params={offset:courseOffset,limit:limit,classification:filters.grouping,sort:filters.sort,customfieldname:filters.customfieldname,customfieldvalue:filters.customfieldvalue};return"summary"===filters.display?(params.requiredfields=Repository.SUMMARY_REQUIRED_FIELDS,summaryDisplayLoaded=!0):params.requiredfields=Repository.CARDLIST_REQUIRED_FIELDS,Repository.getEnrolledCoursesByTimeline(searchParams)})(filters,limit,searchParams).then((coursesData=>(pageBuilder(coursesData,currentPage,pageData,actions),renderCourses(root,loadedPages[currentPage])))).catch(Notification.exception);promises.push(pagePromise)}),searchFunctionalityCurry=()=>(resetGlobals(),(filters,currentPage,pageData,actions,root,promises,limit,inputValue)=>{const searchingPromise=((filters,limit,searchValue)=>{const params={offset:courseOffset,limit:limit,classification:"search",sort:filters.sort,customfieldname:filters.customfieldname,customfieldvalue:filters.customfieldvalue,searchvalue:searchValue};return"summary"===filters.display?(params.requiredfields=Repository.SUMMARY_REQUIRED_FIELDS,summaryDisplayLoaded=!0):(params.requiredfields=Repository.CARDLIST_REQUIRED_FIELDS,summaryDisplayLoaded=!1),Repository.getEnrolledCoursesByTimeline(searchValue)})(filters,limit,inputValue).then((coursesData=>{const searchTerm=document.querySelector('.block-eledia_coursesearch [data-action="search"]').value;return""!==searchTerm.trim()&&coursesData.courses.forEach((c=>{const word=searchTerm.trim(),summary=c.summary,fullname=c.fullname,escapedWord=word.replace(/[.*+?^${}()|[\]\\]/g,"\\$&"),regex=new RegExp("(".concat(escapedWord,")"),"gi");c.summary=summary.replace(regex,"<mark>$1</mark>"),c.fullname=fullname.replace(regex,"<mark>$1</mark>")})),pageBuilder(coursesData,currentPage,pageData,actions),renderCourses(root,loadedPages[currentPage])})).catch(Notification.exception);promises.push(searchingPromise)}),catSearchFunctionality=()=>(dropdownContainer,dropdown,page,selectedCategories)=>{const searchingPromise=(()=>{const params=getParams();return Repository.getCategories(params)})().then((categoriesData=>(selectableCategories=categoriesData,selectedCategories.forEach((selected=>{const categoryIndex=selectableCategories.findIndex((item=>item.id==selected.id));-1!==categoryIndex&&selectableCategories.splice(categoryIndex,1)})),((dropdownContainer,dropdown,categoriesData,selectionsData,page)=>Templates.renderForPromise("block_eledia_coursesearch/nav-category-dropdown",{categories:categoriesData,catselections:selectionsData}).then((_ref=>{let{html:html,js:js}=_ref;const renderResult=Templates.replaceNodeContents(dropdownContainer,html,js);return page.querySelector(dropdown).style.display="block",renderResult})).catch((error=>(0,Notification.exception)(error))))(dropdownContainer,dropdown,selectableCategories,selectedCategories,page)))).catch(Notification.exception);return searchingPromise},tagsSearchFunctionality=()=>(dropdownContainer,dropdown,page,selectedTags)=>{const searchingPromise=(()=>{const params=getParams();return Repository.getTags(params)})().then((tagsData=>(selectableTags=tagsData,selectedTags.forEach((selected=>{const tagsIndex=selectableTags.findIndex((item=>item.id==selected.id));-1!==tagsIndex&&selectableTags.splice(tagsIndex,1)})),((dropdownContainer,dropdown,tagsData,selectionsData,page)=>Templates.renderForPromise("block_eledia_coursesearch/nav-tags-dropdown",{tags:tagsData,tagsselections:selectionsData}).then((_ref2=>{let{html:html,js:js}=_ref2;const renderResult=Templates.replaceNodeContents(dropdownContainer,html,js);return page.querySelector(dropdown).style.display="block",renderResult})).catch((error=>(0,Notification.exception)(error))))(dropdownContainer,dropdown,selectableTags,selectedTags,page)))).catch(Notification.exception);return searchingPromise},customfieldSearchFunctionality=()=>(dropdownContainer,dropdown,page,searchterm)=>(()=>{const params=getParams();return Repository.getCustomfields(params)})().then((customfieldsData=>{var _selectedCustomfields;const noneOptionIndex=customfieldsData.findIndex((option=>-1===option.value));return-1!==noneOptionIndex&&customfieldsData.splice(noneOptionIndex,1),customfields[currentCustomField]=customfieldsData,void 0===selectedCustomfields[currentCustomField]&&(selectedCustomfields[currentCustomField]=[]),null===(_selectedCustomfields=selectedCustomfields[currentCustomField])||void 0===_selectedCustomfields||_selectedCustomfields.forEach((selected=>{const customfieldIndex=customfields[currentCustomField].findIndex((item=>item.value===selected.value));-1!==customfieldIndex&&customfields[currentCustomField].splice(customfieldIndex,1)})),filteredCustomfields[currentCustomField]=customfields[currentCustomField],""!==searchterm.trim()&&(filteredCustomfields[currentCustomField]=filteredCustomfields[currentCustomField].filter((item=>item.name.toLowerCase().includes(searchterm.trim().toLowerCase())))),renderCustomfields(dropdownContainer,dropdown,filteredCustomfields[currentCustomField],selectedCustomfields[currentCustomField],page)})).catch(Notification.exception),initializePagedContent=function(root,promiseFunction){let params=arguments.length>3?arguments[3]:void 0;const pagingLimit=parseInt(root.find(_selectors.default.courseView.region).attr("data-paging"),10);let itemsPerPage=itemsPerPageFunc(pagingLimit,root);const config={...DEFAULT_PAGED_CONTENT_CONFIG};config.eventNamespace=namespace;const pagedContentPromise=PagedContentFactory.createWithLimit(itemsPerPage,((pagesData,actions)=>{let promises=[];return pagesData.forEach((pageData=>{const currentPage=pageData.pageNumber;let limit=pageData.limit>0?pageData.limit:0;if(+lastLimit!=+limit&&(loadedPages=[],courseOffset=0,lastPage=0),lastPage===currentPage)return actions.allItemsLoaded(lastPage),void promises.push(renderCourses(root,loadedPages[currentPage]));lastLimit=limit,void 0===loadedPages[currentPage+1]&&void 0===loadedPages[currentPage]&&(limit*=2);const filters=getFilterValues(root);promiseFunction(filters,currentPage,pageData,actions,root,promises,limit,params)})),promises}),config);pagedContentPromise.then(((html,js)=>(registerPagedEventHandlers(root,namespace),Templates.replaceNodeContents(root.find(_selectors.default.courseView.region),html,js)))).catch(Notification.exception)},initializeCategorySearchContent=(dropdownContainer,dropdown,promiseFunction,page,selectedCategories)=>{promiseFunction(dropdownContainer,dropdown,page,selectedCategories)},initializeTagsSearchContent=(dropdownContainer,dropdown,promiseFunction,page,selectedTags)=>{promiseFunction(dropdownContainer,dropdown,page,selectedTags)},initializeCustomfieldSearchContent=(dropdownContainer,dropdown,promiseFunction,page,searchterm)=>{promiseFunction(dropdownContainer,dropdown,page,searchterm)},registerEventListeners=(root,page)=>{CustomEvents.define(root,[CustomEvents.events.activate]),root.on(CustomEvents.events.activate,_selectors.default.ACTION_ADD_FAVOURITE,((e,data)=>{const favourite=(0,_jquery.default)(e.target).closest(_selectors.default.ACTION_ADD_FAVOURITE),courseId=getCourseId(favourite);addToFavourites(root,courseId),data.originalEvent.preventDefault()})),root.on(CustomEvents.events.activate,_selectors.default.ACTION_REMOVE_FAVOURITE,((e,data)=>{const favourite=(0,_jquery.default)(e.target).closest(_selectors.default.ACTION_REMOVE_FAVOURITE),courseId=getCourseId(favourite);removeFromFavourites(root,courseId),data.originalEvent.preventDefault()})),root.on(CustomEvents.events.activate,_selectors.default.FAVOURITE_ICON,((e,data)=>{data.originalEvent.preventDefault()})),root.on(CustomEvents.events.activate,_selectors.default.ACTION_HIDE_COURSE,((e,data)=>{const target=(0,_jquery.default)(e.target).closest(_selectors.default.ACTION_HIDE_COURSE),courseId=getCourseId(target);((root,courseId)=>{const hideAction=getHideCourseMenuItem(root,courseId),showAction=getShowCourseMenuItem(root,courseId),filters=getFilterValues(root);setCourseHiddenState(courseId,!0),filters.grouping!==GROUPINGS_GROUPING_ALLINCLUDINGHIDDEN&&hideElement(root,courseId),hideAction.addClass("hidden"),showAction.removeClass("hidden")})(root,courseId),data.originalEvent.preventDefault()})),root.on(CustomEvents.events.activate,_selectors.default.ACTION_SHOW_COURSE,((e,data)=>{const target=(0,_jquery.default)(e.target).closest(_selectors.default.ACTION_SHOW_COURSE),courseId=getCourseId(target);((root,courseId)=>{const hideAction=getHideCourseMenuItem(root,courseId),showAction=getShowCourseMenuItem(root,courseId),filters=getFilterValues(root);setCourseHiddenState(courseId,null),filters.grouping!==GROUPINGS_GROUPING_ALLINCLUDINGHIDDEN&&hideElement(root,courseId),hideAction.removeClass("hidden"),showAction.addClass("hidden")})(root,courseId),data.originalEvent.preventDefault()}));const input=page.querySelector(_selectors.default.region.searchInput),clearIcon=page.querySelector(_selectors.default.region.clearIcon),catinput=page.querySelector(_selectors.default.cat.input),tagsinput=page.querySelector(_selectors.default.tags.input),customInputs=page.querySelectorAll(_selectors.default.customfields.input),clearCatIcon=page.querySelector(_selectors.default.cat.clearIcon),clearTagsIcon=page.querySelector(_selectors.default.tags.clearIcon),clearCustomfieldIcons=page.querySelectorAll(_selectors.default.customfields.clearIcon),customClass=_selectors.default.customfields.searchfield,catSelectable=_selectors.default.cat.selectableItem,catSelected=_selectors.default.cat.selectedItem,tagsSelectable=_selectors.default.tags.selectableItem,tagsSelected=_selectors.default.tags.selectedItem,customfieldSelectable=_selectors.default.customfields.selectableItem,customfieldSelected=_selectors.default.customfields.selectedItem,groupingFilter=page.querySelectorAll(_selectors.default.FILTER_GROUPING);clearIcon.addEventListener("click",(()=>{input.value="",searchTerm="",input.focus(),clearSearch(clearIcon,root)})),clearCatIcon.addEventListener("click",(()=>{catSearchTerm="",catinput.value="",catinput.focus(),clearCatSearch(clearCatIcon),initializeCategorySearchContent(_selectors.default.cat.dropdownDiv,_selectors.default.cat.dropdown,catSearchFunctionality(),page,selectedCategories)})),clearTagsIcon.addEventListener("click",(()=>{tagsSearchTerm="",tagsinput.value="",tagsinput.focus(),clearCatSearch(clearTagsIcon),initializeTagsSearchContent(_selectors.default.tags.dropdownDiv,_selectors.default.tags.dropdown,tagsSearchFunctionality(),page,selectedTags)})),clearCustomfieldIcons.forEach((icon=>{currentCustomField=icon.dataset.customfieldid;const customfieldInput=page.querySelector(customClass+currentCustomField);icon.addEventListener("click",(()=>{customfieldInput.value="",customfieldInput.focus(),clearCustomfieldSingleIconSearch(icon),initializeCustomfieldSearchContent(_selectors.default.customfields.dropdownDiv+currentCustomField,_selectors.default.customfields.dropdown+currentCustomField,customfieldSearchFunctionality(),page,"")}))})),input.addEventListener("input",(0,_utils.debounce)((()=>{""===input.value?(searchTerm="",clearSearch(clearIcon,root)):(activeSearch(clearIcon),searchTerm=input.value.trim(),initializePagedContent(root,searchFunctionalityCurry(),input.value.trim(),getParams()))}),1e3)),customInputs.forEach((i=>{i.addEventListener("click",(e=>{currentCustomField=e.target.dataset.customfieldid;const currentSearchterm=e.target.value.toLowerCase();initializeCustomfieldSearchContent(_selectors.default.customfields.dropdownDiv+currentCustomField,_selectors.default.customfields.dropdown+currentCustomField,customfieldSearchFunctionality(),page,currentSearchterm)})),i.addEventListener("input",(0,_utils.debounce)((e=>{currentCustomField=e.target.dataset.customfieldid;const currentSearchterm=e.target.value.toLowerCase();""===currentSearchterm?(clearCustomfieldSearch(clearCustomfieldIcons),manageCustomfielddropdownItems(e,customfieldSelected,customfieldSelectable,_selectors.default.customfields.dropdownDiv+currentCustomField,_selectors.default.customfields.dropdown+currentCustomField,customfieldSearchFunctionality(),page)):(filteredCustomfields[currentCustomField]=filteredCustomfields[currentCustomField].filter((item=>item.name.toLowerCase().includes(currentSearchterm.toLowerCase().trim()))),activeCustomfieldSearch(clearCustomfieldIcons),manageCustomfielddropdownItems(e,customfieldSelected,customfieldSelectable,_selectors.default.customfields.dropdownDiv+currentCustomField,_selectors.default.customfields.dropdown+currentCustomField,customfieldSearchFunctionality(),page))}),1e3))})),catinput.addEventListener("click",(()=>{initializeCategorySearchContent(_selectors.default.cat.dropdownDiv,_selectors.default.cat.dropdown,catSearchFunctionality(),page,selectedCategories)})),catinput.addEventListener("input",(0,_utils.debounce)((()=>{""===catinput.value?(clearCatSearch(clearCatIcon),catSearchTerm="",initializeCategorySearchContent(_selectors.default.cat.dropdownDiv,_selectors.default.cat.dropdown,catSearchFunctionality(),page,selectedCategories)):(activeSearch(clearCatIcon),catSearchTerm=catinput.value.trim(),initializeCategorySearchContent(_selectors.default.cat.dropdownDiv,_selectors.default.cat.dropdown,catSearchFunctionality(),page,selectedCategories))}),1e3)),tagsinput.addEventListener("click",(()=>{initializeTagsSearchContent(_selectors.default.tags.dropdownDiv,_selectors.default.tags.dropdown,tagsSearchFunctionality(),page,selectedTags)})),tagsinput.addEventListener("input",(0,_utils.debounce)((()=>{""===tagsinput.value?(clearCatSearch(clearTagsIcon),tagsSearchTerm="",initializeTagsSearchContent(_selectors.default.tags.dropdownDiv,_selectors.default.tags.dropdown,tagsSearchFunctionality(),page,selectedTags)):(activeSearch(clearTagsIcon),tagsSearchTerm=tagsinput.value.trim(),initializeTagsSearchContent(_selectors.default.tags.dropdownDiv,_selectors.default.tags.dropdown,tagsSearchFunctionality(),page,selectedTags))}),1e3)),document.body.addEventListener("click",manageCategorydropdownCollapse),document.body.addEventListener("click",manageTagsdropdownCollapse),document.body.addEventListener("click",manageCustomfielddropdownCollapse),document.body.addEventListener("click",(e=>{(e.target.classList.contains(catSelected)||e.target.classList.contains(catSelectable))&&(e.preventDefault(),manageCategorydropdownItems(e,catSelected,catSelectable,_selectors.default.cat.dropdownDiv,_selectors.default.cat.dropdown,catSearchFunctionality(),page),initializePagedContent(root,searchFunctionalityCurry(),input.value.trim(),getParams()))})),document.body.addEventListener("click",(e=>{(e.target.classList.contains(tagsSelected)||e.target.classList.contains(tagsSelectable))&&(e.preventDefault(),manageTagsdropdownItems(e,tagsSelected,tagsSelectable,_selectors.default.tags.dropdownDiv,_selectors.default.tags.dropdown,tagsSearchFunctionality(),page),initializePagedContent(root,searchFunctionalityCurry(),input.value.trim(),getParams()))})),document.body.addEventListener("click",(e=>{if(e.target.classList.contains(customfieldSelected)||e.target.classList.contains(customfieldSelectable)){e.preventDefault();const currentId=e.target.dataset.customfieldid;manageCustomfielddropdownItems(e,customfieldSelected,customfieldSelectable,_selectors.default.customfields.dropdownDiv+currentId,_selectors.default.customfields.dropdown+currentId,customfieldSearchFunctionality(),page),initializePagedContent(root,searchFunctionalityCurry(),input.value.trim(),getParams())}})),document.body.addEventListener("click",(e=>{const expandLink=e.target;if(expandLink.classList.contains("eledia-expandsummary")){e.preventDefault();const summary=e.target.previousElementSibling;expandLink.classList.add("d-none"),summary.classList.remove("summary-fadeout")}})),document.body.addEventListener("click",(e=>{if(e.target.classList.contains("eledia-collapsesummary")){e.preventDefault();const summary=e.target.parentElement;summary.nextElementSibling.classList.remove("d-none"),summary.classList.add("summary-fadeout")}})),groupingFilter.forEach((filter=>{const filterType=filter.dataset.value;filter.addEventListener("click",(()=>{courseInProgress=filterType}))}))},clearSearch=(clearIcon,root)=>{clearIcon.classList.add("d-none"),init(root)};_exports.clearSearch=clearSearch;const clearCatSearch=clearCatIcon=>{clearCatIcon.classList.add("d-none")};_exports.clearCatSearch=clearCatSearch;const clearCustomfieldSearch=clearCustomfieldIcons=>{clearCustomfieldIcons.forEach((icon=>{icon.dataset.customfieldid===currentCustomField&&icon.classList.add("d-none")}))};_exports.clearCustomfieldSearch=clearCustomfieldSearch;const clearCustomfieldSingleIconSearch=icon=>{icon.classList.add("d-none")};_exports.clearCustomfieldSingleIconSearch=clearCustomfieldSingleIconSearch;const activeCustomfieldSearch=clearCustomfieldIcons=>{clearCustomfieldIcons.forEach((icon=>{icon.dataset.customfieldid===currentCustomField&&icon.classList.remove("d-none")}))};_exports.activeCustomfieldSearch=activeCustomfieldSearch;const activeSearch=clearIcon=>{clearIcon.classList.remove("d-none")},manageCategorydropdownCollapse=e=>{const catDropdown=document.querySelector(_selectors.default.region.selectBlock).querySelector(_selectors.default.cat.dropdown);e.target.classList.contains("catprevent")||e.target.classList.contains("fa-xmark")?e.target.classList.contains("catprevent")&&!e.target.classList.contains("fa-xmark")&&(catDropdown.style.display="block"):catDropdown.style.display="none"},manageTagsdropdownCollapse=e=>{const tagsDropdown=document.querySelector(_selectors.default.region.selectBlock).querySelector(_selectors.default.tags.dropdown);e.target.classList.contains("tagsprevent")||e.target.classList.contains("fa-xmark")?e.target.classList.contains("tagsprevent")&&!e.target.classList.contains("fa-xmark")&&(tagsDropdown.style.display="block"):tagsDropdown.style.display="none"},manageCategorydropdownItems=(e,selected,selectable,dropdownDiv,dropdown,promiseFunction,page)=>{const categoryId=e.target.dataset.catId;if(e.target.classList.contains(selectable)){const categoryIndex=selectableCategories.findIndex((value=>value.id==categoryId));selectedCategories.push(selectableCategories.splice(categoryIndex,1)[0])}else{const categoryIndex=selectedCategories.findIndex((value=>value.id==categoryId));selectableCategories.push(selectedCategories.splice(categoryIndex,1)[0])}return renderSelectOptions(),Templates.renderForPromise("block_eledia_coursesearch/nav-category-dropdown",{categories:selectableCategories,catselections:selectedCategories}).then((_ref4=>{let{html:html,js:js}=_ref4;const renderResult=Templates.replaceNodeContents(dropdownDiv,html,js);return page.querySelector(dropdown).style.display="block",renderResult})).catch((error=>(0,Notification.exception)(error)))},manageTagsdropdownItems=(e,selected,selectable,dropdownDiv,dropdown,promiseFunction,page)=>{const tagsId=e.target.dataset.tagsId;if(e.target.classList.contains(selectable)){const tagsIndex=selectableTags.findIndex((value=>value.id==tagsId));selectedTags.push(selectableTags.splice(tagsIndex,1)[0])}else{const tagsIndex=selectedTags.findIndex((value=>value.id==tagsId));selectableTags.push(selectedTags.splice(tagsIndex,1)[0])}return renderSelectOptions(),Templates.renderForPromise("block_eledia_coursesearch/nav-tags-dropdown",{tags:selectableTags,tagsselections:selectedTags}).then((_ref5=>{let{html:html,js:js}=_ref5;const renderResult=Templates.replaceNodeContents(dropdownDiv,html,js);return page.querySelector(dropdown).style.display="block",renderResult})).catch((error=>(0,Notification.exception)(error)))},manageCustomfielddropdownCollapse=()=>{document.querySelector(_selectors.default.region.selectBlock).querySelectorAll(_selectors.default.customfields.dropdownAll).forEach((dropdown=>{dropdown.classList.contains(_selectors.default.customfields.dropdown+currentCustomField)?dropdown.style.display="block":dropdown.style.display="none"}))},manageCustomfielddropdownItems=(e,selected,selectable,dropdownDiv,dropdown,promiseFunction,page)=>{const customfieldValue=e.target.dataset.selectvalue,customfieldName=e.target.dataset.selectname,customfieldId=e.target.dataset.customfieldid;if(e.target.classList.contains(selectable)){const customfieldIndex=filteredCustomfields[customfieldId].findIndex((item=>item.value==customfieldValue));selectedCustomfields[customfieldId].push(filteredCustomfields[customfieldId].splice(customfieldIndex,1)[0]),selectedCustomfields[customfieldId].sort(((a,b)=>(""+a.name).localeCompare(b.name)))}else if(e.target.classList.contains(selected)){const customfieldIndex=selectedCustomfields[customfieldId].findIndex((item=>item.value==customfieldValue)),interchangedValue=selectedCustomfields[customfieldId].splice(customfieldIndex,1)[0],searchField=page.querySelector(".customsearch-"+customfieldId);(""===searchField.value||customfieldName.toLowerCase().includes(searchField.value.trim().toLowerCase()))&&filteredCustomfields[customfieldId].push(interchangedValue),filteredCustomfields[customfieldId].sort(((a,b)=>(""+a.name).localeCompare(b.name)))}return renderSelectOptions(),renderCustomfields(dropdownDiv,dropdown,filteredCustomfields[customfieldId],selectedCustomfields[customfieldId],page)},init=root=>{if(root=(0,_jquery.default)(root),loadedPages=[],lastPage=0,courseOffset=0,!root.attr("data-init")){const page=document.querySelector(_selectors.default.region.selectBlock);registerEventListeners(root,page),namespace="block_eledia_coursesearch_"+root.attr("id")+"_"+Math.random(),root.attr("data-init",!0)}initializePagedContent(root,standardFunctionalityCurry(),null,getParams())};_exports.init=init;function renderSelectOptions(){let options=[];selectedCustomfields.forEach(((subArray,subIndex)=>{subArray.forEach(((option,index)=>{options.push({index:subIndex,description:option.name,type:"customfield",cindex:index})}))})),selectedCategories.forEach(((option,index)=>{options.push({index:index,description:option.name,type:"category",cindex:0})})),selectedTags.forEach(((option,index)=>{options.push({index:index,description:option.name,type:"tag",cindex:0})})),Templates.renderForPromise("block_eledia_coursesearch/nav-selected-option-items",{options:options}).then((_ref6=>{let{html:html,js:js}=_ref6;return Templates.replaceNodeContents(".coursesearchitems",html,js)})).catch((error=>(0,Notification.exception)(error)))}_exports.reset=root=>{if(loadedPages.length>0){if("summary"!==getFilterValues(root).display||summaryDisplayLoaded)loadedPages.forEach(((courseList,index)=>{let pagedContentPage=getPagedContentContainer(root,index);renderCourses(root,courseList).then(((html,js)=>Templates.replaceNodeContents(pagedContentPage,html,js))).catch(Notification.exception)}));else{const input=document.querySelector(_selectors.default.region.selectBlock).querySelector(_selectors.default.region.searchInput);""!==input.value?initializePagedContent(root,searchFunctionalityCurry(),input.value.trim()):initializePagedContent(root,standardFunctionalityCurry())}}else init(root)},document.body.addEventListener("click",(e=>{const cancelBtn=e.target.closest(".selected-option-cancelbtn");if(cancelBtn){e.preventDefault();!function(type,index,cindex){switch(type){case"category":selectedCategories[index]&&selectableCategories.push(selectedCategories.splice(index,1)[0]);break;case"tag":selectedTags[index]&&selectableTags.push(selectedTags.splice(index,1)[0]);break;case"customfield":if(selectedCustomfields[index]&&selectedCustomfields[index][cindex]){const interchangedValue=selectedCustomfields[index].splice(cindex,1)[0];filteredCustomfields[index].push(interchangedValue),filteredCustomfields[index].sort(((a,b)=>(""+a.name).localeCompare(b.name)))}break;default:throw new Error('Invalid type "'+type+'" for deleteSelectOption')}renderSelectOptions();const page=document.querySelector(_selectors.default.region.selectBlock),root=(0,_jquery.default)(page),input=page.querySelector(_selectors.default.region.searchInput);initializePagedContent(root,searchFunctionalityCurry(),input.value.trim(),getParams())}(cancelBtn.dataset.type,parseInt(cancelBtn.dataset.index),parseInt(cancelBtn.dataset.cindex))}}))}));

//# sourceMappingURL=view.min.js.map