<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'tiny_aipromptgen', language 'en'.
 *
 * @package    tiny_aipromptgen
 * @copyright  2025 AI4Teachers
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['aipromptgen_use'] = 'Use AI Prompt Generator';
$string['buttontitle'] = 'AI Prompt Generator';
$string['classtype_assessment'] = 'Assessment/Test';
$string['classtype_discussion'] = 'Discussion';
$string['classtype_groupwork'] = 'Group work';
$string['classtype_lab'] = 'Lab/Practical';
$string['classtype_lecture'] = 'Lecture';
$string['classtype_project'] = 'Project-based';
$string['classtype_review'] = 'Review/Revision';
$string['default_language'] = 'English';
$string['error_noapikey'] = 'OpenAI API key is not configured in settings.';
$string['error_noendpoint'] = 'Ollama endpoint is not configured in settings.';
$string['form_agebrowse'] = 'Browse age or range';
$string['form_ageexact'] = 'Exact age';
$string['form_agerange_option'] = 'Age range';
$string['form_agerangelabel'] = 'Student age/grade';
$string['form_audience'] = 'Audience (teacher-facing or student-facing)';
$string['form_audiencebrowse'] = 'Browse audiences';
$string['form_backtocourse'] = 'Back to course';
$string['form_class_typelabel'] = 'Class type';
$string['form_classtypebrowse'] = 'Browse class types';
$string['form_copied'] = 'Copied!';
$string['form_copy'] = 'Copy to clipboard';
$string['form_course'] = 'Course';
$string['form_download'] = 'Download .txt';
$string['form_includeimages'] = 'Include images generated by DALL-E';
$string['form_language'] = 'Prompt language';
$string['form_languagebrowse'] = 'Browse languages';
$string['form_lessonbrowse'] = 'Browse…';
$string['form_lessoncount'] = 'Number of classes';
$string['form_lessonduration'] = 'Lesson duration (minutes)';
$string['form_lessonlabel'] = 'Lesson title';
$string['form_outcomesbrowse'] = 'Browse competencies/outcomes';
$string['form_outcomeslabel'] = 'Outcomes / objectives';
$string['form_provider'] = 'Provider';
$string['form_purpose'] = 'Prompt purpose (e.g., lesson plan, quiz, rubric)';
$string['form_purposebrowse'] = 'Browse purposes';
$string['form_reset'] = 'Clear saved prompt';
$string['form_response'] = 'AI response';
$string['form_response_heading'] = 'Response';
$string['form_result'] = 'Generated AI prompt';
$string['form_sendtoai'] = 'Send to AI';
$string['form_sendtochatgpt'] = 'Send to ChatGPT';
$string['form_subjectlabel'] = 'Subject';
$string['form_submit'] = 'Generate prompt';
$string['form_topicbrowse'] = 'Browse course sections';
$string['form_topiclabel'] = 'Teaching topic (area)';
$string['help_agerange'] = 'Type an age or grade, or click Browse to pick exact age or range';
$string['help_audience'] = 'Type an audience or click Browse to pick';
$string['help_classtype'] = 'Type a class type or click Browse to pick from a list';
$string['help_language'] = 'Type a language or click Browse to pick from installed languages';
$string['help_lesson'] = 'Type a lesson title or click Browse to pick a section/activity';
$string['help_lessonbrowse'] = 'Browse sections and activities';
$string['help_outcomes'] = 'List outcomes/objectives (one or more)';
$string['help_outcomesbrowse'] = 'Browse competencies/outcomes';
$string['help_purpose'] = 'Type a purpose or click Browse to pick from a list';
$string['help_subjectchange'] = 'Change the subject name if necessary';
$string['help_topic'] = 'Type a topic or click Browse to pick from course sections';
$string['label_ageexact_aria'] = 'Exact age value';
$string['label_agerange'] = 'Student age/grade';
$string['label_agerange_from_aria'] = 'Age range from';
$string['label_agerange_to_aria'] = 'Age range to';
$string['label_audience'] = 'Audience';
$string['label_classtype'] = 'Class type';
$string['label_language'] = 'Language';
$string['label_lesson'] = 'Lesson title';
$string['label_lessoncount'] = 'Number of classes';
$string['label_lessonduration'] = 'Lesson duration';
$string['label_outcomes'] = 'Outcomes';
$string['label_purpose'] = 'Purpose';
$string['label_subject'] = 'Subject';
$string['label_topic'] = 'Teaching topic (area)';
$string['lang_en'] = 'English';
$string['lang_pt'] = 'Portuguese';
$string['lang_sk'] = 'Slovak';
$string['lang_sr'] = 'Serbian';
$string['lang_sr_cr'] = 'Serbian (Cyrillic)';
$string['notallowed'] = 'This tool is only available to teachers and managers in this course.';
$string['openpromptbuilder'] = 'Open AI Prompt Builder';
$string['option_lessonplan'] = 'Lesson plan';
$string['option_quiz'] = 'Quiz questions';
$string['option_rubric'] = 'Assessment rubric';
$string['option_student'] = 'Student-facing';
$string['option_teacher'] = 'Teacher-facing';
$string['option_worksheet'] = 'Worksheet / activities';
$string['placeholder_agerange'] = 'e.g., 15 or 10–12';
$string['pluginname'] = 'AI Prompt Generator';
$string['privacy_metadata'] = 'The AI Prompt Generator plugin does not store personal data.';
$string['prompt_age'] = 'Student Age: {$a} years old';
$string['prompt_audience'] = 'Target Audience: {$a}';
$string['prompt_class_type'] = 'Class Type: {$a}';
$string['prompt_duration'] = 'Duration per lesson: {$a} minutes';
$string['prompt_expert'] = 'You are an expert teacher. Create a detailed lesson plan.';
$string['prompt_footer'] = 'Please provide a structured lesson plan with objectives, activities, and timeline.';
$string['prompt_instructions'] = 'Generate the output fully in the specified language. Ensure that the content is appropriate for the given student age/grade, matches the local curriculum when applicable, and directly supports the stated objectives. Structure the output clearly, using headings, subheadings, and bullet points where appropriate.';
$string['prompt_language'] = 'Language: {$a}';
$string['prompt_lesson_title'] = 'Lesson Title: {$a}';
$string['prompt_num_lessons'] = 'Number of lessons: {$a}';
$string['prompt_outcomes'] = "Learning Outcomes/Competencies:";
$string['prompt_prefix'] = 'You are an expert instructional designer helping a teacher in the Moodle course {$a->course}.';
$string['prompt_purpose'] = 'Purpose: {$a}';
$string['prompt_subject'] = 'Subject: {$a}';
$string['prompt_topic'] = 'Topic: {$a}';
$string['setting_apikey'] = 'OpenAI API key';
$string['setting_apikey_desc'] = 'API key for OpenAI. Stored in Moodle configuration.';
$string['setting_model'] = 'OpenAI model';
$string['setting_model_desc'] = 'Chat completion model to use when sending the prompt to ChatGPT. Default is gpt-3.5-turbo.';
$string['setting_ollama_endpoint'] = 'Ollama endpoint';
$string['setting_ollama_endpoint_desc'] = 'Base URL of the local Ollama server (e.g. http://localhost:11434).';
$string['setting_ollama_model'] = 'Ollama model';
$string['setting_ollama_model_desc'] = 'Local model name loaded in Ollama (e.g. llama3, llama3.2, mistral, codellama, phi3:mini).';
$string['setting_ollama_num_predict'] = 'Ollama max tokens (num_predict)';
$string['setting_ollama_num_predict_desc'] = 'Maximum tokens to generate (num_predict option). Lower for faster responses.';
$string['setting_ollama_schema'] = 'Ollama structured output schema';
$string['setting_ollama_schema_desc'] = 'Optional JSON Schema to constrain Ollama responses (leave empty for free-form text).';
$string['setting_ollama_timeout'] = 'Ollama request timeout (seconds)';
$string['setting_ollama_timeout_desc'] = 'Maximum time to wait for Ollama response. Increase for large outputs.';
$string['status_connecting'] = 'Connecting...';
$string['status_copiedclipboard'] = 'Copied to clipboard!';
$string['status_copiedrichtext'] = 'Copied as Rich Text!';
$string['status_copyfailed'] = 'Copy failed';
$string['status_done'] = 'Done';
$string['status_error'] = 'Error';
$string['status_error_occurred'] = 'Error occurred';
$string['status_error_rendering_markdown'] = 'Error rendering Markdown.';
$string['status_finished'] = 'Finished';
$string['status_generating'] = 'Generating...';
$string['status_receiving'] = 'Receiving...';
$string['status_started'] = 'Started';
$string['status_streaming'] = 'Streaming...';
$string['status_timeout'] = 'Timeout (incomplete)';
$string['system_role'] = 'You are a helpful assistant.';
$string['tooltip_editprompt'] = 'Edit the generated prompt before sending';
$string['tooltip_provider_not_configured'] = 'No AI provider is configured.';
$string['view_html'] = 'HTML';
$string['view_htmlcode'] = 'HTML CODE';
$string['view_raw'] = 'RAW';
$string['view_text'] = 'TEXT';
