/**
 * Main UI controller for the AI Prompt Generator.
 *
 * @package
 * @copyright  2025 AI4Teachers
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("tiny_aipromptgen/ui",["core/str"],(function(Str){return{init:function(){require(["tiny_aipromptgen/age","tiny_aipromptgen/pickers","tiny_aipromptgen/actions","tiny_aipromptgen/stream","tiny_aipromptgen/markdown"],(function(Age,Pickers,Actions,Stream,Markdown){var updatePrompt=function(){var getValue=function(id){var el=document.getElementById(id);return el?el.value:""},subject=getValue("id_subject");if(!subject){var subjectEl=document.getElementById("id_subject");subjectEl&&subjectEl.placeholder&&(subject=subjectEl.placeholder)}var age=getValue("id_agerange"),topic=getValue("id_topic"),lesson=getValue("id_lesson"),count=getValue("id_lessoncount")||"1",duration=getValue("id_lessonduration")||"45",classtype=getValue("id_classtype"),purpose=getValue("id_purpose"),audience=getValue("id_audience"),outcomes=getValue("id_outcomes"),language=getValue("id_language");Str.get_strings([{key:"prompt_expert",component:"tiny_aipromptgen"},{key:"prompt_subject",component:"tiny_aipromptgen",param:subject},{key:"prompt_age",component:"tiny_aipromptgen",param:age},{key:"prompt_topic",component:"tiny_aipromptgen",param:topic},{key:"prompt_lesson_title",component:"tiny_aipromptgen",param:lesson},{key:"prompt_num_lessons",component:"tiny_aipromptgen",param:count},{key:"prompt_duration",component:"tiny_aipromptgen",param:duration},{key:"prompt_class_type",component:"tiny_aipromptgen",param:classtype},{key:"prompt_purpose",component:"tiny_aipromptgen",param:purpose},{key:"prompt_audience",component:"tiny_aipromptgen",param:audience},{key:"prompt_outcomes",component:"tiny_aipromptgen"},{key:"prompt_language",component:"tiny_aipromptgen",param:language||""},{key:"prompt_footer",component:"tiny_aipromptgen"},{key:"default_language",component:"tiny_aipromptgen"}]).then((function(strings){var sExpert=strings[0],sSubject=strings[1],sAge=strings[2],sTopic=strings[3],sLessonTitle=strings[4],sNumLessons=strings[5],sDuration=strings[6],sClassType=strings[7],sPurpose=strings[8],sAudience=strings[9],sOutcomes=strings[10],sLanguage=strings[11],sFooter=strings[12],sDefLang=strings[13],usedLang=language||sDefLang;language||(sLanguage=sLanguage.replace("{$a}",usedLang));var p=sExpert+"\n";subject&&(p+=sSubject+"\n"),age&&(p+=sAge+"\n"),topic&&(p+=sTopic+"\n"),lesson&&(p+=sLessonTitle+"\n"),p+=sNumLessons+"\n",p+=sDuration+"\n",classtype&&(p+=sClassType+"\n"),purpose&&(p+=sPurpose+"\n"),audience&&(p+=sAudience+"\n"),outcomes&&(p+=sOutcomes+"\n"+outcomes+"\n"),p+=sLanguage+"\n",p+="\n"+sFooter;var gen=document.getElementById("ai4t-generated");return gen&&(gen.value=p,gen.dispatchEvent(new Event("input",{bubbles:!0}))),p})).catch((function(){}))},applyView=function(view,btns,bodies,bodyRaw,bodyText,bodyCode,bodyHtml,Markdown){var idx={raw:0,text:1,html:2,rich:3}[view];if(btns[idx]&&(btns[idx].classList.remove("btn-outline-secondary"),btns[idx].classList.add("btn-secondary")),"raw"===view&&bodyRaw)bodyRaw.style.display="block";else if("text"===view&&bodyText)bodyText.style.display="block",bodyText.textContent=Markdown.renderText(bodyRaw.textContent);else if("html"===view&&bodyCode)bodyCode.style.display="block",bodyCode.textContent=Markdown.renderMarkdown(bodyRaw.textContent);else if("rich"===view&&bodyHtml){bodyHtml.style.display="block";try{bodyHtml.innerHTML=Markdown.renderMarkdown(bodyRaw.textContent)}catch(e){Str.get_string("status_error_rendering_markdown","tiny_aipromptgen").then((function(s){return bodyHtml.innerHTML="<p>"+s+"</p>",s})).catch((function(){bodyHtml.innerHTML="<p>Error rendering Markdown.</p>"}))}}},handleModalClick=function(e,modal,backdrop,refs){var btn=e.target.closest("button"),t=e.target;btn&&("ai4t-btn-raw"===btn.id?refs.setView("raw"):"ai4t-btn-text"===btn.id?refs.setView("text"):"ai4t-btn-html"===btn.id?refs.setView("html"):"ai4t-btn-rich"===btn.id?refs.setView("rich"):"ai4t-airesponse-modal-close-btn"===btn.id?(modal.style.display="none",backdrop&&(backdrop.style.display="none")):"ai4t-airesponse-modal-copy-btn"===btn.id?handleCopy(refs):"ai4t-airesponse-modal-insert-btn"===btn.id&&handleInsert(refs)),t&&"ai4t-airesponse-modal-close"===t.id&&(modal.style.display="none",backdrop&&(backdrop.style.display="none"))},handleCopy=function(refs){if(refs.bodyHtml&&"none"!==refs.bodyHtml.style.display)refs.copyRichText(refs.bodyHtml)?showStatusById("status_copiedrichtext"):showStatusById("status_copyfailed");else{var text="";if(refs.bodyRaw&&"none"!==refs.bodyRaw.style.display?text=refs.bodyRaw.textContent:refs.bodyText&&"none"!==refs.bodyText.style.display?text=refs.bodyText.textContent:refs.bodyCode&&"none"!==refs.bodyCode.style.display&&(text=refs.bodyCode.textContent),navigator.clipboard&&navigator.clipboard.writeText)navigator.clipboard.writeText(text).then((function(){showStatusById("status_copiedclipboard")})).catch((function(){}));else{var ta=document.createElement("textarea");ta.value=text,document.body.appendChild(ta),ta.select(),document.execCommand("copy"),document.body.removeChild(ta),showStatusById("form_copied")}}},showStatusById=function(id){Str.get_string(id,"tiny_aipromptgen").then((function(s){return showStatus(s),s})).catch((function(){}))},showStatus=function(msg){var status=document.getElementById("ai4t-modal-copy-status");status?(status.textContent=msg,status.style.display="inline",setTimeout((function(){status.style.display="none"}),2e3)):window.console.log(msg)},handleInsert=function(refs){var content="";if(refs.bodyHtml&&"none"!==refs.bodyHtml.style.display?content=refs.bodyHtml.innerHTML:refs.bodyCode&&"none"!==refs.bodyCode.style.display?content=refs.bodyCode.textContent:refs.bodyText&&"none"!==refs.bodyText.style.display?content=refs.bodyText.textContent.trim().split(/\n+/).map((function(p){return"<p>"+p.trim()+"</p>"})).join(""):refs.bodyRaw&&"none"!==refs.bodyRaw.style.display&&(content=refs.bodyRaw.textContent.replace(/\n/g,"<br>")),window.opener&&window.opener.tinyMCE&&window.opener.tinyMCE.activeEditor)try{window.opener.tinyMCE.activeEditor.insertContent(content),window.close()}catch(e){window.console.error("Failed to insert content. The editor window might be closed.")}else window.console.error("Could not find the parent editor window.")},copyRichText=function(el){try{var range=document.createRange();range.selectNode(el);var selection=window.getSelection();selection.removeAllRanges(),selection.addRange(range);var successful=document.execCommand("copy");return selection.removeAllRanges(),successful}catch(e){return!1}};[function(){Age.initAgeModal()},function(){Pickers.attachPicker({openId:"ai4t-lesson-browse",modalId:"ai4t-modal",closeId:"ai4t-modal-close",cancelId:"ai4t-modal-cancel",itemSelector:".ai4t-lesson-item",targetId:"id_lesson"}),Pickers.attachPicker({openId:"ai4t-topic-browse",modalId:"ai4t-topic-modal",closeId:"ai4t-topic-modal-close",cancelId:"ai4t-topic-modal-cancel",itemSelector:".ai4t-topic-item",targetId:"id_topic"}),Pickers.attachOutcomesModal(),Pickers.initLanguageModal(),["purpose","audience","classtype"].forEach((function(k){Pickers.attachPicker({openId:"ai4t-"+k+"-browse",modalId:"ai4t-"+k+"-modal",closeId:"ai4t-"+k+"-modal-close",cancelId:"ai4t-"+k+"-modal-cancel",itemSelector:".ai4t-"+k+"-item",targetId:"id_"+k})}))},function(){Actions.attachCopyDownload()},function(){!function(){var sendBtn=document.getElementById("ai4t-sendtoai"),select=document.getElementById("ai4t-provider"),gen=document.getElementById("ai4t-generated"),hidden=document.getElementById("ai4t-sendto");if(!hidden&&sendBtn){var form=document.getElementById("mform1")||document.getElementById("promptform")||sendBtn.closest("form");form&&((hidden=document.createElement("input")).type="hidden",hidden.name="sendto",hidden.id="ai4t-sendto",form.appendChild(hidden))}if(sendBtn&&select&&gen){var refreshState=function(){var opt=select.options[select.selectedIndex],unconfigured=opt&&/✕\s*$/.test(opt.textContent||"");sendBtn.disabled=!gen.value.trim()||unconfigured};select.addEventListener("change",refreshState),gen.addEventListener("input",refreshState),sendBtn.addEventListener("click",(function(e){if(!sendBtn.disabled){var provider=select.value,form=document.getElementById("ai4t-send-form");if("ollama"!==provider)sendBtn.disabled=!0,Str.get_string("status_generating","tiny_aipromptgen").then((function(s){return sendBtn.textContent=s,s})).catch((function(){sendBtn.textContent="Generating..."})),hidden.value=provider,form&&form.submit();else{e.preventDefault();var resp=document.getElementById("ai4t-airesponse-body")||document.getElementById("ai4t-airesponse");Stream.startStream((function(){return form}),gen,hidden,resp,(function(){}))}}})),refreshState()}}()},function(){["id_subject","id_agerange","id_topic","id_lesson","id_lessoncount","id_lessonduration","id_classtype","id_purpose","id_audience","id_outcomes","id_language"].forEach((function(id){var el=document.getElementById(id);el&&(el.addEventListener("input",updatePrompt),el.addEventListener("change",updatePrompt))})),setTimeout(updatePrompt,500)},function(){!function(){var modal=document.getElementById("ai4t-airesponse-modal");if(modal){var bodyRaw=document.getElementById("ai4t-airesponse-body"),bodyText=document.getElementById("ai4t-airesponse-text"),bodyHtml=document.getElementById("ai4t-airesponse-html"),bodyCode=document.getElementById("ai4t-airesponse-code"),backdrop=document.getElementById("ai4t-modal-backdrop"),setView=function(view){var btns=["raw","text","html","rich"].map((function(v){return document.getElementById("ai4t-btn-"+v)})),bodies=[bodyRaw,bodyText,bodyHtml,bodyCode];btns.forEach((function(btn){btn&&(btn.classList.remove("btn-secondary"),btn.classList.add("btn-outline-secondary"))})),bodies.forEach((function(b){b&&(b.style.display="none")})),applyView(view,btns,bodies,bodyRaw,bodyText,bodyCode,bodyHtml,Markdown)};document.addEventListener("click",(function(e){handleModalClick(e,modal,backdrop,{bodyRaw:bodyRaw,bodyText:bodyText,bodyHtml:bodyHtml,bodyCode:bodyCode,setView:setView,showStatus:showStatus,copyRichText:copyRichText})})),bodyRaw&&bodyRaw.textContent.trim().length>0&&(modal.style.display="block",backdrop&&(backdrop.style.display="block"),setView("rich"))}}()}].forEach((function(fn){try{fn()}catch(e){}}))}))}}}));

//# sourceMappingURL=ui.min.js.map