/**
 * EventSource streaming support for the AI Prompt Generator.
 *
 * @package
 * @copyright  2025 AI4Teachers
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("tiny_aipromptgen/stream",["core/str","tiny_aipromptgen/markdown"],(function(Str,Markdown){const updateElText=function(el,stringId){el&&Str.get_string(stringId,"tiny_aipromptgen").then((function(s){return el.textContent=s,s})).catch((function(){}))};return{startStream:function(findForm,gen,hidden,resp,scrollToResponse){if(!window.EventSource){const form=findForm();return void(form&&form.submit())}const cidEl=document.querySelector("input[name=courseid]"),courseid=cidEl&&cidEl.value||"";hidden.value="ollama";const statusEl=function(resp){let statusEl=document.getElementById("ai-response-status");statusEl||(statusEl=document.createElement("div"),statusEl.id="ai-response-status",statusEl.className="small text-muted",resp&&resp.parentNode&&resp.parentNode.insertBefore(statusEl,resp));const modalStatus=document.getElementById("ai4t-modal-status");modalStatus&&(updateElText(modalStatus,"status_connecting"),modalStatus.style.color="#007bff"),statusEl&&updateElText(statusEl,"status_streaming");const modal=document.getElementById("ai4t-airesponse-modal"),backdrop=document.getElementById("ai4t-modal-backdrop");return backdrop&&(backdrop.style.display="block"),modal&&(modal.style.display="block"),resp&&(resp.textContent="",resp.setAttribute("aria-busy","true")),statusEl}(resp),base=(window.M&&window.M.cfg&&window.M.cfg.wwwroot?window.M.cfg.wwwroot:"")+"/lib/editor/tiny/plugins/aipromptgen/stream.php";let prompt=gen.value||gen.textContent||"";if(!prompt){const form=findForm(),fd=new FormData(form||void 0);prompt="Topic: "+(fd.get("topic")||"")+"\nLesson: "+(fd.get("lesson")||"")+"\nOutcomes: "+(fd.get("outcomes")||"")}const es=new EventSource(base+"?courseid="+encodeURIComponent(courseid)+"&provider=ollama&prompt="+encodeURIComponent(prompt));let lastActivity=Date.now();const checkTimeout=setInterval((function(){Date.now()-lastActivity>3e4&&(updateElText(statusEl,"status_timeout"),resp&&resp.removeAttribute("aria-busy"),es.close(),clearInterval(checkTimeout),scrollToResponse())}),2e3);es.addEventListener("chunk",(function(){lastActivity=Date.now()})),es.addEventListener("done",(function(){clearInterval(checkTimeout)})),es.addEventListener("error",(function(){clearInterval(checkTimeout)})),function(es,resp,statusEl,scrollToResponse){let first=!0;const modalStatus=document.getElementById("ai4t-modal-status");es.addEventListener("start",(function(){updateElText(statusEl,"status_started"),updateElText(modalStatus,"status_receiving"),scrollToResponse()})),es.addEventListener("chunk",(function(ev){resp&&(resp.textContent+=ev.data,first&&(scrollToResponse(),first=!1)),updateElText(modalStatus,"status_receiving")})),es.addEventListener("error",(function(ev){resp&&Str.get_string("status_error","tiny_aipromptgen").then((function(s){return resp.textContent+="\n["+s+"] "+(ev.data||""),s})).catch((function(){resp.textContent+="\n[Error] "+(ev.data||"")})),updateElText(statusEl,"status_error"),modalStatus&&(updateElText(modalStatus,"status_error_occurred"),modalStatus.style.color="#dc3545"),scrollToResponse()})),es.addEventListener("done",(function(){updateElText(statusEl,"status_done"),modalStatus&&(updateElText(modalStatus,"status_finished"),modalStatus.style.color="#28a745"),resp&&(resp.removeAttribute("aria-busy"),resp.textContent=Markdown.autofixMarkdown(resp.textContent)),scrollToResponse(),es.close()}))}(es,resp,statusEl,scrollToResponse)}}}));

//# sourceMappingURL=stream.min.js.map