/**
 * Tutor-IA Chat - Drawer and chat functionality (based on aiplacement_courseassist)
 *
 * @module     local_dttutor/tutor_ia_chat
 * @copyright  2025 Datacurso
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("local_dttutor/tutor_ia_chat",["jquery","core/ajax","core/notification","core/pubsub","core/str","local_dttutor/error_modal"],(function($,Ajax,Notification,PubSub,Str,ErrorModal){const SELECTORS_TOGGLE_BTN='[data-action="tutor-ia-toggle"]',SELECTORS_DRAWER=".tutor-ia-drawer",SELECTORS_CLOSE_BTN=".tutor-ia-close-button",SELECTORS_MESSAGES='[data-region="tutor-ia-messages"]',SELECTORS_INPUT='[data-region="tutor-ia-input"]',SELECTORS_SEND_BTN='[data-action="send-message"]',SELECTORS_PAGE="#page",SELECTORS_JUMP_TO="#jump-to",SELECTORS_BODY="body";class TutorIAChat{constructor(root,uniqueId,courseId,cmId,userId){this.root=$(root),this.uniqueId=uniqueId,this.courseId=courseId,this.cmId=cmId,this.userId=userId,this.streaming=!1,this.currentEventSource=null,this.currentSessionId=null,this.currentAIMessageEl=null,this.currentAIMessageContainer=null,this.selectedText="",this.selectionLineCount=0,this.selectionCharCount=0,this.boundHandleTextSelectionMouseUp=null,this.boundHandleTextSelectionKeyUp=null,this.textSelectionListenersActive=!1,this.textSelectionDebounceTimer=null,this.cachedSelectionIndicator=null,this.cachedSelectionCount=null,this.historyOffset=0,this.historyLimit=20,this.isLoadingHistory=!1,this.hasMoreHistory=!0,this.historyLoaded=!1,this.strings={},this.stringsLoaded=!1,this.welcomeMessage=root.getAttribute("data-welcomemessage")||"",this.isConfigured="1"===root.getAttribute("data-is-configured")||"true"===root.getAttribute("data-is-configured"),this.drawerElement=document.querySelector(SELECTORS_DRAWER),this.pageElement=document.querySelector(SELECTORS_PAGE),this.bodyElement=document.querySelector(SELECTORS_BODY),this.toggleButton=document.querySelector(SELECTORS_TOGGLE_BTN),this.closeButton=document.querySelector(SELECTORS_CLOSE_BTN),this.jumpTo=document.querySelector(SELECTORS_JUMP_TO),this.position=this.drawerElement&&this.drawerElement.getAttribute("data-position")||"right",this.pageClass="left"===this.position?"show-drawer-left":"show-drawer-right",this.bodyClass="left"===this.position?"tutor-ia-drawer-open-left":"tutor-ia-drawer-open-right",this.pageContext=this.detectPageContext(),this.adjustDrawerTopPosition(),this.init()}adjustDrawerTopPosition(){if(!this.drawerElement)return;const navbarSelectors=[".navbar.fixed-top",".fixed-top.navbar","#page-header.fixed-top","nav.fixed-top",".navbar-fixed-top"];let navbarHeight=60;for(const selector of navbarSelectors){const navbar=document.querySelector(selector);if(navbar&&(navbarHeight=navbar.offsetHeight,navbarHeight>0))break}this.drawerElement.style.setProperty("--tutor-ia-drawer-top",navbarHeight+"px"),window.addEventListener("resize",(()=>{const navbar=document.querySelector(navbarSelectors[0]);if(navbar){const newHeight=navbar.offsetHeight;this.drawerElement.style.setProperty("--tutor-ia-drawer-top",newHeight+"px")}}))}detectPageContext(){const context={};if("undefined"!=typeof M&&M.cfg&&M.cfg.pagetype&&(context.pagetype=M.cfg.pagetype),!context.pagetype){const bodyId=document.body.id;bodyId&&(context.pagetype=bodyId.replace("page-",""))}if(!context.pagetype){const pathMatch=document.body.className.match(/path-([\w-]+)/);pathMatch&&(context.pagetype=pathMatch[1])}const urlParams=new URLSearchParams(window.location.search);return context.pagetype&&context.pagetype.includes("forum")?(urlParams.has("d")&&(context.discussionid=parseInt(urlParams.get("d"),10)),urlParams.has("f")&&(context.forumid=parseInt(urlParams.get("f"),10))):context.pagetype&&context.pagetype.includes("quiz")?urlParams.has("attempt")&&(context.attemptid=parseInt(urlParams.get("attempt"),10)):context.pagetype&&context.pagetype.includes("assign")?urlParams.has("id")&&(context.assignid=parseInt(urlParams.get("id"),10)):context.pagetype&&context.pagetype.includes("wiki")&&urlParams.has("pageid")&&(context.pageid=parseInt(urlParams.get("pageid"),10)),context}init(){this.loadStrings(),this.registerEventListeners(),window.addEventListener("beforeunload",(()=>this.cleanup()))}loadStrings(){Str.get_strings([{key:"line",component:"local_dttutor"},{key:"lines",component:"local_dttutor"},{key:"char",component:"local_dttutor"},{key:"chars",component:"local_dttutor"},{key:"selected",component:"local_dttutor"},{key:"yesterday",component:"local_dttutor"},{key:"loading",component:"local_dttutor"},{key:"error_invalid_message",component:"local_dttutor"},{key:"error_message_too_long",component:"local_dttutor"},{key:"error_no_credits",component:"local_dttutor"},{key:"error_no_credits_short",component:"local_dttutor"},{key:"error_internal",component:"local_dttutor"},{key:"connection_interrupted",component:"local_dttutor"},{key:"error_establish_sse_connection",component:"local_dttutor"},{key:"error_unexpected",component:"local_dttutor"},{key:"error_unknown",component:"local_dttutor"},{key:"configuration_error",component:"local_dttutor"},{key:"error_attempt_later",component:"local_dttutor"},{key:"error_license_fallback",component:"local_dttutor"},{key:"error_license_fallback_short",component:"local_dttutor"},{key:"error_no_credits_fallback",component:"local_dttutor"},{key:"error_insufficient_tokens_short",component:"local_dttutor"}]).then((strings=>{this.strings={line:strings[0],lines:strings[1],char:strings[2],chars:strings[3],selected:strings[4],yesterday:strings[5],loading:strings[6],errorInvalidMessage:strings[7],errorMessageTooLong:strings[8],errorNoCredits:strings[9],errorNoCreditsShort:strings[10],errorInternal:strings[11],connectionInterrupted:strings[12],errorEstablishSse:strings[13],errorUnexpected:strings[14],errorUnknown:strings[15],configurationError:strings[16],errorAttemptLater:strings[17],errorLicenseFallback:strings[18],errorLicenseFallbackShort:strings[19],errorNoCreditssFallback:strings[20],errorInsufficientTokensShort:strings[21]},this.stringsLoaded=!0})).catch((()=>{this.strings={line:"line",lines:"lines",char:"char",chars:"chars",selected:"selected",yesterday:"Yesterday",loading:"Loading...",errorInvalidMessage:"Please enter a valid message",errorMessageTooLong:"[Error] Message is too long. Maximum 4000 characters.",errorNoCredits:"Insufficient AI credits available.",errorNoCreditsShort:"No Credits Available",errorInternal:"Internal error: {$a}",connectionInterrupted:"[Connection interrupted]",errorEstablishSse:"[Error] Could not establish SSE connection",errorUnexpected:"An unexpected error occurred. Please try again.",errorUnknown:"An unknown error occurred. Please try again.",configurationError:"Configuration error",errorAttemptLater:"An error occurred. Please try again later.",errorLicenseFallback:"License error: {$a}",errorLicenseFallbackShort:"License Error",errorNoCreditssFallback:"Insufficient credits: {$a}",errorInsufficientTokensShort:"Insufficient Credits"},this.stringsLoaded=!0}))}registerEventListeners(){this.toggleButton&&this.toggleButton.addEventListener("click",(e=>{e.preventDefault(),this.toggleDrawer()})),this.closeButton&&this.closeButton.addEventListener("click",(e=>{e.preventDefault(),this.closeDrawer()})),this.root.find(SELECTORS_SEND_BTN).on("click",(()=>{this.sendMessage()}));const input=this.root.find(SELECTORS_INPUT);input.on("keydown",(e=>{"Enter"!==e.key||e.shiftKey||(e.preventDefault(),this.sendMessage())})),input.on("input",(function(){this.style.height="auto",this.style.height=Math.min(this.scrollHeight,120)+"px"}));this.root.find(SELECTORS_MESSAGES).on("scroll",(()=>{this.handleHistoryScroll()})),document.addEventListener("keydown",(e=>{this.isDrawerOpen()&&"Escape"===e.key&&this.closeDrawer()})),PubSub.subscribe("core_message/drawer_shown",(()=>{this.isDrawerOpen()&&this.closeDrawer()})),this.jumpTo&&this.jumpTo.addEventListener("focus",(()=>{this.closeButton&&this.closeButton.focus()})),this.root.find('[data-action="clear-selection"]').on("click",(()=>{this.clearSelection(),window.getSelection&&window.getSelection().removeAllRanges()}))}attachTextSelectionListeners(){this.textSelectionListenersActive||(this.boundHandleTextSelectionMouseUp=()=>{this.debouncedHandleTextSelection()},this.boundHandleTextSelectionKeyUp=e=>{(e.shiftKey||e.ctrlKey||e.metaKey)&&this.debouncedHandleTextSelection()},document.addEventListener("mouseup",this.boundHandleTextSelectionMouseUp),document.addEventListener("keyup",this.boundHandleTextSelectionKeyUp),this.textSelectionListenersActive=!0)}detachTextSelectionListeners(){this.textSelectionListenersActive&&(this.boundHandleTextSelectionMouseUp&&(document.removeEventListener("mouseup",this.boundHandleTextSelectionMouseUp),this.boundHandleTextSelectionMouseUp=null),this.boundHandleTextSelectionKeyUp&&(document.removeEventListener("keyup",this.boundHandleTextSelectionKeyUp),this.boundHandleTextSelectionKeyUp=null),this.textSelectionDebounceTimer&&(clearTimeout(this.textSelectionDebounceTimer),this.textSelectionDebounceTimer=null),this.textSelectionListenersActive=!1)}debouncedHandleTextSelection(){this.textSelectionDebounceTimer&&clearTimeout(this.textSelectionDebounceTimer),this.textSelectionDebounceTimer=setTimeout((()=>{this.handleTextSelection(),this.textSelectionDebounceTimer=null}),150)}handleTextSelection(){const selection=window.getSelection(),selectedText=selection?selection.toString().trim():"";selectedText&&selectedText.length>0&&(this.selectedText=selectedText,this.selectionLineCount=selectedText.split("\n").length,this.selectionCharCount=selectedText.length,this.updateSelectionIndicator())}cacheSelectionIndicatorElements(){this.cachedSelectionIndicator=this.root.find('[data-region="selection-indicator"]'),this.cachedSelectionCount=this.root.find('[data-region="selection-count"]')}updateSelectionIndicator(){const indicator=this.cachedSelectionIndicator||this.root.find('[data-region="selection-indicator"]'),countElement=this.cachedSelectionCount||this.root.find('[data-region="selection-count"]');if(indicator.length&&countElement.length)if(this.selectedText&&this.selectedText.length>0&&this.selectionLineCount>0){const lineText=1===this.selectionLineCount?this.strings.line:this.strings.lines,charText=1===this.selectionCharCount?this.strings.char:this.strings.chars,selectionText=this.selectionLineCount+" "+lineText+", "+this.selectionCharCount+" "+charText+" "+this.strings.selected;countElement.text(selectionText),indicator.show()}else indicator.hide()}clearSelection(){this.selectedText="",this.selectionLineCount=0,this.selectionCharCount=0,this.updateSelectionIndicator()}isDrawerOpen(){return this.drawerElement&&this.drawerElement.classList.contains("show")}openDrawer(){this.drawerElement&&(PubSub.publish("core_message/hide",{}),this.drawerElement.classList.add("show"),this.drawerElement.setAttribute("tabindex","0"),this.toggleButton&&this.toggleButton.setAttribute("aria-expanded","true"),this.pageElement&&!this.pageElement.classList.contains(this.pageClass)&&this.pageElement.classList.add(this.pageClass),this.bodyElement&&!this.bodyElement.classList.contains(this.bodyClass)&&this.bodyElement.classList.add(this.bodyClass),this.jumpTo&&(this.jumpTo.setAttribute("tabindex",0),this.jumpTo.focus()),this.isConfigured&&this.loadChatHistory(),this.attachTextSelectionListeners(),this.cacheSelectionIndicatorElements())}closeDrawer(){this.drawerElement&&(this.drawerElement.classList.remove("show"),this.drawerElement.setAttribute("tabindex","-1"),this.toggleButton&&this.toggleButton.setAttribute("aria-expanded","false"),this.pageElement&&this.pageElement.classList.contains(this.pageClass)&&this.pageElement.classList.remove(this.pageClass),this.bodyElement&&this.bodyElement.classList.contains(this.bodyClass)&&this.bodyElement.classList.remove(this.bodyClass),this.jumpTo&&this.jumpTo.setAttribute("tabindex",-1),this.toggleButton&&this.toggleButton.focus(),this.detachTextSelectionListeners())}toggleDrawer(){this.isDrawerOpen()?this.closeDrawer():this.openDrawer()}loadChatHistory(){if(this.isLoadingHistory||!this.hasMoreHistory)return;this.isLoadingHistory=!0;const messagesContainer=this.root.find(SELECTORS_MESSAGES),scrollHeightBefore=messagesContainer[0].scrollHeight,scrollTopBefore=messagesContainer[0].scrollTop;this.showHistoryLoading();Ajax.call([{methodname:"local_dttutor_get_chat_history",args:{courseid:parseInt(this.courseId,10),limit:this.historyLimit,offset:this.historyOffset}}])[0].then((data=>{if(this.hideHistoryLoading(),data.success&&data.messages&&data.messages.length>0){const isInitialLoad=0===this.historyOffset;if(this.displayHistoryMessages(data.messages,isInitialLoad),this.historyOffset+=data.messages.length,this.hasMoreHistory=data.pagination.has_more,isInitialLoad)this.scrollToBottom();else{const scrollDiff=messagesContainer[0].scrollHeight-scrollHeightBefore;messagesContainer[0].scrollTop=scrollTopBefore+scrollDiff}}else this.hasMoreHistory=!1;return this.historyLoaded=!0,this.isLoadingHistory=!1,data})).catch((err=>{this.hideHistoryLoading(),this.isLoadingHistory=!1;const errorMessage=this.getFriendlyErrorMessage(err),isConfigError=this.isWebserviceConfigError(err),configUrl=this.extractConfigUrl(err);isConfigError?ErrorModal.showConfigError(errorMessage,configUrl):ErrorModal.showGeneralError(errorMessage)}))}handleHistoryScroll(){this.root.find(SELECTORS_MESSAGES)[0].scrollTop<100&&!this.isLoadingHistory&&this.hasMoreHistory&&this.loadChatHistory()}displayHistoryMessages(messages,isInitialLoad){const messagesContainer=this.root.find(SELECTORS_MESSAGES);if(isInitialLoad&&this.welcomeMessage&&messagesContainer.find('.tutor-ia-message.ai:contains("'+this.welcomeMessage+'")').remove(),isInitialLoad)for(let i=messages.length-1;i>=0;i--){const messageDiv=this.createMessageElement(messages[i]);messagesContainer.append(messageDiv)}else messages.forEach((msg=>{const messageDiv=this.createMessageElement(msg);messagesContainer.prepend(messageDiv)}))}createMessageElement(msg){const messageDiv=$("<div>").addClass("tutor-ia-message").addClass("user"===msg.role?"user":"ai").attr("data-message-id",msg.id),contentDiv=$("<div>").addClass("message-content").text(msg.content),timestampDiv=$("<div>").addClass("message-timestamp").text(this.formatTimestamp(msg.timestamp));return messageDiv.append(contentDiv),messageDiv.append(timestampDiv),messageDiv}formatTimestamp(timestamp){const date=new Date(1e3*timestamp),today=new Date,messageDate=new Date(date.getFullYear(),date.getMonth(),date.getDate()),todayDate=new Date(today.getFullYear(),today.getMonth(),today.getDate()),yesterday=new Date(todayDate);yesterday.setDate(yesterday.getDate()-1);const hours=date.getHours().toString().padStart(2,"0"),minutes=date.getMinutes().toString().padStart(2,"0"),time="".concat(hours,":").concat(minutes);if(messageDate.getTime()===todayDate.getTime())return time;if(messageDate.getTime()===yesterday.getTime())return"".concat(this.strings.yesterday," ").concat(time);const day=date.getDate().toString().padStart(2,"0"),month=(date.getMonth()+1).toString().padStart(2,"0"),year=date.getFullYear();return"".concat(day,"/").concat(month,"/").concat(year," ").concat(time)}showHistoryLoading(){const messagesContainer=this.root.find(SELECTORS_MESSAGES);if(!messagesContainer.find(".history-loading").length){const loadingDiv=$("<div>").addClass("history-loading").text(this.strings.loading);messagesContainer.prepend(loadingDiv)}}hideHistoryLoading(){this.root.find(".history-loading").remove()}sendMessage(){if(!this.isConfigured)return;const input=this.root.find(SELECTORS_INPUT),sendBtn=this.root.find(SELECTORS_SEND_BTN),messageText=input.val().trim();if(messageText&&!this.streaming)if("."!==messageText)if(messageText.length>4e3)this.addMessage(this.strings.errorMessageTooLong,"ai");else try{this.closeCurrentStream(),sendBtn.prop("disabled",!0),this.addMessage(messageText,"user"),input.val(""),input.css("height","auto"),this.scrollToBottom(),this.showTypingIndicator();const metaData={user_role:"Student",timestamp:Math.floor(Date.now()/1e3)};this.pageContext.pagetype&&(metaData.page=this.pageContext.pagetype),this.pageContext.discussionid&&(metaData.discussionid=this.pageContext.discussionid),this.pageContext.forumid&&(metaData.forumid=this.pageContext.forumid),this.pageContext.attemptid&&(metaData.attemptid=this.pageContext.attemptid),this.pageContext.assignid&&(metaData.assignid=this.pageContext.assignid),this.pageContext.pageid&&(metaData.pageid=String(this.pageContext.pageid)),this.cmId&&(metaData.cmid=String(parseInt(this.cmId,10))),this.selectedText&&this.selectedText.length>0&&(metaData.selected_text=this.selectedText);const forceReindexCheckbox=this.root.find('[data-region="debug-force-reindex"]');forceReindexCheckbox.length&&forceReindexCheckbox.is(":checked")&&(metaData.force_reindex="true");Ajax.call([{methodname:"local_dttutor_create_chat_message",args:{courseid:parseInt(this.courseId,10),message:this.sanitizeString(messageText.substring(0,4e3)),meta:JSON.stringify(metaData)}}])[0].then((data=>{if(!data||!data.stream_url)throw new Error("Stream URL missing in response");return this.currentSessionId=data.session_id,this.startSSE(data.stream_url,sendBtn),this.clearSelection(),data})).catch((err=>{if(this.hideTypingIndicator(),this.isNoCreditsError(err)){const errorHtml=err.message||this.strings.errorNoCredits;this.showNoCreditsWarning(errorHtml);this.root.find(SELECTORS_INPUT).prop("disabled",!0),sendBtn.prop("disabled",!0)}else{sendBtn.prop("disabled",!1);const errorMessage=this.getFriendlyErrorMessage(err),isConfigError=this.isWebserviceConfigError(err),configUrl=this.extractConfigUrl(err);isConfigError?ErrorModal.showConfigError(errorMessage,configUrl):ErrorModal.showGeneralError(errorMessage)}}))}catch(error){this.hideTypingIndicator(),sendBtn.prop("disabled",!1),ErrorModal.showGeneralError(this.strings.errorInternal.replace("{$a}",error.message))}else this.addMessage("[Error] "+this.strings.errorInvalidMessage,"ai")}startSSE(streamUrl,sendBtn){try{const es=new EventSource(streamUrl);this.currentEventSource=es,this.streaming=!0;let firstToken=!0,messageCompleted=!1;es.addEventListener("token",(ev=>{try{const payload=JSON.parse(ev.data),text=payload.t||payload.content||"";firstToken&&(firstToken=!1,this.ensureAIMessageEl(),this.hideTypingIndicator()),this.appendToAIMessage(text)}catch(e){}})),es.addEventListener("done",(()=>{messageCompleted=!0,this.finalizeStream(sendBtn)})),es.addEventListener("message_completed",(()=>{messageCompleted=!0,this.finalizeStream(sendBtn)})),es.addEventListener("error",(ev=>{if(ev.data)try{const errorData=JSON.parse(ev.data);return void this.handleStreamError(errorData,sendBtn)}catch(e){}messageCompleted||(this.appendToAIMessage("\n"+this.strings.connectionInterrupted),this.finalizeStream(sendBtn))}))}catch(error){this.addMessage(this.strings.errorEstablishSse,"ai"),this.finalizeStream(sendBtn)}}ensureAIMessageEl(){if(this.currentAIMessageEl)return this.currentAIMessageEl;const messages=this.root.find(SELECTORS_MESSAGES);let messageContainer;const typingEl=messages.find(".tutor-ia-typing");typingEl.length?(messageContainer=typingEl,messageContainer.removeClass("tutor-ia-typing"),messageContainer.addClass("tutor-ia-message ai"),messageContainer.html("")):(messageContainer=$('<div class="tutor-ia-message ai"></div>'),messages.append(messageContainer));const contentDiv=$("<div>").addClass("message-content");return messageContainer.append(contentDiv),this.currentAIMessageEl=contentDiv[0],this.currentAIMessageContainer=messageContainer[0],this.currentAIMessageEl}appendToAIMessage(text){if(this.currentAIMessageEl||this.ensureAIMessageEl(),!this.currentAIMessageEl||"string"!=typeof text)return;const currentText=this.currentAIMessageEl.textContent||"";if(currentText.length+text.length>1e4){const remaining=1e4-currentText.length;remaining>0&&(this.currentAIMessageEl.textContent+=text.substring(0,remaining)+"...")}else this.currentAIMessageEl.textContent+=text,this.scrollToBottom()}addMessage(text,type){if(!text||"string"!=typeof text)return;const messages=this.root.find(SELECTORS_MESSAGES),messageEl=$("<div></div>").addClass("tutor-ia-message").addClass(type),contentDiv=$("<div>").addClass("message-content").text(text.substring(0,1e4)),currentTimestamp=Math.floor(Date.now()/1e3),timestampDiv=$("<div>").addClass("message-timestamp").text(this.formatTimestamp(currentTimestamp));messageEl.append(contentDiv),messageEl.append(timestampDiv),messages.append(messageEl),this.scrollToBottom()}showTypingIndicator(){const messages=this.root.find(SELECTORS_MESSAGES);if(messages.find(".tutor-ia-typing").length)return;const typing=$('<div class="tutor-ia-message ai tutor-ia-typing"></div>').html('<span class="dot"></span><span class="dot"></span><span class="dot"></span>');messages.append(typing),this.scrollToBottom()}hideTypingIndicator(){this.root.find(".tutor-ia-typing").remove()}showNoCreditsWarning(errorHtml){const messages=this.root.find(SELECTORS_MESSAGES);messages.find(".tutor-ia-no-credits-warning").remove();const warningDiv=$('<div class="tutor-ia-no-credits-warning"></div>'),alertDiv=$('<div class="alert alert-danger"></div>');alertDiv.html('<i class="fa fa-exclamation-circle"></i> <div class="warning-content"><strong>'+this.strings.errorNoCreditsShort+"</strong><p>"+errorHtml+"</p></div>"),warningDiv.append(alertDiv),messages.append(warningDiv),this.scrollToBottom()}scrollToBottom(){const messages=this.root.find(SELECTORS_MESSAGES);messages.scrollTop(messages[0].scrollHeight)}closeCurrentStream(){if(this.currentEventSource)try{this.currentEventSource.close()}catch(e){}this.currentEventSource=null,this.streaming=!1,this.currentAIMessageEl=null,this.currentAIMessageContainer=null,this.hideTypingIndicator()}finalizeStream(sendBtn){if(this.currentAIMessageContainer){const currentTimestamp=Math.floor(Date.now()/1e3),timestampDiv=$("<div>").addClass("message-timestamp").text(this.formatTimestamp(currentTimestamp));$(this.currentAIMessageContainer).append(timestampDiv),this.currentAIMessageContainer=null}this.closeCurrentStream(),sendBtn&&sendBtn.prop("disabled",!1)}handleStreamError(errorData,sendBtn){if(this.hideTypingIndicator(),this.finalizeStream(sendBtn),errorData&&errorData.detail&&"error"===errorData.detail.status){const errorMessage=errorData.detail.detail||"";if(errorMessage.toLowerCase().includes("license not allowed")){var self=this;return void Str.get_strings([{key:"error_license_not_allowed",component:"local_dttutor"},{key:"error_license_not_allowed_short",component:"local_dttutor"}]).then((function(strings){ErrorModal.showGeneralError(strings[0],strings[1])})).catch((function(){ErrorModal.showGeneralError(self.strings.errorLicenseFallback.replace("{$a}",errorMessage),self.strings.errorLicenseFallbackShort)}))}if(errorMessage.toLowerCase().includes("insufficient tokens")){var selfTokens=this;return void Str.get_strings([{key:"error_insufficient_tokens",component:"local_dttutor"},{key:"error_insufficient_tokens_short",component:"local_dttutor"}]).then((function(strings){ErrorModal.showGeneralError(strings[0],strings[1])})).catch((function(){ErrorModal.showGeneralError(selfTokens.strings.errorNoCreditssFallback.replace("{$a}",errorMessage),selfTokens.strings.errorInsufficientTokensShort)}))}ErrorModal.showGeneralError(errorMessage)}else ErrorModal.showGeneralError(this.strings.errorUnexpected)}sanitizeString(str){return"string"!=typeof str?"":str.replace(/[<>]/g,"")}isWebserviceConfigError(err){if(!err||!err.message)return!1;const message=err.message.toLowerCase();return message.includes("webservice_not_configured")||message.includes("webservice not configured")||message.includes("error_webservice_not_configured")}isNoCreditsError(err){if(!err||!err.message)return!1;const message=err.message.toLowerCase();return message.includes("notenoughtokens")||message.includes("insufficient ai credits")||message.includes("no credits")||message.includes("out of credits")}getFriendlyErrorMessage(err){return err?this.isWebserviceConfigError(err)?err.message||err.error||this.strings.configurationError:err.message?err.message:err.error?err.error:this.strings.errorAttemptLater:this.strings.errorUnknown}extractConfigUrl(err){if(!err||!err.message)return null;const hrefMatch=err.message.match(/href="([^"]+)"/);return hrefMatch&&hrefMatch[1]?hrefMatch[1]:null}cleanup(){this.closeCurrentStream(),this.detachTextSelectionListeners()}destroy(){this.cleanup(),this.cachedSelectionIndicator=null,this.cachedSelectionCount=null}}return{init:function(root,uniqueId,courseId,cmId,userId){return new TutorIAChat(root,uniqueId,courseId,cmId,userId)}}}));

//# sourceMappingURL=tutor_ia_chat.min.js.map