<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Tiny cursive plugin.
 *
 * @package tiny_cursive
 * @copyright  CTI <info@cursivetechnology.com>
 * @author kuldeep singh <mca.kuldeep.sekhon@gmail.com>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allcourses'] = "All courses";
$string['allmodule'] = 'All modules';
$string['alluser'] = 'All users';
$string['analytics'] = 'Analytics';
$string['analyticspdf'] = "Analytics PDF";
$string['answeringto'] = 'Answering to question';
$string['api_addr_url'] = 'API address URL';
$string['api_url'] = 'API URL';
$string['apply_filter'] = "Please apply a filter!";
$string['assignment'] = "Assignment";
$string['attemptid'] = 'Attempt id';
$string['authorship'] = 'Authorship Confidence ';
$string['authorship_desc'] = 'TypeID verification status';
$string['average'] = "Average";
$string['average_min'] = 'Average words per minute:';
$string['backspace'] = 'Revision %';
$string['backspace_desc'] = 'Percentage of backspace and delete usage';
$string['backspace_percent'] = 'Backspace percent';
$string['character_count'] = 'Character count';
$string['character_verify'] = "Character verification";
$string['characters_per_minute'] = 'Characters per minute';
$string["chart_result"] = 'Showing result based on Course and Module';
$string["chart_result_user"] = 'Showing result based on Course, Module and User';
$string['cite_src'] = 'Enable cite-source';
$string['cite_src_des'] = 'Show cite-source comments under post when enabled';
$string['close'] = 'Close';
$string['comments'] = 'Comments';
$string['confidence_threshold'] = '0.65';
$string['confidence_thresholds'] = 'Confidence Threshold';
$string['copy_behave'] = 'Copy behavior:';
$string['copybehavior'] = 'Copy behavior';
$string['course'] = 'Course';
$string['courseid'] = 'Course ID';
$string['coursename'] = 'Course name';
$string['curlerror'] = 'Curl error';
$string['cursive:dis:fail'] = 'Failed to disable Cursive.';
$string['cursive:dis:succ'] = 'Cursive disabled successfully.';
$string['cursive:editsettings'] = 'Access plugin settings';
$string['cursive:ena:fail'] = 'Failed to enable Cursive.';
$string['cursive:ena:succ'] = 'Cursive enabled successfully.';
$string['cursive:state:active'] = 'Cursive is active:';
$string['cursive:state:active:des'] = 'Your drafting and editing are now being captured as part of your submission.';
$string['cursive:status'] = 'Something went wrong while disabling Cursive.';
$string['cursive:use'] = 'Use TinyMCE Cursive';
$string['cursive:view'] = 'View writing reports';
$string['cursive:write'] = 'Write JSON File or insert records';
$string['cursive:writingreport'] = 'Access to analytics';
$string['cursive_enable_notice'] = 'Enabling this feature will activate the Cursive plugin for this course. Ensure that all participants are informed about its use.';
$string['cursive_more_info'] = 'Please visit Cursive for more information.';
$string['cursive_status'] = 'Cursive Status';
$string['cursivedisable'] = 'Cursive Global settings';
$string['cursivedisable_des'] = 'This setting will disable or enable Cursive for all courses. You can also re-enable or disable it individually through course settings.';
$string['data_save'] = 'Data saved successfully';
$string['data_visualization'] = 'Visualisation';
$string['date'] = "Date";
$string['description'] = "description";
$string['details'] = 'details';
$string['difference'] = 'Difference';
$string['disable'] = 'Disable';
$string['disabled'] = 'Disabled';
$string['discussion'] = "Discussion";
$string['download'] = 'Download';
$string['download_attempt_json'] = 'Download attempt JSON';
$string['download_csv'] = 'Download cumulative report';
$string['download_pdf_message'] = "Download has started. You will be returned shortly.";
$string['draft'] = 'Draft (Submitted)';
$string['draftnot'] = 'Draft (Not submitted)';
$string['due'] = "Due";
$string['edits'] = 'Edits';
$string['edits_des'] = 'Edits are exactly what you think they are, movement of words, changes to characters and text, and updates you make as part of the editing process. This is simply the count of use of keys like Ctrl, Delete, and Backspace. Higher editing can lead to more concise, clear, and refined writing.';
$string['editspastesai'] = 'Edits/Pastes/AI';
$string['effort_ratio'] = 'Effort';
$string['effort_ratio_desc'] = 'Total characters from verified effort / total characters in submission';
$string['email'] = 'Email';
$string['enable'] = 'Enable';
$string['enabled'] = 'Enabled';
$string['enter_nonzerovalue'] = 'Please select at least 5 seconds';
$string['enter_numericvalue'] = 'Please enter numeric value';
$string['enter_time'] = 'Enter time';
$string['errorverifyingtoken'] = 'Error verifying token';
$string['failed'] = 'Failed';
$string['feature'] = 'Feature';
$string['field_require'] = 'This field is required';
$string['filenotfound'] = 'File not found!';
$string['filenotfoundor'] = "File not found! or Failed to read file";
$string['filesizelimit'] = "File exceeds the 16MB size limit.";
$string['freemium'] = "YOU ARE USING THE LIMITED VERSION";
$string['freemium_desc'] = "Learn more about our premium features";
$string['fullmodeerror'] = 'Unable to initialize document view in Fullscreen mode. Opening default view.';
$string['fullmodeerrorr'] = 'You are currently offline. Saved content cannot be retrieved until you are back online.';
$string['fullname'] = 'Fullname';
$string['fullsubmission'] = "Full Submission Text";
$string['generate'] = 'Generate';
$string['gradenot'] = 'Not graded';
$string['gradings'] = 'Grading Status';
$string['host_domain'] = 'Your Host domain.';
$string['importantdates'] = 'Important Dates';
$string['invalidjson'] = 'Invalid JSON content in file.';
$string['invalidparameters'] = 'Invalid parameters have been given.';
$string['json_des'] = "Show payload download option when enabled";
$string['json_title'] = "Enable payload download";
$string['key_count'] = 'Key count';
$string['keys_per_minute'] = 'Keys per minute';
$string['last_modified'] = 'Last modified';
$string['learn_more'] = 'Learn More';
$string['legend'] = "Legend";
$string['module_name'] = 'Module name';
$string['moodle_host'] = 'Moodle host';
$string['name'] = "Name";
$string['new_admin_desc'] = "Customize the notification text and link shown when enabling Cursive on the course settings page.";
$string["new_admin_heading"] = 'Cursive More Info';
$string['no_option'] = "No option available!";
$string['no_submission'] = 'No submission';
$string['nolimit'] = 'No limit';
$string['nopasteevent'] = "No paste events detected for this submission.";
$string['nopaylod'] = 'No payload data!';
$string['note_text_title'] = "Notification text";
$string['note_url_text'] = "URL title";
$string['note_url_title'] = "URL";
$string['notenoughtinfo'] = "Not enough information to verify authorship";
$string['offline'] = 'offline';
$string['opened'] = 'Opened';
$string['orderby'] = 'Order By';
$string['original_text'] = 'Original text';
$string['overdue'] = 'Overdue';
$string['p_burst_cnt'] = 'P-burst Count';
$string['p_burst_cnt_des'] = 'A p-burst is a common feature of writing analytics. In short, it is a sequence of writing until the point at which a writer pauses for 2 seconds or longer. A writing session is invariably made up of many p-bursts which can be quantified. Specifically, this feature reflects the total number of sequences in the writing session or sessions in this document. This number can be compared to the average, but lower or higher numbers do not necessarily translate to good or bad.';
$string['p_burst_mean'] = 'P-Burst Mean';
$string['p_burst_mean_des'] = 'The p-burst mean is the average number of sequential presses between pauses. This is a quick calculation of your ability to string words and thoughts together during the writing process. You may find that your p-burst mean is higher for certain types of writing or when you are writing about certain topics. Higher numbers here can reflect a deeper understanding of the topic, more organized thinking, and fewer distractions while writing.';
$string['pasteEvent'] = "Paste Events";
$string['paste_allow'] = 'Allow';
$string['paste_analysis'] = "Paste Analysis";
$string['paste_block'] = 'Block';
$string['paste_blocked'] = 'Pasting from external sources is not allowed for this assignment.';
$string['paste_cite_source'] = 'Cite Source';
$string['paste_setting'] = 'Paste Settings';
$string['paste_setting_help'] = 'This allows you to control whether students can paste text into the active Tiny editor. The settings are Allow, Block, or use Cite-source. Cite-source collects a student comment which will be visible in the Difference tab and highlights pasted text in the Cursive analytics/replay.';
$string['pastecount'] = 'Paste count';
$string['pastewarning'] = 'You cannot paste text without providing source';
$string['payloadjson'] = "Payload JSON";
$string['pleasewait'] = "Please Wait!";
$string['pluginname'] = 'Cursive';
$string['pluginname_desc'] = 'This plugin configuration provides copy-paste interruption by default. To connect to the Cursive Machine Learning Server for authorship and writing analytics, please enter your token and server details below. If you do not have these, please contact info@cursivetechnology.com.';
$string['pluginname_desc_new'] = "Thanks for installing Cursive. For updates on Cursive's Moodle Plugin Development roadmap and to request new features";
$string['pluginname_desc_new_2'] = "This plugin adds several new features to Moodle to support academic integrity and writing skills development without requiring any connection to the Cursive API. These include writing replay and cite-source copy+paste monitoring.";
$string['pluginname_desc_new_3'] = "Connecting your site to the Cursive API provides your teachers and students access to our machine learning and AI features including authorship verification, text similarity and comparison, writing analytics, and more. To request a Cursive Secret Key and the API URL, please contact";
$string['pluginname_desc_new_link'] = "sign up for our newsletter";
$string['privacy:metadata:database:tiny_cursive'] = 'Information about the tiny cursive data.';
$string['privacy:metadata:database:tiny_cursive:content'] = 'User keystroke data for generating analytics report';
$string['privacy:metadata:database:tiny_cursive:original_content'] = 'User original submission content data';
$string['privacy:metadata:database:tiny_cursive:timemodified'] = 'The time when the data was last modified.';
$string['privacy:metadata:database:tiny_cursive:userid'] = 'The ID of the user who provided the data.';
$string['privacy:metadata:database:tiny_cursive_comments'] = 'Information about the tiny cursive comments data.';
$string['privacy:metadata:database:tiny_cursive_comments:commenttext'] = 'The text of the comment.';
$string['privacy:metadata:database:tiny_cursive_comments:timemodified'] = 'The time when the comment was last modified.';
$string['privacy:metadata:database:tiny_cursive_comments:userid'] = 'The ID of the user who provided the comment.';
$string['privacy:metadata:tiny_cursive'] = 'Tiny cursive plugin user data.';
$string['progress'] = 'Progress';
$string['q_count'] = 'Q Count';
$string['q_count_des'] = 'Q is our stand-in for character. It is any alphanumeric key on your keyboard (spaces not included). These are all additive keys. This differs from Verbosity in its exclusion of edits and space.';
$string['quality'] = 'Quality';
$string['quality_access'] = 'Custom configuration';
$string['quality_access_des'] = 'Active or inactive this advance configuration features.';
$string['queswise'] = 'Question-wise';
$string['quizname'] = 'Activity name';
$string['random_reflex'] = 'Your random reflection prompt';
$string['refer'] = 'References';
$string['remaining'] = 'Remaining';
$string['replay'] = 'Replay';
$string['replyingto'] = 'Replying to Post';
$string['report_date'] = "Report Date";
$string['report_gen'] = "Report generated on";
$string['report_sub_title'] = "Comprehensive Writing Analytic & Attribution Analysis";
$string['report_title'] = "Student Submission Analysis Report";
$string['resubmit'] = "No payload data could be retrieved. Please check your connection and try resubmitting the request.";
$string['resubmitbtn'] = "Resubmit";
$string['retrivedta'] = "Retrieve Data";
$string['rubrics'] = 'Assessment Rubrics';
$string['savechanges'] = 'Save changes';
$string['saved'] = 'saved';
$string['savedcontent'] = 'Saved Content';
$string['saving'] = "saving";
$string['score'] = 'Score';
$string['secretkey'] = 'Cursive Secret Key';
$string['secretkey_desc'] = 'The API Secret Key of Cursive account. Please generate a new webservice token if you updated/added this key.';
$string['sectionadvance'] = 'Advanced';
$string['sectionadvance_desc'] = 'Custom configurations for Quality Metrics';
$string['select_time'] = 'Select time option';
$string['selectcrs'] = 'Select Course';
$string['selectmodule'] = 'Select module';
$string['selectquiz'] = 'Select a quiz';
$string['selectuser'] = 'Select a user';
$string['sent_word_count_mean'] = 'Word count per sentence mean';
$string['sent_word_count_mean_des'] = 'This simple calculation is the total estimated word count divided by the number of sentences providing an average of words per sentence. Sentence length increases as writing skills develop and writers progress from simple noun plus verb configurations to compound and complex sentences with advanced punctuation.';
$string['sentence_count'] = 'Sentence count';
$string['sentence_count_des'] = 'The total number of sentences in your writing is a product of your use of punctuation, which reflects the calculated value here.';
$string['stats'] = 'Stats';
$string['status'] = 'Status';
$string['stndtime'] = 'Standard time';
$string['student_info'] = 'Student Information';
$string['student_name'] = "Student Name";
$string['student_writing_statics'] = 'Writing statistics';
$string['subjectnot'] = 'Subject or message cannot be empty.';
$string['submission_content'] = "Submission Content Analysis";
$string['submission_date'] = "Submission Date";
$string['submission_status'] = 'Submission Status';
$string['submissionqueued'] = "Submission requeued: the submission will be synced in the next scheduled task. Please check back in few minutes.";
$string['success'] = 'Success';
$string['syncinterval'] = 'Sync interval';
$string['syncinterval_des'] = 'Specify how frequently (in seconds) the user\'s writing keystrokes should be synchronized with the server. A lower value provides more real-time tracking but may increase server load. Recommended range is 10-30 seconds.';
$string['test_token'] = 'Test token';
$string['thresold_description'] = 'Each site may set its threshold for providing the successful match “green check” to the TypeID column for student submissions. We recommend .65. However, there may be arguments for lower or higher thresholds depending on your experience or academic honesty policy.';
$string['time_writing'] = 'Time writing ';
$string['time_writing_desc'] = 'Total duration less inactive periods';
$string['timeleft'] = 'Time Left';
$string['timesave_success'] = 'Time saved successfully';
$string['tiny_cursive'] = 'Authorship and Analytics';
$string['tiny_cursive_placeholder'] = 'Write your comment or paste your link here…';
$string['tiny_cursive_srcurl'] = 'Please provide a comment';
$string['tiny_cursive_srcurl_des'] = 'Insert a comment, link, or information to provide context for the pasted text. This will be displayed as part of the submission.';
$string['total_active_time'] = 'Total active time';
$string['total_active_time_des'] = 'Total active time is the duration of your active writing time (pressing keys, manipulating text) minus periods of inactivity longer than 30 seconds.';
$string['total_time'] = 'Total time';
$string['total_time_seconds'] = 'Total time';
$string['total_words'] = 'Total words';
$string['total_words_desc'] = 'Estimated total words from verified effort';
$string['typeid'] = 'TypeID';
$string['uid'] = "ID";
$string['userename'] = 'Username';
$string['verbosity'] = 'Verbosity';
$string['verbosity_des'] = 'This is a count of total activity in the form of key presses. This includes both additions and deletions to your overall text. Every part of the writing process through a keyboard contributes to this number.';
$string['verified'] = "verified";
$string['verified!'] = "not verified";
$string['warning'] = 'You have no permissions to access the page.';
$string['warningpayload'] = 'Something went wrong! or File not found!';
$string['warningpayloadre'] = 'Something went wrong! Please try again later.';
$string['webservicetoken'] = 'Webservice token';
$string['webservicetoken_des'] = 'Webservice token';
$string['webservtokenerror'] = 'An error occurred while generating the token.';
$string['webservtokengenfail'] = 'Webservice token generation failed.';
$string['webservtokengensucc'] = 'Webservice token generation successful.';
$string['word_count'] = 'Word count';
$string['word_count_des'] = 'How many words you typed is estimated based on your usage of the space bar.';
$string['word_len_mean'] = 'Average word length';
$string['word_len_mean_des'] = 'Average word length is calculated by dividing the estimated word count by the total number of characters. Word length varies based on your vocabulary, the audience that you\'re writing for, and the subject. Longer word lengths have an impact on readability and grade-level readability estimates.';
$string['words_per_minute'] = 'Writing speed';
$string['words_per_minute_desc'] = 'Words per minute';
$string['wractivityreport'] = 'Writing activity report';
$string['writing_analytics'] = "Writing Analytics";
