/**
 * Module that creates a replay button.
 * The button displays replay functionality for a specific user.
 *
 * @module     tiny_cursive/replay_button
 * @copyright  2024 CTI <info@cursivetechnology.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("tiny_cursive/replay_button",["core/str"],(function(Str){return function(userid){let questionid=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"";const anchor=document.createElement("a");anchor.href="#",anchor.id="analytics"+userid+questionid,anchor.classList.add("d-inline-flex","justify-content-center","text-decoration-none");const button=document.createElement("div");button.className="tiny_cursive-replay-button";const left=document.createElement("div");left.className="tiny_cursive-replay-left";const icon=document.createElement("img");icon.src=M.util.image_url("playicon","tiny_cursive"),icon.alt="Replay Icon",icon.className="tiny_cursive-replay-bar-icon";const label=document.createElement("span");return label.className="tiny_cursive-replay-label",label.textContent="Replay",Str.get_string("replay","tiny_cursive").then((replayString=>(label.textContent=replayString,replayString))).catch((error=>{window.console.error("Error fetching string:",error)})),left.appendChild(icon),left.appendChild(label),button.appendChild(left),anchor.appendChild(button),anchor}}));

//# sourceMappingURL=replay_button.min.js.map