define("tiny_cursive/document_view",["exports","tiny_cursive/svg_repo"],(function(_exports,_svg_repo){var obj;
/**
   * This module provides functionality for document view management in the Tiny editor,
   * including full page mode display and sidebar information
   * @module     tiny_cursive/document_view
   * @copyright  2025 Cursive Technology, Inc. <info@cursivetechnology.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_svg_repo=(obj=_svg_repo)&&obj.__esModule?obj:{default:obj};return _exports.default=class{constructor(User,Rubrics,submission,modulename,editor,quizInfo){this.User=User,this.Rubrics=Rubrics,this.submission=submission,this.module=modulename,this.editor=editor,this.moduleIcon=_svg_repo.default.assignment,this.quizInfo=quizInfo,this.initStrings()}normalMode(){var _this$editor;let id=(null===(_this$editor=this.editor)||void 0===_this$editor?void 0:_this$editor.id)+"_ifr";("assign"===this.module||"quiz"===this.module||"forum"===this.module||"lesson"===this.module||"pdfannotator"===this.module)&&this.normalizePage(id)}fullPageMode(){var _this$editor4,_this$editor2;if("assign"===this.module)this.moduleIcon=_svg_repo.default.assignment,this.fullPageModule(null===(_this$editor2=this.editor)||void 0===_this$editor2?void 0:_this$editor2.id);else if("forum"===this.module){var _this$editor3;this.moduleIcon=_svg_repo.default.forum,this.fullPageModule(null===(_this$editor3=this.editor)||void 0===_this$editor3?void 0:_this$editor3.id)}else if("quiz"===this.module&&null!==(_this$editor4=this.editor)&&void 0!==_this$editor4&&_this$editor4.id){var _this$editor5;this.moduleIcon=_svg_repo.default.quiz,this.fullPageModule(null===(_this$editor5=this.editor)||void 0===_this$editor5?void 0:_this$editor5.id)}else if("lesson"===this.module){var _this$editor6;this.moduleIcon=_svg_repo.default.lesson,this.fullPageModule(null===(_this$editor6=this.editor)||void 0===_this$editor6?void 0:_this$editor6.id)}else if("pdfannotator"===this.module){var _this$editor7;this.moduleIcon=_svg_repo.default.pdfannotator,this.fullPageModule(null===(_this$editor7=this.editor)||void 0===_this$editor7?void 0:_this$editor7.id)}}docSideBar(status){var _this$editor8;const replyId=new URL(window.location.href).searchParams.get("reply"),toggle=document.querySelector("#cursive-fullpagemode-sidebar-toggle"),timelimitBlock=this.getTimerBlock(this.module),headerInfo=this.getSidebarTitle(),progressBar=document.querySelector(".box.progress_bar"),courseName=document.querySelector("#page-navbar > nav > ol > li:nth-child(1) > a"),courseDes=document.querySelector("#intro"),Dates=document.querySelector(".activity-dates");let openDate=null==Dates?void 0:Dates.querySelector("div:nth-child(1)"),dueDate=null==Dates?void 0:Dates.querySelector("div:nth-child(2)");const container=this.create("div");Object.assign(container,{id:"cursive-fullpagemode-sidebar",className:"bg-white h-100 shadow"}),Object.assign(container.style,{width:"300px",overflow:"auto"});const crossBtn=this.create("span");Object.assign(crossBtn,{id:"cursive-collapse-sidebar",className:"btn p-2",innerHTML:_svg_repo.default.close}),crossBtn.addEventListener("click",(()=>{container.style.transition="width 0.3s ease",container.style.width="0",toggle.style.display="flex"})),null==toggle||toggle.addEventListener("click",(function(){toggle.style.display="none",container.style.width="300px"}));const btnWrapper=this.create("div");Object.assign(btnWrapper,{padding:"0 1rem",position:"sticky",top:"0",backgroundColor:"white"}),btnWrapper.append(crossBtn);const header=this.create("div");header.className="border-bottom p-3 bg-light",Object.assign(header.style,{position:"sticky",top:"0"});const headerTitle=this.create("h3");headerTitle.className="mb-3 d-flex align-items-center",headerTitle.textContent=`${headerInfo.title} ${this.details}`,headerTitle.style.fontWeight="600";const headerIcon=document.querySelector(".page-header-image > div");headerIcon&&headerTitle.prepend(headerIcon.cloneNode(!0));let wordCount=this.wordCounter(status);null!=timelimitBlock&&timelimitBlock.textContent?header.append(headerTitle,wordCount,this.timerCountDown(timelimitBlock)):header.append(headerTitle,wordCount);const content=this.create("div");if(content.className="p-3",content.append(this.createBox({bg:"bg-info",titleColor:"text-info",icon:_svg_repo.default.people,title:this.studentInfo,bodyHTML:this.generateStudentInfo(this.User,courseName)})),"lesson"===this.module&&progressBar&&content.append(this.createBox({bg:"bg-gray",titleColor:"text-dark",icon:this.moduleIcon,title:this.progress,bodyHTML:progressBar.innerHTML})),courseDes&&""!==(null==courseDes?void 0:courseDes.textContent.trim())){let fileSubDiv=document.querySelectorAll(".fileuploadsubmission");fileSubDiv&&fileSubDiv.forEach((Element=>{Element.style.verticalAlign="middle"})),content.append(this.createBox({bg:"bg-gray",titleColor:"text-dark",icon:this.moduleIcon,title:`${this.getSidebarTitle().title} ${this.description}`,bodyHTML:courseDes.innerHTML}))}if("forum"===this.module&&replyId){this.checkForumSubject();let replyPost=document.querySelector(`#post-content-${replyId}`);null!=replyPost&&replyPost.textContent.trim()&&content.append(this.createBox({bg:"bg-gray",titleColor:"text-dark",icon:this.moduleIcon,title:this.replyingto,bodyHTML:replyPost.textContent.trim()}))}if("quiz"===this.module&&null!==(_this$editor8=this.editor)&&void 0!==_this$editor8&&_this$editor8.id){var _this$editor9;let questionId=this.getQuestionId(null===(_this$editor9=this.editor)||void 0===_this$editor9?void 0:_this$editor9.id),question=document.querySelector(`#question-${questionId} .qtext`),intro=atob(this.quizInfo.intro);null!=question&&question.textContent.trim()&&content.append(this.createBox({bg:"bg-amber",titleColor:"text-dark",icon:this.moduleIcon,title:this.answeringto,bodyHTML:question.textContent})),intro&&""!==intro.trim()&&content.append(this.createBox({bg:"bg-gray",titleColor:"text-dark",icon:this.moduleIcon,title:`${this.quiz} ${this.description}`,bodyHTML:intro})),Number(this.quizInfo.open)&&content.append(this.createBox({bg:"bg-amber",titleColor:"text-dark",icon:_svg_repo.default.time,title:this.importantdates,bodyHTML:this.generateImportantDates(Number(this.quizInfo.open),Number(this.quizInfo.close))}))}return Object.keys(this.Rubrics).length&&content.append(this.createBox({bg:"bg-gray",titleColor:"text-dark",icon:this.moduleIcon,title:this.rubrics,bodyHTML:this.generateRubrics(this.Rubrics)})),Dates&&content.append(this.createBox({bg:"bg-amber",titleColor:"text-dark",icon:_svg_repo.default.time,title:this.importantdates,bodyHTML:this.generateImportantDates(openDate,dueDate)})),"assign"===this.module&&content.append(this.createBox({bg:"bg-green",titleColor:"text-success",icon:this.moduleIcon,title:this.subStatus,bodyHTML:this.submissionStatus(this.submission)})),container.append(btnWrapper,header,content),container}createBox(_ref){let{bg:bg,titleColor:titleColor,icon:icon,title:title,bodyHTML:bodyHTML}=_ref;const box=this.create("div");box.className=`tiny_cursive-fullpage-card ${bg}`;const heading=this.create("h4");heading.className=`tiny_cursive-fullpage-card-header ${titleColor} d-flex align-items-center`,heading.innerHTML=`${icon} ${title}`;const body=this.create("div");return body.className="tiny_cursive-fullpage-card-body",body.innerHTML=bodyHTML,box.append(heading,body),box}generateRubrics(Rubrics){const wrapper=this.create("div");return Rubrics.forEach((rubric=>{const rubricDiv=this.create("div");rubricDiv.className="tiny_cursive-rubric-card";const title=this.create("h3");title.className="tiny_cursive-rubric-title",title.textContent=rubric.description,rubricDiv.appendChild(title),Object.values(rubric.levels).forEach((level=>{const levelDiv=this.create("div"),score=Number(level.score);levelDiv.className=0===score?"tiny_cursive-rubric-level tiny_cursive-rubric-low":score<=2?"tiny_cursive-rubric-level tiny_cursive-rubric-mid":"tiny_cursive-rubric-level tiny_cursive-rubric-high",levelDiv.textContent=`${level.definition} / ${level.score}`,rubricDiv.appendChild(levelDiv)})),wrapper.appendChild(rubricDiv)})),wrapper.innerHTML}submissionStatus(submission){var _submission$current,_submission$current2;const wrapper=this.create("div"),statusWrapper=this.create("div");statusWrapper.className="tiny_cursive-status-row";const statusName=this.create("span");statusName.textContent=`${this.status}:`;const statusValue=this.create("span"),isNew="new"===(null==submission||null===(_submission$current=submission.current)||void 0===_submission$current?void 0:_submission$current.status);statusValue.textContent=isNew?this.draftnot:this.draft,statusValue.className="tiny_cursive-status-value "+(isNew?"tiny_cursive-status-red":"tiny_cursive-status-green"),statusWrapper.append(statusName,statusValue);const modifiedWrapper=this.create("div");modifiedWrapper.className="tiny_cursive-status-row";const modifiedName=this.create("span");modifiedName.textContent=`${this.lastModified}: `;const modifiedValue=this.create("span");if(null!=submission&&null!==(_submission$current2=submission.current)&&void 0!==_submission$current2&&_submission$current2.timemodified){const date=new Date(1e3*submission.current.timemodified);modifiedValue.textContent=this.formatDate(date)}else modifiedValue.textContent="N/A";modifiedWrapper.append(modifiedName,modifiedValue);const gradeWrapper=this.create("div");gradeWrapper.className="tiny_cursive-status-row";const gradeName=this.create("span");gradeName.textContent=`${this.gradings}: `;const gradeValue=this.create("span");return null!=submission&&submission.grade?gradeValue.textContent=Number(submission.grade.grade)>0?submission.grade.grade:this.gradenot:gradeValue.textContent=this.gradenot,gradeWrapper.append(gradeName,gradeValue),wrapper.append(statusWrapper,gradeWrapper,modifiedWrapper),wrapper.innerHTML}wordCounter(status){const wordCount=this.create("div"),labelDiv=this.create("div"),label=this.create("span"),value=this.create("span"),icon=this.create("span");icon.className="me-2",icon.innerHTML=_svg_repo.default.assignment,labelDiv.appendChild(icon),labelDiv.append(label),label.textContent=`${this.wordCount}:`,value.textContent="0",value.className="text-primary",value.style.fontWeight="600",value.style.fontSize="14px",wordCount.className="bg-white rounded shadow-sm p-2 d-flex justify-content-between my-2",wordCount.append(labelDiv,value),wordCount.style.fontSize="12px";return new MutationObserver((()=>{const newText=status.textContent.trim();value.textContent=`${newText.replace("words","")}`})).observe(status,{characterData:!0,subtree:!0,childList:!0}),wordCount}timerCountDown(timer){let warningDiv=document.querySelector("#user-notifications > div");if(warningDiv){var _clone$querySelector;let clone=warningDiv.cloneNode(!0);null===(_clone$querySelector=clone.querySelector("button"))||void 0===_clone$querySelector||_clone$querySelector.remove(),this.editor.notificationManager.open({text:clone.textContent,type:"error"})}const timerCount=this.create("div");timerCount.className="bg-white rounded shadow-sm p-2 d-flex justify-content-between my-2";const labelDiv=this.create("div"),label=this.create("span"),value=this.create("span"),icon=this.create("span");if(icon.innerHTML=_svg_repo.default.time,labelDiv.appendChild(icon),labelDiv.append(label),label.textContent=`${this.timeleft}:`,value.textContent="00:00:00",value.className=warningDiv?"text-danger":"text-primary",Object.assign(value.style,{fontWeight:"600",fontSize:"14px"}),timerCount.append(labelDiv,value),timerCount.style.fontSize="12px",timer){new MutationObserver((()=>{const newText=timer.textContent.trim();value.textContent=`${newText}`})).observe(timer,{characterData:!0,subtree:!0,childList:!0})}else value.textContent=this.nolimit;return timerCount}generateStudentInfo(user,course){const wrapper=this.create("div"),nameWrapper=this.create("div"),usernameWrapper=this.create("div"),courseWrapper=this.create("div"),nameLabel=this.create("strong"),nameValue=this.create("span"),usernameLabel=this.create("strong"),usernameValue=this.create("span"),courseLabel=this.create("strong"),courseValue=this.create("span");return nameLabel.textContent=`${this.name}`,nameValue.textContent=user.fullname,usernameLabel.textContent=`${this.userename}: `,usernameValue.textContent=user.username,courseLabel.textContent=`${this.course}: `,courseValue.textContent=course.title,usernameLabel.className="cfw-bold me-2",usernameValue.className="cursiveFw-wrap",courseLabel.className="cfw-bold me-2",courseValue.className="cursiveFw-wrap",nameLabel.className="cfw-bold me-2",nameValue.className="cursiveFw-wrap",nameWrapper.append(nameLabel,nameValue),usernameWrapper.append(usernameLabel,usernameValue),courseWrapper.append(courseLabel,courseValue),wrapper.append(nameWrapper,usernameWrapper,courseWrapper),wrapper.innerHTML}generateImportantDates(open,due){const wrapper=this.create("div");let openDate=null,dueDate=null;const openedWrapper=this.create("div"),dueWrapper=this.create("div"),remainingWrapper=this.create("div"),openedLabel=this.create("span"),openedValue=this.create("span"),dueLabel=this.create("span"),dueValue=this.create("span"),remainingLabel=this.create("span"),remainingValue=this.create("span");return"quiz"===this.module?(openDate=1e3*open,dueDate=1e3*due):(openDate=this.extractDate(null==open?void 0:open.textContent),dueDate=this.extractDate(null==due?void 0:due.textContent)),openedLabel.textContent=`${this.opened}: `,openedValue.textContent=this.formatDate(openDate?new Date(openDate):null),openedValue.className="text-dark",dueLabel.textContent=`${this.due}: `,dueValue.textContent=this.formatDate(dueDate?new Date(dueDate):null),dueValue.className="text-danger",remainingLabel.textContent=`${this.remaining}: `,remainingValue.textContent=this.calculateDate(dueDate),remainingValue.className="text-danger",openedWrapper.className="d-flex justify-content-between",dueWrapper.className="d-flex justify-content-between",remainingWrapper.className="d-flex align-items-center justify-content-between mt-2 pt-2 border-top",openedWrapper.append(openedLabel,openedValue),dueWrapper.append(dueLabel,dueValue),remainingWrapper.append(remainingLabel,remainingValue),wrapper.append(openedWrapper,dueWrapper,remainingWrapper),wrapper.innerHTML}formatDate(date){if(!date)return"-";return date.toLocaleString("en-US",{year:"numeric",month:"short",day:"numeric",hour:"numeric",minute:"numeric",hour12:!0})}extractDate(text){if(!text)return"-";const parts=null==text?void 0:text.split(":");return parts.length>1?parts.slice(1).join(":").trim():text.trim()}calculateDate(date){if(!date)return"-";const diffMs=new Date(date)-new Date;if(diffMs<=0)return"Overdue";return`${Math.floor(diffMs/864e5)} days, ${Math.floor(diffMs/36e5%24)} hours`}fullPageModule(module){var _current$contentDocum,_current$contentWindo,_current$contentWindo2,_document$getElementB;let current="quiz"===this.module?document.getElementById(`${module}_ifr`):document.querySelector(`#${module}_ifr`),p1=current.parentElement,p2=p1.parentElement,p4=p2.parentElement.parentElement,statusBar=document.querySelector(".tox-statusbar__right-container > button"),assignName=document.querySelector(".page-context-header"),header=this.create("div"),btn=null;if(assignName.classList.remove("mb-2"),header.id="tiny_cursive-fullpage-custom-header",Object.assign(header.style,{backgroundColor:"white",display:"flex",justifyContent:"space-between"}),"quiz"===this.module?(btn=document.querySelector("#mod_quiz-next-nav").cloneNode(!0),btn.className="tiny_cursive-fullpage-submit-btn",btn.style.margin=".5rem"):(btn=this.create("input"),btn.className="tiny_cursive-fullpage-submit-btn",btn.value=this.savechanges,btn.type="submit",btn.style.margin=".5rem"),"pdfannotator"===this.module){const style=document.createElement("style");style.id="cursiveForceStyle",style.textContent="\n                .path-mod-pdfannotator #comment-wrapper h4,\n                .path-mod-pdfannotator #comment-nav {\n                    margin: 0 !important;\n                }\n            ",document.head.appendChild(style)}const leftSide=this.create("div"),rightSide=this.create("div");let commonStyle={display:"flex",alignItems:"center",margin:"0 1rem"};Object.assign(leftSide.style,commonStyle),rightSide.id="tiny_cursive-fullpage-right-wrapper",Object.assign(rightSide.style,commonStyle),rightSide.appendChild(btn),leftSide.appendChild(assignName.cloneNode(!0)),header.appendChild(leftSide),header.appendChild(rightSide),p4.insertBefore(header,p4.firstChild),p2.style.backgroundColor="#efefef",Object.assign(current.style,{width:"750px",minWidth:"750px",boxShadow:"0 10px 15px -3px rgb(0 0 0/0.1),0 4px 6px -4px rgb(0 0 0/0.1)"}),Object.assign(p1.style,{display:"flex",justifyContent:"center",outline:"none",margin:"2rem 0 0"});const style=this.create("style");style.id="tiny_cursive-fullpage-mode-style",style.textContent="\n            .tox.tox-edit-focus .tox-edit-area::before {\n                opacity: 0;\n            }",document.head.appendChild(style);let iframeBody=(null===(_current$contentDocum=current.contentDocument)||void 0===_current$contentDocum?void 0:_current$contentDocum.body)||(null===(_current$contentWindo=current.contentWindow)||void 0===_current$contentWindo||null===(_current$contentWindo2=_current$contentWindo.document)||void 0===_current$contentWindo2?void 0:_current$contentWindo2.body);iframeBody&&(iframeBody.style.padding="0.5in"),p2.style.position="relative",null===(_document$getElementB=document.getElementById("cursive-fullpagemode-sidebar"))||void 0===_document$getElementB||_document$getElementB.remove();let toggle=this.create("div");toggle.id="cursive-fullpagemode-sidebar-toggle",toggle.innerHTML=_svg_repo.default.hamburger,p2.appendChild(toggle),p2.appendChild(this.docSideBar(statusBar))}normalizePage(editorId){var _document$getElementB2,_document$getElementB3,_current$contentDocum2,_current$contentWindo3,_current$contentWindo4,_document$head$queryS,_document$head$queryS2;null===(_document$getElementB2=document.getElementById("tiny_cursive-fullpage-custom-header"))||void 0===_document$getElementB2||_document$getElementB2.remove(),null===(_document$getElementB3=document.getElementById("cursive-fullpagemode-sidebar"))||void 0===_document$getElementB3||_document$getElementB3.remove();let current=document.getElementById(editorId),p1=current.parentElement,p2=p1.parentElement;Object.assign(p2.style,{backgroundColor:"",position:""}),Object.assign(current.style,{width:"",minWidth:"",boxShadow:""}),Object.assign(p1.style,{display:"",justifyContent:"",outline:"",margin:""}),p1.classList.remove("tiny-cursive-editor-container");let iframeBody=(null===(_current$contentDocum2=current.contentDocument)||void 0===_current$contentDocum2?void 0:_current$contentDocum2.body)||(null===(_current$contentWindo3=current.contentWindow)||void 0===_current$contentWindo3||null===(_current$contentWindo4=_current$contentWindo3.document)||void 0===_current$contentWindo4?void 0:_current$contentWindo4.body);iframeBody&&(iframeBody.style.padding="0"),null===(_document$head$queryS=document.head.querySelector("#tiny_cursive-fullpage-mode-style"))||void 0===_document$head$queryS||_document$head$queryS.remove(),null===(_document$head$queryS2=document.head.querySelector("#cursiveForceStyle"))||void 0===_document$head$queryS2||_document$head$queryS2.remove()}checkForumSubject(){const form=document.querySelector("#tiny_cursive-fullpage-right-wrapper > input"),msg=this.subjectnot;form&&form.addEventListener("click",(e=>{const subjectInput=document.getElementById("id_subject");let content=this.editor.getContent().trim();subjectInput&&""!==subjectInput.value.trim()&&""!==content||(e.preventDefault(),e.stopPropagation(),this.editor.windowManager.alert(msg))}))}getSidebarTitle(){const[assign,discus,quiz,lesson]=this.getText("sbTitle");switch(this.module){case"assign":return{title:assign,icon:_svg_repo.default.assignment};case"forum":return{title:discus,icon:_svg_repo.default.forum};case"lesson":return{title:lesson,icon:_svg_repo.default.forum};case"quiz":return{title:quiz,icon:_svg_repo.default.quiz};case"pdfannotator":return{title:"PDF Annotation",icon:_svg_repo.default.pdfannotator};default:return{title:"Page",icon:_svg_repo.default.quiz}}}getTimerBlock(module){switch(module){case"assign":return document.querySelector("#mod_assign_timelimit_block > div > div");case"forum":return document.querySelector("#mod_forum_timelimit_block");case"lesson":return document.querySelector("#lesson-timer");case"quiz":return document.querySelector("#quiz-time-left");default:return null}}getQuestionId(editoId){try{return editoId&&"string"==typeof editoId?editoId.replace(/^q(\d+):(\d+)_.*$/,"$1-$2"):""}catch(error){return window.console.error("Error getting question ID:",error),""}}initStrings(){[this.details,this.studentInfo,this.progress,this.description,this.replyingto,this.answeringto,this.importantdates,this.rubrics,this.subStatus,this.status,this.draft,this.draftnot,this.lastModified,this.gradings,this.gradenot,this.wordCount,this.timeleft,this.nolimit,this.name,this.userename,this.course,this.opened,this.due,this.overdue,this.remaining,this.savechanges,this.subjectnot]=this.getText("docSideBar")}getText(key){return JSON.parse(localStorage.getItem(key))||[]}create(tag){return document.createElement(tag)}},_exports.default}));

//# sourceMappingURL=document_view.min.js.map