define("tiny_cursive/cursive_autosave",["exports","core/templates","core/ajax","tiny_cursive/svg_repo","core/str"],(function(_exports,_templates,_ajax,_svg_repo,_str){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * TODO describe module cursive_autosave
   *
   * @module     tiny_cursive/cursive_autosave
   * @copyright  2025 Cursive Technology, Inc. <info@cursivetechnology.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_templates=_interopRequireDefault(_templates),_svg_repo=_interopRequireDefault(_svg_repo);class CursiveAutosave{static instance=null;constructor(editor,rightWrapper,modules,isFullScreen){if(CursiveAutosave.instance)return CursiveAutosave.instance;this.editor=editor,this.module=modules,this.savingState="",this.rightWrapper=rightWrapper,this.isFullScreen=isFullScreen,this.fetchSavedContent=this.fetchSavedContent.bind(this),this.handleEscapeKey=this.handleEscapeKey.bind(this),this._savingTimer=null,CursiveAutosave.instance=this,this.fetchStrings()}static getInstance(editor,rightWrapper,modules,isFullScreen){this.instance||(this.instance=new CursiveAutosave(editor,rightWrapper,modules,isFullScreen)),this.instance.isFullScreen=isFullScreen;return("quiz"===modules.modulename?document.querySelector(`#tiny_cursive_savingState${modules.questionid}`):document.querySelector("#tiny_cursive_savingState"))||this.instance.init(),this.instance}init(){const stateWrapper=this.cursiveSavingState(this.savingState);stateWrapper.classList.add("tiny_cursive_savingState","btn"),"quiz"===this.module.modulename?stateWrapper.id=`tiny_cursive_savingState${this.module.questionid}`:stateWrapper.id="tiny_cursive_savingState",this.rightWrapper.prepend(stateWrapper),stateWrapper.addEventListener("click",this.fetchSavedContent)}destroy(){CursiveAutosave.instance=null}static destroyInstance(){this.instance&&(this.instance.destroy(),this.instance=null)}cursiveSavingState(state){let wrapperDiv=document.createElement("div"),textSpan=document.createElement("span"),button=document.createElement("button"),iconSpan=document.createElement("span");return button.style.padding=".3rem",textSpan.style.fontSize="0.75rem",textSpan.style.color="gray","quiz"===this.module.modulename?(iconSpan.id=`CursiveCloudIcon${this.module.questionid}`,textSpan.id=`CursiveStateText${this.module.questionid}`):(iconSpan.id="CursiveCloudIcon",textSpan.id="CursiveStateText"),state&&(textSpan.textContent=this.getStateText(state),iconSpan.innerHTML=this.getStateIcon(state)),wrapperDiv.style.verticalAlign="middle",wrapperDiv.appendChild(iconSpan),wrapperDiv.appendChild(textSpan),button.appendChild(wrapperDiv),button}static updateSavingState(state){const instance=this.instance;instance.savingState=state;let stateWrapper=null;stateWrapper="quiz"===instance.module.modulename?document.querySelector(`#tiny_cursive_savingState${instance.module.questionid}`):document.querySelector("#tiny_cursive_savingState");let iconSpan="",stateTextEl="";stateWrapper&&("quiz"===instance.module.modulename?(iconSpan=stateWrapper.querySelector(`#CursiveCloudIcon${instance.module.questionid}`),stateTextEl=stateWrapper.querySelector(`#CursiveStateText${instance.module.questionid}`)):(iconSpan=stateWrapper.querySelector("#CursiveCloudIcon"),stateTextEl=stateWrapper.querySelector("#CursiveStateText")),stateTextEl&&iconSpan&&(stateTextEl.textContent=instance.getStateText(state),iconSpan.innerHTML=instance.getStateIcon(state)),instance._savingTimer&&clearTimeout(instance._savingTimer),"saved"===state&&stateTextEl&&(instance._savingTimer=setTimeout((()=>{stateTextEl.textContent=""}),5e3)))}getStateText(state){const[saving,saved,offline]=this.getText("state");switch(state){case"saving":return saving;case"saved":return saved;case"offline":return offline;default:return""}}getStateIcon(state){switch(state){case"saving":case"saved":return _svg_repo.default.cloudSave;case"offline":return"data:image/svg+xml;base64,"+btoa(_svg_repo.default.offline);default:return""}}async fetchSavedContent(e){var _dropdown$classList,_this$editor;e.preventDefault();let dropdown=document.querySelector("#savedDropdown");if(null==dropdown||null===(_dropdown$classList=dropdown.classList)||void 0===_dropdown$classList?void 0:_dropdown$classList.contains("show"))return void this.closeSavedDropdown();let editorWrapper=null;editorWrapper="quiz"===this.module.modulename?document.querySelector(`#tiny_cursive_savingState${this.module.questionid}`):document.querySelector("#tiny_cursive_savingState");let args={id:this.module.resourceId,cmid:this.module.cmid,modulename:`${this.module.modulename}_autosave`,editorid:null===(_this$editor=this.editor)||void 0===_this$editor?void 0:_this$editor.id,userid:this.module.userid,courseid:this.module.courseid};(0,_ajax.call)([{methodname:"cursive_get_autosave_content",args:args}])[0].done((data=>{let context={comments:JSON.parse(data)};Object.values(context.comments).forEach((content=>{content.time=this.timeAgo(content.timemodified)})),this.renderCommentList(context,editorWrapper)})).fail((error=>{this.throwWarning("fullmodeerrorr",this.editor),window.console.error("Error fetching saved content:",error)}))}toggleSavedDropdown(){var _dropdown$classList2;const dropdown=document.querySelector("#savedDropdown");(null==dropdown||null===(_dropdown$classList2=dropdown.classList)||void 0===_dropdown$classList2?void 0:_dropdown$classList2.contains("show"))?this.closeSavedDropdown():this.openSavedDropdown()}openSavedDropdown(){document.querySelector("#savedDropdown").classList.add("show"),document.removeEventListener("keydown",this.handleEscapeKey),document.addEventListener("keydown",this.handleEscapeKey)}closeSavedDropdown(){const dropdown=document.querySelector("#savedDropdown");dropdown&&(dropdown.classList.remove("show"),dropdown.remove(),document.removeEventListener("keydown",this.handleEscapeKey))}handleEscapeKey(event){"Escape"===event.key&&this.closeSavedDropdown()}timeAgo(unixTime){const seconds=Math.floor(Date.now()/1e3)-unixTime;if(seconds<5)return"just now";if(seconds<60)return`${seconds} sec ago`;const minutes=Math.floor(seconds/60);if(minutes<60)return`${minutes} min ago`;const hours=Math.floor(minutes/60);if(hours<24)return`${hours} hour${hours>1?"s":""} ago`;const days=Math.floor(hours/24);if(days<7)return`${days} day${days>1?"s":""} ago`;const weeks=Math.floor(days/7);if(weeks<4)return`${weeks} week${weeks>1?"s":""} ago`;const months=Math.floor(days/30);if(months<12)return`${months} month${months>1?"s":""} ago`;const years=Math.floor(days/365);return`${years} year${years>1?"s":""} ago`}renderCommentList(context,editorWrapper){_templates.default.render("tiny_cursive/saved_content",context).then((html=>{editorWrapper.style.position="relative";const tempDiv=document.createElement("div");if(tempDiv.innerHTML=html.trim(),tempDiv.id="savedDropdown",tempDiv.classList.add("tiny_cursive-saved-dropdown"),!tempDiv)return window.console.error("Saved content template rendered empty or invalid HTML."),!1;let existingPanel=document.querySelector("#savedDropdown");return existingPanel||(editorWrapper.appendChild(tempDiv),existingPanel=tempDiv),existingPanel.classList.toggle("active"),this.openSavedDropdown(),this.insertSavedItems(this.editor),!0})).catch((error=>window.console.error(error)))}fetchStrings(){localStorage.getItem("state")||Promise.all([(0,_str.get_string)("saving","tiny_cursive"),(0,_str.get_string)("saved","tiny_cursive"),(0,_str.get_string)("offline","tiny_cursive")]).then((function(strings){return localStorage.setItem("state",JSON.stringify(strings))})).catch((error=>window.console.error(error)))}throwWarning(str,editor){(0,_str.get_string)(str,"tiny_cursive").then((str=>editor.windowManager.alert(str))).catch((error=>window.console.error(error)))}getText(key){return JSON.parse(localStorage.getItem(key))}insertSavedItems(editor){document.querySelectorAll(".tiny_cursive-item-preview").forEach((element=>{element.addEventListener("click",(function(){editor.insertContent(" "+this.textContent)}))}))}}return _exports.default=CursiveAutosave,_exports.default}));

//# sourceMappingURL=cursive_autosave.min.js.map