/**
 * Module that creates an analytics button with an icon and text.
 * The button displays analytics information for a specific user and question.
 *
 * @module     tiny_cursive/analytic_button
 * @copyright  2024 CTI <info@cursivetechnology.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("tiny_cursive/analytic_button",["core/str"],(function(Str){return function(effort,userid){let questionid=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"";const anchor=document.createElement("a");anchor.href="#",anchor.id="analytics"+userid+questionid,anchor.classList.add("d-inline-flex","justify-content-center","text-decoration-none");const button=document.createElement("div");button.className="tiny_cursive-analytics-button";const left=document.createElement("div");left.className="tiny_cursive-analytics-left";const icon=document.createElement("img");icon.src=M.util.image_url("chart-column","tiny_cursive"),icon.alt="Analytics Icon",icon.className="tiny_cursive-analytics-bar-icon";const label=document.createElement("span");if(label.className="tiny_cursive-analytics-label",label.textContent="Analytics",Str.get_string("analytics","tiny_cursive").then((analyticsString=>(label.textContent=analyticsString,analyticsString))).catch((error=>{window.console.error("Error fetching string:",error)})),left.appendChild(icon),left.appendChild(label),button.appendChild(left),effort){const right=document.createElement("div");right.className="tiny_cursive-analytics-right",right.textContent=effort+"%",right.title="Effort",effort<90&&(right.style.backgroundColor="#EAB308"),button.appendChild(right)}return anchor.appendChild(button),anchor}}));

//# sourceMappingURL=analytic_button.min.js.map