/**
 * Defines the behavior of the student's answer form for a vplquestion.
 * @copyright  Astor Bizard, 2019
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("qtype_vplquestion/studentanswer",["jquery","core/config","core/modal_factory","core/modal_events","core/templates","qtype_vplquestion/codeeditors","mod_vpl/vplterminal","qtype_vplquestion/vplservice"],(function($,cfg,ModalFactory,ModalEvents,Templates,CodeEditors,VPLTerminal,VPLService){function str(key){switch(key){case"console":return"[Process";case"connected":case"connecting":case"running":return"running]";case"connection_closed":return"exited]";default:return key}}function makeResultHtml(result,field,level,pre){if(result[field]){var formattedText="";return(pre?function(text){var map={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#039;"};return text.replace(/[&<>"']/g,(function(c){return map[c]}))}(result[field]):function(text){text=text.replace(/<img[^>]*>/gi,"");var div=document.createElement("div");div.innerHTML=text;var allowedTags={a:["href"],b:[],br:[],div:[],em:[],i:[],p:[],pre:[],span:["lang"]},allowedAttrs=["class"],filterNodes=function(element){if(element.nodeType===Node.ELEMENT_NODE){element.childNodes.forEach(filterNodes);var tag=element.tagName.toLowerCase();tag in allowedTags?Array.from(element.attributes).forEach((function(attr){allowedTags[tag].concat(allowedAttrs).includes(attr.name.toLowerCase())?"a"===tag&&"href"===attr.name.toLowerCase()&&(attr.value.startsWith(cfg.wwwroot)||attr.value.startsWith("#")||(element.outerHTML=element.innerHTML)):element.removeAttributeNode(attr)})):element.outerHTML=element.innerHTML}else element.nodeType!==Node.TEXT_NODE&&element.remove()};return filterNodes(div),div.innerHTML}(result[field])).split(/\n|<br\s*\/?>/).forEach((function(line){pre?formattedText+=line+"\n":line.trim().length>0&&("-"==(line=line.trim()).charAt(0)?formattedText+='<b class="vpl-test-title rounded px-1">'+line.substring(1)+"</b><br>":"&gt;"==line.substring(0,4)?formattedText+='<pre class="m-0">'+line.substring(4)+"</pre>":formattedText+=line+"<br>")})),'<span class="vpl-result-title vpl-title-'+level+' d-block font-weight-bold border border-dark pl-1 mb-1">'+M.util.get_string(field,"qtype_vplquestion")+"</span>"+(pre?"<pre>"+formattedText.trim()+"</pre>":formattedText.trim())}return""}function displayResult(displayId,result){var $display=$("#"+displayId);null===result&&(result=$display.data("result"));var html=makeResultHtml(result,"compilation","error",!0)+makeResultHtml(result,"evaluation","info",!1)+makeResultHtml(result,"execerror","error",!0)+makeResultHtml(result,"evaluationerror","error",!0);html||(html=makeResultHtml(result,"execution","error",!0)),$display[html?"show":"hide"](),$display.html(html)}return void 0!==VPLTerminal.VPLTerminal&&(VPLTerminal=VPLTerminal.VPLTerminal),{setup:function(questionId,vplId,userId,textareaName){var $textarea=$('textarea[name="'+textareaName+'"]'),$resetAndCorrectionButtons=$("#qvpl_reset_q"+questionId+", #qvpl_correction_q"+questionId);CodeEditors.setupQuestionEditor($textarea,$resetAndCorrectionButtons,$textarea.data("lineoffset")).done((function(){if("readonly"!=$textarea.attr("readonly")){var wrapperId="terminal_wrapper_q"+questionId,terminal=new VPLTerminal(wrapperId,wrapperId,str);$("#"+wrapperId).dialog("option","draggable",!1),terminal.setMessage=function(){};var qvplButtons="#qvpl_buttons_q"+questionId,$globalTerminalWrapper=$("#"+wrapperId).parent();$globalTerminalWrapper.insertAfter(qvplButtons);var oldConnect=terminal.connect;terminal.connect=function(){oldConnect.apply(terminal,arguments),$globalTerminalWrapper.css("top",0).css("left",0),$("body > .ui-widget-overlay.ui-front").first().remove()},$globalTerminalWrapper.find(".ui-dialog-titlebar-close").html('<i class="fa fa-close"></i>').addClass("btn btn-secondary close-terminal");var setupButton=function(action,icon,filestype){var $button=$(qvplButtons+' button[data-action="'+action+'"]'),$icon=$('<i class="fa fa-'+icon+' ml-2"></i>');$icon.appendTo($button);var reenableButtons=function(){$icon.addClass("fa-"+icon).removeClass("fa-refresh fa-spin"),$(".qvpl-buttons *").removeAttr("disabled")};$button.click((function(){$(".qvpl-buttons *").attr("disabled","disabled"),$(".close-terminal").trigger("click"),$icon.addClass("fa-refresh fa-spin").removeClass("fa-"+icon),VPLService.call("save",vplId,questionId,$textarea.val(),filestype).then((function(){return VPLService.call("exec",action,vplId,userId,terminal,(function(result){displayResult("vpl_result_q"+questionId,result),reenableButtons()}))})).fail((function(details){displayResult("vpl_result_q"+questionId,{execerror:details}),reenableButtons()}))}))};setupButton("run","rocket","run"),setupButton("debug","check-square-o","precheck"),setupButton("evaluate","check-square-o","precheck")}})),Templates.render("qtype_vplquestion/editorpreferencesform",{qid:questionId,installedthemes:JSON.parse(document.querySelector("[data-role=qvpl_installedthemes]").dataset.themes)}).done((function(formHTML){$.when(CodeEditors.getEditorPreferences(),ModalFactory.create({type:ModalFactory.types.SAVE_CANCEL,title:'<i class="fa fa-fw fa-cog icon"></i>'+M.util.get_string("editoroptions","qtype_vplquestion"),body:formHTML})).done((function(prefs,modal){modal.attachToDOM();var $fontSizeInput=modal.getBody().find('[name="vpl_fontsize'+questionId+'"]');$fontSizeInput.val(prefs.fontSize);var $aceThemeInput=modal.getBody().find('[name="vpl_editortheme'+questionId+'"]');$aceThemeInput.val(prefs.aceTheme);var prevFontSize=$fontSizeInput.val();$fontSizeInput.on("input",(function(){var newFontSize=Number($(this).val());isNaN(newFontSize)?$(this).val(prevFontSize):(newFontSize=Math.min(Math.max(newFontSize,1),48),$(this).val(newFontSize),prevFontSize=newFontSize,CodeEditors.changeFontSize(newFontSize))})),modal.getBody().find('[data-role="fontsizeincr"]').click((function(){$fontSizeInput.val(Number($fontSizeInput.val())+1),$fontSizeInput.trigger("input")})),modal.getBody().find('[data-role="fontsizedecr"]').click((function(){$fontSizeInput.val(Number($fontSizeInput.val())-1),$fontSizeInput.trigger("input")})),$aceThemeInput.on("change",(function(){CodeEditors.changeTheme($(this).val())})),modal.getRoot().on(ModalEvents.save,(function(){$fontSizeInput.data("save",$fontSizeInput.val()),$aceThemeInput.data("save",$aceThemeInput.val()),CodeEditors.saveEditorPreferences($aceThemeInput.val(),$fontSizeInput.val())})),modal.getRoot().on(ModalEvents.shown,(function(){$fontSizeInput.data("save",$fontSizeInput.val()),$aceThemeInput.data("save",$aceThemeInput.val())})),modal.getRoot().on(ModalEvents.hidden,(function(){$fontSizeInput.val($fontSizeInput.data("save")),$aceThemeInput.val($aceThemeInput.data("save")),CodeEditors.changeFontSize($fontSizeInput.val()),CodeEditors.changeTheme($aceThemeInput.val()),$('[name^="vpl_fontsize"]').val($fontSizeInput.val()),$('[name^="vpl_editortheme"]').val($aceThemeInput.val())})),$("#qvpl_editor_preferences"+questionId).css("visibility","visible").click((function(){modal.show()}))}))}))},displayResult:displayResult}}));

//# sourceMappingURL=studentanswer.min.js.map