/**
 * Provides utility methods to setup resizable ace editors into a page.
 * @copyright  Astor Bizard, 2019
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("qtype_vplquestion/codeeditors",["jquery","core/url","core/config"],(function($,url,cfg){var aceTheme,fontSize;function setupAceEditors($textareas,aceSize,aceLang){var aceEditor,prevY,$placeholderBeingResized=null;return void 0===aceLang&&(aceLang="plain_text"),$textareas.each((function(){var $textarea=$(this),$editorPlaceholder=$("<div>",{width:"100%",height:aceSize,id:"ace_placeholder_"+$textarea.attr("name"),class:"ace-placeholder"}).insertAfter($textarea);$textarea.hide(),$("<div>",{id:"ace_resize_"+$textarea.attr("name"),class:"ace-resize"}).insertAfter($editorPlaceholder).mousedown((function(event){prevY=event.clientY,$placeholderBeingResized=$editorPlaceholder,event.preventDefault()})),(aceEditor=ace.edit($editorPlaceholder[0])).setOptions({theme:"ace/theme/"+aceTheme,mode:"ace/mode/"+aceLang}),aceEditor.setFontSize(fontSize),aceEditor.$blockScrolling=1/0,aceEditor.getSession().setValue($textarea.val()),aceEditor.setReadOnly($textarea.is("[readonly]")),aceEditor.on("input",(function(){$textarea.val(ace.edit("ace_placeholder_"+$textarea.attr("name")).getValue())}))})),$(window).mousemove((function(event){$placeholderBeingResized&&($placeholderBeingResized.height((function(i,height){return height+event.clientY-prevY})),prevY=event.clientY,ace.edit($placeholderBeingResized[0]).resize(),event.preventDefault())})).mouseup((function(){$placeholderBeingResized=null})),aceEditor}function loadAce(){if("undefined"!=typeof ace&&void 0!==aceTheme)return $.Deferred().resolve();var ACESCRIPTLOCATION=url.relativeUrl("/mod/vpl/editor/ace9");return $.when($.ajax({url:ACESCRIPTLOCATION+"/ace.js",dataType:"script",cache:!0,success:function(){ace.config.set("basePath",ACESCRIPTLOCATION)}}),getEditorPreferences().then((function(prefs){return aceTheme=prefs.aceTheme,fontSize=prefs.fontSize,prefs})))}function getEditorPreferences(){return $.ajax({url:url.relativeUrl("/question/type/vplquestion/ajax/vplpreferences.json.php"),cache:!0}).promise().then((function(outcome){return{aceTheme:outcome.success?outcome.response.aceTheme:"chrome",fontSize:outcome.success?Number(outcome.response.fontSize):12}}))}return{setupFormEditors:function(){return loadAce().done((function(){setupAceEditors($('textarea[data-role="code-editor"]'),"170px")}))},setupQuestionEditor:function($textarea,$setTextButtons,lineOffset){return loadAce().done((function(){var aceEditor=setupAceEditors($textarea,"200px",$textarea.data("templatelang"));aceEditor.setOption("firstLineNumber",lineOffset),$setTextButtons.each((function(){var text=$(this).data("text");$(this).removeAttr("data-text"),$(this).click((function(event){aceEditor.getValue()!=text&&aceEditor.setValue(text),event.preventDefault()}))}))}))},getEditorPreferences:getEditorPreferences,saveEditorPreferences:function(aceTheme,fontSize){$.ajax({url:url.relativeUrl("/question/type/vplquestion/ajax/vplpreferences.json.php"),cache:!1,method:"POST",data:{set:{aceTheme:aceTheme,fontSize:Number(fontSize)},sesskey:cfg.sesskey}})},changeFontSize:function(newFontSize){$(".ace-placeholder").each((function(){ace.edit(this).setFontSize(Number(newFontSize))}))},changeTheme:function(newTheme){$(".ace-placeholder").each((function(){ace.edit(this).setOptions({theme:"ace/theme/"+newTheme})}))}}}));

//# sourceMappingURL=codeeditors.min.js.map