<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Web services declaration.
 * @package    mod_randomactivity
 * @copyright  2025 Astor Bizard
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$functions = [
        'mod_randomactivity_get_balanced_seed' => [
                'classname'    => 'mod_randomactivity\external\activity_pool_utility',
                'methodname'   => 'get_balanced_seed',
                'description'  => 'Get seed to balance users among activities',
                'type'         => 'read',
                'ajax'         => true,
                'capabilities' => 'mod/randomactivity:viewactivities',
                'services' => [
                        MOODLE_OFFICIAL_MOBILE_SERVICE,
                ],
        ],
        'mod_randomactivity_get_users_assignment' => [
                'classname'    => 'mod_randomactivity\external\activity_pool_utility',
                'methodname'   => 'get_users_assignment',
                'description'  => 'Get users assignment with given seed',
                'type'         => 'read',
                'ajax'         => true,
                'capabilities' => 'mod/randomactivity:manage',
                'services' => [
                        MOODLE_OFFICIAL_MOBILE_SERVICE,
                ],
        ],
];
