// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * AJAX calls for this component.
 * @copyright  2025 Astor Bizard
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

define(['core/ajax'], function(Ajax) {
    return {
        getBalancedSeed: function(id, nactivities, group) {
            return Ajax.call([{
                methodname: 'mod_randomactivity_get_balanced_seed',
                args: {
                    id,
                    nactivities,
                    group,
                },
            }])[0];
        },
        getUsersAssignment: function(id, activities, seed, group) {
            return Ajax.call([{
                methodname: 'mod_randomactivity_get_users_assignment',
                args: {
                    id,
                    activities,
                    seed,
                    group,
                },
            }])[0];
        },
    };
});
