/**
 * Provides utility methods to make a html table sortable by column.
 * @copyright  Astor Bizard, 2020
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("mod_randomactivity/sorttable",[],(function(){return{makeSortable:function(tableid){let nosortcols=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[],defaultsortcol=arguments.length>2?arguments[2]:void 0,nexcludedlines=arguments.length>3&&void 0!==arguments[3]?arguments[3]:0;var sortdirection;null===defaultsortcol&&(defaultsortcol=void 0);var tableBody=document.querySelector("#"+tableid+" tbody"),tableHead=document.querySelector("#"+tableid+" thead"),tableHeaders=tableHead.querySelectorAll("th"),sortArrows=[];tableHeaders.forEach((function(header,i){if(-1==nosortcols.indexOf(i)&&-1==nosortcols.indexOf(i-tableHeaders.length)){var sortArrow=document.createElement("i");sortArrow.classList.add("icon","fa","fa-fw"),header.append(sortArrow),sortArrows.push(sortArrow),header.style.cursor="pointer",header.style.userSelect="none",header.onclick=function(){if(sortArrow.dataset.active)sortdirection=-sortdirection,sortArrow.classList.toggle("fa-caret-up",1!=sortdirection),sortArrow.classList.toggle("fa-caret-down",1==sortdirection);else{var previouslyActiveArrow=tableHead.querySelector("th i[data-active]");previouslyActiveArrow&&(previouslyActiveArrow.classList.remove("fa-caret-down","fa-caret-up"),delete previouslyActiveArrow.dataset.active),sortArrow.classList.add("fa-caret-down"),sortArrow.dataset.active=!0,sortdirection=1}var rows=Array.from(tableBody.children),endrows=rows.splice(-nexcludedlines,nexcludedlines);rows.sort((function(a,b){var getCellValue=function(tr){var cell=tr.querySelector(".cell.c"+i);return cell.querySelector("[value]")?.getAttribute("value")||cell.innerText},v1=getCellValue(a),v2=getCellValue(b);return sortdirection*(isNaN(v1)||isNaN(v2)?v1.toString().localeCompare(v2):v1-v2)})).forEach((function(tr,index){var candidates=Array.from(tr.firstElementChild.querySelectorAll("*"));candidates.push(tr.firstElementChild),candidates.forEach((function(el){/^[0-9]+$/.test(el.innerHTML)&&(el.innerHTML=index+1)})),tableBody.append(tr)})),endrows.forEach((function(tr){tableBody.append(tr)}))}}})),tableHead.querySelectorAll("th a").forEach((function(link){link.onclick=function(e){e.stopPropagation()}})),sortArrows[defaultsortcol].click()}}}));

//# sourceMappingURL=sorttable.min.js.map