/**
 * Defines the behavior of the view page for a randomactivity.
 * @copyright  Astor Bizard, 2020
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("mod_randomactivity/activitiesform",["jquery","jqueryui","core/str","mod_randomactivity/orderabletable","mod_randomactivity/repository"],(function($,jqui,Str,OrderableTable,Repository){function updateActivities(table,activities){var tableBody=table.querySelector("tbody"),tablerows=tableBody.querySelectorAll("tr");if(tablerows.length>1)table.querySelector(".empty-row")?.remove();else if(0==tablerows.length){var ncols=table.querySelectorAll("thead th").length;tableBody.insertAdjacentHTML("beforeend",'<tr class="empty-row lastrow"><td colspan="'+ncols+'"></td></tr>')}var newactivities="";tableBody.querySelectorAll("tr:not(.empty-row)").forEach((function(tr,i){tr.querySelector("td:first-child").innerHTML=i+1,newactivities+=tr.dataset.cmid+" ",tr.classList.remove("lastrow")})),tablerows[tablerows.length-1].classList.add("lastrow"),activities.value=newactivities.trim()}return{setup:function(){var table=document.getElementById("randomactivity-activities-table"),form=document.getElementById("form-randomactivity-activities"),activities=form.querySelector("[name=activities]"),seed=form.querySelector("[name=seed]");updateActivities(table,activities),OrderableTable.makeOrderable(document.querySelectorAll('[data-role="activitytable"]'),(function(){updateActivities(table,activities),form.dispatchEvent(new CustomEvent("change"))})),document.querySelectorAll('[data-role="activitytable"] button[data-role="remove"]').forEach((function(button){button.onclick=function(){var tr=button.closest("tr");document.querySelector('.activity-to-add[data-cmid="'+tr.dataset.cmid+'"] tbody').append(tr),updateActivities(table,activities),form.dispatchEvent(new CustomEvent("change"))}}));var applyChangesButton=document.getElementById("apply-assign-button");applyChangesButton.setAttribute("disabled","disabled");var preventUnsavedChangesUnload=function(event){event.preventDefault(),event.returnValue=""},changed=!1;form.onchange=function(){applyChangesButton.removeAttribute("disabled"),changed||(changed=!0,window.addEventListener("beforeunload",preventUnsavedChangesUnload))},document.getElementById("cancel-button").onclick=function(){window.removeEventListener("beforeunload",preventUnsavedChangesUnload)};var popupDialogClasses={"ui-dialog":"popup-dialog bg-white p-3","ui-dialog-content":"my-3","ui-dialog-titlebar-close":"d-none","ui-dialog-buttonpane":"text-right"};!async function(){var $confirmReassignDialog=$("#confirm-reassign").dialog({autoOpen:!1,classes:popupDialogClasses,title:await Str.get_string("confirm","moodle"),modal:!0,buttons:[{text:await Str.get_string("confirm","moodle"),class:"btn btn-primary mx-1",click:function(){window.removeEventListener("beforeunload",preventUnsavedChangesUnload),form.submit()}},{text:await Str.get_string("cancel","moodle"),class:"btn btn-secondary mx-1",click:function(){$(this).dialog("close")}}],open:function(){document.querySelector(":focus").blur()}});applyChangesButton.onclick=function(){$confirmReassignDialog.dialog("open")}}(),document.getElementById("seed-timestamp").onclick=function(event){event.preventDefault(),seed.value=(new Date).getTime(),form.dispatchEvent(new CustomEvent("change"))},document.getElementById("seed-balance").onclick=async function(event){event.preventDefault();var load=document.querySelector(".load-icon");load.style.display="",seed.setAttribute("disabled","disabled");var id=form.querySelector("[name=id]").value,group=form.querySelector("[name=group]").value,nactivities=""!=activities.value?activities.value.split(" ").length:0;seed.value=await Repository.getBalancedSeed(id,nactivities,group),form.dispatchEvent(new CustomEvent("change")),seed.removeAttribute("disabled"),load.style.display="none"},document.querySelector('[data-role="refresh-assignees"]').onclick=async function(){document.querySelector(":focus").blur();var id=form.querySelector("[name=id]").value,group=form.querySelector("[name=group]").value,assignees=await Repository.getUsersAssignment(id,activities.value,seed.value,group);table.querySelectorAll("tbody tr td:nth-child(3)").forEach((function(cell,i){cell.innerHTML=assignees[i]}))};var filters={selector:document.querySelector(".activity-type-selector"),dropdown:document.querySelector(".activity-type-dropdown"),selectedvalue:document.querySelector(".activity-type-selected span"),search:document.getElementById("activity-search")},activitiesList=document.querySelector(".activities-to-add-list"),sections=activitiesList.querySelectorAll(".list-section"),applyActivitiesChoiceFilters=function(){var type=filters.selectedvalue.dataset.cmtype,name=filters.search.value,currentActivities=activities.value.split(" "),noSectionToShow=!0;sections.forEach((function(section){var noActivityToAddInSection=!0,isExpanded=section.classList.contains("expanded");section.querySelectorAll(".activity-to-add").forEach((function(activity){var cmid=activity.dataset.cmid,cmtype=activity.dataset.cmtype,cmname=activity.querySelector("label").innerText,isFilteredIn=(!type||cmtype==type)&&!currentActivities.includes(cmid+"")&&(""===name||cmname.toLowerCase().includes(name.toLowerCase()));activity.toggleAttribute("hidden",!isFilteredIn||!isExpanded),activity.toggleAttribute("aria-hidden",!isFilteredIn||!isExpanded),noActivityToAddInSection=noActivityToAddInSection&&!isFilteredIn})),section.toggleAttribute("hidden",noActivityToAddInSection),section.toggleAttribute("aria-hidden",noActivityToAddInSection),noSectionToShow=noSectionToShow&&noActivityToAddInSection})),document.getElementById("no-activity-to-add-message").toggleAttribute("hidden",!noSectionToShow),document.getElementById("no-activity-to-add-message").toggleAttribute("aria-hidden",!noSectionToShow)};!async function(){var $addActivitiesDialog=$("#activities-choice").dialog({autoOpen:!1,classes:popupDialogClasses,title:await Str.get_string("addactivities","mod_randomactivity"),modal:!0,buttons:[{text:await Str.get_string("addselectedactivities","mod_randomactivity"),class:"btn btn-primary mx-1",click:function(){document.querySelectorAll(".activity-to-add").forEach((function(activity){activity.querySelector('input[type="checkbox"]').checked&&table.querySelector("tbody").append(activity.querySelector("tr"))})),$(this).dialog("close"),updateActivities(table,activities),form.dispatchEvent(new CustomEvent("change"))}},{text:await Str.get_string("cancel","moodle"),class:"btn btn-secondary mx-1",click:function(){$(this).dialog("close")}}],open:function(){document.querySelector(":focus").blur(),activitiesList.querySelectorAll('.activity-to-add input[type="checkbox"]').forEach((function(checkbox){checkbox.checked=!1})),sections.forEach((function(section){section.classList.add("expanded")})),activitiesList.scrollTop=0,filters.selectedvalue.innerHTML=document.querySelector(".activity-type").innerHTML,filters.selectedvalue.dataset.cmtype="",filters.selector.classList.remove("expanded"),filters.selector.classList.add("collapsed"),filters.selector.style.width="",filters.dropdown.style.width="",filters.search.value="",updateSearchBar(),applyActivitiesChoiceFilters()}});document.getElementById("add-activities").onclick=function(){$addActivitiesDialog.dialog("open")}}();var toggleDropdownMenu=function(){var newDropdownWidth;if(filters.selector.classList.toggle("collapsed"),filters.selector.classList.toggle("expanded"),filters.selector.classList.contains("expanded")){var dropdownwidth=2*filters.dropdown.offsetWidth-filters.dropdown.clientWidth;newDropdownWidth=Math.max(dropdownwidth,filters.selector.offsetWidth)+"px"}else newDropdownWidth="";filters.selector.style.width=newDropdownWidth,filters.dropdown.style.width=newDropdownWidth};filters.selector.onclick=toggleDropdownMenu,filters.dropdown.onclick=toggleDropdownMenu,document.querySelectorAll(".activity-type").forEach((function(activityType){activityType.onclick=function(){filters.selectedvalue.innerHTML=activityType.innerHTML,filters.selectedvalue.dataset.cmtype=activityType.dataset.cmtype,applyActivitiesChoiceFilters()}}));var updateSearchBar=function(){filters.search.classList.toggle("empty",""===filters.search.value),applyActivitiesChoiceFilters()};filters.search.onkeyup=updateSearchBar,document.querySelector(".search-remove").onclick=function(){filters.search.value="",updateSearchBar()},document.querySelector(".search-icon").onclick=function(){filters.search.focus()},activitiesList.querySelectorAll(".list-section .toggle-all button").forEach((function(toggleButton){toggleButton.onclick=function(e){e.stopImmediatePropagation(),toggleButton.closest(".list-section").querySelectorAll('.activity-to-add:not([hidden]) input[type="checkbox"]').forEach((function(checkbox){checkbox.checked="select"==toggleButton.dataset.action}))}})),activitiesList.querySelectorAll(".section-header").forEach((function(header){header.onclick=function(){header.closest(".list-section").classList.toggle("expanded"),applyActivitiesChoiceFilters()}}))}}}));

//# sourceMappingURL=activitiesform.min.js.map