<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * this file contains the user selector for already excluded users
 *
 * File         current.php
 * Encoding     UTF-8
 *
 * @package     tool_usersuspension
 *
 * @copyright   Sebsoft.nl
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace tool_usersuspension\exclude\user\selector;

defined('MOODLE_INTERNAL') || die;

require_once($CFG->dirroot . '/user/selector/lib.php');

/**
 * tool_usersuspension\exclude\user\selector\current
 *
 * @package     tool_usersuspension
 *
 * @copyright   Sebsoft.nl
 * @author      RvD <helpdesk@sebsoft.nl>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class current extends \user_selector_base {
    /**
     * Candidate users
     * @param string $search
     * @return array
     */
    public function find_users($search) {
        global $DB;

        $excludeids = \tool_usersuspension\util::get_user_exclusion_list();
        if (empty($excludeids)) {
            return [];
        }

        // By default wherecondition retrieves all users except the deleted, not confirmed and guest.
        [$wherecondition, $params] = $this->search_sql($search, 'u');

        $fields = 'SELECT ' . $this->required_fields_sql('u');
        $countfields = 'SELECT COUNT(1)';

        [$insql, $uparams] = $DB->get_in_or_equal($excludeids, SQL_PARAMS_NAMED, 'exclude', true, 0);
        $params = array_merge($params, $uparams);

        $sql = " FROM {user} u WHERE {$wherecondition} AND u.id {$insql}";

        [$sort, $sortparams] = users_order_by_sql('u', $search, $this->accesscontext);
        $order = ' ORDER BY ' . $sort;

        if (!$this->is_validating()) {
            $counter = $DB->count_records_sql($countfields . $sql, $params);
            if ($counter > $this->maxusersperpage) {
                return $this->too_many_results($search, $counter);
            }
        }

        $availableusers = $DB->get_records_sql($fields . $sql . $order, array_merge($params, $sortparams));

        if (empty($availableusers)) {
            return [];
        }

        return [$availableusers];
    }

    /**
     * Return the options to recreate this selector
     *
     * @return array
     */
    protected function get_options() {
        $options = parent::get_options();
        return $options;
    }
}
