<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Indonesian language strings for Tutor-IA plugin.
 *
 * @package    local_dttutor
 * @copyright  2025 Datacurso
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accepted_files_pdf_only'] = 'Hanya file PDF yang diterima';
$string['avatar'] = 'Avatar Tutor-IA';
$string['avatar_desc'] = 'Pilih avatar yang akan ditampilkan pada tombol chat mengambang Tutor-IA. Jika tidak ada yang dipilih atau file tidak ada, Avatar 1 akan digunakan secara default.';
$string['avatar_position'] = 'Posisi avatar';
$string['avatar_position_desc'] = 'Konfigurasikan di mana tombol avatar mengambang Tutor-IA akan ditampilkan. Pilih posisi sudut yang telah ditentukan atau sesuaikan koordinat X,Y yang tepat. Pratinjau langsung menunjukkan bagaimana tampilannya.';
$string['cachedef_sessions'] = 'Cache untuk sesi chat Tutor-IA';
$string['cancel_indexing'] = 'Batal';
$string['char'] = 'karakter';
$string['chars'] = 'karakter';
$string['choose_files'] = 'Pilih file';
$string['clear_selection'] = 'Hapus pilihan';
$string['close'] = 'Tutup Tutor IA';
$string['configuration_error'] = 'Kesalahan konfigurasi';
$string['configure_now'] = 'Konfigurasi sekarang';
$string['connection_interrupted'] = '[Koneksi terputus]';
$string['course_custom_prompt'] = 'Prompt Kustom Khusus Kursus';
$string['course_custom_prompt_help'] = 'Prompt kustom ini menggantikan pengaturan global hanya untuk kursus ini. Biarkan kosong untuk menggunakan prompt global.';
$string['course_indexing'] = 'Sinkronisasi Kursus';
$string['course_materials'] = 'Materi Kursus (PDF)';
$string['course_materials_help'] = 'Unggah file PDF tambahan yang harus dirujuk oleh tutor AI saat menjawab pertanyaan.';
$string['custom_prompt'] = 'Prompt khusus';
$string['custom_prompt_desc'] = 'Instruksi khusus untuk mengontrol perilaku tutor AI. Gunakan bidang ini untuk memberikan pedoman spesifik, nada, atau batasan pengetahuan untuk tutor.';
$string['customavatar'] = 'Avatar khusus';
$string['customavatar_desc'] = 'Unggah gambar avatar khusus Anda sendiri. Ini akan menggantikan avatar yang telah dipilih sebelumnya.';
$string['customavatar_dimensions'] = 'Dimensi yang direkomendasikan: 200x200 piksel. Format yang didukung: PNG, JPG, JPEG, SVG. Ukuran file maksimum: 512KB.';
$string['drag_drop_upload'] = 'Seret & Jatuhkan file PDF di sini';
$string['drag_drop_upload_or_browse'] = 'atau klik untuk menjelajah';
$string['drawer_side'] = 'Sisi pembukaan laci';
$string['drawer_side_help'] = 'Pilih dari sisi mana laci chat akan dibuka. Ini independen dari posisi tombol avatar.';
$string['drawer_side_left'] = 'Buka dari kiri';
$string['drawer_side_right'] = 'Buka dari kanan';
$string['dttutor:use'] = 'Gunakan Tutor-IA';
$string['enable_tutor_for_course'] = 'Aktifkan Tutor AI untuk kursus ini';
$string['enable_tutor_for_course_help'] = 'Ketika diaktifkan, Tutor AI akan tersedia untuk siswa dan guru di kursus ini. Pengaturan plugin global juga harus diaktifkan.';
$string['enabled'] = 'Aktifkan Chat';
$string['enabled_desc'] = 'Aktifkan atau nonaktifkan chat Tutor-IA secara global';
$string['error_api_not_configured'] = 'Konfigurasi API tidak ada. Silakan periksa pengaturan Anda.';
$string['error_api_request_failed'] = 'Kesalahan permintaan API: {$a}';
$string['error_attempt_later'] = 'Terjadi kesalahan. Silakan coba lagi nanti.';
$string['error_cache_unavailable'] = 'Layanan chat sementara tidak tersedia. Silakan coba refresh halaman.';
$string['error_empty_message'] = 'Pesan tidak boleh kosong';
$string['error_establish_sse_connection'] = '[Kesalahan] Tidak dapat membuat koneksi SSE';
$string['error_http_code'] = 'Kesalahan HTTP {$a}';
$string['error_insufficient_tokens'] = 'Tidak ada cukup kredit AI yang tersedia untuk memproses permintaan Anda. Silakan hubungi administrator untuk menambahkan lebih banyak kredit agar dapat melanjutkan penggunaan Tutor AI.';
$string['error_insufficient_tokens_short'] = 'Kredit Tidak Mencukupi';
$string['error_internal'] = 'Kesalahan internal: {$a}';
$string['error_invalid_api_response'] = 'Respons API tidak valid';
$string['error_invalid_coordinates'] = 'Koordinat tidak valid. Silakan gunakan nilai CSS yang valid (mis: 10px, 2rem, 50%)';
$string['error_invalid_message'] = 'Silakan masukkan pesan yang valid';
$string['error_invalid_position'] = 'Data posisi tidak valid';
$string['error_license_fallback'] = 'Kesalahan lisensi: {$a}';
$string['error_license_fallback_short'] = 'Kesalahan Lisensi';
$string['error_license_not_allowed'] = 'Lisensi situs Anda tidak mengizinkan akses ke layanan Tutor AI. Silakan hubungi administrator untuk memverifikasi status lisensi atau meningkatkan paket Anda.';
$string['error_license_not_allowed_short'] = 'Kesalahan Lisensi';
$string['error_message_too_long'] = '[Kesalahan] Pesan terlalu panjang. Maksimum 4000 karakter.';
$string['error_metadata_too_large'] = 'Metadata yang dikirim dengan pesan Anda terlalu besar. Silakan coba lagi.';
$string['error_no_credits'] = 'Kredit AI tidak mencukupi.';
$string['error_no_credits_fallback'] = 'Kredit tidak mencukupi: {$a}';
$string['error_no_credits_short'] = 'Tidak Ada Kredit Tersedia';
$string['error_selected_text_too_large'] = 'Teks yang dipilih terlalu besar. Silakan pilih bagian yang lebih kecil.';
$string['error_unexpected'] = 'Terjadi kesalahan yang tidak terduga. Silakan coba lagi.';
$string['error_unknown'] = 'Terjadi kesalahan yang tidak diketahui. Silakan coba lagi.';
$string['error_webservice_not_configured'] = 'Chat Tutor AI tidak dikonfigurasi dengan benar dan saat ini tidak tersedia.';
$string['error_webservice_not_configured_action'] = 'Silakan hubungi administrator situs atau laporkan masalah ini untuk mengaktifkan layanan chat.';
$string['error_webservice_not_configured_admin'] = 'Webservice Penyedia AI Datacurso perlu dikonfigurasi sebelum menggunakan Tutor AI. <a href="{$a}" target="_blank">Klik di sini untuk mengkonfigurasinya sekarang</a>.';
$string['error_webservice_not_configured_admin_inline'] = 'Webservice Penyedia AI Datacurso perlu dikonfigurasi sebelum menggunakan Tutor AI.';
$string['error_webservice_not_configured_short'] = 'Layanan Chat Tidak Tersedia';
$string['indexing_cancelled'] = 'Dibatalkan';
$string['indexing_completed'] = 'Disinkronkan';
$string['indexing_failed'] = 'Sinkronisasi gagal';
$string['indexing_interrupted'] = 'Terputus';
$string['indexing_not_indexed'] = 'Belum disinkronkan';
$string['indexing_phase_estimating'] = 'Memperkirakan token...';
$string['indexing_phase_fetching'] = 'Mengambil data kursus...';
$string['indexing_phase_finalizing'] = 'Menyelesaikan...';
$string['indexing_phase_initializing'] = 'Menginisialisasi...';
$string['indexing_phase_preparing'] = 'Menyiapkan dokumen...';
$string['indexing_phase_uploading'] = 'Mengunggah dokumen...';
$string['indexing_progress'] = 'Progres: {$a}%';
$string['indexing_running'] = 'Sinkronisasi sedang berlangsung';
$string['indexing_status'] = 'Status Sinkronisasi';
$string['last_indexed'] = 'Terakhir disinkronkan: {$a}';
$string['line'] = 'baris';
$string['lines'] = 'baris';
$string['loading'] = 'Memuat...';
$string['manage_tutor'] = 'Manajemen Tutor AI';
$string['material_deleted'] = 'Material berhasil dihapus';
$string['material_uploaded'] = 'Material berhasil diunggah';
$string['off_topic_detection_enabled'] = 'Aktifkan deteksi topik di luar konteks';
$string['off_topic_detection_enabled_desc'] = 'Saat diaktifkan, tutor AI akan mendeteksi dan merespons pesan di luar konteks sesuai dengan tingkat keketatan yang dikonfigurasi di bawah.';
$string['off_topic_strictness'] = 'Keketatan deteksi di luar konteks';
$string['off_topic_strictness_desc'] = 'Kontrol seberapa ketat deteksi topik di luar konteks. Permisif memungkinkan lebih banyak fleksibilitas, sedangkan ketat memberlakukan percakapan yang hanya terkait dengan kursus.';
$string['off_topic_strictness_moderate'] = 'Moderat';
$string['off_topic_strictness_permissive'] = 'Permisif';
$string['off_topic_strictness_strict'] = 'Ketat';
$string['open'] = 'Buka Tutor IA';
$string['or_click_to_browse'] = 'atau klik untuk menjelajah';
$string['pluginname'] = 'Tutor IA';
$string['position_custom'] = 'Posisi khusus';
$string['position_left'] = 'Sudut kiri bawah';
$string['position_preset'] = 'Posisi yang telah ditentukan';
$string['position_right'] = 'Sudut kanan bawah';
$string['position_x'] = 'Posisi horizontal (X)';
$string['position_x_help'] = 'Jarak dari tepi kiri. Contoh: 2rem, 20px, 5%. Gunakan nilai negatif untuk memposisikan dari tepi kanan.';
$string['position_x_label'] = 'X: {$a->value} (dari {$a->ref})';
$string['position_y'] = 'Posisi vertikal (Y)';
$string['position_y_help'] = 'Jarak dari tepi bawah. Contoh: 6rem, 80px, 10%. Gunakan nilai negatif untuk memposisikan dari tepi atas.';
$string['position_y_label'] = 'Y: {$a->value} (dari {$a->ref})';
$string['positiondisplay_corner'] = 'Posisi: sudut {$a->preset} | Laci: {$a->drawer}';
$string['positiondisplay_custom'] = 'Posisi: X: {$a->x}, Y: {$a->y} | Laci: {$a->drawer}';
$string['preview'] = 'Pratinjau Langsung';
$string['ref_bottom'] = 'Bawah';
$string['ref_left'] = 'Kiri';
$string['ref_right'] = 'Kanan';
$string['ref_top'] = 'Atas';
$string['reference_edge_x'] = 'Tepi referensi horizontal';
$string['reference_edge_y'] = 'Tepi referensi vertikal';
$string['restart_indexing'] = 'Sinkronkan Ulang Kursus';
$string['selected'] = 'dipilih';
$string['selection_indicator'] = '{$a} baris dipilih';
$string['selectionformat'] = '{$a->lines} {$a->linetext}, {$a->chars} {$a->chartext} dipilih';
$string['sendmessage'] = 'Kirim pesan';
$string['sessionnotready'] = 'Sesi Tutor-IA belum siap. Silakan coba lagi.';
$string['start_indexing'] = 'Mulai Sinkronisasi';
$string['student'] = 'Siswa';
$string['teacher'] = 'Guru';
$string['tutor_disabled_notice'] = 'Tutor AI saat ini dinonaktifkan untuk kursus ini. Siswa tidak akan melihat antarmuka chat.';
$string['tutor_status'] = 'Status Tutor AI';
$string['tutorcustomization'] = 'Kustomisasi Tutor';
$string['tutorname_default'] = 'Tutor AI';
$string['tutorname_setting'] = 'Nama tutor';
$string['tutorname_setting_desc'] = 'Konfigurasikan nama yang akan ditampilkan di header chat. Anda dapat menggunakan {teachername} untuk menampilkan nama guru sebenarnya dari kursus, atau memasukkan nama khusus. Contoh: "{teachername}" akan menampilkan "Budi Santoso", "Asisten AI" akan menampilkan "Asisten AI".';
$string['typemessage'] = 'Ketik pesan Anda...';
$string['unauthorized'] = 'Akses tidak sah';
$string['upload_files'] = 'Unggah file';
$string['upload_material'] = 'Unggah material';
$string['welcomemessage'] = 'Halo! Saya adalah asisten AI Anda. Bagaimana saya dapat membantu Anda hari ini?';
$string['welcomemessage_default'] = 'Halo! Saya {teachername}, asisten AI Anda. Bagaimana saya dapat membantu Anda hari ini?';
$string['welcomemessage_setting'] = 'Pesan selamat datang';
$string['welcomemessage_setting_desc'] = 'Sesuaikan pesan selamat datang yang ditampilkan saat membuka chat. Anda dapat menggunakan placeholder: {teachername}, {coursename}, {username}, {firstname}';
$string['yesterday'] = 'Kemarin';
