/**
 * Indexing progress management with full backend API integration
 *
 * @module     local_dttutor/indexing_progress
 * @copyright  2025 Datacurso
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("local_dttutor/indexing_progress",["jquery","core/ajax","core/notification","core/str"],(function($,Ajax,Notification,Str){var IndexingProgress=function(courseid,initialStatus,initialTaskId){this.courseid=courseid,this.taskId=initialTaskId||null,this.initialStatus=initialStatus||"not_indexed",this.pollInterval=null,this.retries=0,this.maxRetries=3,this.isPolling=!1};return IndexingProgress.prototype.init=function(){this.attachEventHandlers(),"running"===this.initialStatus&&this.taskId?(window.console.log("Page loaded with running status, starting polling for task:",this.taskId),this.showProgressUI(),this.startPolling()):this.checkForStoredTask(),this.setupBeforeUnload()},IndexingProgress.prototype.attachEventHandlers=function(){var self=this;$('[data-action="start-indexing"]').on("click",(function(e){e.preventDefault(),self.checkStatusBeforeStart()})),$('[data-action="cancel-indexing"]').on("click",(function(e){e.preventDefault();var taskid=$(this).data("taskid");!taskid&&self.taskId&&(taskid=self.taskId),self.cancelIndexing(taskid)}))},IndexingProgress.prototype.checkForStoredTask=function(){var storedTaskId=this.getStoredTaskId();storedTaskId&&(this.taskId=storedTaskId,this.checkTaskStatus())},IndexingProgress.prototype.setupBeforeUnload=function(){var self=this;window.addEventListener("beforeunload",(function(event){if(self.isPolling&&self.taskId){var message="Indexing will continue in the background. You can safely close this page.";return event.returnValue=message,message}}))},IndexingProgress.prototype.checkStatusBeforeStart=function(){var self=this,forcereindex="completed"===this.initialStatus;Ajax.call([{methodname:"local_dttutor_get_indexing_status",args:{courseid:this.courseid}}])[0].done((function(data){self.initialStatus=data.status,"completed"===data.status?self.startIndexing(!0):"running"===data.status&&data.task_id?(self.taskId=data.task_id,self.saveTaskId(data.task_id),self.showProgressUI(),self.startPolling()):self.startIndexing(forcereindex)})).fail((function(){self.startIndexing(forcereindex)}))},IndexingProgress.prototype.checkTaskStatus=function(){var self=this;Ajax.call([{methodname:"local_dttutor_get_indexing_progress",args:{task_id:this.taskId,courseid:this.courseid}}])[0].done((function(data){"running"===data.status||"pending"===data.status?(self.showProgressUI(),self.startPolling()):(data.status,self.clearStoredTaskId())})).fail((function(){self.clearStoredTaskId()}))},IndexingProgress.prototype.startIndexing=function(forcereindex){var self=this;forcereindex=forcereindex||!1,window.console.log("Starting indexing with force_reindex:",forcereindex),Ajax.call([{methodname:"local_dttutor_start_indexing",args:{courseid:this.courseid,force_reindex:forcereindex}}])[0].done((function(response){response.success&&response.task_id?(self.taskId=response.task_id,self.saveTaskId(response.task_id),self.showProgressUI(),self.startPolling()):response.message&&(Notification.addNotification({message:response.message,type:"info"}),"already_indexed"===response.status&&setTimeout((function(){window.location.reload()}),2e3))})).fail(Notification.exception)},IndexingProgress.prototype.startPolling=function(){var self=this;this.isPolling=!0;var poll=function(){self.pollProgress()};this.pollInterval=setInterval(poll,2e3),poll()},IndexingProgress.prototype.pollProgress=function(){var self=this;Ajax.call([{methodname:"local_dttutor_get_indexing_progress",args:{task_id:this.taskId,courseid:this.courseid}}])[0].done((function(data){switch(self.retries=0,self.updateProgressUI(data),data.status){case"pending":$('[data-region="indexing-phase-name"]').text("Starting...");break;case"running":default:break;case"completed":self.stopPolling(),self.clearStoredTaskId(),self.showSuccess();break;case"failed":self.stopPolling(),self.clearStoredTaskId(),self.showError(data.error||"Indexing failed");break;case"cancelled":self.stopPolling(),self.clearStoredTaskId(),self.showCancelled();break;case"interrupted":self.stopPolling(),self.clearStoredTaskId(),self.showInterrupted()}})).fail((function(error){self.handlePollError(error)}))},IndexingProgress.prototype.handlePollError=function(error){var self=this;if(window.console.warn("Polling error:",error),this.retries++,this.retries>=this.maxRetries)this.stopPolling(),Notification.addNotification({message:"Connection error. Please refresh the page.",type:"error"});else{var delay=2e3*Math.pow(2,this.retries-1);this.stopPolling(),setTimeout((function(){self.taskId&&self.startPolling()}),delay)}},IndexingProgress.prototype.updateProgressUI=function(data){var percent=data.overall_percent||0;if($('[data-region="indexing-progress-bar"]').css("width",percent+"%"),$('[data-region="indexing-progress-bar"]').attr("aria-valuenow",percent),$('[data-region="indexing-progress-percent"]').text(Math.round(percent)+"%"),data.current_phase&&$('[data-region="indexing-phase-name"]').text(data.current_phase),data.phase_details&&$('[data-region="indexing-phase-details"]').text(data.phase_details).show(),data.items_total&&data.items_total>0){var itemsText=data.items_processed+" / "+data.items_total+" items";$('[data-region="indexing-items"]').text(itemsText).show()}},IndexingProgress.prototype.stopPolling=function(){this.pollInterval&&(clearInterval(this.pollInterval),this.pollInterval=null),this.isPolling=!1},IndexingProgress.prototype.showProgressUI=function(){$('[data-region="indexing-progress-container"]').show(),$('[data-region="indexing-phase-info"]').show(),$('[data-action="cancel-indexing"]').show(),$('[data-action="start-indexing"]').hide()},IndexingProgress.prototype.hideProgressUI=function(){$('[data-region="indexing-progress-container"]').hide(),$('[data-region="indexing-phase-info"]').hide(),$('[data-action="cancel-indexing"]').hide(),$('[data-action="start-indexing"]').show()},IndexingProgress.prototype.showSuccess=function(){this.hideProgressUI(),Str.get_string("indexing_completed","local_dttutor").then((function(str){Notification.addNotification({message:str,type:"success"})})).catch((function(){Notification.addNotification({message:"Indexing completed successfully",type:"success"})})),setTimeout((function(){window.location.reload()}),2e3)},IndexingProgress.prototype.showError=function(error){this.hideProgressUI(),Notification.addNotification({message:error||"Indexing failed",type:"error"}),setTimeout((function(){window.location.reload()}),3e3)},IndexingProgress.prototype.showCancelled=function(){this.hideProgressUI(),Str.get_string("indexing_cancelled","local_dttutor").then((function(str){Notification.addNotification({message:str,type:"info"})})).catch((function(){Notification.addNotification({message:"Indexing was cancelled",type:"info"})})),setTimeout((function(){window.location.reload()}),2e3)},IndexingProgress.prototype.showInterrupted=function(){this.hideProgressUI(),Str.get_string("indexing_interrupted","local_dttutor").then((function(str){Notification.addNotification({message:str,type:"warning"})})).catch((function(){Notification.addNotification({message:"Indexing was interrupted. Please try again.",type:"warning"})})),setTimeout((function(){window.location.reload()}),3e3)},IndexingProgress.prototype.cancelIndexing=function(taskid){var self=this;taskid&&Ajax.call([{methodname:"local_dttutor_cancel_indexing",args:{task_id:taskid,courseid:this.courseid}}])[0].done((function(response){response.success&&(self.stopPolling(),self.clearStoredTaskId(),self.showCancelled())})).fail(Notification.exception)},IndexingProgress.prototype.saveTaskId=function(taskId){try{localStorage.setItem("local_dttutor_indexing_task_"+this.courseid,taskId)}catch(e){}},IndexingProgress.prototype.getStoredTaskId=function(){try{return localStorage.getItem("local_dttutor_indexing_task_"+this.courseid)}catch(e){return null}},IndexingProgress.prototype.clearStoredTaskId=function(){try{localStorage.removeItem("local_dttutor_indexing_task_"+this.courseid)}catch(e){}},{init:function(courseid,initialStatus,initialTaskId){new IndexingProgress(courseid,initialStatus,initialTaskId).init()}}}));

//# sourceMappingURL=indexing_progress.min.js.map