<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Plugin strings are defined here.
 *
 * @package     mod_plugnmeet
 * @category    string
 * @author     Jibon L. Costa <jibon@mynaparrot.com>
 * @copyright  2022 MynaParrot
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['choosereadme'] = 'Readme при виборі теми.';
$string['missingidandcmid'] = 'Відсутній id та cmid';
$string['modulename'] = 'plugNmeet';
$string['modulename_help'] = 'Використовуйте модуль plugNmeet для...';
$string['modulenameplural'] = 'plugNmeets';
$string['newmodulename'] = 'ім\'я plugNmeet';
$string['newmodulename_help'] = 'Це вміст підказки довідки, пов\'язаної з полем plugNmeet';
$string['newmodulesettings'] = 'Параметри';
$string['nonewmodules'] = 'Немає plugNmeet';
$string['pluginadministration'] = 'Адміністрація plugNmeet';
$string['pluginname'] = 'plugNmeet';
$string['pluginname_help'] = 'Текст довідки при додаванні цього типу питання.';
$string['pluginnameadding'] = 'Відображається при додаванні цього типу питання.';
$string['pluginnameediting'] = 'Відображається при редагуванні цього типу питання.';
$string['pluginnamesummary'] = 'Відображається при виборі типу питання, який потрібно додати.';
$string['plugnmeet:access'] = 'Доступ до контенту';
$string['plugnmeet:addinstance'] = 'Як додати нову активність plugNmeet';
$string['plugnmeet:edit'] = 'Редагувати plugNmeet';
$string['plugnmeet:enrol'] = 'Реєстрація користувачів';
$string['plugnmeet:manage'] = 'Керування користувачами';
$string['plugnmeet:unenrol'] = 'Скасування реєстрації користувачів';
$string['plugnmeet:upload'] = 'Завантажити контент';
$string['plugnmeet:useeditor'] = 'Редагувати контент';
$string['plugnmeet:view'] = 'Переглянути plugNmeet';
$string['privacy:metadata:plugnmeet'] = 'Щоб інтегруватися з віддаленим сервером plugnmeet, потрібно обмінюватися даними користувача з цим сервером.';
$string['privacy:metadata:plugnmeet:userid'] = 'Userid надсилається з Moodle, щоб ви могли отримати доступ до ваших даних на віддаленій системі.';
$string['privacy:metadata:plugnmeet:fullname'] = 'Ваше повне ім\'я надсилається до віддаленої системи для кращої взаємодії з користувачем.';

$string['view'] = 'Вид';
$string['yes'] = 'Так';
$string['no'] = 'Ні';
$string['join'] = 'Приєднатися до';
$string['plugnmeetname'] = 'plugNmeet';
$string['plugnmeetname_help'] = 'Допомога';
$string['plugnmeet_viewed'] = 'Перегляд активності plugNmeet';
$string['joined_session'] = 'Приєднана сесія';

$string['plugnmeetconfig'] = 'Конфігурація plugNmeet';
$string['plugnmeet_server_url'] = 'URL-адреса сервера Plugnmeet';
$string['plugnmeet_server_url_des'] = 'Введіть URL-адресу сервера plugNmeet';
$string['plugnmeet_api_key'] = 'Ключ API plugnmeet';
$string['plugnmeet_api_key_des'] = 'Введіть ключ API plugnmeet';
$string['plugnmeet_secret'] = 'Секрет плагіна';
$string['plugnmeet_secret_des'] = 'Введіть plugnmeet Secret';
$string['livekit_server_url'] = 'URL-адреса сервера Livekit';
$string['livekit_server_url_des'] = 'Введіть URL-адресу сервера Livekit';
$string['custom_logo'] = 'Логотип на замовлення';
$string['custom_logo_des'] = 'Логотип на замовлення для конференц-залу';

$string['plugnmeetoptions'] = 'Параметри plugNmeet';
$string['enable_dynacast'] = 'Увімкніть динамаст';
$string['enable_dynacast_des'] = 'Увімкніть динамаст';
$string['enable_simulcast'] = 'Увімкнути одночасну трансляцію';
$string['enable_simulcast_des'] = 'Увімкнути одночасну трансляцію';
$string['stop_mic_track_on_mute'] = 'Зупинка мікрофонної доріжки в режимі вимкнення звуку';
$string['stop_mic_track_on_mute_des'] = 'Зупинка мікрофонної доріжки в режимі вимкнення звуку';
$string['video_codec'] = 'Відеокодек';
$string['video_codec_des'] = 'Відеокодек';
$string['default_webcam_resolution'] = 'Роздільна здатність веб-камери за замовчуванням';
$string['default_webcam_resolution_des'] = 'Роздільна здатність веб-камери за замовчуванням';
$string['default_screen_share_resolution'] = 'Роздільна здатність спільного доступу до екрана за замовчуванням';
$string['default_screen_share_resolution_des'] = 'Роздільна здатність спільного доступу до екрана за замовчуванням';
$string['default_audio_preset'] = 'Стиль звуку';
$string['default_audio_preset_des'] = 'Аудіо пресет для мікрофона';
$string['copyright_display'] = 'Увімкнути відображення авторських прав';
$string['copyright_display_des'] = 'Якщо увімкнено, то відображатиметься текст нижче';
$string['copyright_text'] = 'Авторські права на текст';
$string['copyright_text_des'] = 'Цей текст може бути встановлений, якщо конфігурація сервера дозволяє перевизначити';

$string['roomtitle'] = 'Назва кімнати';
$string['welcome_message'] = 'Вітальне повідомлення';
$string['max_participants'] = 'Максимальна кількість учасників (0 = необмежена)';

$string['room_features'] = 'Особливості приміщення';
$string['roomfeatures'] = 'Особливості приміщення';
$string['allow_webcams'] = 'Дозволити веб-камери';
$string['mute_on_start'] = 'Вимкнення звуку під час запуску';
$string['allow_screen_share'] = 'Дозволити спільний доступ до екрана';
$string['allow_rtmp'] = 'Дозволити RTMP';
$string['allow_view_other_webcams'] = 'Дозволити перегляд інших веб-камер';
$string['allow_view_other_users_list'] = 'Дозволити перегляд іншим користувачам';
$string['admin_only_webcams'] = 'Веб-камери лише для адміністратора';
$string['allow_polls'] = 'Дозволити опитування';
$string['room_duration'] = 'Тривалість кімнати (У хвилинах, 0 = необмежено)';
$string['moderator_join_first'] = 'Модератор приєднуйтесь першим';
$string['moderator_join_first_error'] = 'Зустріч ще не розпочалася, будь ласка, поверніться пізніше';
$string['enable_analytics'] = 'Увімкніть аналітику';
$string['allow_virtual_bg'] = 'Дозволити віртуальний фон';
$string['allow_raise_hand'] = 'Дозволити підняти руку';
$string['auto_gen_user_id'] = 'Автоматична генерація ідентифікатора користувача';

$string['other_features'] = 'Розширені функції';

$string['recordingfeatures'] = 'Особливості запису';
$string['allow_recording'] = 'Дозволити запис';
$string['allow_cloud_recording'] = 'Дозволити запис у хмарі';
$string['enable_auto_cloud_recording'] = 'Увімкніть автоматичний запуск запису в хмарі';
$string['allow_local_recording'] = 'Дозволити локальний запис';
$string['is_allow_view_recording'] = 'Надання учням можливості переглядати записи';
$string['is_allow_download_recording'] = 'Дозвольте учням завантажувати записи';

$string['chatfeatures'] = 'Функції чату';
$string['allow_chat'] = 'Дозволити чат';
$string['allow_file_upload'] = 'Дозволити завантаження файлів';

$string['shared_note_pad_features'] = 'Функції спільного блокнота';
$string['allow_shared_notepad'] = 'Дозволити спільний блокнот';

$string['whiteboard_features'] = 'Особливості дошки';
$string['allow_whiteboard'] = 'Дозволити Whiteboard';

$string['external_media_player_features'] = 'Особливості зовнішнього медіаплеєра';
$string['allowed_external_media_player'] = 'Дозволити зовнішній медіаплеєр';

$string['waiting_room_features'] = 'Особливості залу очікування';
$string['activate_waiting_room'] = 'Активувати зал очікування';
$string['waiting_room_msg'] = 'Повідомлення в залі очікування';

$string['breakout_room_features'] = 'Особливості кімнати підгруп';
$string['allow_breakout_rooms'] = 'Дозволити сеанси підгруп';
$string['allowed_number_rooms'] = 'Кількість кімнат';

$string['display_external_link_features'] = 'Відображення функцій зовнішніх посилань';
$string['allow_display_external_link_features'] = 'Дозволити відображення функцій зовнішніх посилань';
$string['allow_ingress_features'] = 'Дозволяють створити проникнення';

$string['defaultlock'] = 'Налаштування блокування за замовчуванням';
$string['lock_microphone'] = 'Блокування мікрофона';
$string['lock_webcam'] = 'Блокування веб-камери';
$string['lock_screen_sharing'] = 'Спільний доступ до екрана блокування';
$string['lock_whiteboard'] = 'Замкнути дошку';
$string['lock_shared_notepad'] = 'Блокування спільного блокнота';
$string['lock_chat'] = 'Як заблокувати чат';
$string['lock_chat_send_message'] = 'Заблокувати надіслати повідомлення';
$string['lock_chat_file_share'] = 'Блокування спільного доступу до файлів';
$string['lock_private_chat'] = 'Як заблокувати приватний чат';

$string['available'] = 'Доступно з';
$string['deadline'] = 'Термін';

$string['extraoption'] = 'Додаткові опції';

$string['client_load'] = 'Навантаження на клієнта від';
$string['client_load_des'] = 'Типове значення: віддалене';
$string['remote'] = 'Віддаленого';
$string['local'] = 'Місцевий';

$string['client_download_url'] = 'Url для завантаження локального клієнта';
$string['client_download_url_des'] = 'Url для завантаження локального клієнта. За замовчуванням github';
$string['update_client_code'] = '<button class="btn btn-sm btn-secondary mb-6" id="updateClient">Завантажити останній клієнт</button>';
$string['error_file_open'] = 'Помилка при відкритті zip-файлу';
$string['client_updated_success'] = 'Клієнт успішно оновлений';
$string['client_updated_failed'] = 'Не вдалося оновити клієнт';

$string['join'] = 'Приєднатися до';
$string['end'] = 'Кінець';
$string['recordings'] = 'Записи';
$string['recording_date'] = 'Дата запису';
$string['meeting_date'] = 'Дата зустрічі';
$string['file_size'] = 'Розмір файлу (МБ)';
$string['play'] = 'Грати';
$string['download'] = 'Завантажити';
$string['delete'] = 'Видалити';
$string['sure_to_delete'] = 'Ви обов\'язково видалили?';

$string['design_customization'] = 'Кастомізація дизайну';
$string['custom_css_url'] = 'Користувацька URL-адреса CSS';
$string['custom_css_url_des'] = 'Має бути https прямий URL файлу CSS';
$string['primary_color'] = 'Основний колір';
$string['primary_color_des'] = 'Основний колір для інтерфейсу';
$string['secondary_color'] = 'Вторинний колір';
$string['secondary_color_des'] = 'Додатковий колір для інтерфейсу';
$string['background_color'] = 'Колір фону';
$string['background_color_des'] = 'Колір фону інтерфейсу';
$string['background_image'] = 'Фонове зображення';
$string['background_image_des'] = 'Має бути розміром 1920X1080 для найкращого результату.';
$string['header_color'] = 'Колір заголовка';
$string['header_color_des'] = 'Колір заголовка інтерфейсу';
$string['footer_color'] = 'Колір нижнього колонтитула';
$string['footer_color_des'] = 'Колір нижнього колонтитула інтерфейсу';
$string['left_color'] = 'Колір лівої сторони';
$string['left_color_des'] = 'Колір лівої бічної панелі';
$string['side_panel_bg_color'] = 'Колір фону бічної панелі';
$string['side_panel_bg_color_des'] = 'Колір фону правої панелі';
$string['column_camera_position'] = 'Положення колонки камери';
$string['column_camera_position_des'] = 'Положення колонки камери. Типове значення: ліворуч';
$string['column_camera_width'] = 'Ширина камери колонки';
$string['column_camera_width_des'] = 'Ширина камери колонки';

$string['allow_speech_to_text_translation_features'] = 'Дозволити функції перетворення мовлення в текст/переклад';
$string['allow_speech_translation'] = 'Дозволити переклад';

$string['enable_end_to_end_encryption_features'] = 'Увімкнути наскрізне шифрування (E2EE)';
$string['enabled_self_insert_encryption_key'] = 'Увімкніть ручну клавішу E2EE';
$string['included_e2ee_chat_messages'] = "Увімкніть шифрування для чату";
$string['included_e2ee_whiteboard'] = "Увімкніть шифрування для дошки";

$string['sip_dial_in_features'] = "Функції підключення SIP/VoIP";
$string['sip_dial_in_features_is_allow'] = "Дозволити SIP/VoIP набирати";
$string['enable_dial_in_on_create'] = "Увімкніть налаштування при створенні";
$string['hide_phone_number'] = "Приховати номер телефону";

$string['insights_features'] = 'Insights AI';
$string['insights_features_is_allow'] = 'Увімкнути функції аналітиків';
$string['insights_transcription_features_is_allow'] = 'Дозволити транскрипцію';
$string['insights_transcription_features_is_allow_translation'] = 'Дозволити транскрипційний переклад';
$string['insights_transcription_features_is_allow_speech_synthesis'] = 'Дозволити синтез мовлення';
$string['insights_chat_translation_features_is_allow'] = 'Дозволити переклад у чаті';
$string['insights_ai_features_is_allow'] = 'Дозволити функції ШІ';
$string['insights_ai_text_chat_features_is_allow'] = 'Дозволити текстовий чат ШІ';
$string['insights_ai_meeting_summarization_features_is_allow'] = 'Дозволити узагальнення засідань ШІ';
