<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Plugin strings are defined here.
 *
 * @package     mod_plugnmeet
 * @category    string
 * @author     Jibon L. Costa <jibon@mynaparrot.com>
 * @copyright  2022 MynaParrot
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['choosereadme'] = 'Readme при выборе темы.';
$string['missingidandcmid'] = 'Отсутствуют id и cmid';
$string['modulename'] = 'plugNmeet';
$string['modulename_help'] = 'Используйте модуль plugNmeet для...';
$string['modulenameplural'] = 'plugNmeets';
$string['newmodulename'] = 'Имя plugNmeet';
$string['newmodulename_help'] = 'Это содержимое подсказки справки, связанной с полем plugNmeet';
$string['newmodulesettings'] = 'Параметры';
$string['nonewmodules'] = 'Без plugNmeet';
$string['pluginadministration'] = 'Администрирование plugNmeet';
$string['pluginname'] = 'plugNmeet';
$string['pluginname_help'] = 'Текст справки при добавлении этого типа вопроса.';
$string['pluginnameadding'] = 'Отображается при добавлении этого типа вопроса.';
$string['pluginnameediting'] = 'Отображается при редактировании этого типа вопроса.';
$string['pluginnamesummary'] = 'Отображается при выборе типа добавляемого вопроса.';
$string['plugnmeet:access'] = 'Доступ к содержимому';
$string['plugnmeet:addinstance'] = 'Добавление нового действия plugNmeet';
$string['plugnmeet:edit'] = 'Редактировать plugNmeet';
$string['plugnmeet:enrol'] = 'Зарегистрируйте пользователей';
$string['plugnmeet:manage'] = 'Управление пользователями';
$string['plugnmeet:unenrol'] = 'Отмена регистрации пользователей';
$string['plugnmeet:upload'] = 'Загрузка контента';
$string['plugnmeet:useeditor'] = 'Редактирование содержимого';
$string['plugnmeet:view'] = 'Посмотреть plugNmeet';
$string['privacy:metadata:plugnmeet'] = 'Чтобы интегрироваться с удаленным сервером plugnmeet, необходимо обмениваться пользовательскими данными с этим сервером.';
$string['privacy:metadata:plugnmeet:userid'] = 'Идентификатор пользователя отправляется из Moodle, чтобы вы могли получить доступ к своим данным в удаленной системе.';
$string['privacy:metadata:plugnmeet:fullname'] = 'Ваше полное имя будет отправлено в удаленную систему, чтобы обеспечить лучший пользовательский опыт.';

$string['view'] = 'Вид';
$string['yes'] = 'Да';
$string['no'] = 'Нет';
$string['join'] = 'Соединять';
$string['plugnmeetname'] = 'plugNmeet';
$string['plugnmeetname_help'] = 'Справка';
$string['plugnmeet_viewed'] = 'Просмотр активности plugNmeet';
$string['joined_session'] = 'Присоединенный сеанс';

$string['plugnmeetconfig'] = 'Конфигурация plugNmeet';
$string['plugnmeet_server_url'] = 'URL сервера PlugnMeet';
$string['plugnmeet_server_url_des'] = 'Введите URL-адрес сервера plugNmeet.';
$string['plugnmeet_api_key'] = 'Ключ API plugnmeet';
$string['plugnmeet_api_key_des'] = 'Введите ключ API plugnmeet';
$string['plugnmeet_secret'] = 'Секрет plugnmeet';
$string['plugnmeet_secret_des'] = 'Вход в секрет plugnmeet';
$string['livekit_server_url'] = 'URL сервера Livekit';
$string['livekit_server_url_des'] = 'Введите URL сервера Livekit';
$string['custom_logo'] = 'Пользовательский логотип';
$string['custom_logo_des'] = 'Индивидуальный логотип для конференц-зала';

$string['plugnmeetoptions'] = 'Опции plugNmeet';
$string['enable_dynacast'] = 'Включение dynacast';
$string['enable_dynacast_des'] = 'Включение dynacast';
$string['enable_simulcast'] = 'Включить одновременную трансляцию';
$string['enable_simulcast_des'] = 'Включить одновременную трансляцию';
$string['stop_mic_track_on_mute'] = 'Остановка микрофонной дорожки при отключении звука';
$string['stop_mic_track_on_mute_des'] = 'Остановка микрофонной дорожки при отключении звука';
$string['video_codec'] = 'Видеокодек';
$string['video_codec_des'] = 'Видеокодек';
$string['default_webcam_resolution'] = 'Разрешение веб-камеры по умолчанию';
$string['default_webcam_resolution_des'] = 'Разрешение веб-камеры по умолчанию';
$string['default_screen_share_resolution'] = 'Разрешение демонстрации экрана по умолчанию';
$string['default_screen_share_resolution_des'] = 'Разрешение демонстрации экрана по умолчанию';
$string['default_audio_preset'] = 'Предустановка аудио';
$string['default_audio_preset_des'] = 'Предустановка аудио для микрофона';
$string['copyright_display'] = 'Включить отображение авторских прав';
$string['copyright_display_des'] = 'Если включено, то он будет отображать текст ниже';
$string['copyright_text'] = 'Текст об авторском праве';
$string['copyright_text_des'] = 'Этот текст можно установить, если конфигурацию сервера позволяют переопределить';

$string['roomtitle'] = 'Название номера';
$string['welcome_message'] = 'Приветственное сообщение';
$string['max_participants'] = 'Максимальное количество участников (0 = не ограничено)';

$string['room_features'] = 'Особенности номера';
$string['roomfeatures'] = 'Особенности номера';
$string['allow_webcams'] = 'Разрешить использование веб-камер';
$string['mute_on_start'] = 'Отключение звука при старте';
$string['allow_screen_share'] = 'Как разрешить демонстрацию экрана';
$string['allow_rtmp'] = 'Разрешить RTMP';
$string['allow_view_other_webcams'] = 'Разрешить просмотр других веб-камер';
$string['allow_view_other_users_list'] = 'Разрешить просмотр других пользователей';
$string['admin_only_webcams'] = 'Веб-камеры только для администраторов';
$string['allow_polls'] = 'Разрешить опросы';
$string['room_duration'] = 'Продолжительность номера (в минутах, 0 = неограниченно)';
$string['moderator_join_first'] = 'Модератор присоединяется первым';
$string['moderator_join_first_error'] = 'Встреча еще не началась, пожалуйста, вернитесь позже';
$string['enable_analytics'] = 'Включите аналитику';
$string['allow_virtual_bg'] = 'Разрешить виртуальный фон';
$string['allow_raise_hand'] = 'Разрешить поднять руку';
$string['auto_gen_user_id'] = 'Автоматическая генерация идентификатора пользователя';

$string['other_features'] = 'Расширенные возможности';

$string['recordingfeatures'] = 'Особенности записи';
$string['allow_recording'] = 'Разрешить запись';
$string['allow_cloud_recording'] = 'Разрешение записи в облако';
$string['enable_auto_cloud_recording'] = 'Включение автоматического запуска записи в облаке';
$string['allow_local_recording'] = 'Разрешить локальную запись';
$string['is_allow_view_recording'] = 'Предоставление учащимся возможности просматривать запись';
$string['is_allow_download_recording'] = 'Предоставление учащимся возможности скачивать записи';

$string['chatfeatures'] = 'Функции чата';
$string['allow_chat'] = 'Разрешить чат';
$string['allow_file_upload'] = 'Разрешить загрузку файлов';

$string['shared_note_pad_features'] = 'Функции общего блокнота';
$string['allow_shared_notepad'] = 'Разрешить общий блокнот';

$string['whiteboard_features'] = 'Особенности доски';
$string['allow_whiteboard'] = 'Разрешить виртуальную доску';

$string['external_media_player_features'] = 'Возможности внешнего медиаплеера';
$string['allowed_external_media_player'] = 'Разрешить внешний медиаплеер';

$string['waiting_room_features'] = 'Особенности зала ожидания';
$string['activate_waiting_room'] = 'Активировать зал ожидания';
$string['waiting_room_msg'] = 'Сообщение в зале ожидания';

$string['breakout_room_features'] = 'Особенности сессионных залов';
$string['allow_breakout_rooms'] = 'Разрешите сессионные залы';
$string['allowed_number_rooms'] = 'Количество номеров';

$string['display_external_link_features'] = 'Отображение функций внешних ссылок';
$string['allow_display_external_link_features'] = 'Разрешить отображение функций внешних ссылок';
$string['allow_ingress_features'] = 'Разрешить создание входящего трафика';

$string['defaultlock'] = 'Настройки блокировки по умолчанию';
$string['lock_microphone'] = 'Блокировка микрофона';
$string['lock_webcam'] = 'Блокировка веб-камеры';
$string['lock_screen_sharing'] = 'Блокировка экрана';
$string['lock_whiteboard'] = 'Доска с замком';
$string['lock_shared_notepad'] = 'Блокировка общего блокнота';
$string['lock_chat'] = 'Блокировка чата';
$string['lock_chat_send_message'] = 'Блокировка отправки сообщения';
$string['lock_chat_file_share'] = 'Блокировка общего доступа к файлам';
$string['lock_private_chat'] = 'Блокировка приватного чата';

$string['available'] = 'Доступно от';
$string['deadline'] = 'Срок';

$string['extraoption'] = 'Дополнительные опции';

$string['client_load'] = 'Клиентская нагрузка от';
$string['client_load_des'] = 'По умолчанию: Remote';
$string['remote'] = 'Удалённый';
$string['local'] = 'Местный';

$string['client_download_url'] = 'URL для скачивания локального клиента';
$string['client_download_url_des'] = 'Ссылка для скачивания локального клиента. По умолчанию github';
$string['update_client_code'] = '<button class="btn btn-sm btn-secondary mb-6" id="updateClient">Скачать последнюю версию клиента</button>';
$string['error_file_open'] = 'Ошибка при открытии zip-файла';
$string['client_updated_success'] = 'Клиент успешно обновлен';
$string['client_updated_failed'] = 'Не удалось обновить клиент';

$string['join'] = 'Соединять';
$string['end'] = 'Конец';
$string['recordings'] = 'Записи';
$string['recording_date'] = 'Дата записи';
$string['meeting_date'] = 'Дата встречи';
$string['file_size'] = 'Размер файла (МБ)';
$string['play'] = 'Играть';
$string['download'] = 'Загружать';
$string['delete'] = 'Удалить';
$string['sure_to_delete'] = 'Вы уверены, что удалите?';

$string['design_customization'] = 'Кастомизация дизайна';
$string['custom_css_url'] = 'Пользовательский URL-адрес CSS';
$string['custom_css_url_des'] = 'Должен быть прямой URL-адрес CSS-файла https';
$string['primary_color'] = 'Основной цвет';
$string['primary_color_des'] = 'Основной цвет для интерфейса';
$string['secondary_color'] = 'Вторичный цвет';
$string['secondary_color_des'] = 'Дополнительный цвет для интерфейса';
$string['background_color'] = 'Цвет фона';
$string['background_color_des'] = 'Цвет фона интерфейса';
$string['background_image'] = 'Фоновое изображение';
$string['background_image_des'] = 'Для достижения наилучшего результата должен быть размер 1920X1080.';
$string['header_color'] = 'Цвет заголовка';
$string['header_color_des'] = 'Цвет заголовка интерфейса';
$string['footer_color'] = 'Цвет нижнего колонтитула';
$string['footer_color_des'] = 'Цвет нижнего колонтитула интерфейса';
$string['left_color'] = 'Цвет левой стороны';
$string['left_color_des'] = 'Цвет левой боковой панели';
$string['side_panel_bg_color'] = 'Цвет фона боковой панели';
$string['side_panel_bg_color_des'] = 'Цвет фона правой стороны панели';
$string['column_camera_position'] = 'Положение камеры колонны';
$string['column_camera_position_des'] = 'Положение камеры колонны. По умолчанию: левый';
$string['column_camera_width'] = 'Ширина камеры в столбце';
$string['column_camera_width_des'] = 'Ширина камеры в столбце';

$string['allow_speech_to_text_translation_features'] = 'Разрешить преобразование речи в текст/функции перевода';
$string['allow_speech_translation'] = 'Разрешить перевод';

$string['enable_end_to_end_encryption_features'] = 'Включение сквозного шифрования (E2EE)';
$string['enabled_self_insert_encryption_key'] = 'Включите ручную клавишу E2EE';
$string['included_e2ee_chat_messages'] = "Как включить шифрование для чата";
$string['included_e2ee_whiteboard'] = "Включение шифрования для доски объявлений";

$string['sip_dial_in_features'] = "Функции подключения SIP/VoIP";
$string['sip_dial_in_features_is_allow'] = "Разрешить SIP/VoIP-набор";
$string['enable_dial_in_on_create'] = "Включите dial in при создании";
$string['hide_phone_number'] = "Скрыть номер телефона";

$string['insights_features'] = 'Insights AI';
$string['insights_features_is_allow'] = 'Включить функции аналитики';
$string['insights_transcription_features_is_allow'] = 'Разрешить транскрипцию';
$string['insights_transcription_features_is_allow_translation'] = 'Разрешить транскрипционный перевод';
$string['insights_transcription_features_is_allow_speech_synthesis'] = 'Разрешить синтез речи';
$string['insights_chat_translation_features_is_allow'] = 'Разрешить перевод в чате';
$string['insights_ai_features_is_allow'] = 'Разрешить функции ИИ';
$string['insights_ai_text_chat_features_is_allow'] = 'Разрешить текстовый чат с помощью ИИ';
$string['insights_ai_meeting_summarization_features_is_allow'] = 'Разрешить резюме встреч с помощью ИИ';
