<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Plugin strings are defined here.
 *
 * @package     mod_plugnmeet
 * @category    string
 * @author     Jibon L. Costa <jibon@mynaparrot.com>
 * @copyright  2022 MynaParrot
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['choosereadme'] = 'Lisez-moi lors de la sélection du thème.';
$string['missingidandcmid'] = 'ID et cmid manquants';
$string['modulename'] = 'plugNmeet';
$string['modulename_help'] = 'Utilisez le module plugNmeet pour...';
$string['modulenameplural'] = 'plugNmeets';
$string['newmodulename'] = 'nom plugNmeet';
$string['newmodulename_help'] = 'Il s’agit du contenu de l’infobulle d’aide associée au champ plugNmeet';
$string['newmodulesettings'] = 'Paramètres';
$string['nonewmodules'] = 'Pas de plugNmeet';
$string['pluginadministration'] = 'Administration de plugNmeet';
$string['pluginname'] = 'plugNmeet';
$string['pluginname_help'] = 'Texte d’aide lors de l’ajout de ce type de question.';
$string['pluginnameadding'] = 'Rendu lors de l’ajout de ce type de question.';
$string['pluginnameediting'] = 'Rendu lors de la modification de ce type de question.';
$string['pluginnamesummary'] = 'Rendu lors du choix du type de question à ajouter.';
$string['plugnmeet:access'] = 'Accéder au contenu';
$string['plugnmeet:addinstance'] = 'Ajouter une nouvelle activité plugNmeet';
$string['plugnmeet:edit'] = 'Modifier plugNmeet';
$string['plugnmeet:enrol'] = 'Inscrire des utilisateurs';
$string['plugnmeet:manage'] = 'Gérer les utilisateurs';
$string['plugnmeet:unenrol'] = 'Désinscrire les utilisateurs';
$string['plugnmeet:upload'] = 'Télécharger du contenu';
$string['plugnmeet:useeditor'] = 'Modifier le contenu';
$string['plugnmeet:view'] = 'Voir plugNmeet';
$string['privacy:metadata:plugnmeet'] = 'Afin de s’intégrer à un serveur plugnmeet distant, les données utilisateur doivent être échangées avec ce serveur.';
$string['privacy:metadata:plugnmeet:userid'] = 'L’identifiant utilisateur est envoyé depuis Moodle pour vous permettre d’accéder à vos données sur le système distant.';
$string['privacy:metadata:plugnmeet:fullname'] = 'Votre nom complet est envoyé au système distant pour permettre une meilleure expérience utilisateur.';

$string['view'] = 'Vue';
$string['yes'] = 'Oui';
$string['no'] = 'Non';
$string['join'] = 'Unir';
$string['plugnmeetname'] = 'plugNmeet';
$string['plugnmeetname_help'] = 'Aide';
$string['plugnmeet_viewed'] = 'plugNmeet activité consultée';
$string['joined_session'] = 'Session jointe';

$string['plugnmeetconfig'] = 'Configuration de plugNmeet';
$string['plugnmeet_server_url'] = 'URL du serveur plugnmeet';
$string['plugnmeet_server_url_des'] = 'Entrez l’URL du serveur plugNmeet';
$string['plugnmeet_api_key'] = 'Clé API plugnmeet';
$string['plugnmeet_api_key_des'] = 'Entrez la clé API plugnmeet';
$string['plugnmeet_secret'] = 'plugnmeet Secret';
$string['plugnmeet_secret_des'] = 'Entrez plugnmeet Secret';
$string['livekit_server_url'] = 'URL du serveur Livekit';
$string['livekit_server_url_des'] = 'Entrez l’URL du serveur Livekit';
$string['custom_logo'] = 'Logo personnalisé';
$string['custom_logo_des'] = 'Logo personnalisé pour salle de conférence';

$string['plugnmeetoptions'] = 'Les options de plugNmeet';
$string['enable_dynacast'] = 'Activer dynacast';
$string['enable_dynacast_des'] = 'Activer dynacast';
$string['enable_simulcast'] = 'Activer la diffusion simultanée';
$string['enable_simulcast_des'] = 'Activer la diffusion simultanée';
$string['stop_mic_track_on_mute'] = 'Arrêter la piste du micro en sourdine';
$string['stop_mic_track_on_mute_des'] = 'Arrêter la piste du micro en sourdine';
$string['video_codec'] = 'Codec vidéo';
$string['video_codec_des'] = 'Codec vidéo';
$string['default_webcam_resolution'] = 'Résolution par défaut de la webcam';
$string['default_webcam_resolution_des'] = 'Résolution par défaut de la webcam';
$string['default_screen_share_resolution'] = 'Résolution de partage d’écran par défaut';
$string['default_screen_share_resolution_des'] = 'Résolution de partage d’écran par défaut';
$string['default_audio_preset'] = 'Préréglage audio';
$string['default_audio_preset_des'] = 'Préréglage audio pour microphone';
$string['copyright_display'] = 'Activer l’affichage des droits d’auteur';
$string['copyright_display_des'] = 'S’il est activé, il affichera le texte ci-dessous';
$string['copyright_text'] = 'Texte du droit d’auteur';
$string['copyright_text_des'] = 'Ce texte peut être défini si la configuration du serveur permet de remplacer';

$string['roomtitle'] = 'Titre de la chambre';
$string['welcome_message'] = 'Message de bienvenue';
$string['max_participants'] = 'Nombre maximum de participants (0 = illimité)';

$string['room_features'] = 'Caractéristiques de la chambre';
$string['roomfeatures'] = 'Caractéristiques de la chambre';
$string['allow_webcams'] = 'Autoriser les webcams';
$string['mute_on_start'] = 'Muet au démarrage';
$string['allow_screen_share'] = 'Autoriser le partage d’écran';
$string['allow_rtmp'] = 'Autoriser RTMP';
$string['allow_view_other_webcams'] = 'Autoriser l’affichage d’autres webcams';
$string['allow_view_other_users_list'] = 'Autoriser l’affichage d’autres utilisateurs';
$string['admin_only_webcams'] = 'Webcams réservées aux administrateurs';
$string['allow_polls'] = 'Autoriser les sondages';
$string['room_duration'] = 'Durée de la chambre (en minutes, 0 = illimitée)';
$string['moderator_join_first'] = 'Modérateur : rejoignez en premier';
$string['moderator_join_first_error'] = 'La réunion n’a pas encore commencé, merci de revenir plus tard';
$string['enable_analytics'] = 'Activer l’analytique';
$string['allow_virtual_bg'] = 'Autoriser l’arrière-plan virtuel';
$string['allow_raise_hand'] = 'Permettre de lever la main';
$string['auto_gen_user_id'] = 'Génération automatique de l’ID utilisateur';

$string['other_features'] = 'Fonctionnalités avancées';

$string['recordingfeatures'] = 'Fonctions d’enregistrement';
$string['allow_recording'] = 'Autoriser l’enregistrement';
$string['allow_cloud_recording'] = 'Autoriser l’enregistrement dans le cloud';
$string['enable_auto_cloud_recording'] = 'Activer le démarrage automatique de l’enregistrement dans le cloud';
$string['allow_local_recording'] = 'Autoriser l’enregistrement local';
$string['is_allow_view_recording'] = 'Autoriser les élèves à visionner l’enregistrement';
$string['is_allow_download_recording'] = 'Autoriser les élèves à télécharger l’enregistrement';

$string['chatfeatures'] = 'Fonctionnalités de chat';
$string['allow_chat'] = 'Autoriser le chat';
$string['allow_file_upload'] = 'Autoriser le téléchargement de fichiers';

$string['shared_note_pad_features'] = 'Fonctionnalités du bloc-notes partagé';
$string['allow_shared_notepad'] = 'Autoriser le bloc-notes partagé';

$string['whiteboard_features'] = 'Caractéristiques du tableau blanc';
$string['allow_whiteboard'] = 'Autoriser le tableau blanc';

$string['external_media_player_features'] = 'Caractéristiques du lecteur multimédia externe';
$string['allowed_external_media_player'] = 'Autoriser le lecteur multimédia externe';

$string['waiting_room_features'] = 'Caractéristiques de la salle d’attente';
$string['activate_waiting_room'] = 'Activer la salle d’attente';
$string['waiting_room_msg'] = 'Message de la salle d’attente';

$string['breakout_room_features'] = 'Caractéristiques de la salle de réunion';
$string['allow_breakout_rooms'] = 'Autoriser les salles de réunion';
$string['allowed_number_rooms'] = 'Nombre de chambres';

$string['display_external_link_features'] = 'Afficher les fonctionnalités des liens externes';
$string['allow_display_external_link_features'] = 'Autoriser l’affichage des fonctionnalités de lien externe';
$string['allow_ingress_features'] = 'Autoriser la création d’une entrée';

$string['defaultlock'] = 'Paramètres de verrouillage par défaut';
$string['lock_microphone'] = 'Verrouiller le microphone';
$string['lock_webcam'] = 'Verrouiller la webcam';
$string['lock_screen_sharing'] = 'Partage de l’écran de verrouillage';
$string['lock_whiteboard'] = 'Verrouiller le tableau blanc';
$string['lock_shared_notepad'] = 'Verrouiller le bloc-notes partagé';
$string['lock_chat'] = 'Verrouiller le chat';
$string['lock_chat_send_message'] = 'Verrouiller l’envoi du message';
$string['lock_chat_file_share'] = 'Verrouiller le partage de fichiers';
$string['lock_private_chat'] = 'Verrouiller le chat privé';

$string['available'] = 'Disponible à partir du';
$string['deadline'] = 'Date limite';

$string['extraoption'] = 'Options supplémentaires';

$string['client_load'] = 'Charge du client à partir de';
$string['client_load_des'] = 'Par défaut : à distance';
$string['remote'] = 'Lointain';
$string['local'] = 'Local';

$string['client_download_url'] = 'URL de téléchargement du client local';
$string['client_download_url_des'] = 'URL de téléchargement du client local. Github par défaut';
$string['update_client_code'] = '<button class="btn btn-sm btn-secondary mb-6" id="updateClient">Télécharger le dernier client</button>';
$string['error_file_open'] = 'Erreur lors de l’ouverture du fichier zip';
$string['client_updated_success'] = 'Client mis à jour avec succès';
$string['client_updated_failed'] = 'Echec de la mise à jour du client';

$string['join'] = 'Unir';
$string['end'] = 'Fin';
$string['recordings'] = 'Enregistrements';
$string['recording_date'] = 'Date d’enregistrement';
$string['meeting_date'] = 'Date de la réunion';
$string['file_size'] = 'Taille du fichier (Mo)';
$string['play'] = 'Jouer';
$string['download'] = 'Télécharger';
$string['delete'] = 'Supprimer';
$string['sure_to_delete'] = 'Êtes-vous sûr de supprimer ?';

$string['design_customization'] = 'Personnalisation du design';
$string['custom_css_url'] = 'URL CSS personnalisée';
$string['custom_css_url_des'] = 'Doit être l’url du fichier CSS direct https';
$string['primary_color'] = 'Couleur primaire';
$string['primary_color_des'] = 'Couleur primaire pour l’interface';
$string['secondary_color'] = 'Couleur secondaire';
$string['secondary_color_des'] = 'Couleur secondaire pour l’interface';
$string['background_color'] = 'Couleur d’arrière-plan';
$string['background_color_des'] = 'Couleur d’arrière-plan de l’interface';
$string['background_image'] = 'Image d’arrière-plan';
$string['background_image_des'] = 'Devrait avoir une taille de 1920X1080 pour un meilleur résultat.';
$string['header_color'] = 'Couleur de l’en-tête';
$string['header_color_des'] = 'Couleur de l’en-tête de l’interface';
$string['footer_color'] = 'Couleur du pied de page';
$string['footer_color_des'] = 'Couleur du pied de page de l’interface';
$string['left_color'] = 'Couleur du côté gauche';
$string['left_color_des'] = 'Couleur de la barre latérale gauche';
$string['side_panel_bg_color'] = 'Couleur de fond du panneau latéral';
$string['side_panel_bg_color_des'] = 'Couleur de fond du panneau côté droit';
$string['column_camera_position'] = 'Position de la caméra colonne';
$string['column_camera_position_des'] = 'Position de la caméra en colonne. Par défaut : gauche';
$string['column_camera_width'] = 'Largeur de la caméra colonne';
$string['column_camera_width_des'] = 'Largeur de la caméra colonne';

$string['allow_speech_to_text_translation_features'] = 'Autoriser les fonctions de conversion de la parole en texte';
$string['allow_speech_translation'] = 'Autoriser la traduction';

$string['enable_end_to_end_encryption_features'] = 'Activer le chiffrement de bout en bout (E2EE)';
$string['enabled_self_insert_encryption_key'] = 'Activer la touche manuelle E2EE';
$string['included_e2ee_chat_messages'] = "Activer le chiffrement pour le chat";
$string['included_e2ee_whiteboard'] = "Activer le chiffrement pour le tableau blanc";

$string['sip_dial_in_features'] = "Fonctionnalités de réglage SIP/VoIP";
$string['sip_dial_in_features_is_allow'] = "Autoriser le SIP/VoIP à l’appel";
$string['enable_dial_in_on_create'] = "Activer le dial-in lors de la création";
$string['hide_phone_number'] = "Masquer le numéro de téléphone";

$string['insights_features'] = 'IA des insights';
$string['insights_features_is_allow'] = 'Activer les fonctionnalités d’insights';
$string['insights_transcription_features_is_allow'] = 'Autoriser la transcription';
$string['insights_transcription_features_is_allow_translation'] = 'Autoriser la traduction par transcription';
$string['insights_transcription_features_is_allow_speech_synthesis'] = 'Autoriser la synthèse vocale';
$string['insights_chat_translation_features_is_allow'] = 'Autoriser la traduction du chat';
$string['insights_ai_features_is_allow'] = 'Autoriser les fonctionnalités d’IA';
$string['insights_ai_text_chat_features_is_allow'] = 'Autoriser le chat texte par IA';
$string['insights_ai_meeting_summarization_features_is_allow'] = 'Permettre la synthèse des réunions par IA';
