<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Plugin strings are defined here.
 *
 * @package     mod_plugnmeet
 * @category    string
 * @author     Jibon L. Costa <jibon@mynaparrot.com>
 * @copyright  2022 MynaParrot
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['choosereadme'] = 'Léame al seleccionar el tema.';
$string['missingidandcmid'] = 'Falta id y cmid';
$string['modulename'] = 'plugNmeet';
$string['modulename_help'] = 'Utilice el módulo plugNmeet para...';
$string['modulenameplural'] = 'plugNmeets';
$string['newmodulename'] = 'nombre de plugNmeet';
$string['newmodulename_help'] = 'Este es el contenido de la información sobre herramientas de ayuda asociada con el campo plugNmeet';
$string['newmodulesettings'] = 'Configuración';
$string['nonewmodules'] = 'Sin plugNmeet';
$string['pluginadministration'] = 'administración de plugNmeet';
$string['pluginname'] = 'plugNmeet';
$string['pluginname_help'] = 'Texto de ayuda al agregar este tipo de pregunta.';
$string['pluginnameadding'] = 'Se representa al agregar este tipo de pregunta.';
$string['pluginnameediting'] = 'Se representa al editar este tipo de pregunta.';
$string['pluginnamesummary'] = 'Se representa al elegir el tipo de pregunta que se va a agregar.';
$string['plugnmeet:access'] = 'Acceder al contenido';
$string['plugnmeet:addinstance'] = 'Agregar una nueva actividad de plugNmeet';
$string['plugnmeet:edit'] = 'Editar plugNmeet';
$string['plugnmeet:enrol'] = 'Inscribir usuarios';
$string['plugnmeet:manage'] = 'Administrar usuarios';
$string['plugnmeet:unenrol'] = 'Dar de baja a los usuarios';
$string['plugnmeet:upload'] = 'Subir contenido';
$string['plugnmeet:useeditor'] = 'Editar contenido';
$string['plugnmeet:view'] = 'Ver plugNmeet';
$string['privacy:metadata:plugnmeet'] = 'Para integrarse con un servidor remoto de plugnmeet, los datos del usuario deben intercambiarse con ese servidor.';
$string['privacy:metadata:plugnmeet:userid'] = 'El ID de usuario se envía desde Moodle para permitirle acceder a sus datos en el sistema remoto.';
$string['privacy:metadata:plugnmeet:fullname'] = 'Su nombre completo se envía al sistema remoto para permitir una mejor experiencia de usuario.';

$string['view'] = 'Vista';
$string['yes'] = 'Sí';
$string['no'] = 'No';
$string['join'] = 'Juntar';
$string['plugnmeetname'] = 'plugNmeet';
$string['plugnmeetname_help'] = 'Ayuda';
$string['plugnmeet_viewed'] = 'Actividad de plugNmeet vista';
$string['joined_session'] = 'Unirse a la sesión';

$string['plugnmeetconfig'] = 'configuración plugNmeet';
$string['plugnmeet_server_url'] = 'URL del servidor de plugnmeet';
$string['plugnmeet_server_url_des'] = 'Ingrese la URL del servidor plugNmeet';
$string['plugnmeet_api_key'] = 'Clave de API de plugnmeet';
$string['plugnmeet_api_key_des'] = 'Ingrese la clave API de plugnmeet';
$string['plugnmeet_secret'] = 'plugnmeet Secreto';
$string['plugnmeet_secret_des'] = 'Entrar en plugnmeet Secret';
$string['livekit_server_url'] = 'URL del servidor Livekit';
$string['livekit_server_url_des'] = 'Introduzca la URL del servidor Livekit';
$string['custom_logo'] = 'Logotipo personalizado';
$string['custom_logo_des'] = 'Logotipo personalizado para sala de conferencias';

$string['plugnmeetoptions'] = 'Opciones de plugNmeet';
$string['enable_dynacast'] = 'Habilitación de dynacast';
$string['enable_dynacast_des'] = 'Habilitación de dynacast';
$string['enable_simulcast'] = 'Habilitación de la transmisión simultánea';
$string['enable_simulcast_des'] = 'Habilitación de la transmisión simultánea';
$string['stop_mic_track_on_mute'] = 'Detener la pista de micrófono en silencio';
$string['stop_mic_track_on_mute_des'] = 'Detener la pista de micrófono en silencio';
$string['video_codec'] = 'Códec de vídeo';
$string['video_codec_des'] = 'Códec de vídeo';
$string['default_webcam_resolution'] = 'Resolución predeterminada de la cámara web';
$string['default_webcam_resolution_des'] = 'Resolución predeterminada de la cámara web';
$string['default_screen_share_resolution'] = 'Resolución predeterminada de uso compartido de pantalla';
$string['default_screen_share_resolution_des'] = 'Resolución predeterminada de uso compartido de pantalla';
$string['default_audio_preset'] = 'Preajuste de audio';
$string['default_audio_preset_des'] = 'Preajuste de audio para micrófono';
$string['copyright_display'] = 'Habilitar la visualización de derechos de autor';
$string['copyright_display_des'] = 'Si está habilitado, mostrará el texto a continuación';
$string['copyright_text'] = 'Texto protegido por derechos de autor';
$string['copyright_text_des'] = 'Este texto se puede establecer si la configuración del servidor permite anular';

$string['roomtitle'] = 'Título de la habitación';
$string['welcome_message'] = 'Mensaje de bienvenida';
$string['max_participants'] = 'Número máximo de participantes (0 = ilimitados)';

$string['room_features'] = 'Características de la habitación';
$string['roomfeatures'] = 'Características de la habitación';
$string['allow_webcams'] = 'Permitir cámaras web';
$string['mute_on_start'] = 'Silenciar al iniciar';
$string['allow_screen_share'] = 'Permitir el uso compartido de pantalla';
$string['allow_rtmp'] = 'Permitir RTMP';
$string['allow_view_other_webcams'] = 'Permitir ver otras cámaras web';
$string['allow_view_other_users_list'] = 'Permitir ver a otros usuarios';
$string['admin_only_webcams'] = 'Cámaras web solo para administradores';
$string['allow_polls'] = 'Permitir sondeos';
$string['room_duration'] = 'Duración de la habitación (en minutos, 0 = ilimitado)';
$string['moderator_join_first'] = 'El moderador se une primero';
$string['moderator_join_first_error'] = 'La reunión aún no ha comenzado, por favor regrese más tarde';
$string['enable_analytics'] = 'Habilitación de análisis';
$string['allow_virtual_bg'] = 'Permitir fondo virtual';
$string['allow_raise_hand'] = 'Permitir levantar la mano';
$string['auto_gen_user_id'] = 'Generación automática de ID de usuario';

$string['other_features'] = 'Características avanzadas';

$string['recordingfeatures'] = 'Funciones de grabación';
$string['allow_recording'] = 'Permitir grabación';
$string['allow_cloud_recording'] = 'Permitir la grabación en la nube';
$string['enable_auto_cloud_recording'] = 'Habilitar el inicio automático de la grabación en la nube';
$string['allow_local_recording'] = 'Permitir grabación local';
$string['is_allow_view_recording'] = 'Permitir que los estudiantes vean la grabación';
$string['is_allow_download_recording'] = 'Permitir que los estudiantes descarguen la grabación';

$string['chatfeatures'] = 'Funciones de chat';
$string['allow_chat'] = 'Permitir chat';
$string['allow_file_upload'] = 'Permitir la carga de archivos';

$string['shared_note_pad_features'] = 'Funciones del bloc de notas compartido';
$string['allow_shared_notepad'] = 'Permitir bloc de notas compartido';

$string['whiteboard_features'] = 'Características de la pizarra';
$string['allow_whiteboard'] = 'Permitir pizarra';

$string['external_media_player_features'] = 'Funciones del reproductor multimedia externo';
$string['allowed_external_media_player'] = 'Permitir reproductor multimedia externo';

$string['waiting_room_features'] = 'Características de la sala de espera';
$string['activate_waiting_room'] = 'Activar sala de espera';
$string['waiting_room_msg'] = 'Mensaje de la sala de espera';

$string['breakout_room_features'] = 'Características de la sala para grupos pequeños';
$string['allow_breakout_rooms'] = 'Permitir salas para grupos pequeños';
$string['allowed_number_rooms'] = 'Número de habitaciones';

$string['display_external_link_features'] = 'Mostrar características de enlace externo';
$string['allow_display_external_link_features'] = 'Permitir mostrar características de enlace externo';
$string['allow_ingress_features'] = 'Permitir crear entrada';

$string['defaultlock'] = 'Configuración de bloqueo predeterminada';
$string['lock_microphone'] = 'Bloquear micrófono';
$string['lock_webcam'] = 'Bloquear cámara web';
$string['lock_screen_sharing'] = 'Compartir pantalla de bloqueo';
$string['lock_whiteboard'] = 'Pizarra de bloqueo';
$string['lock_shared_notepad'] = 'Bloquear bloc de notas compartido';
$string['lock_chat'] = 'Bloquear chat';
$string['lock_chat_send_message'] = 'Bloquear mensaje de envío';
$string['lock_chat_file_share'] = 'Bloquear recurso compartido de archivos';
$string['lock_private_chat'] = 'Bloquear el chat privado';

$string['available'] = 'Disponible en';
$string['deadline'] = 'Fecha tope';

$string['extraoption'] = 'Opciones adicionales';

$string['client_load'] = 'Carga de cliente desde';
$string['client_load_des'] = 'Predeterminado: remoto';
$string['remote'] = 'Remoto';
$string['local'] = 'Local';

$string['client_download_url'] = 'URL de descarga del cliente local';
$string['client_download_url_des'] = 'URL de descarga del cliente local. github predeterminado';
$string['update_client_code'] = '<button class="btn btn-sm btn-secondary mb-6" id="updateClient">Descargar el cliente más reciente</button>';
$string['error_file_open'] = 'Error al abrir el archivo zip';
$string['client_updated_success'] = 'El cliente se ha actualizado con éxito';
$string['client_updated_failed'] = 'No se pudo actualizar el cliente';

$string['join'] = 'Juntar';
$string['end'] = 'Fin';
$string['recordings'] = 'Grabaciones';
$string['recording_date'] = 'Fecha de grabación';
$string['meeting_date'] = 'Fecha de la reunión';
$string['file_size'] = 'Tamaño del archivo (MB)';
$string['play'] = 'Jugar';
$string['download'] = 'Descargar';
$string['delete'] = 'Borrar';
$string['sure_to_delete'] = '¿Está seguro de eliminar?';

$string['design_customization'] = 'Personalización del diseño';
$string['custom_css_url'] = 'URL CSS personalizada';
$string['custom_css_url_des'] = 'Debe ser https URL de archivo CSS directo';
$string['primary_color'] = 'Color primario';
$string['primary_color_des'] = 'Color primario para la interfaz';
$string['secondary_color'] = 'Color secundario';
$string['secondary_color_des'] = 'Color secundario para la interfaz';
$string['background_color'] = 'Color de fondo';
$string['background_color_des'] = 'Color de fondo de la interfaz';
$string['background_image'] = 'Imagen de fondo';
$string['background_image_des'] = 'Debe tener un tamaño de 1920X1080 para obtener el mejor resultado.';
$string['header_color'] = 'Color del encabezado';
$string['header_color_des'] = 'Color del encabezado de la interfaz';
$string['footer_color'] = 'Color del pie de página';
$string['footer_color_des'] = 'Color del pie de página de la interfaz';
$string['left_color'] = 'Color del lado izquierdo';
$string['left_color_des'] = 'Color de la barra lateral izquierda';
$string['side_panel_bg_color'] = 'Color de fondo del panel lateral';
$string['side_panel_bg_color_des'] = 'Color de fondo del panel lateral derecho';
$string['column_camera_position'] = 'Posición de la cámara de columna';
$string['column_camera_position_des'] = 'Posición de la cámara de columna. Predeterminado: izquierda';
$string['column_camera_width'] = 'Anchura de la cámara de columna';
$string['column_camera_width_des'] = 'Anchura de la cámara de columna';

$string['allow_speech_to_text_translation_features'] = 'Permitir funciones de conversión de voz a texto/traducción';
$string['allow_speech_translation'] = 'Permitir la traducción';

$string['enable_end_to_end_encryption_features'] = 'Habilitar el cifrado de extremo a extremo (E2EE)';
$string['enabled_self_insert_encryption_key'] = 'Activar la tecla manual E2EE';
$string['included_e2ee_chat_messages'] = "Habilitar el cifrado para el chat";
$string['included_e2ee_whiteboard'] = "Habilitar el cifrado para la pizarra";

$string['sip_dial_in_features'] = "Características de ajuste SIP/VoIP";
$string['sip_dial_in_features_is_allow'] = "Permitir el ajuste SIP/VoIP";
$string['enable_dial_in_on_create'] = "Activar el marcador al crear";
$string['hide_phone_number'] = "Ocultar número de teléfono";

$string['insights_features'] = 'IA de Insights';
$string['insights_features_is_allow'] = 'Habilitar funciones de insights';
$string['insights_transcription_features_is_allow'] = 'Permitir transcripción';
$string['insights_transcription_features_is_allow_translation'] = 'Permitir la traducción de transcripción';
$string['insights_transcription_features_is_allow_speech_synthesis'] = 'Permitir la síntesis de voz';
$string['insights_chat_translation_features_is_allow'] = 'Permitir la traducción del chat';
$string['insights_ai_features_is_allow'] = 'Permitir funciones de IA';
$string['insights_ai_text_chat_features_is_allow'] = 'Permitir chat de texto con IA';
$string['insights_ai_meeting_summarization_features_is_allow'] = 'Permitir la sinopsis de reuniones por IA';
