<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Plugin strings are defined here.
 *
 * @package     mod_plugnmeet
 * @category    string
 * @author     Jibon L. Costa <jibon@mynaparrot.com>
 * @copyright  2022 MynaParrot
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['choosereadme'] = 'Readme when selecting the theme.';
$string['missingidandcmid'] = 'Missing id and cmid';
$string['modulename'] = 'plugNmeet';
$string['modulename_help'] = 'Use the plugNmeet module for...';
$string['modulenameplural'] = 'plugNmeets';
$string['newmodulename'] = 'plugNmeet name';
$string['newmodulename_help'] = 'This is the content of the help tooltip associated with the plugNmeet field';
$string['newmodulesettings'] = 'Settings';
$string['nonewmodules'] = 'No plugNmeet';
$string['pluginadministration'] = 'plugNmeet administration';
$string['pluginname'] = 'plugNmeet';
$string['pluginname_help'] = 'Help text when adding this question type.';
$string['pluginnameadding'] = 'Rendered when adding this question type.';
$string['pluginnameediting'] = 'Rendered when editing this question type.';
$string['pluginnamesummary'] = 'Rendered when choosing the question type to be added.';
$string['plugnmeet:access'] = 'Access content';
$string['plugnmeet:addinstance'] = 'Add a new plugNmeet activity';
$string['plugnmeet:edit'] = 'Edit plugNmeet';
$string['plugnmeet:enrol'] = 'Enrol users';
$string['plugnmeet:manage'] = 'Manage users';
$string['plugnmeet:unenrol'] = 'Unenrol users';
$string['plugnmeet:upload'] = 'Upload content';
$string['plugnmeet:useeditor'] = 'Edit content';
$string['plugnmeet:view'] = 'View plugNmeet';
$string['privacy:metadata:plugnmeet'] = 'In order to integrate with a remote plugnmeet server, user data needs to be exchanged with that server.';
$string['privacy:metadata:plugnmeet:userid'] = 'The userid is sent from Moodle to allow you to access your data on the remote system.';
$string['privacy:metadata:plugnmeet:fullname'] = 'Your full name is sent to the remote system to allow a better user experience.';

$string['view'] = 'View';
$string['yes'] = 'Yes';
$string['no'] = 'No';
$string['join'] = 'Join';
$string['plugnmeetname'] = 'plugNmeet';
$string['plugnmeetname_help'] = 'Help';
$string['plugnmeet_viewed'] = 'plugNmeet activity viewed';
$string['joined_session'] = 'Joined session';

$string['plugnmeetconfig'] = 'plugNmeet config';
$string['plugnmeet_server_url'] = 'plugnmeet server url';
$string['plugnmeet_server_url_des'] = 'Enter plugNmeet Server URL';
$string['plugnmeet_api_key'] = 'plugnmeet API Key';
$string['plugnmeet_api_key_des'] = 'Enter plugnmeet API Key';
$string['plugnmeet_secret'] = 'plugnmeet Secret';
$string['plugnmeet_secret_des'] = 'Enter plugnmeet Secret';
$string['livekit_server_url'] = 'Livekit server url';
$string['livekit_server_url_des'] = 'Enter Livekit server url';
$string['custom_logo'] = 'Custom logo';
$string['custom_logo_des'] = 'Custom logo for conference room';

$string['plugnmeetoptions'] = 'plugNmeet options';
$string['enable_dynacast'] = 'Enable dynacast';
$string['enable_dynacast_des'] = 'Enable dynacast';
$string['enable_simulcast'] = 'Enable simulcast';
$string['enable_simulcast_des'] = 'Enable simulcast';
$string['stop_mic_track_on_mute'] = 'Stop mic track on mute';
$string['stop_mic_track_on_mute_des'] = 'Stop mic track on mute';
$string['video_codec'] = 'Video codec';
$string['video_codec_des'] = 'Video codec';
$string['default_webcam_resolution'] = 'Default webcam resolution';
$string['default_webcam_resolution_des'] = 'Default webcam resolution';
$string['default_screen_share_resolution'] = 'Default screen share resolution';
$string['default_screen_share_resolution_des'] = 'Default screen share resolution';
$string['default_audio_preset'] = 'Audio preset';
$string['default_audio_preset_des'] = 'Audio preset for microphone';
$string['copyright_display'] = 'Enable copyright display';
$string['copyright_display_des'] = 'If enabled then it will display bellow text';
$string['copyright_text'] = 'Copyright text';
$string['copyright_text_des'] = 'This text can be set if configuration of server allow to override';

$string['roomtitle'] = 'Room title';
$string['welcome_message'] = 'Welcome message';
$string['max_participants'] = 'Maximum participants (0 = unlimited)';

$string['room_features'] = 'Room features';
$string['roomfeatures'] = 'Room features';
$string['allow_webcams'] = 'Allow webcams';
$string['mute_on_start'] = 'Mute on start';
$string['allow_screen_share'] = 'Allow screen sharing';
$string['allow_rtmp'] = 'Allow RTMP';
$string['allow_view_other_webcams'] = 'Allow view other webcams';
$string['allow_view_other_users_list'] = 'Allow view other users';
$string['admin_only_webcams'] = 'Admin only webcams';
$string['allow_polls'] = 'Allow polls';
$string['room_duration'] = 'Room duration (In minutes, 0 = unlimited)';
$string['moderator_join_first'] = 'Moderator join first';
$string['moderator_join_first_error'] = 'The meeting has not started yet, please come back later';
$string['enable_analytics'] = 'Enable analytics';
$string['allow_virtual_bg'] = 'Allow virtual background';
$string['allow_raise_hand'] = 'Allow raise hand';
$string['auto_gen_user_id'] = 'Auto generate user ID';

$string['other_features'] = 'Advanced features';

$string['recordingfeatures'] = 'Recording features';
$string['allow_recording'] = 'Allow recording';
$string['allow_cloud_recording'] = 'Allow cloud recording';
$string['enable_auto_cloud_recording'] = 'Enable auto start cloud recording';
$string['allow_local_recording'] = 'Allow local recording';
$string['is_allow_view_recording'] = 'Allow students to view recording';
$string['is_allow_download_recording'] = 'Allow students to download recording';

$string['chatfeatures'] = 'Chat features';
$string['allow_chat'] = 'Allow chat';
$string['allow_file_upload'] = 'Allow file upload';

$string['shared_note_pad_features'] = 'Shared notepad features';
$string['allow_shared_notepad'] = 'Allow Shared notepad';

$string['whiteboard_features'] = 'Whiteboard features';
$string['allow_whiteboard'] = 'Allow Whiteboard';

$string['external_media_player_features'] = 'External media player features';
$string['allowed_external_media_player'] = 'Allow external media player';

$string['waiting_room_features'] = 'Waiting room features';
$string['activate_waiting_room'] = 'Activate waiting room';
$string['waiting_room_msg'] = 'Waiting room message';

$string['breakout_room_features'] = 'Breakout room features';
$string['allow_breakout_rooms'] = 'Allow breakout rooms';
$string['allowed_number_rooms'] = 'Number of rooms';

$string['display_external_link_features'] = 'Display external link features';
$string['allow_display_external_link_features'] = 'Allow display external link features';
$string['allow_ingress_features'] = 'Allow to create ingress';

$string['defaultlock'] = 'Default lock settings';
$string['lock_microphone'] = 'Lock microphone';
$string['lock_webcam'] = 'Lock webcam';
$string['lock_screen_sharing'] = 'Lock screen sharing';
$string['lock_whiteboard'] = 'Lock whiteboard';
$string['lock_shared_notepad'] = 'Lock shared notepad';
$string['lock_chat'] = 'Lock chat';
$string['lock_chat_send_message'] = 'Lock send message';
$string['lock_chat_file_share'] = 'Lock file share';
$string['lock_private_chat'] = 'Lock private chat';

$string['available'] = 'Available from';
$string['deadline'] = 'Deadline';

$string['extraoption'] = 'Extra options';

$string['client_load'] = 'Client load from';
$string['client_load_des'] = 'default: remote';
$string['remote'] = 'Remote';
$string['local'] = 'Local';

$string['client_download_url'] = 'Local client download url';
$string['client_download_url_des'] = 'Local client download url. Default github';
$string['update_client_code'] = '<button class="btn btn-sm btn-secondary mb-6" id="updateClient">Download latest client</button>';
$string['error_file_open'] = 'Error in zip file open';
$string['client_updated_success'] = 'Client updated successfully';
$string['client_updated_failed'] = 'Failed to update client';

$string['join'] = 'Join';
$string['end'] = 'End';
$string['recordings'] = 'Recordings';
$string['recording_date'] = 'Recording date';
$string['meeting_date'] = 'Meeting date';
$string['file_size'] = 'File size (MB)';
$string['play'] = 'Play';
$string['download'] = 'Download';
$string['delete'] = 'Delete';
$string['sure_to_delete'] = 'Are you sure to delete?';

$string['design_customization'] = 'Design Customization';
$string['custom_css_url'] = 'Custom CSS URL';
$string['custom_css_url_des'] = 'Should be https direct CSS file url';
$string['primary_color'] = 'Primary Color';
$string['primary_color_des'] = 'Primary Color for interface';
$string['secondary_color'] = 'Secondary Color';
$string['secondary_color_des'] = 'Secondary Color for interface';
$string['background_color'] = 'Background color';
$string['background_color_des'] = 'Interface background color';
$string['background_image'] = 'Background image';
$string['background_image_des'] = 'Should be 1920X1080 in size for best result.';
$string['header_color'] = 'Header Color';
$string['header_color_des'] = 'Interface Header Color';
$string['footer_color'] = 'Footer Color';
$string['footer_color_des'] = 'Interface Footer Color';
$string['left_color'] = 'Left Side Color';
$string['left_color_des'] = 'Left side bar color';
$string['side_panel_bg_color'] = 'Side Panel background color';
$string['side_panel_bg_color_des'] = 'Right side panel background color';
$string['column_camera_position'] = 'Column camera position';
$string['column_camera_position_des'] = 'Column camera position. Default: left';
$string['column_camera_width'] = 'Column camera width';
$string['column_camera_width_des'] = 'Column camera width';

$string['allow_speech_to_text_translation_features'] = 'Allow speech to text/translation features';
$string['allow_speech_translation'] = 'Allow translation';

$string['enable_end_to_end_encryption_features'] = 'Enable End-To-End Encryption (E2EE)';
$string['enabled_self_insert_encryption_key'] = 'Enable manual E2EE key';
$string['included_e2ee_chat_messages'] = "Enable encryption for chat";
$string['included_e2ee_whiteboard'] = "Enable encryption for whiteboard";

$string['sip_dial_in_features'] = "SIP/VoIP dial in features";
$string['sip_dial_in_features_is_allow'] = "Allow SIP/VoIP dial in";
$string['enable_dial_in_on_create'] = "Enable dial in on create";
$string['hide_phone_number'] = "Hide phone number";

$string['insights_features'] = 'Insights AI';
$string['insights_features_is_allow'] = 'Enable insights features';
$string['insights_transcription_features_is_allow'] = 'Allow transcription';
$string['insights_transcription_features_is_allow_translation'] = 'Allow transcription translation';
$string['insights_transcription_features_is_allow_speech_synthesis'] = 'Allow speech synthesis';
$string['insights_chat_translation_features_is_allow'] = 'Allow chat translation';
$string['insights_ai_features_is_allow'] = 'Allow AI features';
$string['insights_ai_text_chat_features_is_allow'] = 'Allow AI text chat';
$string['insights_ai_meeting_summarization_features_is_allow'] = 'Allow AI meeting summarization';
