/**
 * Handle expand/collapse functionality for grouped search results
 *
 * @module     mod_coursesearch/resultgroups
 * @copyright  2025 Yurii Lysak
 * @license    http://www.gnu.org/licenses/gpl-3.0.html GNU GPL v3 or later
 */
define("mod_coursesearch/resultgroups",[],(function(){function toggleGroup(groupElement,expand){const header=groupElement.querySelector(".coursesearch-group-header"),matches=groupElement.querySelector(".coursesearch-group-matches"),toggle=groupElement.querySelector(".coursesearch-group-toggle"),icon=toggle?toggle.querySelector(".icon"):null;if(!header||!matches)return;const isExpanded=!groupElement.classList.contains("coursesearch-group-collapsed");void 0===expand&&(expand=!isExpanded),expand?(groupElement.classList.remove("coursesearch-group-collapsed"),groupElement.classList.add("coursesearch-group-expanded"),header.setAttribute("aria-expanded","true"),matches.setAttribute("aria-hidden","false"),icon&&(icon.classList.remove("fa-chevron-down"),icon.classList.add("fa-chevron-up")),toggle&&toggle.setAttribute("aria-label",toggle.dataset.collapseLabel||"Collapse matches")):(groupElement.classList.remove("coursesearch-group-expanded"),groupElement.classList.add("coursesearch-group-collapsed"),header.setAttribute("aria-expanded","false"),matches.setAttribute("aria-hidden","true"),icon&&(icon.classList.remove("fa-chevron-up"),icon.classList.add("fa-chevron-down")),toggle&&toggle.setAttribute("aria-label",toggle.dataset.expandLabel||"Expand matches"))}function handleGroupToggle(event){const target=event.target,groupElement=target.closest(".coursesearch-result-group");groupElement&&(target.closest("a")||(event.preventDefault(),event.stopPropagation(),toggleGroup(groupElement)))}function handleGroupKeydown(event){if("Enter"===event.key||" "===event.key){if("A"===event.target.tagName)return;event.preventDefault();const groupElement=event.target.closest(".coursesearch-result-group");groupElement&&toggleGroup(groupElement)}}function attachHandlers(){document.querySelectorAll(".coursesearch-result-group").forEach((function(group){if(group.dataset.coursesearchGroupHandler)return;group.dataset.coursesearchGroupHandler="true";const header=group.querySelector(".coursesearch-group-header"),toggle=group.querySelector(".coursesearch-group-toggle");header&&(header.addEventListener("click",handleGroupToggle),header.addEventListener("keydown",handleGroupKeydown));const activityNameSpan=group.querySelector(".coursesearch-group-activity-name");activityNameSpan&&activityNameSpan.addEventListener("keydown",handleGroupKeydown),toggle&&toggle.addEventListener("click",(function(e){e.preventDefault(),e.stopPropagation(),toggleGroup(group)}))}))}return{init:function(){"loading"===document.readyState?document.addEventListener("DOMContentLoaded",attachHandlers):attachHandlers()}}}));

//# sourceMappingURL=resultgroups.min.js.map