/**
 * Handle click interception on search result links
 * Stores highlight data in sessionStorage before navigation
 *
 * @module     mod_coursesearch/resultlinks
 * @copyright  2025 Yurii Lysak
 * @license    http://www.gnu.org/licenses/gpl-3.0.html GNU GPL v3 or later
 */
define("mod_coursesearch/resultlinks",[],(function(){function attachClickHandlers(){document.querySelectorAll(".coursesearch-results a[href]").forEach((function(link){link.dataset.coursesearchHandler||(link.dataset.coursesearchHandler="true",link.addEventListener("click",(function(){const href=this.getAttribute("href");try{const url=new URL(href,window.location.origin),highlight=url.searchParams.get("cs_highlight"),occurrence=url.searchParams.get("cs_occurrence"),highlightAll=url.searchParams.get("cs_highlight_all"),hash=url.hash;let moduleId=null;if(hash){const match=hash.match(/^#module-(\d+)$/);match&&(moduleId=match[1])}if(highlight&&"undefined"!=typeof sessionStorage)try{const safeHighlight=JSON.stringify(highlight);sessionStorage.setItem("coursesearch_highlight",safeHighlight),moduleId&&/^\d+$/.test(moduleId)&&sessionStorage.setItem("coursesearch_moduleId",moduleId),sessionStorage.setItem("coursesearch_timestamp",Date.now().toString()),sessionStorage.setItem("coursesearch_shouldScroll","true"),"1"===highlightAll?sessionStorage.setItem("coursesearch_highlight_all","true"):sessionStorage.removeItem("coursesearch_highlight_all"),null!==occurrence&&"1"!==highlightAll&&/^\d+$/.test(occurrence)?sessionStorage.setItem("coursesearch_occurrence",occurrence):sessionStorage.removeItem("coursesearch_occurrence")}catch(err){}}catch(err){}})))}))}return{init:function(){"loading"===document.readyState?document.addEventListener("DOMContentLoaded",attachClickHandlers):attachClickHandlers()}}}));

//# sourceMappingURL=resultlinks.min.js.map