<?php
// This file is part of the Certify Certificate module for Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Language strings for the certify module
 *
 * @package    mod_certify
 * @subpackage certify
 * @copyright  Certify <dev@certify.one>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['activityname'] = 'Activity name';
$string['additionalactivitiesone'] = 'Warning: You are adding more than one activity to a course.<br/>Both activities are viewable by students, so be sure to give them different names.';
$string['apikeylabel'] = 'API key';
$string['apikeyhelp'] = 'Enter your API key from certify.one';
$string['certify:addinstance'] = 'Add a certificate/badge instance';
$string['certify:manage'] = 'Manage a certificate/badge instance';
$string['certify:student'] = 'Retrieve a certificate or badge';
$string['certify:view'] = 'View a certificate or badge';
$string['certificatename'] = 'Certificate/Badge name';
$string['certificateurl'] = 'Certificate/Badge url';
$string['dashboardlink'] = 'Certify dashboard link';
$string['dashboardlinktext'] = 'To delete or style credentials, log in to the <a href="https://app.certify.one" target="_blank">dashboard</a>';
$string['datecreated'] = 'Date created';
$string['description'] = 'Description';
$string['eventcertificatecreated'] = 'A credential was posted to Certify';
$string['id'] = 'ID';
$string['indexheader'] = 'All certificates/badges for {$a}';
$string['issued'] = 'Issued';
$string['modulename'] = 'Certify Digital Badges';
$string['modulename_help'] = 'The Certify certificate & badge activity module allows you to issue course certificates or badges to students on certify.one.

Add the activity wherever you want your students see their certificate or badge.';
$string['modulename_link'] = 'mod/certify/view';
$string['modulenameplural'] = 'Certify Digital Badges';
$string['nocertificates'] = 'There are no certificates/badges';
$string['pluginadministration'] = 'Certify certificates/badges administration';
$string['pluginname'] = 'Certify Digital Badges';
$string['recipient'] = 'Recipient';
$string['groupselect'] = 'Credential';
$string['viewheader'] = 'Issued Credentials for {$a}';
$string['viewsubheader'] = 'Credential ID: {$a}';
$string['gotodashboard'] = 'To update the appearance of your badges and certificates, visit: <a href="https://app.certify.one" target="_blank">https://app.certify.one</a>';
$string['overview'] = 'Overview';
$string['activitygroupdescription'] = 'Credentials need to have been created in the <a href="{$a}" target="_blank">Certify Dashboard</a> before credentials can be issued. If none appear, check your API Key to make sure integration is set up correctly.';
$string['certifygroup'] = 'Certify Credentials';
$string['privacy:metadata:certify'] = 'In order to integrate with Certify, user data needs to be exchanged with that service.';
$string['privacy:metadata:certify:email'] = 'Your email address is sent to Certify to issue a credential.';
$string['privacy:metadata:certify:fullname'] = 'Your full name is sent to Certify to issue a credential.';
$string['privacy:metadata:certify:quizgrade'] = 'Your quiz grade may be sent to Certify to issue a credential.';
$string['updatecheck'] = 'Certify version update check';
$string['eventcoursemoduleviewed'] = 'Course module viewed';
$string['eventcoursemoduleinstancelistviewed'] = 'Course module instance list viewed';

$string['certificateheading'] = 'Certificate';
$string['badgeheading'] = 'Badge';
$string['certificateimagealt'] = 'Certificate Image';
$string['badgeimagealt'] = 'Badge Image';
$string['certificateviewertitle'] = 'Certificate Viewer';
$string['credentialloaderror'] = 'Certify Package error: Credential page couldn\'t load.';

// Error strings.
$string['getissuederror'] = 'An error occured while fetching the certificates with achievement id = {$a}.

Please contact Certify\'s support';
$string['getcredentialserror'] = 'An error occured while fetching credentials.

Please contact Certify\'s support';
$string['gettemplateserror'] = 'An error occured while fetching certificate templates.

Please contact Certify\'s support';
$string['manualadderror:add'] = 'An error occured while issuing a certificate to Certify for user id = {$a}.

Please contact Certify\'s support.
Error Code: Add001';
$string['manualadderror:edit'] = 'An error occured while issuing a certificate to Certify for user id = {$a}.

Please contact Certify\'s support.
Error Code: Edit001';
$string['errormbstringextension'] = 'You or administrator must install the mbstring PHP extension.';
$string['errordomextension'] = 'You or administrator must install the dom PHP extension.';
$string['errorapikeynotset'] = 'Please set your API Key first in the plugin settings.';
