<?php
// This file is part of Exabis Eportfolio (extension for Moodle)
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.
// (c) 2016 GTN - Global Training Network GmbH <office@gtn-solutions.com>.

$string['translation:language'] = 'German';
$string['translation:person'] = 'Andreas Riepl';
$string['translation:organisation'] = 'GTN GmbH';
$string['translation:email'] = 'ariepl.work@gmail.com';

// === Main ===
// Shown in admin plugin list.
$string['pluginname'] = 'Exabis ePortfolio';
// === Shown in block title and all headers.
$string['blocktitle'] = 'Exabis ePortfolio';
$string['exaport:use'] = 'Nutzung';
$string['exaport:addinstance'] = 'Exabis ePortfolio zum Kurs hinzuf&uumlgen';
$string['exaport:myaddinstance'] = 'Exabis ePortfolie zur Startseite hinzuf&uumlgen';
$string['exaport:export'] = 'Export von SCORM-Files';
$string['exaport:import'] = 'Import von SCORM-Files';
$string['exaport:importfrommoodle'] = 'Import von Moodle';
$string['exaport:shareintern'] = 'Internes Teilen von Views';
$string['exaport:shareextern'] = 'Externes Teilen von Views';
$string['exaport:allowposts'] = 'Kommentare erlauben';
$string['exaport:competences'] = 'Kompetenzen erlauben';
$string['exaport:viewartifactsfromstudents'] = 'Portfolio Artefakte der eigenen SuS sehen';
$string['new'] = 'Neu';
$string['addbookmark'] = 'Bookmark hinzufügen';
$string['addcategory'] = 'Kategorie hinzufügen';
$string['attachment'] = 'Anhang';
$string['attachincluded'] = 'Anhang?';
$string['awaiting'] = '(\\$a wartend)';
$string['back'] = 'zurück';
$string['close'] = 'Schließen';
$string['backtocourse'] = 'zurück zum Kurs';
$string['categories'] = 'Kategorien';
$string['explaincategories'] = '<span class=\'block_eportfolio_bold\'>Kategorien:</span> hier kannst du die Kategorien einsehen und bearbeiten.';
$string['category'] = 'Kategorie';
$string['categoryhead'] = 'Bezeichnung der Kategorie';
$string['categorysaved'] = 'Kategorie hinzugefügt.';
$string['categoryedited'] = 'Kategorie gespeichert.';
$string['categorydeleted'] = 'Kategorie gel&ouml;scht.';
$string['date'] = 'Datum';
$string['dontincludeurl'] = 'Diese Option ausw&auml;hlen um die Verknüpfung zwischen Bookmark und URL aufzuheben';
$string['duplicatedurl'] = 'Diese URL ist bereits bei den Bookmarks vorhanden.';
$string['editcategories'] = 'Kategorien bearbeiten';
$string['explaining'] = 'Das ePortfolio-System kann verwendet werden um Webadressen, Dateien, Notizen und Kommentare zu verwalten.';
$string['explainingmoredata'] = '<strong>Dies ist dein Bereich, um Belege für deinen Lernweg zu sammeln.</strong>
			<ul>
				<li><strong>Füge deine besten Arbeiten hinzu:</strong> Lade Dateien, Weblinks oder Beschreibungen von Projekten, Präsentationen und mehr hoch.</li>
				<li><strong>Reflektiere über deine Erfahrungen:</strong> Erkläre, was du gelernt hast, welche Herausforderungen du bewältigt hast und deine Erfolge für jeden Eintrag.</li>
			</ul>
			<strong>Betrachte jeden Eintrag als eine Art Geschichte, die deine Fähigkeiten und dein Wissen beschreibt.</strong>';
$string['explaininglink'] = '<span class=\'block_eportfolio_bold\'>Externe Links:</span> diese Links k&ouml;nnen mit anderen Kursteilnehmer:innen ausgetauscht werden.';
$string['explainingfile'] = '<span class=\'block_eportfolio_bold\'>Dateien:</span> diese Dateien k&ouml;nnen mit anderen Kursteilnehmer:innen ausgetauscht werden.';
$string['explainingnote'] = '<span class=\'block_eportfolio_bold\'>Notizen:</span> diese Notizen k&ouml;nnen mit anderen Kursteilnehmer:innen ausgetauscht werden.';
$string['explainingshare'] = 'Um einem/einer anderen Teilnehmer:in den Link zu ver&ouml;ffentlichen, klicke auf den jeweiligen Namen und speichere dann die &Auml;nderungen.  Du kannst mehr als eine/n Teilnehmer:in ausw&auml;hlen.';
$string['explainingshared'] = 'Folgende Teilnehmer:innen haben ver&ouml;ffentlichte Links, Dateien bzw. Notizen.';
$string['explainingsharefile'] = 'Um einem/einer anderen Teilnehmer:in die Datei zu ver&ouml;ffentlichen, klicke auf den jeweiligen Namen und speichere dann die &Auml;nderungen.  Du kannst mehr als eine/n Teilnehmer:in ausw&auml;hlen.';
$string['explainingsharenote'] = 'Um einem/einer anderen Teilnehmer:in die Notiz zu ver&ouml;ffentlichen, klicke auf den jeweiligen Namen und speichere dann die &Auml;nderungen.  Du kannst mehr als eine/n Teilnehmer:in ausw&auml;hlen.';
$string['file'] = 'Datei';
$string['iconfile'] = 'Miniaturansicht';
$string['iconfile_merge'] = 'Symbol mit Ordner-Symbol kombinieren';
$string['iconfile_merge_description'] = 'Symbolbild verknüpft sich mit dem Ordner-Symbol.';
$string['firstnameshared'] = 'Familienname';
$string['go'] = 'Go!';
$string['hidesummary'] = '(Gesamtaufstellung ausblenden)';
$string['managecategories'] = 'Kategorien verwalten';
$string['mandatoryfields'] = 'Eine Kategorienbezeichnung und eine kurze Beschreibung ist erforderlich. Bitte fülle beides aus.';
$string['mandatoryfieldsforcat'] = 'Eine Feldbezeichnung ist erforderlich. Bitte fülle diese aus.';
$string['myportfolio'] = 'Meine Portfolio Artefakte';
$string['myportfoliotitle'] = 'ePortfolio-Modul: Füge hier Links und Dateien hinzu.';
$string['newlink'] = 'Neuen externen Link hinzufügen';
$string['newfile'] = 'Neue Datei hinzufügen';
$string['newnote'] = 'Neue Notiz hinzufügen';
$string['nocategories'] = '(bisher gibt es noch keine Kategorien)';
$string['nobookmarksall'] = '(bisher gibt es noch keine Eintr&auml;ge)';
$string['nobookmarkslink'] = '(bisher gibt es noch keine Links)';
$string['nobookmarksfile'] = '(bisher gibt es noch keine Dateien)';
$string['nobookmarksnote'] = '(bisher gibt es noch keine Notizen)';
$string['noentry'] = 'Kein Eintrag';
$string['note'] = 'Notiz';
$string['notetitle'] = 'Notiz';
$string['shared_views'] = 'Geteilte Views';
$string['showall'] = 'auch andere Kurse anzeigen';
$string['showcourse'] = 'nur diesen Kurs anzeigen';
$string['showsummary'] = '(Gesamtaufstellung einblenden)';
$string['strshare'] = 'Ver&ouml;ffentlichen';
$string['strunshare'] = 'Ver&ouml;ffentlichung zurücknehmen';
$string['summary'] = 'Gesamtaufstellung (optional)';
$string['url'] = 'URL';
$string['maincategory'] = 'Hauptkategorie';
$string['subcategory'] = 'Unterkategorie';
$string['accessoptions'] = 'Wer hat Zugriff?';
$string['shareallexceptthose'] = 'Zugriff für <span class=\'block_eportfolio_bold\'>alle</span> (auch jene, die hier nicht angezeigt werden) au&szlig;er folgenden Benutzern';
$string['sharenoneexceptthose'] = 'Zugriff für <span class=\'block_eportfolio_bold\'>keine</span> au&szlig;er folgende Benutzer';
$string['internalaccessall'] = 'Zugriff für <span class=\'block_eportfolio_bold\'>alle</span>';
$string['internalaccessusers'] = 'Zugriff nur für folgende Benutzer';
$string['internalaccessgroups'] = 'Zugriff für folgende Gruppen';
$string['externaccess'] = 'externer ePortfolio-Link';
$string['emailaccess'] = 'Per Email teilen';
$string['emailaccessdescription'] = 'Gib eine Email Adresse pro Zeile ein<br />Jede Adresse erhält einen eindeutigen Link mit Zugriff auf diese View. Das Löschen der Adresse löscht den Zugriff auf diese View.';
$string['emailaccessmessagesubject'] = 'Ein ePortfolio wurde mit dir geteilt';
$string['emailaccessmessage'] = 'Hallo! {$a->sendername} hat das ePortfolio "{$a->viewname}" mit dir geteilt. Es kann hier abgerufen werden: {$a->url}';
$string['emailaccessmessageHTML'] = 'Hallo!<br />{$a->sendername} hat das ePortfolio "{$a->viewname}" mit dir geteilt.<br />Sie ist kann <a href="{$a->url}">hier</a> aberufen werden';

// 'emailaccessmessagesubject_updatedview' => [
//     'Ich habe ein Eportfolio aktualisiert, welches ich mit Ihnen geteilt habe',
//     'I updated an eportfolio view I shared with you',
// ],
$string['emailaccessmessagesubject_updatedview'] = '{$a->sendername} hat Änderungen an einem E-Portfolio vorgenommen, das mit Ihnen geteilt ist.';
$string['emailaccessmessage_updatedview'] = 'Hallo! {$a->sendername} hat das ePortfolio "{$a->viewname}", welches er mit dir geteilt hat, aktualisiert. Es kann hier abgerufen werden: {$a->url}';
$string['emailaccessmessageHTML_updatedview'] = 'Hallo!<br />{$a->sendername} hat das ePortfolio "{$a->viewname}", welches er mit dir geteilt hat, aktualisiert.<br />Sie ist kann <a href="{$a->url}">hier</a> aberufen werden';
$string['showallusers'] = 'Zeige Benutzer aller meiner Kurse';
$string['showcourseusers'] = 'Zeige nur Benutzer des aktuellen Kurses';
$string['sharedpersons'] = 'Personen mit ver&ouml;ffentlichten Portfolios';
$string['moodleimport'] = 'Import aus Moodle-Aufgaben';
$string['nomoodleimportyet'] = 'Im Moment sind noch keine Abgaben vorhanden!';
$string['deletecategoryconfirm'] = 'Willst du die Kategorie "{$a->name}" wirklich l&ouml;schen? Es werden alle Eintr&auml;ge in dieser Kategorie und alle Unterkategorien mitgel&ouml;scht!';
$string['name'] = 'Name';
$string['role'] = 'Rolle';
$string['nousersfound'] = 'Keine Benutzer gefunden';
$string['delete'] = 'L&ouml;schen';
$string['add'] = 'Hinzufügen';
$string['edit'] = 'Editieren';
$string['checkall'] = 'Alle auswählen';
$string['grouptitle'] = 'Gruppentitel';
$string['membercount'] = 'Anzahl von Mitgliedern';
$string['nogroupsfound'] = 'Keine Gruppen gefunden';
$string['make_it_yours'] = 'Mach\' es zu deinem Eigenen';

// === Export/import.
$string['import'] = 'Import SCORM-Datei';
$string['import_short'] = 'Import';
$string['explainexport'] = '<span class=\'block_eportfolio_center\'><span class=\'block_eportfolio_bold\'>Export:</span> hier kannst du dein ePortfolio exportieren</span>';
$string['createexport'] = 'SCORM-Datei erstellen';
$string['createexportxapi'] = 'XAPI-Datei erstellen';
$string['clicktodownloadscorm'] = 'Folgenden Button drücken, um SCORM-Datei herunterzuladen:';
$string['add_directory_structure'] = 'Mit Unterverzeichnissen exportieren';
$string['download'] = 'Herunterladen';
$string['endedit'] = 'Editieren beenden';
$string['change'] = '&auml;ndern';
$string['explainpersonal'] = '<span class=\'block_eportfolio_bold\'>Pers&ouml;nliche Informationen</span>';
$string['personal'] = 'Informationen';
$string['descriptionsaved'] = 'Beschreibung gespeichert';
$string['course'] = 'Kurs';
$string['importexport'] = 'Import/Export';
$string['explainimport'] = 'hier kannst du SCORM-Dateien ins Portfolio importieren. Wenn Marker gefunden werden, die darauf hinweisen, dass diese SCORM-Datei zuvor aus dem Portfolio-Modul exportiert wurde, so wird versucht, die Struktur entsprechend zu importieren.';
$string['makeimport'] = 'Import';
$string['add_this_file'] = 'Diese Datei hinzufügen';
$string['bookmarksall'] = 'Alle Eintr&auml;ge';
$string['bookmarkslinks'] = 'Links';
$string['bookmarksfiles'] = 'Dateien';
$string['bookmarksnotes'] = 'Notizen';
$string['noguestpost'] = 'G&auml;ste haben hier keinen Zugriff!';
$string['comments'] = 'Kommentare';
$string['addcomment'] = 'Kommentar hinzufügen';
$string['externcomment'] = 'Kommentare mitver&ouml;ffentlichen';
$string['itemgrading'] = 'Beurteilung';
$string['gradeitem'] = 'Abgabe beurteilen';
$string['submititem'] = 'Abgeben';
$string['saveitem'] = 'Speichern';

// === Notes.
$string['deletenoteconfirm'] = 'Möchtest du diese Notiz wirklich l&ouml;schen?';
$string['deletelinkconfirm'] = 'Möchtest du diesen Link wirklich l&ouml;schen?';
$string['deletefileconfirm'] = 'Möchtest du diese Datei wirklich l&ouml;schen?';

// === Different.
$string['couldninsertcomment'] = 'Kommentar konnte nicht eingefügt werden!';
$string['importedcommentsstart'] = 'Importierte Kommentare:<br /><br />';
$string['importedcommentsend'] = 'Ende importierte Kommentare';
$string['filetypenotdetected'] = 'Filetyp von $a->filename ($a->title) konnte nicht ermittelt werden. Datei wurde nicht importiert!';
$string['linkedfilenotfound'] = 'Datei $a->filename in $a->url ($a->title) wurde nicht gefunden. Datei wurde nicht importiert!';
$string['couldntinsert'] = 'Konnte $a nicht in der Datenbank einfügen';
$string['couldntcreatedirectory'] = 'Verzeichnis konnte nicht erstellt werden';
$string['couldntcopyfile'] = 'Konnte Datei $a nicht kopieren! Datei wurde nicht importiert!';
$string['success'] = 'Datei erfolgreich importiert';
$string['couldntinsertcategory'] = 'Kategorie konnte nicht eingefügt werden!';
$string['couldntupdatecategory'] = 'Kategorie konnte nicht aktualisiert werden!';
$string['couldntextractscormfile'] = 'SCORM-Datei konnte nicht extrahiert werden!';
$string['couldntcreatetempdir'] = 'Tempor&auml;res Verzeichnis konnte nicht erstellt werden.!';
$string['scormhastobezip'] = 'SCORM-Datei muss im zip-Format vorliegen!';
$string['uploadfailed'] = 'Upload nicht erfolgreich!';
$string['couldntupdatedesc'] = 'Beschreibung konnte nicht aktualisiert werden!';
$string['couldntinsertdesc'] = 'Beschreibung konnte nicht eingefügt werden!';
$string['exportcomment'] = 'Das ist eine exportierte Datei von exabis ePortfolio. Bitte entferne die Kommentare nicht, da sie sonst nicht mehr mitimportiert werden k&ouml;nnen!';
$string['comment'] = 'Kommentar';
$string['commentshouldnotbeempty'] = 'Der Kommentar darf nicht leer sein.';
$string['title'] = 'Titel';
$string['titlenotemtpy'] = 'Der Titel darf nicht leer sein.';
$string['intro'] = 'Inhalt';
$string['shortdescription'] = 'Kurzbeschreibung';
$string['project_description'] = 'Der Grund hinter diesem Projekt';
$string['project_process'] = 'Umsetzung des Projekts';
$string['project_result'] = 'Ergebnisse und Erkenntnisse';
$string['intronotempty'] = 'Der Inhalt darf nicht leer sein.';
$string['link'] = 'Link';
$string['mixed'] = 'Artefakte';
$string['add_mixed'] = 'Neue Artefakte';
$string['categorynotempty'] = 'Es muss eine Kategorie ausgew&auml;hlt sein.';
$string['urlnotempty'] = 'Die URL darf nicht leer sein.';
$string['selectall'] = 'Alle markieren';
$string['deselectall'] = 'Alle Markierungen l&ouml;schen';
$string['internalaccess'] = 'Interner Zugriff';
$string['externalaccess'] = 'Externer Zugriff';
$string['loginasmode'] = 'Du hast als Administrator keine Zugriff auf fremde Portfolios';
$string['badsessionkey'] = 'Session nicht mehr gültig';
$string['invalidinstance'] = 'Ungültige Instanz';
$string['invalidcourseid'] = 'Ungültige Kursnummer';
$string['wronglinkid'] = 'Falsche Link-Id';
$string['incorrectlinksid'] = 'Falsche Links-Post Id';
$string['incorrectnoteid'] = 'Falsche Notizen Id';
$string['unknownaction'] = 'Unbekannte Aktion';
$string['filenotfound'] = 'Datei nicht gefunden';
$string['wrongfileid'] = 'Falsche Datei Id';
$string['wrongfilepostid'] = 'Falsche Datei-Post Id';
$string['wrongnoteid'] = 'Falsche Notiz Id';
$string['wrongnotepostid'] = 'Falsche Notiz-Post Id';
$string['bookmarknotfound'] = 'Bookmark nicht gefunden';
$string['commentnotfound'] = 'Kommentar nicht gefunden';
$string['updateposterror'] = 'Posting konnte in Datenbank nicht aktualisiert werden';
$string['deleteposterror'] = 'Fehler beim L&ouml;schen des Postings';
$string['addposterror'] = 'Posting konnte in Datenbank nicht hinzugefügt werden';
$string['invalidassignmentid'] = 'Falsche Abgabe-Id';
$string['invalidfileatthisassignment'] = 'Datei existiert nicht zu dieser Abgabe!';
$string['publishedportfolios'] = 'Ver&ouml;ffentliche Portfolios';
$string['viewcategories'] = 'Kategorien verwalten';
$string['updownarrow'] = 'Pfeil nach oben/nach unten';
$string['comment_delete_confirmation'] = 'Willst du wirklich diesen Kommentar löschen?';

// Shared portfolios.
$string['nocoursetogether'] = 'Kein Kurs';
$string['nothingshared'] = 'Kein freigegebenen ePortfolios gefunden';

// === Errors.
$string['nouserforid'] = 'Kein Benutzer zu dieser Id!';
$string['nouserforaccess'] = 'Benutzer nicht gefunden (Zugriffscode unbekannt)';

// === Export.
$string['export'] = 'Export SCORM-Datei';
$string['export_short'] = 'Export';
$string['exportepx'] = 'Export EPX-Datei';
$string['createepxexport'] = 'EPX-Datei erstellen';
$string['exportviewselect'] = 'Um alle Einträge einer bestimmten View zu exportieren, bitte diese hier w&auml;hlen';
$string['export_directory'] = 'Exportiere Ordnerstruktur';
$string['createexport_directory'] = 'Erstelle Ordnerstruktur';

// === Stuff.
$string['type'] = 'Typ';
$string['share'] = 'Share';
$string['explainingall'] = 'Alle Eintr&auml;ge im Portfolio';
$string['share_to_other_users'] = 'Benutzer suchen';
$string['other_users_course'] = 'Benutzer, die nicht in meinen Kursen sind';
$string['other_groups_course'] = 'Andere Kurse';

// === Item sorting.
$string['userdefinedsort'] = 'Eigene Sortierung vornehmen';
$string['movetop'] = 'An erste Stelle';
$string['movebottom'] = 'An letzte Stelle';

// === Views.
$string['view'] = 'View';
$string['views'] = 'Meine Views';
$string['explainingviews'] = 'View verwalten';
$string['noviews'] = 'Bitte Views anlegen';
$string['viewnotfound'] = 'Das Objekt ist für den Benutzer nicht einsehbar / Keine Zugriffsberechtigung.';
$string['newview'] = 'Neue View erstellen';
$string['viewinformation'] = 'View Informationen';
$string['viewdescription'] = 'Beschreibung';
$string['viewdesign'] = 'View Darstellung';
$string['viewitems'] = 'Deine Eintr&auml;ge';
$string['viewitem'] = 'Eintrag';
$string['view_specialitems'] = 'Spezielle Eintr&auml;ge';
$string['view_specialitem_headline'] = 'Kopfzeile';
$string['view_specialitem_personal'] = 'Persönliche Information';
$string['view_specialitem_text'] = 'Text';
$string['view_specialitem_text_help'] = 'Der Block mit individuellem Text. Du kannst den Text nach Belieben formatieren.';
$string['view_specialitem_media'] = 'Medieneintrag';
$string['view_specialitem_badge'] = 'Badge';
$string['view_specialitem_headline_defaulttext'] = 'Kopfzeile hier eingeben';
$string['view_specialitem_text_defaulttext'] = 'Text hier eingeben';
$string['view_sharing'] = 'Ver&ouml;ffentlichen';
$string['viewand'] = 'und';
$string['view_sharing_noaccess'] = 'Kein Zugriff';
$string['show'] = 'Anzeigen';
$string['thiscourse'] = 'Aktueller Kurs';
$string['othercourses'] = 'Andere Kurse';
$string['autofillview'] = 'Alle bestehenden Artefakte in diese View einfügen';
$string['sharetoteacher'] = 'Sofort mit allen Kurs-Trainer/:innen teilen';
$string['createpage'] = 'Zieh das Elemente in das Feld unterhalb, um deinen Inhalt zu erstellen.';
$string['chooselayout'] = 'W&aumlhle ein Layout für deinen View.';
$string['viewtitle'] = 'Titel und Beschreibung';
$string['viewcontent'] = 'Inhalt';
$string['viewlayout'] = 'Layout';
$string['viewshare'] = 'Teilen';
$string['viewlayoutgroup1'] = '1 Spalte';
$string['viewlayoutgroup2'] = '2 Spalten';
$string['viewlayoutgroup3'] = '3 Spalten';
$string['viewlayoutgroup4'] = '4 Spalten';
$string['viewlayoutgroup5'] = '5 Spalten';
$string['viewlayout1'] = 'Gleiche Breite';
$string['viewlayout2'] = 'Gleiche Breite';
$string['viewlayout3'] = 'Linke Spalte breiter';
$string['viewlayout4'] = 'Rechte Spalte breiter';
$string['viewlayout5'] = 'Gleiche Breite';
$string['viewlayout6'] = 'Mittlere Spalte breiter';
$string['viewlayout7'] = 'Mittlere Spalte viel breiter';
$string['viewlayout8'] = 'Gleiche Breite';
$string['viewlayout9'] = 'Mittlere Spalte breiter';
$string['viewlayout10'] = 'Gleiche Breite';
$string['personalinformation'] = 'Persönliche Information';
$string['personalinformation_help'] = 'Der Block mit deinen persönlichen Daten, wie: Name, E-Mail.<br><a href=\'{$a}\' target=\'_blank\' class=\'external-link\'>Profil anzeigen</a></a>';
$string['cvinformation'] = 'Lebenslauf Information';
$string['cvinformation_help'] = 'Der Block mit deinen exabis ePortfolio-Lebenslaufdaten, wie: Ausbildung, Beschäftigung usw.<br><a href=\'{$a}\' target=\'_blank\' class=\'external-link\'>Lebenslauf anzeigen</a>';
$string['cvgroup'] = 'Lebenslauf';
$string['headertext'] = 'Kopfzeile';
$string['headertext_help'] = 'Der einfache Block zum Hinzufügen einer einzigen Überschriftzeile';
$string['item'] = 'Artefakt';
$string['items'] = 'Artefakte';
$string['items_help'] = 'Der Block mit deinen Artefakten<br><a href=\'{$a}\' target=\'_blank\' class=\'external-link\'>Deine Artefakte anzeigen</a>';
$string['media'] = 'Medieneintrag';
$string['media_help'] = 'Der Block mit eingebetteten Mediendaten von Quellen wie: YouTube, Vimeo, SlideShare usw.';
$string['fieldstoshow'] = 'Anzuzeigende Felder';
$string['listofartefacts'] = 'W&aumlhle ein Element aus';
$string['listofbadges'] = 'Liste von Badges';
$string['addButton'] = 'Hinzufügen';
$string['saveButton'] = 'Speichern';
$string['saveViewShareSettingsButton'] = 'Portfolio teilen';
$string['saveViewButton'] = 'Portfolio speichern';
$string['saveAndNotifyButton'] = 'Portfolio speichern und Benachrichtigungen senden';
$string['cancelButton'] = 'Abbrechen';
$string['blocktitle2'] = 'Blocktitel';
$string['blockcontent'] = 'Blockinhalt';
$string['firstname'] = 'Vorname';
$string['lastname'] = 'Nachname';
$string['profilepicture'] = 'Profilbild';
$string['nopicture'] = 'kein Bild';
$string['noprofilepicture'] = 'kein Bild verfügbar';
$string['mailadress'] = 'E-Mail-Adresse';
$string['nomail'] = 'keine Mail-Adresse';
$string['noemails'] = 'keine Mail-Adresse vorhanden';
$string['aboutme'] = 'Über mich';
$string['aboutme_description'] = 'Vordefiniert durch Lebenslaufinformationen, kann jedoch für jeden Block bearbeitet werden.';
$string['notify'] = 'Benachrichtigen';
$string['sharejs'] = 'teilen';
$string['viewmustbesafed'] = 'Vorausgewählt auf Grund globaler Einstellungen. Das Portfolio muss gespeichert werden, bevor diese Benachrichtigen-Einstellung wirksam wird';
$string['mediacontent'] = 'URL oder eingebetteter Code*';
$string['height'] = 'H&ouml;he';
$string['width'] = 'Breite';
$string['media_allowed_notes'] = 'URLs der folgenden Seiten sind erlaubt:';
$string['filterByTag'] = 'Tag zum Filtern verwenden';
$string['tagarea_block_exaportitem'] = 'Meine Portfolio Artefakte';
$string['searchByTitle'] = 'Suchen';
$string['clearAllFilers'] = 'Alle Filter zurücksetzen';
$string['sharedwith'] = 'Geteilt mit';
$string['sharedwith_user_cnt'] = 'Mit {$a} Benutzern geteilt';
$string['sharedwith_onlyme'] = 'Nur mit mir geteilt';
$string['sharedwith_shareall'] = 'Mit allen Benutzer::innen geteilt';
$string['sharedwith_shareexternal'] = 'Geteilte externe Views';
$string['sharedwith_group'] = 'Mit meiner Gruppe geteilt';
$string['sharedwith_group_cnt'] = 'Mit {$a} Gruppe geteilt';

// === Copy to course.
$string['filecopiedtocourse'] = 'Datei wurde in den Kurs $a->coursename unter dem Namen $a->filename kopiert';
$string['copyitemtocourse'] = 'In Kurs kopieren';
$string['desp_language'] = 'Desp Sprache';
$string['cofigureblock'] = 'Konfigurationsblock';
$string['selectitems'] = 'W&aumlehle Elemente aus';
$string['cofigureblock_text'] = 'Text';
$string['cofigureblock_header'] = 'Konfiguration der Kopfzeile';
$string['cofigureblock_item'] = 'Auswahl der Artefakte';
$string['cofigureblock_media'] = 'Medieneintrag';
$string['cofigureblock_personalinfo'] = 'Pers&ouml;nliche Information';
$string['cofigureblock_cvinfo'] = 'Lebenslauf Information';
$string['cofigureblock_badge'] = 'Badges auswählen';
$string['cofigureblock_cvinfo_education_history'] = 'Bildungs-Karriere';
$string['cofigureblock_cvinfo_employment_history'] = 'Bildungs-Karriere';
$string['cofigureblock_cvinfo_certif'] = 'Zertifikate, Akkreditierungen, Auszeichnungen';
$string['cofigureblock_cvinfo_public'] = 'Bücher und Publikationen';
$string['cofigureblock_cvinfo_mbrship'] = 'Mitgliedschaften';
$string['cofigureblock_cvinfo_goals'] = 'Meine Ziele';
$string['cofigureblock_cvinfo_skills'] = 'Meine Kompetenzen';
$string['cofigureblock_cvinfo_interests'] = 'Interessen';
$string['in'] = 'at';
$string['cofigureblock_cvinfo_withfiles'] = 'mit Anhängen publizieren';
$string['configureblock_cvinfo_group_by_category'] = 'Lebenslaufelemente in Kategorien anzeigen';

// === Desp.
$string['back_to_desp'] = 'zurück zum d-ESP';
$string['desp_pluginname'] = 'Dossier';
$string['steckbrief'] = 'Steckbrief';
$string['desp_categories'] = '
    Erzählungen, Rollenspielszenen, Gedichte, Collagen
    Lebenslauf
    Berichte über Theateraufführungen, Ausstellungen
    Berichte über Projekte, Projektreflexionen
    Audio- und Videoclips
    Begegnungen durch Reisen in andere Länder
    Überlegungen zu deinem Sprachenlernen
    Zeugnisse
    Zertifikate
    Bestätigungen
    Hören
    Einzelarbeit
    Partnerarbeit
    Gruppenarbeit
    Lesen
    Einzelarbeit
     - Partnerarbeit
     - Gruppenarbeit
    An Gesprächen teilnehmen
     - Einzelarbeit
     - Partnerarbeit
     - Gruppenarbeit
    Zusammenhängend sprechen
     - Einzelarbeit
     - Partnerarbeit
     - Gruppenarbeit
    Schreiben
     - Einzelarbeit
     - Gruppenarbeit
     - Partnerarbeit
';

// === Config.
$string['config_feature_copy_to_course'] = 'Schüler dürfen Dateien in den Kurs kopieren';
$string['competenceinteraction'] = 'Interaktion mit Block Exabis Competence Grid, falls dieser installiert ist, zulassen.';
$string['opencomps'] = 'Kompetenzen auswählen';
$string['selectcomps'] = 'W&auml;hle hier die Kompetenzen, die zu deinem Upload passen!';
$string['competences_old_version'] = 'Auf diesem Moodle ist eine alte Version von Exabis Competences installiert. Diese wird von Exabis Eportfolio nicht mehr unterstützt.';
$string['expandcomps'] = 'Alle &ouml;ffnen';
$string['contactcomps'] = 'Alle schlie&szlig;en';
$string['studentcomps'] = 'Hier kannst du einsch&auml;tzen, ob folgende Kompetenzen durch Dein Artefakt erreicht wurden.';
$string['teachercomps'] = 'Hier kannst du beurteilen, ob die Lernenden folgende Kompetenzen durch Artefakte erreicht haben.';
$string['competences'] = 'Kompetenzen';
$string['desp_einleitung'] = 'Hier ist nun meine Sammelmappe, mein Dossier. Hier kann ich anderen zeigen, was ich alles gemacht habe. Ich kann genau sehen, wie viel ich schon gelernt habe.';
$string['settings_interaktion_exacomp_head'] = 'Interaktion exabis ePortfolio - Exabis Competence Grid';
$string['settings_interaktion_exacomp_body'] = 'Interaktion mit Block Exabis Competence Grid, falls dieser installiert ist, zulassen.';
$string['settings_allow_loginas_head'] = '"Login als" erlauben';
$string['settings_allow_loginas_body'] = '';
$string['settings_create_desp_categories_head'] = 'Create Desp Categories';
$string['settings_create_desp_categories_body'] = '';
$string['settings_disable_shareall_head'] = 'Mit allen Benutzer::innen teilen deaktivieren';
$string['settings_disable_shareall_body'] = 'Klicke <a href="{$a}">hier</a> um alle globalen Freigaben zu löschen';
$string['settings_disable_externaccess_head'] = 'Teilen Option "Externer Zugriff" auf Portfolios deaktivieren.';
$string['settings_disable_externaccess_body'] = '';
$string['settings_disable_shareemails_head'] = 'Teilen Option "Per E-Mail teilen" von Portfolios deaktivieren.';
$string['settings_disable_shareemails_body'] = '';
$string['settings_disable_external_comments_head'] = 'Teilen von Kommentaren in externen Views deaktivieren';
$string['settings_disable_external_comments_body'] = '';
$string['block_exaport_app_externaleportfolio_head'] = 'Dateien in Mahara speichern';
$string['block_exaport_app_externaleportfolio_body'] = 'App: Setze das Häkchen um Dateien in Mahara zu speichern, ansonsten werden Datein im exabis ePortfolio hinterlegt.';
$string['block_exaport_maxbytes'] = 'Maximale Upload-Dateigröße in Exabis ePortfolio';
$string['block_exaport_maxbytes_body'] = 'Maximale Dateigröße, die Dateien haben können, die im Exabis ePortfolio hochgeladen werden. <br> Wert für diese Seite ist: {$a->sitemaxbytes}. Siehe <a href="{$a->settingsurl}">Einstellungen</a>';
$string['block_exaport_userquota'] = 'Benutzer-Dateikontingent Exabis ePortfolio';
$string['block_exaport_userquota_body'] = 'Maximale Anzahl an Bytes, die ein Benutzer im Exabis ePortfolio hochladen kann. <br> Wert für diese Seite ist: {$a->bytes}. Siehe <a href="{$a->settingsurl}">Einstellungen</a>';
$string['block_exaport_multiplefilesinitem'] = 'Mehrere Dateien in Datei-Artefakt hochladen';
$string['block_exaport_multiplefilesinitem_body'] = 'limit: 10 Dateien';
$string['block_exaport_copytomyportfolio'] = 'Aktiviere "In mein Portfolio kopieren"';
$string['block_exaport_copytomyportfolio_body'] = 'Benutzer können Artefakte aus einer geteilten Kategorie in ihr eigenes Portfolio kopieren.';
$string['block_exaport_app_alloweditdelete_head'] = 'Schüler/:innen dürfen trotz Lehrerbeurteilungen ePortfolio Items editieren und löschen';
$string['block_exaport_app_alloweditdelete_body'] = 'Nur in Kombination mit Exabis Competence Grid und Dakora sinnvoll';
$string['delete_all_shareall'] = 'Alle globalen Freigaben "shareall" löschen?';
$string['block_exaport_teachercanseeartifactsofstudents_head'] = 'Trainer/in hat Zugriff auf alle Artefakte eigene Schüler/:innen';
$string['block_exaport_teachercanseeartifactsofstudents_body'] = 'Vertrauenswürdige Trainer/:innen müssen im jeweiligen Profil als solche definiert werden. Dies funktioniert nur, wenn obige Option aktiviert ist.<br />{$a}Die Liste der Teilnehmer/:innen für jede/n als vertrauenswürdig definierte/n Trainer/in generiert sich automatisch durch Kurseinschreibungen<br />Teilnehmer/:innen können diesen Zugriff nicht deaktivieren. Dies hat keine Auswirkungen auf die Gewährung von Zugriffen für andere Teilnehmer/:innen.';
$string['block_exaport_teachercanseeartifactsofstudents_configurationlink'] = 'erforderliches Profilfeld für vertrauenswürdigen Trainer erstellen';
$string['block_exaport_confirm_profilefield_create'] = 'Willst du wirklich das Profilfeld für vertrauenswürdige Trainer erstellen?';
$string['block_exaport_confirm_profilefield_exists'] = 'Das erforderliche Feld existiert bereits';
$string['block_exaport_profilefield_created'] = 'Das erforderliche Feld wurde hinzugefügt';

// === Resume.
$string['resume_template_newresume'] = '<h2>Mein Lebenslauf</h2>';
$string['resume_my'] = 'Mein Lebenslauf';
$string['resume_cover'] = 'Begleit-Informationen';
$string['resume_coversaved'] = 'Begleit-Informationen gespeichert';
$string['resume_eduhistory'] = 'Bildungs-Karriere';
$string['resume_edu'] = 'Bildung';
$string['resume_edusaved'] = 'Bildungsverlauf gespeichert';
$string['resume_deleteeduconfirm'] = 'Willst du wirklich den Eintrag löschen?';
$string['resume_edudeleted'] = 'Eintrag gelöscht';
$string['resume_employhistory'] = 'Beschäftigungs-Historie';
$string['resume_employ'] = 'Beschäftigung';
$string['resume_employsaved'] = 'Beschäftigung gespeichert';
$string['resume_deleteemployconfirm'] = 'Willst du wirklich den Eintrag löschen?';
$string['resume_employdeleted'] = 'Beschäftigung gelöscht';
$string['resume_interests'] = 'Interessen';
$string['resume_interestssaved'] = 'Interessen gespeichert';
$string['resume_startdate'] = 'Start-Datum';
$string['resume_enddate'] = 'End-Datum';
$string['resume_institution'] = 'Bildungseinrichtung';
$string['resume_institutionaddress'] = 'Adresse der Bildungseinrichtung';
$string['resume_qualification'] = 'Qualifikation';
$string['resume_qualtype'] = 'Art der Qualifikation';
$string['resume_qualname'] = 'Bezeichnung der Qualifikation';
$string['resume_qualdescription'] = 'Beschreibung der Qualifikation';
$string['resume_files'] = 'Anhang';
$string['resume_employer'] = 'Arbeitgeber';
$string['resume_employeraddress'] = 'Adresse des Arbeitgebers';
$string['resume_jobtitle'] = 'Job-Titel';
$string['resume_position'] = 'Position';
$string['resume_positiondescription'] = 'Beschreibung der Position';
$string['resume_certif'] = 'Zertifikate, Akkreditierungen, Auszeichnungen';
$string['resume_date'] = 'Datum';
$string['resume_title'] = 'Title';
$string['resume_description'] = 'Beschreibung';
$string['resume_certifsaved'] = 'Zertifikat, Akkreditierung bzw. Auszeichnung gespeichert';
$string['resume_deletecertifconfirm'] = 'Willst du wirklich den Eintrag löschen?';
$string['resume_certifdeleted'] = 'Zertifikat, Akkreditierung bzw. Auszeichnung gelöscht';
$string['resume_public'] = 'Bücher und Publikationen';
$string['resume_contribution'] = 'Beiträge';
$string['resume_contributiondetails'] = 'Details zum Beitrag';
$string['resume_url'] = 'URL';
$string['resume_publicsaved'] = 'Bücher und Publikationen gespeichert';
$string['resume_deletepublicconfirm'] = 'Willst du wirklich den Eintrag löschen?';
$string['resume_publicdeleted'] = 'Buch oder Publikation gelöscht';
$string['resume_mbrship'] = 'Mitgliedschaften';
$string['resume_mbrshipsaved'] = 'Mitgliedschaften gespeichert';
$string['resume_deletembrshipconfirm'] = 'Willst du wirklich den Eintrag löschen?';
$string['resume_mbrshipdeleted'] = 'Mitgliedschaft gelöscht';
$string['resume_linkedin'] = 'LinkedIn-Profil';
$string['resume_linkedinsaved'] = 'LinkedIn-Profil gespeichert';
$string['resume_deletelinkedinconfirm'] = 'Willst du wirklich den Eintrag löschen?';
$string['resume_linkedindeleted'] = 'LinkedIn-Profil gelöscht';
$string['resume_mygoals'] = 'Meine Ziele';
$string['resume_goals'] = 'Ziele';
$string['resume_goalspersonal'] = 'persönliche Ziele';
$string['resume_goalsacademic'] = 'Bildungsziele';
$string['resume_goalscareers'] = 'Karriereziele';
$string['resume_goalspersonalsaved'] = 'Persönliche Ziele gespeichert';
$string['resume_goalsacademicsaved'] = 'Bildungsziele gespeichert';
$string['resume_goalscareerssaved'] = 'Karriereziele gespeichert';
$string['resume_myskills'] = 'Meine Kompetenzen';
$string['resume_skills'] = 'Kompetenzen';
$string['resume_skillspersonal'] = 'Persönliche Kompetenzen';
$string['resume_skillsacademic'] = 'Bildungs-Kompetenzen';
$string['resume_skillscareers'] = 'Karriere-Kompetenzen';
$string['resume_skillspersonalsaved'] = 'Persönliche Kompetenzen gespeichert';
$string['resume_skillsacademicsaved'] = 'Bildungs-Kompetenzen gespeichert';
$string['resume_skillscareerssaved'] = 'Karriere-Kompetenzen gespeichert';
$string['resume_goalscomp'] = 'Kompetenzen';
$string['resume_skillscomp'] = 'Kompetenzen';
$string['resume_badges'] = 'Moodle-Auszeichnungen';
$string['resume_exportto_europass'] = 'Export für Europass';
$string['resume_exportto_europass_intro'] = '<p>Das Tool hilft den Nutzer:innen und Nutzern bei der Ermittlung von Lern- und Karrieremöglichkeiten. Im Hinblick auf Beratung und Service-Angebot ist das Profil auch für Arbeitgeber, Freiwilligenorganisationen, Recruiter/:innen, Laufbahnberater/:innen, Jugendorganisationen, Bildungseinrichtungen und andere Organisationen interessant.</p>
        <p>We provide a way for using your CV from Exabis eProtfolio in Europass profile<br>
            The generated XML-file has to be inserted into the page <a href="https://europa.eu/europass/eportfolio/screen/cv-editor?lang=de" target="_blank">Hier kannst du deinen Lebenslauf erstellen</a><br>
            (better to be logged in in the Europass previously)<br>
            Press the button "<strong>Europass-Lebenslauf importieren</strong>" and upload XML-file wich will genareted the button below
        </p>

    Ein paar Kurznotizen:<br>
    <ul><li>Der generierte Lebenslauf sollte auf alle Fälle nochmals kontrolliert werden</li>
        <li>Persönliche Daten werden aus den persönlichen Moodle-Informationen generiert</li>
        <li>Alle Datumsangaben sollten überprüft werden</li>
        <li>Bilder die über die HTML-Editoren eingefügt wurden werden nicht exportiert</li>
        <li>Texte die über die HTML-Editoren eingefügt wurden müssen unter Umständen neu formatiert werden</li>
        <li>Vorgaben für angehängte Dateien: Formate PDF, PNG, JPG sind erlaubt, maximale Dateigröße: 2,5 MB.</li>
    </ul>';
$string['resume_exportto_europass_getXML'] = 'XML herunterladen';
$string['resume_expand'] = 'Alles öffnen';
$string['resume_collaps'] = 'Alles schließen';

// === Structure sharing.
$string['shared_categories'] = 'Geteilte Kategorien';
$string['nothingstructureshared'] = 'Keine geteilten Strukturen';
$string['browsecategory'] = 'Inhalt anzeigen';
$string['copycategory'] = 'In mein Portfolio kopieren';
$string['sharedArtefacts'] = 'Gruppe-Portfolios, die mit dir geteilt wurden';
$string['shareditems_category'] = 'Gruppen-Portfolios, die mit dir geteilt wurden';
$string['create_as_note'] = 'Als Artefakt hinzufügen';
$string['category_not_found'] = 'Kategorie nicht gefunden';
$string['root_category'] = 'Hauptkategorie';
$string['current_category'] = 'Aktuelle Kategorie';
$string['change_layout'] = 'Darstellung wechseln';
$string['details'] = 'Details';
$string['tiles'] = 'Kacheln';
$string['category_up'] = 'übergeordnete Kategorie';
$string['supported'] = 'Projekt wurde unterstützt von';
$string['developed'] = 'entwickelt von';
$string['myfilearea'] = 'Mein Dateibereich';
$string['show_mystudents'] = 'Meine Teilnehmer/:innen';
$string['show_sharedbyuser'] = 'von Teilnehmer/:innen geteilt';
$string['enrolled_courses'] = 'mit folgenden Kursen verknüpft';
$string['browseportfolio'] = 'Inhalt anzeigen';

// === Language categories.

// === Message.
$string['messageprovider:sharing'] = 'Nachricht, wenn ein Benutzer/in etwas mit mir teilt';
$string['messageprovider:viewupdated'] = 'Nachricht, wenn ein Benutzer seine geteilte View aktualisiert';

// === Not Used Anymore.
// 'i_shared' => [
//     'Ich habe ein Eportfolio mit Ihnen geteilt',
//     'I shared an eportfolio view with you',
// ],
$string['i_shared'] = '{$a->sendername} hat die ePortfolio Ansicht {$a->title} mit Ihnen geteilt';
$string['i_updated'] = '{$a->sendername} hat Änderungen an dem E-Portfolio {$a->title} vorgenommen, welches mit Ihnen geteilt ist.';
$string['addstdcat'] = 'Standardkategorien importieren';
$string['incompatible_video'] = 'Um dieses Video anzusehen, bitte den direkten Link benutzen: {$a->link}';
$string['download_pdf'] = 'Download as Pdf';
$string['pdf_settings'] = 'PDF-Einstellungen';
$string['pdf_settings_description'] = 'Wenn du spezielle oder ungewöhnliche Schriftzeichen verwendest, kann es zu Problemen mit dem generierten PDF kommen. Du kannst daher versuchen, unterschiedliche Schriftarteinstellungen zu verwenden.<br>
			Deine PDF-Einstellungen werden für diese Ansicht gespeichert.<br>Wenn deine Ansicht mit anderen Benutzern geteilt wird, sehen sie das PDF mit deinen Einstellungen.<br>
			Nicht-standardisierte Schriftarten können einige Optionen wie Fett, Kursiv usw. verlieren.';
$string['pdf_settings_fontfamily'] = 'Schriftfamilie';
$string['pdf_settings_fontsize'] = 'Grundlegende Schriftgröße';
$string['pdf_settings_showmetadata'] = 'Metadaten zur Ansicht hinzufügen';
$string['pdf_settings_showusername'] = 'Benutzername';
$string['pdf_settings_showuserpicture'] = 'Profilbild';
$string['pdf_settings_showuseremail'] = 'Benutzer E-Mail';
$string['pdf_settings_showuserphone'] = 'Benutzer Telefon';
$string['pdf_customfont'] = 'Benutzerdefinierte Schriftart hochladen';
$string['pdf_settings_uploadfont'] = 'Eigene Schriftart hochladen';
$string['pdf_settings_pagesize'] = 'Seitengröße';
$string['pdf_settings_pageorient'] = 'Seitenausrichtung';
$string['pdf_settings_pageorient.portrait'] = 'Hochformat';
$string['pdf_settings_pageorient.landscape'] = 'Querformat';
$string['pdf_customfont_help'] = 'Du kannst deine eigene .ttf-Datei hochladen. Wir werden versuchen, sie für die PDF-Erstellung zu verwenden.';
$string['pdf_settings_fontfamily_fixedgroup'] = 'Vordefinierte Schriften';
$string['pdf_settings_fontfamily_customgroup'] = 'Benutzerdefinierte hochgeladene Schriftarten';
$string['settings_layout_settings_heading'] = 'Layout-Einstellungen';
$string['block_exaport_allowcustomlayout_head'] = 'Benutzerdefinierte Optionen für das Layout der Views für View-Eigentümer';
$string['block_exaport_allowcustomlayout_body'] = 'Ermöglicht die Verwendung benutzerdefinierter Layout-Einstellungen für Views (ähnlich den unten aufgeführten Optionen) für reguläre Besitzer der Views.';
$string['settings_layout_settings_description'] = 'Hier kannst du einige Layout-Optionen der View ändern oder eigene benutzerdefinierte CSS-Regeln verwenden, um die View nach deinen Wünschen zu gestalten.<br>Diese Einstellungen werden als Standardeinstellungen <strong>für alle Views</strong> verwendet.';
$string['layout_settings'] = 'Layout-Einstellungen';
$string['layout_settings_description'] = 'Hier kannst du einige Layout-Optionen der View ändern oder eigene benutzerdefinierte CSS-Regeln verwenden, um die View nach deinen Wünschen zu gestalten.';
$string['layout_settings_font_size'] = 'Schriftgröße';
$string['layout_settings_border_width'] = 'Randbreite';
$string['layout_settings_font_weight'] = 'Fett';
$string['layout_settings_border_width_only_bottom'] = 'Nur unterer Rand';
$string['layout_settings_view_headers'] = 'Überschriften der View-Blöcke';
$string['layout_settings_view_content'] = 'Inhalt der View-Blöcke';
$string['layout_settings_custom_css'] = 'benutzerdefinierte CSS-Regeln';
$string['layout_settings_custom_css_description'] = 'Hier kannst du eigene benutzerdefinierte CSS-Regeln verwenden.';
$string['selected_competencies'] = 'Erreichte Kompetenz';
$string['forms.item.title'] = 'Titel';
$string['forms.item.title_help'] = '';
$string['forms.item.project_description'] = 'Der Grund hinter diesem Projekt';
$string['forms.item.project_description_help'] = '<strong>Erkläre kurz den Zweck deiner Arbeit:</strong>
			<ul>
				<li>Welches Problem wurde damit angesprochen?</li>
				<li>Welche Fähigkeiten wolltest du entwickeln?</li>
				<li>Was war der Kontext?</li>
			</ul>';
$string['forms.item.project_description_editor'] = 'Der Grund hinter diesem Projekt';
$string['forms.item.project_description_editor_help'] = '<strong>Erkläre kurz den Zweck deiner Arbeit:</strong>
			<ul>
				<li>Welches Problem wurde angesprochen?</li>
				<li>Welche Fähigkeiten wolltest du entwickeln?</li>
				<li>Was war der Kontext?</li>
			</ul>';
$string['forms.item.project_process'] = 'Umsetzung des Projekts';
$string['forms.item.project_process_help'] = '<strong>Beschreibe deinen Weg:</strong>
			<ul>
				<li>Welche Schritte hast du unternommen, um dieses Projekt abzuschließen?</li>
				<li>Welche Herausforderungen sind dir begegnet und wie hast du sie gemeistert?</li>
				<li>Welche Ressourcen hast du genutzt?</li>
			</ul>';
$string['forms.item.project_process_editor'] = 'Umsetzung des Projekts';
$string['forms.item.project_process_editor_help'] = '<strong>Beschreibe deinen Weg:</strong>
			<ul>
				<li>Welche Schritte hast du unternommen, um dieses Projekt abzuschließen?</li>
				<li>Welche Herausforderungen sind dir begegnet und wie hast du sie gemeistert?</li>
				<li>Welche Ressourcen hast du genutzt?</li>
			</ul>';
$string['forms.item.project_result'] = 'Ergebnisse und Erkenntnisse';
$string['forms.item.project_result_help'] = '<strong>Fasse die Ergebnisse deines Projekts kurz zusammen:</strong>
			<ul>
				<li>Was hast du erreicht?</li>
				<li>Welche Fähigkeiten und Kompetenzen hast du durch diese Arbeit entwickelt oder gestärkt?</li>
				<li>Was hast du über dich und deine Fähigkeiten gelernt?</li>
				<li>Was würdest du das nächste Mal anders machen?</li>
			</ul>';
$string['forms.item.project_result_editor'] = 'Ergebnisse und Erkenntnisse';
$string['forms.item.project_result_editor_help'] = '<strong>Fasse die Ergebnisse deines Projekts kurz zusammen:</strong>
			<ul>
				<li>Was hast du erreicht?</li>
				<li>Welche Fähigkeiten und Kompetenzen hast du durch diese Arbeit entwickelt oder gestärkt?</li>
				<li>Was hast du über dich und deine Fähigkeiten gelernt?</li>
				<li>Was würdest du das nächste Mal anders machen?</li>
			</ul>';
$string['item.project_information'] = 'Projekt Information';
$string['view_saved'] = 'View gespeichert';
$string['view_sharing_updated'] = 'Ver&ouml;ffentlichung gespeichert';
$string['list'] = 'Liste';
$string['what_is_embed_code_title'] = 'Was ist ein Einbettungscode?';
$string['what_is_embed_code_content'] = '<p>Einbettungscode ist ein Code, der von einer Drittanbieter-Website wie YouTube oder Twitter generiert wird und den ein Benutzer in seine eigene Webseite kopieren und einfügen kann. Dieser eingebettete Code zeigt dann dasselbe Medium, dieselbe Anwendung oder denselben Feed auf der Webseite des Benutzers wie im Original.</p>
			<p>Wir bieten Anleitungen für die beliebtesten Videoplattformen wie YouTube oder Vimeo.</p>
			<p><strong>So findest du den Einbettungscode auf YouTube:</strong></p>
			<ol>
				<li>Gehe zu YouTube.</li>
				<li>Gehe zu dem Video, das du einbetten möchtest.</li>
				<li>Klicke auf den <strong>Teilen-Link</strong> unter dem Video und dann auf den <strong>Einbetten-Link</strong>.</li>
				<li>Klicke auf die Schaltfläche <strong>Kopieren</strong> im unteren Bereich des geöffneten Fensters.</li>
				<li>Der Einbettungslink wird blau markiert und in die Zwischenablage kopiert.</li>
				<li>Füge den Code in das Textfeld von exabis E-portfolio ein.</li>
			</ol>
			<p><strong>So findest du den Einbettungscode auf Vimeo:</strong></p>
			<ol>
				<li>Gehe zu Vimeo.</li>
				<li>Gehe zu dem Video, das du einbetten möchtest.</li>
				<li>Klicke auf die Schaltfläche <strong>Teilen</strong> oben rechts im Video.</li>
				<li>Ein Popup-Fenster mit den Einbettungslink-Informationen wird angezeigt. Du musst nur den <strong>&lt;<i>iframe</i>&gt;</strong>-Teil des Einbettungslinks kopieren.
					Beispiel:<br>
					<ol>
						<li>
							Der gesamte Einbettungslink zeigt Folgendes:<br>
							<textarea disabled=\'true\' style=\'border: none;background-color:white;width:100%;font-size:0.75em;\'>&lt;iframe src=&quote;https://player.vimeo.com/video/1233456789&quote; width=&quote;640&quote; height=&quote;360&quote; frameborder=&quote;0&quote; allow=&quote;autoplay; fullscreen&quote; allowfullscreen&gt;&lt;/iframe&gt;&lt;p&gt;&lt;a href=&quote;https://vimeo.com/1233456789&quote;&gt;1- Automation Opening[2]&lt;/a&gt; von &lt;a href=&quote;https://vimeo.com/user98765432&quote;&gt;R1 Marketing&lt;/a&gt; auf &lt;a href=&quote;https://vimeo.com&quote;&gt;Vimeo&lt;/a&gt;.&lt;/p&gt;</textarea>
						</li>
						<li>
							Du musst nur den <strong>&lt;<i>iframe</i>&gt;</strong>-Teil kopieren:<br>
							<textarea disabled=\'true\' style=\'border: none;background-color:white;width:100%;font-size:0.75em;\'>&lt;iframe src=&quote;https://player.vimeo.com/video/1233456789&quote; width=&quote;640&quote; height=&quote;360&quote; frameborder=&quote;0&quote; allow=&quote;autoplay; fullscreen&quote; allowfullscreen&gt;&lt;/iframe&gt;</textarea>
						</li>
					</ol>
				<li>Füge diesen Code in das Textfeld von exabis E-portfolio ein.</li>
			</ol>
            ';

// === Privacy wordings
$string['privacy:metadata:block_exaportuser'] = 'Benutzerdaten von exabis e-portfolio';
$string['privacy:metadata:block_exaportuser:user_id'] = 'Benutzerid';
$string['privacy:metadata:block_exaportuser:description'] = 'Beschreibung';
$string['privacy:metadata:block_exaportuser:view_items_layout'] = 'Benutzerid';
$string['privacy:metadata:block_exaportcate'] = 'Kategorien des Benutzers';
$string['privacy:metadata:block_exaportcate:pid'] = 'Hauptkategorie ID';
$string['privacy:metadata:block_exaportcate:userid'] = 'Benutzerid';
$string['privacy:metadata:block_exaportcate:name'] = 'Titel';
$string['privacy:metadata:block_exaportcate:timemodified'] = 'letzte Änderung';
$string['privacy:metadata:block_exaportcate:courseid'] = 'Kurse ID';
$string['privacy:metadata:block_exaportcate:description'] = 'Beschreibung';
$string['privacy:metadata:block_exaportcate:subjid'] = 'Raster ID';
$string['privacy:metadata:block_exaportcate:topicid'] = 'Kompetenzbereich ID';
$string['privacy:metadata:block_exaportcate:source'] = 'Source';
$string['privacy:metadata:block_exaportcate:sourceid'] = 'Source Id';
$string['privacy:metadata:block_exaportcate:parent_ids'] = 'Liste der übergeordneten IDs';
$string['privacy:metadata:block_exaportcate:parent_titles'] = 'List der übergeordneten Titel';
$string['privacy:metadata:block_exaportcate:stid'] = 'Schultyp ID';
$string['privacy:metadata:block_exaportcate:sourcemod'] = 'Sourcemod';
$string['privacy:metadata:block_exaportcate:name_short'] = 'Kurztitel';
$string['privacy:metadata:block_exaportcate:shareall'] = 'Freigegeben für alle? 0 - nicht freigegeben; 1 - für alle freigegeben; 2 - für Gruppen freigegeben';
$string['privacy:metadata:block_exaportcate:internshare'] = 'intern geteilt?';
$string['privacy:metadata:block_exaportcate:structure_shareall'] = 'Als Struktur freigegeben? 0 - nicht freigegeben; 1 - für alle freigegeben; 2 - für Gruppen freigegeben';
$string['privacy:metadata:block_exaportcate:structure_share'] = 'Als Struktur freigegeben? Siehe auch \'structure_shareall\'';
$string['privacy:metadata:block_exaportitem'] = 'Artefakt des Benutzers';
$string['privacy:metadata:block_exaportitem:userid'] = 'Artefakt des Besitzers';
$string['privacy:metadata:block_exaportitem:type'] = 'Typ des Artefakts';
$string['privacy:metadata:block_exaportitem:categoryid'] = 'Kategorie Id';
$string['privacy:metadata:block_exaportitem:name'] = 'Name';
$string['privacy:metadata:block_exaportitem:url'] = 'Url';
$string['privacy:metadata:block_exaportitem:intro'] = 'Intro';
$string['privacy:metadata:block_exaportitem:timemodified'] = 'Zeit zuletzt geändert';
$string['privacy:metadata:block_exaportitem:courseid'] = 'Kurs Id';
$string['privacy:metadata:block_exaportitem:shareall'] = 'Freigegeben für alle?';
$string['privacy:metadata:block_exaportitem:externaccess'] = 'Externer Zugriff?';
$string['privacy:metadata:block_exaportitem:externcomment'] = 'Kommentar für Externe';
$string['privacy:metadata:block_exaportitem:fileurl'] = 'URL zur Datei';
$string['privacy:metadata:block_exaportitem:exampid'] = 'zugehörige Beispiel-ID';
$string['privacy:metadata:block_exaportitem:langid'] = 'Sprach-ID';
$string['privacy:metadata:block_exaportitem:source'] = 'Source';
$string['privacy:metadata:block_exaportitem:sourceid'] = 'Source Id';
$string['privacy:metadata:block_exaportitem:iseditable'] = 'Ist bearbeitbar?';
$string['privacy:metadata:block_exaportitem:example_url'] = 'Material Url';
$string['privacy:metadata:block_exaportitem:parentid'] = 'Übergeordnete ID';
$string['privacy:metadata:block_exaportitemcomm'] = 'Kommentare zu Artefakten';
$string['privacy:metadata:block_exaportitemcomm:itemid'] = 'Id zu Artefakten';
$string['privacy:metadata:block_exaportitemcomm:userid'] = 'Autor des Kommentars';
$string['privacy:metadata:block_exaportitemcomm:entry'] = 'Kommentar';
$string['privacy:metadata:block_exaportitemcomm:timemodified'] = 'zuletzt geändert';
$string['privacy:metadata:block_exaportview'] = 'Kommentar zu Artefakten';
$string['privacy:metadata:block_exaportview:userid'] = 'Besitzer der View';
$string['privacy:metadata:block_exaportview:name'] = 'Name';
$string['privacy:metadata:block_exaportview:description'] = 'Beschreibung';
$string['privacy:metadata:block_exaportview:timemodified'] = 'zuletzt geändert';
$string['privacy:metadata:block_exaportview:shareall'] = 'Für alle Teilen?';
$string['privacy:metadata:block_exaportview:externaccess'] = 'Externer Zugriff?';
$string['privacy:metadata:block_exaportview:externcomment'] = 'Kommentar von extern?';
$string['privacy:metadata:block_exaportview:langid'] = 'Sprach-ID';
$string['privacy:metadata:block_exaportview:layout'] = 'Layout der View';
$string['privacy:metadata:block_exaportview:sharedemails'] = 'Liste freigegebener E-Mails';
$string['privacy:metadata:block_exaportview:autofill_artefacts'] = 'Automatisches Ausfüllen bei Artefakten aktiviert';
$string['privacy:metadata:block_exaportresume'] = 'Lebenslaufdaten';
$string['privacy:metadata:block_exaportresume:user_id'] = 'Besitzer des Lebenslaufs';
$string['privacy:metadata:block_exaportresume:courseid'] = 'Kurs ID';
$string['privacy:metadata:block_exaportresume:cover'] = 'Inhalt des Deckblattes';
$string['privacy:metadata:block_exaportresume:interests'] = 'Interessen';
$string['privacy:metadata:block_exaportresume:goalspersonal'] = 'persönliche Ziele';
$string['privacy:metadata:block_exaportresume:goalsacademic'] = 'akademische Ziele';
$string['privacy:metadata:block_exaportresume:goalscareers'] = 'Karriereziele';
$string['privacy:metadata:block_exaportresume:skillspersonal'] = 'Persönliche Fähigkeiten';
$string['privacy:metadata:block_exaportresume:skillsacademic'] = 'akademische Fähigkeiten';
$string['privacy:metadata:block_exaportresume:skillscareers'] = 'Karriere Fähigkeiten';
$string['privacy:metadata:core_files'] = 'Exabis ePortfolio speichert Dateien, die vom Benutzer hochgeladen wurden, um Teil von Artefakten, Lebenslaufeinträgen und Kommentaren zu werden.';
$string['whyEportfolio'] = 'Warum ein ePortfolio?';
$string['whyEportfolio_description'] = '<h4>Machen Sie Arbeit sichtbar: Ihr digitales Portfolio</h4>
            <br>
            <p>Sie investieren viel Zeit und Energie in Aufgaben, Projekte oder Weiterbildungen. Oft verschwinden diese Ergebnisse jedoch nach der Abgabe oder dem Kursende in der Schublade, dabei spiegeln sie Ihr Können, Ihre Kreativität und Ihr Wissen wider.</p>
            <p>Mit einem <strong>ePortfolio</strong> haben Sie die Möglichkeit, Ihre Arbeiten, erworbenen Kompetenzen und Lernfortschritte sichtbar zu machen. So entsteht eine Sammlung, die Sie nicht nur für sich selbst dokumentieren, sondern auch mit Lehrenden, Institutionen oder potenziellen Arbeitgeber:innen teilen können.</p>
            <p>Von Präsentationen über Projektberichte bis hin zu Videos oder Zertifikaten – Ihr Portfolio macht Leistungen greifbar. Auch Microcredentials können integriert werden und unterstreichen Ihre Erfolge in Aus- und Weiterbildung.</p>
            <br>
            <h4>Was ist ein ePortfolio?</h4>
            <br>
            <p>Ein ePortfolio ist mehr als nur ein digitaler Lebenslauf. Es ist eine persönliche Sammlung Ihrer Arbeiten, die Ihre Fähigkeiten und Erfahrungen lebendig darstellt. Anders als ein klassischer CV bietet es echte Nachweise: Arbeitsproben, Reflexionen und den Kontext, in dem Sie Ihre Kompetenzen erworben haben.</p>
            <p>Mit Exabis ePortfolio können Sie mehrere Ansichten erstellen, passgenau für bestimmte Bewerbungen, Jobchancen oder Präsentationen. So zeigen Sie immer das, was für die jeweilige Situation am wichtigsten ist.</p>
            <br>
            <h4>Wie erstellst du dein ePortfolio?</h4>
            <br>
            <ol>
                <li><strong>Sammeln:</strong> Tragen Sie Ihre Arbeiten zusammen, seien es Aufgaben, Präsentationen, Projekte, Videos oder Ähnliches.</li>
                <li><strong>Auswählen:</strong> Entscheiden Sie sich für Ihre besten Arbeiten, die Ihre Stärken am deutlichsten zeigen.</li>
                <li><strong>Reflektieren:</strong> Ergänzen Sie kurze Beschreibungen, die Ihre Kompetenzen verdeutlichen und den Kontext erklären.</li>
                <li><strong>Gestalten:</strong> Bauen Sie ein Portfolio Schritt für Schritt auf und entwickeln Sie es laufend weiter.</li>
            </ol>
            <p>Mit Exabis ePortfolio geht das unkompliziert, flexibel und effizient. Sie haben jederzeit die Kontrolle darüber, wie Sie sich und Ihr Können präsentieren und machen sichtbar, was Sie einzigartig macht.</p>';
$string['cofigureblock_cvinfo_help'] = 'Du wirst den aktuellen Status der ausgewählten Elemente in deinem Lebenslauf sehen. Der Blockinhalt wird aktualisiert, wenn du später Änderungen an irgendwelchen Elementen in deinem Lebenslauf vornimmst.';
$string['cofigureblock_cvinfo_cover'] = 'Über mich';
$string['cofigureblock_cvinfo_cover_actual'] = 'Aktuellen Lebenslauf "Über mich" Inhalt hinzufügen';
$string['create_view_content_help_title'] = 'Gestalte deine einzigartige Geschichte: Erstelle dein Portfolio';
$string['create_view_content_help_text'] = '<ul>
				<li><strong>Plane dein Layout:</strong> Ziehe und lasse Bausteine fallen und arrangiere sie, um deine Geschichte zu erzählen. Verwende Spalten (verfügbar im Abschnitt "Layout"), um dein Portfolio zu planen.</li>
				<li><strong>Organisiere für Klarheit:</strong> Verwende Überschriften, Links und Notizen, um deine Inhalte effektiv zu strukturieren.</li>
				<li><strong>Personalisiere deinen Stil:</strong> Wähle Schriftarten und Farben innerhalb der verfügbaren Optionen, um einen Hauch von dir hinzuzufügen.</li>
			</ul>
			<strong>Denke daran: Dein e-Portfolio erzählt der Welt von dir und deinen Fähigkeiten. Mache es klar, prägnant und ansprechend!</strong>';
$string['moreinfolink'] = 'Mehr Informationen anzeigen ...';
$string['badges_help'] = 'Der Block mit dir verliehenen Abzeichen<br><a href=\'{$a}\' target=\'_blank\' class=\'external-link\'>Deine Abzeichen anzeigen</a>';
$string['view_preview_help_title'] = 'Vorschau';
$string['view_preview_help'] = 'Vorschau der View';
$string['block_exaport_used_layout'] = 'Verwendetes Layout';
$string['block_exaport_used_layout_body'] = 'Ändern Sie das Layout, falls es Darstellungsprobleme gibt. Momentan wird es nur für die Artefaktliste verwendet.';
$string['block_exaport_used_layout_moodle_bootstrap'] = 'Karten-Layout';
$string['block_exaport_used_layout_clean_old'] = 'Kachel-Layout (Alt - Unterstützung endet mit Version 4.6.7)';
$string['settings_export_settings_heading'] = 'Export-Einstellungen';
$string['settings_exaport_mysource'] = 'Source ID';
$string['settings_exaport_mysource_body'] = 'Automatisch generierte ID dieser Exaport Installation. Diese kann nicht geändert werden';
$string['settings_exaport_wp_sso_url'] = 'Url to WordPress SSO receiver';
$string['settings_exaport_wp_sso_url_body'] = 'The url to server which is ready to recieve commands from exaport';
$string['settings_exaport_wp_sso_passphrase'] = 'WordPress SSO Passphrase';
$string['settings_exaport_wp_sso_passphrase_body'] = 'The Passphrase to connect with WordPress SSO receiver';
$string['settings_exaport_wp_sso_enabled'] = 'Enable WordPress SSO connection';
$string['settings_exaport_wp_sso_enabled_body'] = 'Enable WordPress connection. Options below must be configured';
$string['settings_exaport_wp_sso_error_no_url_configured'] = 'First set up the "block_exaport/wp_sso_url" option';
$string['settings_exaport_reload_settings_page'] = 'Reload';
$string['settings_exaport_wp_sso_error_no_passphrase_registered'] = 'The passphrase must be registered in the WordPress SSO server.';
$string['settings_exaport_wp_sso_how_to_get_secret'] = 'You need to register your "block_exaport/mysource" value into WordPress SSO server and get a secret code<br />Then you need to insert the secret code into field below and get the passphrase';
$string['settings_exaport_wp_sso_url_to_get_secret'] = 'Get the secret code';
$string['settings_exaport_wp_sso_enter_secret_placeholder'] = 'Enter the secret code';
$string['settings_exaport_wp_sso_request_passphrase_button'] = 'Request the passphrase';
$string['settings_exaport_wp_sso_passphrase_ok'] = 'The passphrase is configured';
$string['settings_exaport_wp_sso_test_passphrase_button'] = 'Test';
$string['settings_exaport_wp_sso_remove_passphrase_button'] = 'Remove the passphrase';
$string['wp_exported_view'] = 'Exportierte Ansicht';
$string['wp_exported_view_hidden_in_wp'] = 'Exportiert, aber in Wordpress ausgeblendet';
$string['wp_exported_view_newer_than_wp'] = 'WordPress-Ansicht ist älter als die Moodle-Ansicht';
$string['alwaysnotifywhenshare'] = 'Immer benachrichtigen, wenn geteilt wird';
$string['alwaysnotifywhenshare_description'] = 'Wenn aktiviert, wird das Kontrollkästchen "Benachrichtige Benutzer" automatisch aktiviert und deaktiviert, wenn das Kontrollkästchen "Teilen" angeklickt wird.';
