/******************************************************************************
 *
 * This module provides a wrapper for user-interface modules, handling hiding
 * of the textArea that is being replaced by the UI element,
 * resizing of the UI component, and support of such usability functions as
 * ctrl-alt-M to disable/re-enable the entire user interface, including the
 * wrapper.
 *
 * @module coderunner/userinterfacewrapper
 * @copyright  Richard Lobb, 2015, The University of Canterbury
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 *
 * The InterfaceWrapper class is constructed either by Moodle PHP calls of
 * the form
 *
 * $PAGE->requires->js_call_amd($modulename, $functionname, $params)
 *
 * (e.g. from within render.php) or by JavaScript require calls, e.g. from
 * authorform.js when the question author changes UI type.
 *
 * The InterfaceWrapper provides:
 *
 * 1. A constructor InterfaceWrapper(uiname, textareaId) which
 *    hides the given text area, replaces it with a wrapper div (resizable in
 *    height by the user but with width resizing managed by changes in window
 *    width), created an instance of nameInstance as defined in the file
 *    ui_name.js (see below).
 *    params is a record containing the decoded value of
 *
 * 2. A stop() method that destroys the embedded UI and hides the wrapper.
 *
 * 3. A restart() method that shows the wrapper again and re-creates the prior
 *    embedded UI component within it.
 *
 * 4. A loadUi(uiname, params) method that kills any currently running UI element
 *    (if there is one) and (re)loads the specified one. The params parameter
 *    is a record that allows additional parameters to be passed in, such as
 *    those from the question's uiParams field and, in the case of the
 *    Ace UI, the 'lang' (language) that the editor is editing. This data
 *    is supplied by the PHP via the data-params attribute of the answer's
 *    base textarea.
 *
 * 5. Regular checking for any resizing of the wrapper, which are passed on to
 *    the embedded UI element's resize() method.
 *
 * 6. Monitoring of alt-ctrl-M key presses which toggle the visibility of the
 *    wrapper plus UI element and the syncronised textArea by calls to stop()
 *    and restart
 *
 * =========================================================================
 *
 * The embedded user-interface module must be defined in a JavaScript file
 * of the form ui_name.js which must define a class nameInstance with
 * the following functionality:
 *
 * 1. A constructor SomeUiName(textareaId, width, height, params) that
 *    builds an HTML component of the given width and height. textareaId is the
 *    ID of the textArea from which the UI element should obtain its initial
 *    serialisation and to which it should write the serialisation when its save
 *    or destroy methods are called. params is a JavaScript object,
 *    decoded from the JSON uiParams defined by the question plus any
 *    additional data required, such as the 'lang' in the case of Ace.
 *
 * 2. A getElement() method that returns the HTML element that the
 *    InterfaceWrapper is to insert into the document tree.
 *
 * 3. A method failed() that should return true unless the constructor
 *    failed (e.g. because it was not able to de-serialise the text area's
 *    contents). The wrapper will call destroy() on the object if failed()
 *    returns true and abort the use of the UI element. The text area will
 *    have the uiloadfailed class added, which CSS will display in some
 *    error mode (e.g. a red border).
 *
 * 4. A method failMessage() that will be called only when failed() returns
 *    True. It should be a defined CodeRunner language string key.
 *
 * 5. A sync() method that copies the serialised represention of the UI plugin's
 *    data to the related TextArea. This is used when submit is clicked.
 *
 * 6. A destroy() method that should sync the contents to the text area then
 *    destroy any HTML elements or other created content. This method is called
 *    when CTRL-ALT-M is typed by the user to turn off all UI plugins
 *
 * 7. A resize(width, height) method that should resize the entire UI element
 *    to the given dimensions.
 *
 * 8. A hasFocus() method that returns true if the UI element has focus.
 *
 * 9. A syncIntervalSecs() method that returns the time interval between
 *    calls to the sync() method. 0 for no sync calls. The userinterfacewrapper
 *    provides all instances with a generic (base-class) version that returns
 *    the value of a UI parameter sync_interval_secs if given else uses the
 *    UI interface wrapper default (currently 5).
 *
 * 10. An allowFullScreen() method that returns True if the UI supports
 *    use of the full-screen button in the bottom right of the UI wrapper.
 *    Defaults to False if not implemented.
 *
 * 11. A setAllowFullScreen(allow) method that takes a boolean parameter that
 *    allows or disallows the use of full screening. This overrides the setting
 *    from the allowFullScreen() method and is provided to allow parent UIs
 *    such as Scratchpad to override the default settings of a child UI.
 *
 * The return value from the module define is a record with a single field
 * 'Constructor' that references the constructor (e.g. Graph, AceWrapper etc)
 *
 *****************************************************************************/
define("qtype_coderunner/userinterfacewrapper",["core/templates","core/notification"],(function(Templates,Notification){function InterfaceWrapper(uiname,textareaId){let t=this;this.GUTTER=16,this.DEFAULT_SYNC_INTERVAL_SECS=5,this.uniqueId=Math.random();this.isFullScreenEnable=null,this.taId=textareaId,this.loadFailId=textareaId+"_loadfailerr",this.textArea=document.getElementById(textareaId),this.textArea.current_ui_wrapper&&alert("JavaScript error: multiple UIs on ".concat(textareaId,"!"));const params=this.textArea.getAttribute("data-params");this.uiParams=params?JSON.parse(params):{},this.uiParams.lang=this.textArea.getAttribute("data-lang"),this.readOnly=this.textArea.readOnly,this.isLoading=!1,this.loadFailed=!1,this.retries=0;let h=this.textArea.clientHeight,content_lines=this.textArea.value.split("\n").length,rows=this.textArea.rows;content_lines>rows&&(rows=Math.min(content_lines,50)),h=Math.max(h,19*rows,50),this.textArea.style.height=h+"px",this.wrapperNode=document.createElement("div"),this.wrapperNode.id="".concat(this.taId,"_wrapper"),this.wrapperNode.classList.add("ui_wrapper","position-relative"),this.wrapperNode.uniqueId=this.uniqueId,this.wrapperNode.style.display="none",this.wrapperNode.style.resize="vertical",this.wrapperNode.style.overflow="hidden",this.wrapperNode.style.minHeight=h+"px",this.wrapperNode.style.width="100%",this.wrapperNode.style.border="1px solid darkgrey",this.textArea.insertAdjacentElement("afterend",this.wrapperNode),this.wLast=0,this.hLast=0,this.textArea.current_ui_wrapper=this,this.uiInstance=null,this.loadUi(uiname,this.uiParams);new ResizeObserver((function(){t.checkForResize()})).observe(this.wrapperNode),window.addEventListener("resize",(function(){t.checkForResize()}));const form=this.textArea.closest("form");form&&form.addEventListener("submit",(function(){null!==t.uiInstance&&t.uiInstance.sync()})),document.body.addEventListener("keydown",(function keyDown(e){if("m"===e.key&&e.ctrlKey&&e.altKey){const wrapper=document.getElementById("".concat(t.taId,"_wrapper"));wrapper&&wrapper.uniqueId===t.uniqueId?null!==t.uiInstance||t.loadFailed?t.stop():t.restart():document.removeEventListener("keydown",keyDown)}}))}return InterfaceWrapper.prototype.setAllowFullScreen=function(enableFullScreen){this.isFullScreenEnable=enableFullScreen},InterfaceWrapper.prototype.loadUi=function(uiname,params){const t=this;function syncIntervalSecsBase(){return params.hasOwnProperty("sync_interval_secs")?parseInt(params.sync_interval_secs):t.DEFAULT_SYNC_INTERVAL_SECS}if(this.isLoading)return this.retries+=1,void(this.retries>20?(alert("Failed to load "+uiname+" UI component. If this error persists, please report it to the forum on coderunner.org.nz"),this.retries=0,this.loading=0):setTimeout((function(){t.loadUi(uiname,params)}),200));this.retries=0,this.params=params,this.stop(),this.uiname=uiname,""===this.uiname||"none"===this.uiname||sessionStorage.getItem("disableUis")?this.uiInstance=null:(this.isLoading=!0,require(["qtype_coderunner/ui_"+this.uiname],(function(ui){const h=t.textArea.clientHeight-t.GUTTER,w=t.textArea.clientWidth,uiInstance=new ui.Constructor(t.taId,w,h,params);if(uiInstance.failed()){t.loadFailed=!0,t.wrapperNode.style.display="none",t.textArea.style.display="",uiInstance.destroy(),t.uiInstance=null,t.textArea.classList.add("uiloadfailed");const loadFailDiv=document.createElement("div");loadFailDiv.id=t.loadFailId,loadFailDiv.className="uiloadfailed",t.textArea.parentNode.insertBefore(loadFailDiv,t.textArea),langString=uiInstance.failMessage(),errorDiv=loadFailDiv,require(["core/str"],(function(str){const s=str.get_string(langString,"qtype_coderunner"),fallback=str.get_string("ui_fallback","qtype_coderunner");Promise.all([s,fallback]).then((function(results){const s=results[0],fallback=results[1];errorDiv.innerHTML=s+"<br>"+fallback}))}))}else{var _uiInstance$allowFull;t.textArea.style.display="none",t.wrapperNode.style.display="";let elementToAdd=uiInstance.getElement();if(elementToAdd&&elementToAdd.jquery&&(elementToAdd=elementToAdd[0]),elementToAdd){t.wrapperNode.appendChild(elementToAdd);elementToAdd.querySelectorAll("script").forEach((oldScript=>{const newScript=document.createElement("script");oldScript.src?newScript.src=oldScript.src:newScript.textContent=oldScript.textContent,document.head.appendChild(newScript),document.head.removeChild(newScript)}))}t.uiInstance=uiInstance,t.loadFailed=!1,t.checkForResize();let uiInstancePrototype=Object.getPrototypeOf(uiInstance);uiInstancePrototype.syncIntervalSecs=uiInstancePrototype.syncIntervalSecs||syncIntervalSecsBase,t.startSyncTimer(uiInstance),(null!==t.isFullScreenEnable?t.isFullScreenEnable:null===(_uiInstance$allowFull=uiInstance.allowFullScreen)||void 0===_uiInstance$allowFull?void 0:_uiInstance$allowFull.call(uiInstance))?t.initFullScreenToggle(t.taId):t.removeFullScreenButton(t.taId)}var langString,errorDiv;t.isLoading=!1})))},InterfaceWrapper.prototype.removeFullScreenButton=function(fieldId){const screenModeButton=document.getElementById("".concat(fieldId,"_wrapper")).parentNode.querySelector(".screen-mode-button");screenModeButton&&screenModeButton.remove()},InterfaceWrapper.prototype.initFullScreenToggle=function(fieldId){const wrapperEditor=document.getElementById("".concat(fieldId,"_wrapper"));function enterFullscreen(fullscreenButton,exitFullscreenButton,e){let t=this;e.preventDefault(),t.wrapperHeight=t.wrapperNode.clientHeight,t.heightEditNode=t.hLast,t.widthEditNode=t.wLast,fullscreenButton.classList.add("d-none"),wrapperEditor.append(exitFullscreenButton),wrapperEditor.addEventListener("fullscreenchange",(()=>{null===document.fullscreenElement?(t.uiInstance.resize(t.widthEditNode,t.heightEditNode),wrapperEditor.style.height=t.wrapperHeight+"px",exitFullscreenButton.classList.add("d-none"),fullscreenButton.classList.remove("d-none")):exitFullscreenButton.classList.remove("d-none")})),wrapperEditor.requestFullscreen().catch(Notification.exception)}function exitFullscreen(e){let t=this;e.preventDefault(),document.exitFullscreen(),wrapperEditor.style.height=t.wrapperHeight+"px",t.uiInstance.resize(t.widthEditNode,t.heightEditNode)}wrapperEditor.parentNode.querySelector(".screen-mode-button")||Templates.renderForPromise("qtype_coderunner/screenmode_button",{}).then((_ref=>{let{html:html}=_ref;const screenModeButton=Templates.appendNodeContents(wrapperEditor,html,"")[0],fullscreenButton=screenModeButton.querySelector(".button-fullscreen"),exitFullscreenButton=screenModeButton.querySelector(".button-exit-fullscreen");fullscreenButton.classList.remove("d-none"),fullscreenButton.addEventListener("click",enterFullscreen.bind(this,fullscreenButton,exitFullscreenButton)),exitFullscreenButton.addEventListener("click",exitFullscreen.bind(this))}))},InterfaceWrapper.prototype.startSyncTimer=function(uiInstance){const timeout=uiInstance.syncIntervalSecs();this.uiInstance.timer=timeout?setInterval((function(){uiInstance.sync()}),1e3*timeout):null},InterfaceWrapper.prototype.stopSyncTimer=function(uiInstance){uiInstance.timer&&clearTimeout(uiInstance.timer)},InterfaceWrapper.prototype.stop=function(){null!==this.uiInstance&&(this.stopSyncTimer(this.uiInstance),this.textArea.style.display="",this.uiInstance.hasFocus()&&(this.textArea.focus(),this.textArea.selectionStart=this.textArea.value.length),this.uiInstance.destroy(),this.uiInstance=null,this.wrapperNode.style.display="none"),this.loadFailed=!1,this.textArea.classList.remove("uiloadfailed");const elementToRemove=document.getElementById(this.loadFailId);elementToRemove&&elementToRemove.parentNode.removeChild(elementToRemove)},InterfaceWrapper.prototype.restart=function(){null===this.uiInstance&&this.loadUi(this.uiname,this.params)},InterfaceWrapper.prototype.checkForResize=function(){if(this.uiInstance){const h=this.wrapperNode.clientHeight,w=this.wrapperNode.clientWidth,maxWidth=this.wrapperNode.clientWidth,hAdjusted=h-this.GUTTER,wAdjusted=Math.min(maxWidth,w);hAdjusted==this.hLast&&wAdjusted==this.wLast||(this.uiInstance.resize(wAdjusted,hAdjusted),this.hLast=hAdjusted,this.wLast=wAdjusted)}},{newUiWrapper:function(uiname,textareaId){return uiname?new InterfaceWrapper(uiname,textareaId):null},InterfaceWrapper:InterfaceWrapper}}));

//# sourceMappingURL=userinterfacewrapper.min.js.map