define("qtype_coderunner/ui_scratchpad",["exports","core/templates","qtype_coderunner/userinterfacewrapper","qtype_coderunner/outputdisplayarea"],(function(_exports,_templates,_userinterfacewrapper,_outputdisplayarea){var obj;
/**
   * Implementation of the scratchpad_ui user interface plugin. For overall details
   * of the UI plugin architecture, see userinterfacewrapper.js.
   *
   * This plugin replaces the usual textarea answer element with a UI is designed to
   * allow the execution of code in the CodeRunner question in a manner similar to an IDE.
   * It contains two editor boxes, one on top of another, allowing users to enter and
   * edit code in both. It contains two embedded Ace UIs.
   *  By default, only the top editor is visible and the bottom editor (Scratchpad Area) is hidden,
   * clicking the Scratchpad button shows it. The Scratchpad area contains a second editor,
   * a Run button and a Prefix with Answer checkbox. Additionally, there is a help button that
   * provides information about how to use the Scratchpad.
   *  It's possible to run code 'in-browser' by clicking the Run Button,
   * without making a submission via the Check Button:
   *          If Prefix with Answer is not checked, only the code in the Scratchpad is run --
   *      allowing for a rough working spot to quickly check the result of code.
   *          Otherwise, when Prefix with Answer is checked, the code in the Scratchpad is
   *      appended to the code in the first editor before being run.
   *  The Run Button has some limitations when using its default configuration:
   *     Does not support programs that use STDIN (by default);
   *     Only supports textual STDOUT (by default).
   * Note: These features can be supported, see the README section on wrappers...
   *  The serialisation of this UI is a JSON object with the fields
   * with fields:
   *      answer_code: [""] A list containing a string with answer code from the first editor;
   *      test_code: [""] A list containing a string with containing answer code from the second editor;
   *      show_hide: ["1"] when scratchpad is visible, otherwise [""];
   *      prefix_ans: ["1"] when Prefix with Answer is checked, otherwise [""].
   *
   * UI Parameters:
   *    - scratchpad_name: display name of the scratchpad, used to hide/un-hide the scratchpad.
   *    - button_name: run button text.
   *    - prefix_name: prefix with answer check-box label text.
   *    - help_text: help text to show.
   *    - run_lang: language used to run code when the run button is clicked,
   *      this should be the language your wrapper is written in (if applicable).
   *    - wrapper_src: location of wrapper code to be used by the run button, if applicable:
   *      setting to globalextra will use text in global extra field,
   *    - prototypeextra will use the prototype extra field.
   *    - output_display_mode: control how program output is displayed on runs, there are three modes:
   *          - text: display program output as text, html escaped;
   *          - json: display program output, when it is json,
   *          - html: display program output as raw html.
   *      NOTE: see qtype_coderunner/outputdisplayarea.js for more info...
   *    - disable_scratchpad: disable the scratchpad, effectively reverting to the Ace UI
   *      from student perspective.
   *    - invert_prefix: inverts meaning of prefix_ans serialisation -- '1' means un-ticked, vice versa.
   *      This can be used to swap the default state.
   *
   * @module qtype_coderunner/ui_scratchpad
   * @copyright  Richard Lobb, 2022, The University of Canterbury
   * @copyright  James Napier, 2022, The University of Canterbury
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.Constructor=void 0,_templates=(obj=_templates)&&obj.__esModule?obj:{default:obj};const invertSerial=current=>"1"===current[0]?[""]:["1"],escapeRegExp=string=>string.replace(/[.*+?^${}()|[\]\\]/g,"\\$&"),overwriteValues=(defaults,prescribed)=>{let overwritten={...defaults};if(prescribed)for(const[key,value]of Object.entries(defaults))overwritten[key]=prescribed[key]||value;return overwritten};_exports.Constructor=class{constructor(textAreaId,width,height,uiParams){const DEF_UI_PARAMS={scratchpad_name:"",button_name:"",prefix_name:"",help_text:"",params:{},run_lang:uiParams.lang,output_display_mode:"text",disable_scratchpad:!1,wrapper_src:null,open_delimiter:"{|",close_delimiter:"|}",escape:!1,jobe_servers:[],api_keys:[]};this.textArea=document.getElementById(textAreaId),this.textAreaId=textAreaId,this.height=height,this.readOnly=this.textArea.readonly,this.fail=!1,this.outerDiv=null,this.outputDisplay=null,this.invertPreload=uiParams.invert_prefix,this.jobeServers=uiParams.jobe_servers,this.apiKeys=uiParams.api_keys,this.lang=uiParams.lang,this.numRows=this.textArea.rows,this.uiParams=overwriteValues(DEF_UI_PARAMS,uiParams),this.runWrapper=this.getRunWrapper();const preloadString=this.textArea.value;let preload;try{preload=this.readJson(preloadString)}catch(error){return this.fail=!0,void(this.failString="scratchpad_ui_invalidserialisation")}this.updateContext(preload),this.reload()}getRunWrapper(){const wrapperSrc=this.uiParams.wrapper_src;let runWrapper=null;return wrapperSrc&&("globalextra"===wrapperSrc||"prototypeextra"===wrapperSrc?runWrapper=this.textArea.dataset[wrapperSrc]:(this.fail=!0,this.failString="scratchpad_ui_badrunwrappersrc")),runWrapper}failed(){return this.fail}failMessage(){return this.failString}sync(){if(!this.context)return;const serialisation=this.getSerialisation();this.setSerialisation(serialisation)}getSerialisation(){const prefixAns=document.getElementById(this.context.prefix_ans.id),showHide=document.getElementById(this.context.show_hide.id);let serialisation={answer_code:[this.context.answer_code.text],test_code:[this.context.test_code.text],show_hide:[this.context.show_hide.show],prefix_ans:[invertSerial(this.context.prefix_ans.checked)]};return this.answerTextarea&&(serialisation.answer_code=[this.answerTextarea.value]),this.testTextarea&&(serialisation.test_code=[this.testTextarea.value]),showHide&&!(el=>{if(!el.classList.contains("collapse")&&!el.classList.contains("collapsing"))throw Error("Element does not have collapse class");return!el.classList.contains("show")})(showHide)?serialisation.show_hide=["1"]:serialisation.show_hide=[""],null!=prefixAns&&prefixAns.checked||this.context.disable_scratchpad?serialisation.prefix_ans=["1"]:serialisation.prefix_ans=[""],this.invertPreload&&(serialisation.prefix_ans=invertSerial(serialisation.prefix_ans)),serialisation}setSerialisation(serialisation){serialisation.prefix_ans=invertSerial(serialisation.prefix_ans),Object.values(serialisation).some((val=>1===val.length&&val[0].length>0))?(serialisation.prefix_ans=invertSerial(serialisation.prefix_ans),this.textArea.value=JSON.stringify(serialisation)):this.textArea.value=""}getElement(){return this.outerDiv}handleRunButtonClick(){if(null===this.outputDisplay)return;this.sync();const preloadString=this.textArea.value,serial=this.readJson(preloadString),escape=code=>this.uiParams.escape?JSON.stringify(code).slice(1,-1):code,code=function(answerCode,testCode,prefixAns,template){let open=arguments.length>4&&void 0!==arguments[4]?arguments[4]:"\\(",close=arguments.length>5&&void 0!==arguments[5]?arguments[5]:"\\)";template||(template="".concat(open," ANSWER_CODE ").concat(close,"\n")+"".concat(open," SCRATCHPAD_CODE ").concat(close)),prefixAns||(answerCode="");const escOpen=escapeRegExp(open),escClose=escapeRegExp(close),answerRegex=new RegExp("".concat(escOpen,"\\s*ANSWER_CODE\\s*").concat(escClose),"g"),scratchpadRegex=new RegExp("".concat(escOpen,"\\s*SCRATCHPAD_CODE\\s*").concat(escClose),"g");return(template=template.replaceAll(answerRegex,(()=>answerCode))).replaceAll(scratchpadRegex,(()=>testCode))}(escape(serial.answer_code[0]),escape(serial.test_code[0]),serial.prefix_ans[0],this.runWrapper,this.uiParams.open_delimiter,this.uiParams.close_delimiter);this.jobeServers?this.outputDisplay.runCodeDirect(code,"",this.jobeServers,this.apiKeys,!0):this.outputDisplay.runCode(code,"",!0)}updateContext(preload){this.context={id:this.textAreaId,disable_scratchpad:this.uiParams.disable_scratchpad,scratchpad_name:this.uiParams.scratchpad_name,button_name:this.uiParams.button_name,help_text:{text:this.uiParams.help_text},answer_code:{id:this.textAreaId+"_answer-code",name:"answer_code",text:preload.answer_code[0],lang:this.lang,rows:this.numRows},test_code:{id:this.textAreaId+"_test-code",name:"test_code",text:preload.test_code[0],lang:this.lang,rows:6},show_hide:{id:this.textAreaId+"_scratchpad",show:preload.show_hide[0]},prefix_ans:{id:this.textAreaId+"_prefix-ans",label:this.uiParams.prefix_name,checked:preload.prefix_ans[0]},output_display:{id:this.textAreaId+"_run-output"},jquery_escape:function(){return function(text,render){return CSS.escape(render(text))}}}}readJson(preloadString){let serial;if(""!==preloadString){try{serial=JSON.parse(preloadString)}catch{serial={answer_code:[preloadString]}}if(!serial.hasOwnProperty("answer_code"))throw TypeError("JSON has wrong signature, missing answer_code field.")}return serial=overwriteValues({answer_code:[""],test_code:[""],show_hide:[""],prefix_ans:["1"]},serial),this.invertPreload&&(serial.prefix_ans=invertSerial(serial.prefix_ans)),serial}async reload(){try{const{html:html}=await _templates.default.renderForPromise("qtype_coderunner/scratchpad_ui",this.context);this.drawUi(html),this.addAceUis(),this.outputDisplay=new _outputdisplayarea.OutputDisplayArea(this.context.output_display.id,this.uiParams.output_display_mode,this.uiParams.run_lang,this.uiParams.params),this.addEventListeners()}catch(e){this.fail=!0,this.failString="scratchpad_ui_templateloadfail"}}drawUi(html){const wrapperDiv=document.getElementById(this.textAreaId).nextSibling;wrapperDiv.innerHTML=html,this.outerDiv=wrapperDiv.firstChild,wrapperDiv.style.resize="none"}addAceUis(){this.answerTextarea=document.getElementById(this.context.answer_code.id),this.testTextarea=document.getElementById(this.context.test_code.id),this.answerCodeUi=(0,_userinterfacewrapper.newUiWrapper)("ace",this.context.answer_code.id),this.answerCodeUi.setAllowFullScreen(!0),this.testTextarea&&(this.testCodeUi=(0,_userinterfacewrapper.newUiWrapper)("ace",this.context.test_code.id),this.testCodeUi.setAllowFullScreen(!0))}addEventListeners(){const runButton=document.getElementById(this.textAreaId+"_run-btn");runButton&&runButton.addEventListener("click",(()=>this.handleRunButtonClick()))}resize(){}hasFocus(){var _this$answerCodeUi,_this$testCodeUi;let focused=!1;return null!==(_this$answerCodeUi=this.answerCodeUi)&&void 0!==_this$answerCodeUi&&_this$answerCodeUi.uiInstance.hasFocus()&&(focused=!0),null!==(_this$testCodeUi=this.testCodeUi)&&void 0!==_this$testCodeUi&&_this$testCodeUi.uiInstance.hasFocus()&&(focused=!0),focused}destroy(){var _this$answerCodeUi2,_this$testCodeUiCodeU,_this$outerDiv;this.sync(),null===(_this$answerCodeUi2=this.answerCodeUi)||void 0===_this$answerCodeUi2||_this$answerCodeUi2.uiInstance.destroy(),null===(_this$testCodeUiCodeU=this.testCodeUiCodeUi)||void 0===_this$testCodeUiCodeU||_this$testCodeUiCodeU.uiInstance.destroy(),null===(_this$outerDiv=this.outerDiv)||void 0===_this$outerDiv||_this$outerDiv.remove(),this.outerDiv=null}}}));

//# sourceMappingURL=ui_scratchpad.min.js.map