/**
 * Implementation of the html_ui user interface plugin. For overall details
 * of the UI plugin architecture, see userinterfacewrapper.js.
 *
 * This plugin replaces the usual textarea answer element with a div
 * containing the author-supplied HTML. The serialisation of that HTML,
 * which is what is essentially copied back into the textarea for submissions
 * as the answer, is a JSON object. The fields of that object are the names
 * of all author-supplied HTML elements with a class 'coderunner-ui-element';
 * all such objects are expected to have a 'name' attribute as well. The
 * associated field values are lists. Each list contains all the values, in
 * document order, of the results of calling the jquery val() method in turn
 * on each of the UI elements with that name.
 * This means that at least input, select and textarea
 * elements are supported. The author is responsible for checking the
 * compatibility of other elements with jquery's val() method.
 *
 * The HTML to use in the answer area must be provided as the contents of
 * either the globalextra field or the prototypeextra field in the question
 * authoring form. The choice of which is set by the html_src UI parameter, which
 * must be either 'globalextra' or 'prototypeextra'.
 *
 * If any fields of the answer html are to be preloaded, these should be specified
 * in the answer preload with json of the form '{"<fieldName>": "<fieldValueList>",...}'
 * where fieldValueList is a list of all the values to be assigned to the fields
 * with the given name, in document order.
 *
 * To accommodate the possibility of dynamic HTML, any leftover preload values,
 * that is, values that cannot be positioned within the HTML either because
 * there is no field of the required name or because, in the case of a list,
 * there are insufficient elements, are assigned to the data['leftovers']
 * attribute of the outer html div, as a sub-object of the original object.
 * This outer div can be located as the 'closest' (in a jQuery sense)
 * div.qtype-coderunner-html-outer-div. The author-supplied HTML must include
 * JavaScript to make use of the 'leftovers'.
 *
 * As a special case of the serialisation, if all values in the serialisation
 * are either empty strings or a list of empty strings, the serialisation is
 * itself the empty string.
 *
 * @module coderunner/ui_html
 * @copyright  Richard Lobb, 2018, The University of Canterbury
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("qtype_coderunner/ui_html",["jquery"],(function($){function HtmlUi(textareaId,width,height,uiParams){this.textArea=$(document.getElementById(textareaId)),this.textareaId=textareaId;var srcField=uiParams.html_src||"globalextra";this.html=this.textArea.attr("data-"+srcField),this.html=this.html.replace(/___textareaId___/gm,textareaId),this.readOnly=this.textArea.prop("readonly"),this.uiParams=uiParams,this.fail=!1,this.htmlDiv=null,this.reload()}return HtmlUi.prototype.failed=function(){return this.fail},HtmlUi.prototype.failMessage=function(){return"htmluiloadfail"},HtmlUi.prototype.sync=function(){var name,serialisation={},empty=!0;this.getFields().each((function(){var value,type;type=$(this).attr("type"),name=$(this).attr("name"),value="checkbox"!==type&&"radio"!==type||$(this).is(":checked")?$(this).val():"",serialisation.hasOwnProperty(name)?serialisation[name].push(value):serialisation[name]=[value],""!==value&&(empty=!1)})),empty?this.textArea.val(""):this.textArea.val(JSON.stringify(serialisation))},HtmlUi.prototype.getElement=function(){return this.htmlDiv},HtmlUi.prototype.getFields=function(){return $(this.htmlDiv).find(".coderunner-ui-element")},HtmlUi.prototype.setField=function(field,value){"checkbox"===field.attr("type")||"radio"===field.attr("type")?field.prop("checked",field.val()===value):field.val(value)},HtmlUi.prototype.reload=function(){var valuesToLoad,values,i,fields,leftOvers,content=$(this.textArea).val(),outerDiv="<div style='height:fit-content' class='qtype-coderunner-html-outer-div' id='"+("qtype-coderunner-outer-div-"+this.textareaId)+"'>";if(this.htmlDiv=$(outerDiv+this.html+"</div>"),this.htmlDiv.data("uiparams",this.uiParams),this.htmlDiv.data("templateparams",this.uiParams),content)try{for(var name in valuesToLoad=JSON.parse(content),leftOvers={},valuesToLoad){for(values=valuesToLoad[name],fields=this.getFields().filter("[name='"+name+"']"),leftOvers[name]=[],i=0;i<values.length;i++)i<fields.length?this.setField($(fields[i]),values[i]):leftOvers[name].push(values[i]);0===leftOvers[name].length&&delete leftOvers[name]}$.isEmptyObject(leftOvers)||this.htmlDiv.attr("data-leftovers",JSON.stringify(leftOvers))}catch(e){this.fail=!0}},HtmlUi.prototype.resize=function(){},HtmlUi.prototype.hasFocus=function(){var focused=!1;return this.getFields().each((function(){this===document.activeElement&&(focused=!0)})),focused},HtmlUi.prototype.destroy=function(){this.sync(),$(this.htmlDiv).remove(),this.htmlDiv=null},{Constructor:HtmlUi}}));

//# sourceMappingURL=ui_html.min.js.map