/**
 * JavaScript to interface to the Ace editor, which is used both in
 * the author editing page and by the student question submission page.
 * The class defined in this module is a plugin for the InterfaceWrapper class
 * declared in userinterfacewrapper.js. See that file for an explanation of
 * the interface to this module.
 *
 * A special case behaviour of the AceWrapper is that it needs to know
 * the Programming language that is being edited. This MUST be provided in
 * the constructor params parameter (an associative array) as a string
 * with key 'lang'.
 *
 * @module qtype_coderunner/ui_ace
 * @copyright  Richard Lobb, 2015, 2017, The University of Canterbury
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("qtype_coderunner/ui_ace",["jquery"],(function($){function AceWrapper(textareaId,w,h,params){var session,code,textarea=$(document.getElementById(textareaId)),wrapper=$(document.getElementById(textareaId+"_wrapper")),focused=textarea[0]===document.activeElement,lang=params.lang,t=this;try{window.ace.require("ace/ext/language_tools"),this.modelist=window.ace.require("ace/ext/modelist"),this.textareaId=textareaId,this.textarea=textarea,this.enabled=!1,this.contents_changed=!1,this.capturingTab=!1,this.clickInProgress=!1,this.editNode=$("<div></div>"),this.editNode.css({resize:"none",height:h,width:"100%"}),this.editor=window.ace.edit(this.editNode.get(0)),textarea.prop("readonly")&&this.editor.setReadOnly(!0),this.editor.setOptions({enableBasicAutocompletion:!0,enableLiveAutocompletion:params.live_autocompletion,fontSize:params.font_size?params.font_size:"14px",newLineMode:"unix"}),this.editor.$blockScrolling=1/0,session=this.editor.getSession(),code=this.textarea.val(),(void 0===params.import_from_scratchpad||params.import_from_scratchpad)&&(code=this.extract_from_json_maybe(code)),session.setValue(code);const userTheme=window.localStorage.getItem("qtype_coderunner.ace.theme"),consider_prefers=params.auto_switch_light_dark&&window.matchMedia;null!==userTheme?this.editor.setTheme(userTheme):consider_prefers&&window.matchMedia("(prefers-color-scheme: dark)").matches?this.editor.setTheme("ace/theme/tomorrow_night"):consider_prefers&&window.matchMedia("(prefers-color-scheme: light)").matches?this.editor.setTheme("ace/theme/textmate"):params.theme?this.editor.setTheme("ace/theme/"+params.theme):this.editor.setTheme("ace/theme/textmate"),this.currentTheme=this.editor.getTheme(),this.fixSlowLoad(),this.setLanguage(lang),this.setEventHandlers(textarea),this.set_ace_aria_label(this.editor.container),this.captureTab(),this.editor.renderer.on("afterRender",(function(){var gutter=wrapper.find(".ace_gutter");gutter.hasClass("moodle-has-zindex")||(gutter.addClass("moodle-has-zindex"),focused&&(t.editor.focus(),t.editor.navigateFileEnd()),t.aceLabel=wrapper.find(".answerprompt"),t.aceLabel.attr("for","ace_"+textareaId),t.aceTextarea=wrapper.find(".ace_text-input"),t.aceTextarea.attr("id","ace_"+textareaId))})),this.fail=!1}catch(err){this.fail=!0}}return AceWrapper.prototype.set_ace_aria_label=function(editor_container){require(["core/str"],(function(str){str.get_string("ace_aria_label","qtype_coderunner").then((function(label){editor_container.setAttribute("aria-label",label)}))}))},AceWrapper.prototype.extract_from_json_maybe=function(code){try{code=JSON.parse(code).answer_code[0]}catch(err){}return code},AceWrapper.prototype.failed=function(){return this.fail},AceWrapper.prototype.failMessage=function(){return"ace_ui_notready"},AceWrapper.prototype.sync=function(){const thisThemeNow=this.editor.getTheme(),globalTheme=window.localStorage.getItem("qtype_coderunner.ace.theme");thisThemeNow!==this.currentTheme?(this.currentTheme=thisThemeNow,window.localStorage.setItem("qtype_coderunner.ace.theme",thisThemeNow)):globalTheme&&thisThemeNow!=globalTheme&&(this.editor.setTheme(globalTheme),this.currentTheme=globalTheme)},AceWrapper.prototype.syncIntervalSecs=function(){return 2},AceWrapper.prototype.setLanguage=function(language){var session=this.editor.getSession(),mode=this.findMode(language);mode&&session.setMode(mode.mode)},AceWrapper.prototype.getElement=function(){return this.editNode},AceWrapper.prototype.captureTab=function(){this.capturingTab=!0,this.editor.commands.bindKeys({Tab:"indent","Shift-Tab":"outdent"})},AceWrapper.prototype.releaseTab=function(){this.capturingTab=!1,this.editor.commands.bindKeys({Tab:null,"Shift-Tab":null})},AceWrapper.prototype.fixSlowLoad=function(){const observer=new IntersectionObserver((()=>{$(document).trigger("mousemove")})),editNode=this.editNode.get(0);observer.observe(editNode)},AceWrapper.prototype.setEventHandlers=function(){var t=this;this.editor.getSession().on("change",(function(){t.textarea.val(t.editor.getSession().getValue()),t.contents_changed=!0})),this.editor.on("blur",(function(){t.contents_changed&&t.textarea.trigger("change")})),this.editor.on("mousedown",(function(){t.clickInProgress=!0})),this.editor.on("focus",(function(){t.clickInProgress?t.captureTab():t.releaseTab()})),this.editor.on("click",(function(){t.clickInProgress=!1})),this.editor.container.addEventListener("keydown",(function(e){void 0!==e.which&&0===e.which||(77===e.keyCode&&e.ctrlKey&&!e.altKey?(t.capturingTab?t.releaseTab():t.captureTab(),e.preventDefault()):27===e.keyCode?t.releaseTab():e.shiftKey||e.ctrlKey||e.altKey||9==e.keyCode||t.captureTab())}),!0)},AceWrapper.prototype.destroy=function(){var focused;this.fail||(focused=this.editor.isFocused(),this.textarea.val(this.editor.getSession().getValue()),this.editor.destroy(),$(this.editNode).remove(),focused&&(this.textarea.focus(),this.textarea[0].selectionStart=this.textarea[0].value.length))},AceWrapper.prototype.hasFocus=function(){return this.editor.isFocused()},AceWrapper.prototype.findMode=function(language){var candidate,filename,result,candidates,nameMap={octave:"matlab",nodejs:"javascript","c#":"cs",pypy3:"python"};if("string"==typeof language){language.toLowerCase()in nameMap&&(language=nameMap[language.toLowerCase()]),candidates=[language,language.replace(/\d+$/,"")];for(var i=0;i<candidates.length;i++)if(filename="input."+(candidate=candidates[i]),(result=this.modelist.modesByName[candidate]||this.modelist.modesByName[candidate.toLowerCase()]||this.modelist.getModeForPath(filename)||this.modelist.getModeForPath(filename.toLowerCase()))&&"text"!==result.name)return result}},AceWrapper.prototype.resize=function(w,h){this.editNode.outerHeight(h),this.editNode.outerWidth(w),this.editor.resize()},AceWrapper.prototype.allowFullScreen=function(){return!0},{Constructor:AceWrapper}}));

//# sourceMappingURL=ui_ace.min.js.map