/**
 * This AMD module provides the functionality for the "Show differences"
 * button that is shown in the student's result page if their answer
 * isn't right and an "exact-match" (or near equivalent) grader is being used.
 *
 * @module qtype_coderunner/showdiff
 * @copyright  Richard Lobb, 2016, The University of Canterbury
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("qtype_coderunner/showdiff",["jquery"],(function($){function lcss(items1,items2){var M,i,j,n,result,length;for(M=function(items1,items2){var lengths,i,j,n1=items1.length,n2=items2.length,has_fill="function"==typeof[1].fill;for(lengths=[],i=0;i<=n1;i+=1)if(lengths[i]=new Array(n2+1),has_fill)lengths[i].fill(0);else for(j=0;j<n2+1;j++)lengths[i][j]=0;for(i=0;i<n1;i+=1)for(j=0;j<n2;j+=1)items1[i]==items2[j]?lengths[i+1][j+1]=1+lengths[i][j]:lengths[i+1][j+1]=Math.max(lengths[i][j+1],lengths[i+1][j]);return lengths}(items1,items2),length=M[items1.length][items2.length],result=[],i=items1.length,j=items2.length,n=length-1;n>=0;)items1[i-1]==items2[j-1]?(result[n]=items1[i-1],n-=1,i-=1,j-=1):M[i-1][j]==M[i][j]?i-=1:j-=1;return result}function insertDels(tokens,subSeq,startDel,endDel){var i,html="",deleting=!1,ssi=0;for(void 0===startDel&&(startDel="<del>"),void 0===endDel&&(endDel="</del>"),i=0;i<tokens.length;i+=1)ssi<subSeq.length&&tokens[i]==subSeq[ssi]?(deleting&&(html+=endDel,deleting=!1),ssi+=1):deleting||(html+=startDel,deleting=!0),html+=tokens[i];return deleting&&(html+=endDel),html}function getTokens(element){var seq,token,match,isPre="pre"===element.tagName.toLowerCase(),text=element.innerHTML,i=0;for(isPre&&(text=text.replace(/\n/g,"↩\n")),text=text.replace(/(<br ?.*?>)/g,"↩$1"),seq=[],i=0;i<text.length;)seq.push((token=void 0,match=void 0,"&"!=text[i]||null===(match=text.substring(i,text.length).match(/(^&[a-zA-Z]+;)|(^&#[0-9]+;)|(^&#[xX][0-9a-fA-F]+;)/))?(token=text[i],i+=1):(token=match[0],i+=token.length),token));return seq}function showDifferences(firstEl,secondEl){var seq1,seq2,css;css=lcss(seq1=getTokens(firstEl),seq2=getTokens(secondEl)),firstEl.innerHTML=insertDels(seq1,css,"<del>","</del>"),secondEl.innerHTML=insertDels(seq2,css,"<del>","</del>")}function hideDifferences(firstEl,secondEl){var replPat=new RegExp("(</?del[^>]*>)|(↩)","g");firstEl.innerHTML=firstEl.innerHTML.replace(replPat,""),secondEl.innerHTML=secondEl.innerHTML.replace(replPat,"")}function processAllRows(tableRows,gotCol,expectedCol,f){for(var cells,i=0;i<tableRows.length;i++)f((cells=tableRows[i].getElementsByTagName("td"))[expectedCol].children[0],cells[gotCol].children[0])}return{initDiffButton:function(buttonId,showValue,hideValue,expectedString,gotString){var table,tableRows,thEls,diffButton=$('[id="'+buttonId+'"]'),columnCount=0,gotCol=-1,expectedCol=-1;thEls=(table=diffButton.closest("div.coderunner-test-results")).find("thead tr").children(),tableRows=table.find("tbody tr"),thEls.each((function(){$(this).html()===gotString?gotCol=columnCount:$(this).html()===expectedString&&(expectedCol=columnCount),columnCount+=1})),-1!==gotCol&&-1!==expectedCol?diffButton.on("click",(function(){diffButton.prop("value")===showValue?(processAllRows(tableRows.toArray(),gotCol,expectedCol,showDifferences),diffButton.prop("value",hideValue)):(processAllRows(tableRows.toArray(),gotCol,expectedCol,hideDifferences),diffButton.prop("value",showValue))})):(diffButton.enabled=!1,diffButton.hide())}}}));

//# sourceMappingURL=showdiff.min.js.map